/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen.documentation;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DocumentationConfigGen {
    private static final Log LOG = LogFactory.getLog(DocumentationConfigGen.class);
    private String[] srcFiles;
    private String outputFolder = ".";

    public void generate() {
        int i;
        if (this.srcFiles == null || this.srcFiles.length == 0) {
            System.out.print("No files specified\n");
            return;
        }
        System.out.print("Files to document:");
        for (i = 0; i < this.srcFiles.length; ++i) {
            System.out.print(this.srcFiles[i] + "\n");
        }
        System.out.print("\n Output directory : " + this.getOutputFolder() + "\n");
        try {
            for (i = 0; i < this.srcFiles.length; ++i) {
                this.createDocumentationConfiguration(this.srcFiles[i]);
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            LOG.equals(e);
            e.printStackTrace();
        }
    }

    private String addSubfolder(String parent, String child) {
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        return parent + child;
    }

    public void createDocumentationConfiguration(String srcFile) throws NoClassDefFoundError, FileNotFoundException, IOException {
        JavaDocBuilder builder = new JavaDocBuilder();
        File file = new File(srcFile);
        builder.addSource(file);
        JavaSource src = builder.getSources()[0];
        JavaClass clazz = src.getClasses()[0];
        Document doc = this.generateClassDocumentation(clazz);
        String name = clazz.getFullyQualifiedName().replaceAll("\\.", "/");
        name = name + ".doc.xml";
        name = this.addSubfolder(this.outputFolder, name);
        File targetFile = new File(name);
        this.createOutputFolders(clazz.getPackage());
        XMLOutputter outputer = new XMLOutputter();
        FileWriter writer = new FileWriter(targetFile);
        outputer.setFormat(Format.getPrettyFormat());
        outputer.output(doc, (Writer)writer);
        writer.close();
    }

    private Element createExceptionElement(DocletTag tag, Type[] types) {
        String value = tag.getValue().trim();
        int idx = value.indexOf(32);
        if (idx < 0) {
            return null;
        }
        String exceptionName = value.substring(0, idx);
        String exceptionComment = value.substring(idx + 1);
        String exceptionFullName = this.getExcFullName(types, exceptionName);
        Element exc = new Element("exception");
        exc.setAttribute("class", exceptionFullName);
        return exc.addContent((Content)this.newDocElement(exceptionComment));
    }

    private Element newDocElement(String text) {
        return new Element("documentation").setText(text);
    }

    private Element generateMethod(JavaMethod method) {
        String returnStr;
        DocletTag returnTag;
        if (!method.isPublic() || method.isStatic()) {
            return null;
        }
        Element methodElement = new Element("method");
        methodElement.setAttribute("name", method.getName());
        methodElement.setAttribute("parametersNumber", String.valueOf(method.getParameters().length));
        String comment = method.getComment();
        if (comment != null && !"".equals(comment)) {
            methodElement.addContent((Content)this.newDocElement(comment));
        }
        JavaParameter[] paramters = method.getParameters();
        DocletTag[] paramsTag = method.getTagsByName("param");
        if (paramsTag != null) {
            for (int p = 0; p < paramsTag.length; ++p) {
                Element param = this.createParameterElement(paramsTag[p], paramters);
                if (param == null) continue;
                methodElement.addContent((Content)param);
            }
        }
        if ((returnTag = method.getTagByName("return")) != null && (returnStr = returnTag.getValue().trim()).length() > 0) {
            Element returnElement = new Element("return");
            returnElement.addContent((Content)this.newDocElement(returnStr));
            methodElement.addContent((Content)returnElement);
        }
        DocletTag[] throwsTag = method.getTagsByName("throws");
        Type[] types = method.getExceptions();
        if (throwsTag != null) {
            for (int t = 0; t < throwsTag.length; ++t) {
                Element exceptionElment = this.createExceptionElement(throwsTag[t], types);
                if (exceptionElment == null) continue;
                methodElement.addContent((Content)exceptionElment);
            }
        }
        if (methodElement.getChildren().size() == 0) {
            return null;
        }
        return methodElement;
    }

    private Element createParameterElement(DocletTag tag, JavaParameter[] parameters) {
        String value = tag.getValue().trim();
        int idx = value.indexOf(32);
        if (idx < 0) {
            return null;
        }
        String paramName = value.substring(0, idx);
        String paramComment = value.substring(idx + 1);
        int paramIdx = -1;
        for (int i = 0; i < parameters.length; ++i) {
            if (!paramName.equals(parameters[i].getName())) continue;
            paramIdx = i;
            break;
        }
        if (paramIdx < 0) {
            return null;
        }
        Element param = new Element("parameter");
        param.setAttribute("index", String.valueOf(paramIdx));
        return param.addContent((Content)this.newDocElement(paramComment));
    }

    private String getExcFullName(Type[] types, String localName) {
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            String fullname = type.getValue();
            if (!fullname.endsWith(localName)) continue;
            return fullname;
        }
        return null;
    }

    private void createOutputFolders(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        String pathLevel = this.getOutputFolder();
        while (tokenizer.hasMoreTokens()) {
            String folder = tokenizer.nextToken();
            File file = new File(pathLevel = this.addSubfolder(pathLevel, folder));
            if (file.exists()) continue;
            file.mkdir();
        }
    }

    private Document generateClassDocumentation(JavaClass clazz) {
        Document document = new Document();
        Element service = new Element("service");
        document.addContent((Content)service);
        if (!"".equals(clazz.getComment())) {
            service.addContent((Content)this.newDocElement(clazz.getComment()));
        }
        JavaMethod[] methods = clazz.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            Element methodElem = this.generateMethod(methods[m]);
            if (methodElem == null) continue;
            service.addContent((Content)methodElem);
        }
        return document;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public String[] getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(String[] srcFiles) {
        this.srcFiles = srcFiles;
    }

    public static void main(String[] args) throws Exception {
        DocumentationConfigGen gen = new DocumentationConfigGen();
        gen.setOutputFolder(".");
        gen.setSrcFiles(new String[]{"/home/tomeks/dev/xfire/examples/book/src/main/org/codehaus/xfire/demo/BookService.java"});
        gen.generate();
    }
}

