/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.deletefile.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.FileExistsValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDeleteFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename;
    private boolean failIfFileNotExists;

    public JobEntryDeleteFile(String n) {
        super(n, "");
        this.filename = null;
        this.failIfFileNotExists = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.DELETE_FILE);
    }

    public JobEntryDeleteFile() {
        this("");
    }

    public JobEntryDeleteFile(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryDeleteFile je = (JobEntryDeleteFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_if_file_not_exists", (boolean)this.failIfFileNotExists));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.failIfFileNotExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_if_file_not_exists"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryDeleteFile.Error_0001_Unable_To_Load_Job_From_Xml_Node"), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.failIfFileNotExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_if_file_not_exists");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFile.ERROR_0002_Unable_To_Load_From_Repository", Long.toString(id_jobentry)), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "fail_if_file_not_exists", this.failIfFileNotExists);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryDeleteFile.ERROR_0003_Unable_To_Save_Job_To_Repository", Long.toString(id_job)), (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.filename != null) {
            FileObject fileObject;
            String realFilename;
            block15: {
                realFilename = this.getRealFilename();
                fileObject = null;
                fileObject = KettleVFS.getFileObject((String)realFilename);
                if (!fileObject.exists()) {
                    if (this.isFailIfFileNotExists()) {
                        result.setResult(false);
                        log.logError(this.toString(), Messages.getString("JobEntryDeleteFile.ERROR_0004_File_Does_Not_Exist", realFilename), new Object[0]);
                    } else {
                        result.setResult(true);
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), Messages.getString("JobEntryDeleteFile.File_Already_Deleted", realFilename), new Object[0]);
                        }
                    }
                    break block15;
                }
                System.gc();
                boolean deleted = fileObject.delete();
                if (!deleted) {
                    log.logError(this.toString(), Messages.getString("JobEntryDeleteFile.ERROR_0005_Could_Not_Delete_File", realFilename), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                }
                if (log.isBasic()) {
                    log.logBasic(this.toString(), Messages.getString("JobEntryDeleteFile.File_Deleted", realFilename), new Object[0]);
                }
                result.setResult(true);
            }
            Object var11_11 = null;
            if (fileObject == null) return result;
            try {
                fileObject.close();
                return result;
            }
            catch (IOException ex) {}
            return result;
            {
                catch (IOException e) {
                    log.logError(this.toString(), Messages.getString("JobEntryDeleteFile.ERROR_0006_Exception_Deleting_File", realFilename, e.getMessage()), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var11_12 = null;
                    if (fileObject == null) return result;
                    try {
                        fileObject.close();
                        return result;
                    }
                    catch (IOException ex) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (fileObject == null) throw throwable;
                try {
                    fileObject.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        log.logError(this.toString(), Messages.getString("JobEntryDeleteFile.ERROR_0007_No_Filename_Is_Defined"), new Object[0]);
        return result;
    }

    public boolean isFailIfFileNotExists() {
        return this.failIfFileNotExists;
    }

    public void setFailIfFileNotExists(boolean failIfFileExists) {
        this.failIfFileNotExists = failIfFileExists;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        if (this.isFailIfFileNotExists()) {
            FileExistsValidator.putFailIfDoesNotExist(ctx, true);
        }
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryDeleteFile().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }
}

