"""Generated client library for biglake version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.biglake.v1 import biglake_v1_messages as messages


class BiglakeV1(base_api.BaseApiClient):
  """Generated client library for service biglake version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://biglake.googleapis.com/'
  MTLS_BASE_URL = 'https://biglake.mtls.googleapis.com/'

  _PACKAGE = 'biglake'
  _SCOPES = ['https://www.googleapis.com/auth/bigquery', 'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BiglakeV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new biglake handle."""
    url = url or self.BASE_URL
    super(BiglakeV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.iceberg_v1_restcatalog_extensions_projects_catalogs = self.IcebergV1RestcatalogExtensionsProjectsCatalogsService(self)
    self.iceberg_v1_restcatalog_extensions_projects = self.IcebergV1RestcatalogExtensionsProjectsService(self)
    self.iceberg_v1_restcatalog_extensions = self.IcebergV1RestcatalogExtensionsService(self)
    self.iceberg_v1_restcatalog_v1_projects_catalogs_namespaces_tables = self.IcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesService(self)
    self.iceberg_v1_restcatalog_v1_projects_catalogs_namespaces = self.IcebergV1RestcatalogV1ProjectsCatalogsNamespacesService(self)
    self.iceberg_v1_restcatalog_v1_projects_catalogs = self.IcebergV1RestcatalogV1ProjectsCatalogsService(self)
    self.iceberg_v1_restcatalog_v1_projects = self.IcebergV1RestcatalogV1ProjectsService(self)
    self.iceberg_v1_restcatalog_v1 = self.IcebergV1RestcatalogV1Service(self)
    self.iceberg_v1_restcatalog = self.IcebergV1RestcatalogService(self)
    self.iceberg_v1 = self.IcebergV1Service(self)
    self.iceberg = self.IcebergService(self)
    self.projects_catalogs_namespaces_tables = self.ProjectsCatalogsNamespacesTablesService(self)
    self.projects_catalogs_namespaces = self.ProjectsCatalogsNamespacesService(self)
    self.projects_catalogs = self.ProjectsCatalogsService(self)
    self.projects = self.ProjectsService(self)

  class IcebergV1RestcatalogExtensionsProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_extensions_projects_catalogs resource."""

    _NAME = 'iceberg_v1_restcatalog_extensions_projects_catalogs'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogExtensionsProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates the Iceberg REST Catalog. Currently only supports Google Cloud Storage Bucket catalogs. Google Cloud Storage Bucket catalog id is the bucket for which the catalog is created (e.g. `my-catalog` for `gs://my-catalog`). If the bucket does not exist, of the caller does not have bucket metadata permissions, the catalog will not be created.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergCatalog) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['iceberg_catalog_id'],
        relative_path='iceberg/v1/restcatalog/extensions/{+parent}/catalogs',
        request_field='icebergCatalog',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsCreateRequest',
        response_type_name='IcebergCatalog',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes the Iceberg REST Catalog. Delete does not delete a catalog that has contents -- at least one namespace. Delete is not supported for all catalog types.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='DELETE',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/extensions/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Failover(self, request, global_params=None):
      r"""Failover the catalog to a new primary replica region.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsFailoverRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FailoverIcebergCatalogResponse) The response message.
      """
      config = self.GetMethodConfig('Failover')
      return self._RunMethod(
          config, request, global_params=global_params)

    Failover.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs/{catalogsId}:failover',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.failover',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/extensions/{+name}:failover',
        request_field='failoverIcebergCatalogRequest',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsFailoverRequest',
        response_type_name='FailoverIcebergCatalogResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the Iceberg REST Catalog configuration options.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergCatalog) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/extensions/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsGetRequest',
        response_type_name='IcebergCatalog',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the Iceberg REST Catalogs.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIcebergCatalogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['page_size', 'page_token', 'view'],
        relative_path='iceberg/v1/restcatalog/extensions/{+parent}/catalogs',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsListRequest',
        response_type_name='ListIcebergCatalogsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Update the Iceberg REST Catalog configuration options.

      Args:
        request: (BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergCatalog) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/extensions/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='PATCH',
        method_id='biglake.iceberg.v1.restcatalog.extensions.projects.catalogs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='iceberg/v1/restcatalog/extensions/{+name}',
        request_field='icebergCatalog',
        request_type_name='BiglakeIcebergV1RestcatalogExtensionsProjectsCatalogsPatchRequest',
        response_type_name='IcebergCatalog',
        supports_download=False,
    )

  class IcebergV1RestcatalogExtensionsProjectsService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_extensions_projects resource."""

    _NAME = 'iceberg_v1_restcatalog_extensions_projects'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogExtensionsProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergV1RestcatalogExtensionsService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_extensions resource."""

    _NAME = 'iceberg_v1_restcatalog_extensions'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogExtensionsService, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_v1_projects_catalogs_namespaces_tables resource."""

    _NAME = 'iceberg_v1_restcatalog_v1_projects_catalogs_namespaces_tables'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a table in the namespace.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+parent}/tables',
        request_field='createIcebergTableRequest',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCreateRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def Credentials(self, request, global_params=None):
      r"""Loads credentials for a table in the namespace.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCredentialsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LoadIcebergTableCredentialsResponse) The response message.
      """
      config = self.GetMethodConfig('Credentials')
      return self._RunMethod(
          config, request, global_params=global_params)

    Credentials.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}/credentials',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.credentials',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['snapshots'],
        relative_path='iceberg/v1/restcatalog/v1/{+name}/credentials',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesCredentialsRequest',
        response_type_name='LoadIcebergTableCredentialsResponse',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a table in the namespace.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}',
        http_method='DELETE',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['purgeRequested'],
        relative_path='iceberg/v1/restcatalog/v1/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a table in the namespace.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['snapshots'],
        relative_path='iceberg/v1/restcatalog/v1/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesGetRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists table identifiers (not *tables*) in the namespace.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIcebergTableIdentifiersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='iceberg/v1/restcatalog/v1/{+parent}/tables',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesListRequest',
        response_type_name='ListIcebergTableIdentifiersResponse',
        supports_download=False,
    )

    def UpdateIcebergTable(self, request, global_params=None):
      r"""This is CommitTable Iceberg API, which maps to `UpdateIcebergTable` in the Google API nomenclature.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesUpdateIcebergTableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('UpdateIcebergTable')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateIcebergTable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.tables.updateIcebergTable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+name}',
        request_field='updateIcebergTableRequest',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesTablesUpdateIcebergTableRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

  class IcebergV1RestcatalogV1ProjectsCatalogsNamespacesService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_v1_projects_catalogs_namespaces resource."""

    _NAME = 'iceberg_v1_restcatalog_v1_projects_catalogs_namespaces'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogV1ProjectsCatalogsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a namespace in the catalog.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergNamespace) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+parent}/namespaces',
        request_field='icebergNamespace',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesCreateRequest',
        response_type_name='IcebergNamespace',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Returns 204, not 200 on success.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}',
        http_method='DELETE',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an Iceberg namespace in the catalog (or checks if it exists, if the method is HEAD).

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergNamespace) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+name}',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesGetRequest',
        response_type_name='IcebergNamespace',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Iceberg namespaces in the catalog. We only support one level of nesting for namespaces.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIcebergNamespacesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces',
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.list',
        ordered_params=['apiParent'],
        path_params=['apiParent'],
        query_params=['pageSize', 'pageToken', 'parent'],
        relative_path='iceberg/v1/restcatalog/v1/{+apiParent}/namespaces',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesListRequest',
        response_type_name='ListIcebergNamespacesResponse',
        supports_download=False,
    )

    def Properties(self, request, global_params=None):
      r"""Updates namespace properties.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesPropertiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UpdateIcebergNamespaceResponse) The response message.
      """
      config = self.GetMethodConfig('Properties')
      return self._RunMethod(
          config, request, global_params=global_params)

    Properties.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/properties',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.properties',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+name}/properties',
        request_field='icebergNamespaceUpdate',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesPropertiesRequest',
        response_type_name='UpdateIcebergNamespaceResponse',
        supports_download=False,
    )

    def Register(self, request, global_params=None):
      r"""Register a table using given metadata file location.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesRegisterRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (HttpBody) The response message.
      """
      config = self.GetMethodConfig('Register')
      return self._RunMethod(
          config, request, global_params=global_params)

    Register.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/register',
        http_method='POST',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.register',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+parent}/register',
        request_field='registerIcebergTableRequest',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesRegisterRequest',
        response_type_name='HttpBody',
        supports_download=False,
    )

    def UpdateProperties(self, request, global_params=None):
      r"""Updates namespace properties.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesUpdatePropertiesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (UpdateIcebergNamespaceResponse) The response message.
      """
      config = self.GetMethodConfig('UpdateProperties')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateProperties.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='iceberg/v1/restcatalog/v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/properties',
        http_method='PATCH',
        method_id='biglake.iceberg.v1.restcatalog.v1.projects.catalogs.namespaces.updateProperties',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='iceberg/v1/restcatalog/v1/{+name}/properties',
        request_field='icebergNamespaceUpdate',
        request_type_name='BiglakeIcebergV1RestcatalogV1ProjectsCatalogsNamespacesUpdatePropertiesRequest',
        response_type_name='UpdateIcebergNamespaceResponse',
        supports_download=False,
    )

  class IcebergV1RestcatalogV1ProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_v1_projects_catalogs resource."""

    _NAME = 'iceberg_v1_restcatalog_v1_projects_catalogs'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogV1ProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergV1RestcatalogV1ProjectsService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_v1_projects resource."""

    _NAME = 'iceberg_v1_restcatalog_v1_projects'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogV1ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergV1RestcatalogV1Service(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog_v1 resource."""

    _NAME = 'iceberg_v1_restcatalog_v1'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogV1Service, self).__init__(client)
      self._upload_configs = {
          }

    def GetConfig(self, request, global_params=None):
      r"""GetIcebergCatalogConfig lists all catalog configuration settings. Most importantly it contains the optional `endpoints` field which lists what methods this catalog supports, since we are not supporting all the methods right now. It returns all the methods defined in this service (subject to project config allowlisting). This is not a GCP resource.

      Args:
        request: (BiglakeIcebergV1RestcatalogV1GetConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IcebergCatalogConfig) The response message.
      """
      config = self.GetMethodConfig('GetConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetConfig.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='biglake.iceberg.v1.restcatalog.v1.getConfig',
        ordered_params=[],
        path_params=[],
        query_params=['warehouse'],
        relative_path='iceberg/v1/restcatalog/v1/config',
        request_field='',
        request_type_name='BiglakeIcebergV1RestcatalogV1GetConfigRequest',
        response_type_name='IcebergCatalogConfig',
        supports_download=False,
    )

  class IcebergV1RestcatalogService(base_api.BaseApiService):
    """Service class for the iceberg_v1_restcatalog resource."""

    _NAME = 'iceberg_v1_restcatalog'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1RestcatalogService, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergV1Service(base_api.BaseApiService):
    """Service class for the iceberg_v1 resource."""

    _NAME = 'iceberg_v1'

    def __init__(self, client):
      super(BiglakeV1.IcebergV1Service, self).__init__(client)
      self._upload_configs = {
          }

  class IcebergService(base_api.BaseApiService):
    """Service class for the iceberg resource."""

    _NAME = 'iceberg'

    def __init__(self, client):
      super(BiglakeV1.IcebergService, self).__init__(client)
      self._upload_configs = {
          }

  class ProjectsCatalogsNamespacesTablesService(base_api.BaseApiService):
    """Service class for the projects_catalogs_namespaces_tables resource."""

    _NAME = 'projects_catalogs_namespaces_tables'

    def __init__(self, client):
      super(BiglakeV1.ProjectsCatalogsNamespacesTablesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.namespaces.tables.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsNamespacesTablesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}/tables/{tablesId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.tables.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesTablesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

  class ProjectsCatalogsNamespacesService(base_api.BaseApiService):
    """Service class for the projects_catalogs_namespaces resource."""

    _NAME = 'projects_catalogs_namespaces'

    def __init__(self, client):
      super(BiglakeV1.ProjectsCatalogsNamespacesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.namespaces.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsNamespacesGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}/namespaces/{namespacesId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.namespaces.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsNamespacesSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

  class ProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the projects_catalogs resource."""

    _NAME = 'projects_catalogs'

    def __init__(self, client):
      super(BiglakeV1.ProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the IAM policy for the specified Catalog.

      Args:
        request: (BiglakeProjectsCatalogsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}:getIamPolicy',
        http_method='GET',
        method_id='biglake.projects.catalogs.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='BiglakeProjectsCatalogsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM policy for the specified catalog.

      Args:
        request: (BiglakeProjectsCatalogsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/catalogs/{catalogsId}:setIamPolicy',
        http_method='POST',
        method_id='biglake.projects.catalogs.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='BiglakeProjectsCatalogsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(BiglakeV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
