/*
 * Decompiled with CFR 0.152.
 */
package com.azure.json.implementation.jackson.core;

import com.azure.json.implementation.jackson.core.util.ByteArrayBuilder;
import java.util.Arrays;

public final class Base64Variant {
    private static final int INT_SPACE = 32;
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final transient int[] _asciiToBase64 = new int[128];
    private final transient char[] _base64ToAsciiC = new char[64];
    private final transient byte[] _base64ToAsciiB = new byte[64];

    public Base64Variant() {
        int alphaLen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".length();
        "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getChars(0, alphaLen, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int i = 0;
        while (i < alphaLen) {
            char alpha = this._base64ToAsciiC[i];
            this._base64ToAsciiB[i] = (byte)alpha;
            this._asciiToBase64[alpha] = i++;
        }
        this._asciiToBase64[61] = -2;
    }

    public int getMaxLineLength() {
        return Integer.MAX_VALUE;
    }

    public int decodeBase64Char(char c) {
        return c <= '\u007f' ? this._asciiToBase64[c] : -1;
    }

    public int decodeBase64Char(int ch) {
        return ch <= 127 ? this._asciiToBase64[ch] : -1;
    }

    public int encodeBase64Chunk(int b24, char[] buffer, int outPtr) {
        buffer[outPtr++] = this._base64ToAsciiC[b24 >> 18 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiC[b24 >> 12 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiC[b24 >> 6 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiC[b24 & 0x3F];
        return outPtr;
    }

    public int encodeBase64Partial(int bits, int outputBytes, char[] buffer, int outPtr) {
        buffer[outPtr++] = this._base64ToAsciiC[bits >> 18 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiC[bits >> 12 & 0x3F];
        buffer[outPtr++] = outputBytes == 2 ? this._base64ToAsciiC[bits >> 6 & 0x3F] : 61;
        buffer[outPtr++] = 61;
        return outPtr;
    }

    public int encodeBase64Chunk(int b24, byte[] buffer, int outPtr) {
        buffer[outPtr++] = this._base64ToAsciiB[b24 >> 18 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiB[b24 >> 12 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiB[b24 >> 6 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiB[b24 & 0x3F];
        return outPtr;
    }

    public int encodeBase64Partial(int bits, int outputBytes, byte[] buffer, int outPtr) {
        buffer[outPtr++] = this._base64ToAsciiB[bits >> 18 & 0x3F];
        buffer[outPtr++] = this._base64ToAsciiB[bits >> 12 & 0x3F];
        int pb = 61;
        buffer[outPtr++] = outputBytes == 2 ? this._base64ToAsciiB[bits >> 6 & 0x3F] : pb;
        buffer[outPtr++] = pb;
        return outPtr;
    }

    public void decode(String str, ByteArrayBuilder builder) throws IllegalArgumentException {
        int ptr = 0;
        int len = str.length();
        while (ptr < len) {
            char ch;
            if ((ch = str.charAt(ptr++)) <= ' ') continue;
            int bits = this.decodeBase64Char(ch);
            if (bits < 0) {
                this._reportInvalidBase64(ch, 0, null);
            }
            int decodedData = bits;
            if (ptr >= len) {
                throw new IllegalArgumentException(Base64Variant.missingPaddingMessage());
            }
            if ((bits = this.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                this._reportInvalidBase64(ch, 1, null);
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                throw new IllegalArgumentException(Base64Variant.missingPaddingMessage());
            }
            if ((bits = this.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(ch, 2, null);
                }
                if (ptr >= len) {
                    throw new IllegalArgumentException(Base64Variant.missingPaddingMessage());
                }
                if ((ch = str.charAt(ptr++)) != '=') {
                    this._reportInvalidBase64(ch, 3, "expected padding character '='");
                }
                builder.append(decodedData >>= 4);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                throw new IllegalArgumentException(Base64Variant.missingPaddingMessage());
            }
            if ((bits = this.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(ch, 3, null);
                }
                builder.appendTwoBytes(decodedData >>= 2);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            builder.appendThreeBytes(decodedData);
        }
    }

    public String toString() {
        return "MIME-NO-LINEFEEDS";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o != null && o.getClass() == this.getClass();
    }

    public int hashCode() {
        return "MIME-NO-LINEFEEDS".hashCode();
    }

    private void _reportInvalidBase64(char ch, int bindex, String msg) throws IllegalArgumentException {
        String base = ch <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(ch) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units" : (ch == '=' ? "Unexpected padding character ('=') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch) || Character.isISOControl(ch) ? "Illegal character (code 0x" + Integer.toHexString(ch) + ") in base64 content" : "Illegal character '" + ch + "' (code 0x" + Integer.toHexString(ch) + ") in base64 content"));
        if (msg != null) {
            base = base + ": " + msg;
        }
        throw new IllegalArgumentException(base);
    }

    public static String missingPaddingMessage() {
        return "Unexpected end of base64-encoded String: base64 variant 'MIME-NO-LINEFEEDS' expects padding (one or more '=' characters) at the end. This Base64Variant might have been incorrectly configured";
    }
}

