/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.traccar.api.BaseResource;
import org.traccar.model.Action;
import org.traccar.model.BaseModel;
import org.traccar.model.User;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Order;
import org.traccar.storage.query.Request;

@Path(value="audit")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AuditResource
extends BaseResource {
    @GET
    public Stream<Action> get(@QueryParam(value="from") Date from, @QueryParam(value="to") Date to) throws StorageException {
        Map<Long, String> userEmailMap;
        this.permissionsService.checkAdmin(this.getUserId());
        try (Stream<User> stream = this.storage.getObjectsStream(User.class, new Request(new Columns.All()));){
            userEmailMap = stream.filter(user -> user.getEmail() != null).collect(Collectors.toMap(BaseModel::getId, User::getEmail));
        }
        return this.storage.getObjectsStream(Action.class, new Request(new Columns.All(), new Condition.Between("actionTime", from, to), new Order("actionTime"))).map(action -> {
            action.setUserEmail((String)userEmailMap.get(action.getUserId()));
            return action;
        });
    }
}

