/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.util;

import java.nio.channels.ReadPendingException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConstantThrowable;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.IncomingFrames;
import org.eclipse.jetty.websocket.core.util.DemandChain;

public abstract class WebSocketDemander
extends IteratingCallback
implements DemandChain {
    private static final Throwable SENTINEL_CLOSE_EXCEPTION = new ConstantThrowable("Closed");
    private final AutoLock _lock = new AutoLock();
    private final IncomingFrames _emitFrame;
    private boolean _inputDemand = false;
    private boolean _outputDemand = false;
    private Throwable _failure = null;
    private DemandChain _nextDemand;
    private Frame _frame;
    private Callback _callback;
    private boolean _needContent = true;
    private boolean _first = true;

    public WebSocketDemander(IncomingFrames emitFrame) {
        this._emitFrame = emitFrame;
    }

    @Override
    public void setNextDemand(DemandChain nextDemand) {
        this._nextDemand = nextDemand;
    }

    protected abstract boolean handle(Frame var1, Callback var2, boolean var3);

    public void emitFrame(Frame frame, Callback callback) {
        IllegalStateException failure = null;
        try (AutoLock ignored = this._lock.lock();){
            if (!this._outputDemand) {
                failure = new IllegalStateException("Demand already fulfilled");
            } else {
                this._outputDemand = false;
            }
        }
        if (failure != null) {
            callback.failed((Throwable)failure);
            this.failFlusher(failure);
        } else {
            this._emitFrame.onFrame(frame, callback);
        }
    }

    @Override
    public void demand() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure != null) {
                throw new IllegalStateException("Flusher is failed", this._failure);
            }
            if (this._outputDemand) {
                throw new ReadPendingException();
            }
            this._outputDemand = true;
        }
        this.iterate();
    }

    public void onFrame(Frame frame, Callback callback) {
        Throwable failure = null;
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure != null) {
                failure = this._failure;
            } else if (this._inputDemand) {
                this._inputDemand = false;
                this._frame = frame;
                this._callback = new CountingCallback(callback, 1);
            } else {
                failure = new IllegalStateException("No demand for onFrame");
            }
        }
        if (failure == null) {
            this.succeeded();
        } else {
            callback.failed(failure);
            this.failFlusher(failure);
            this.failed(failure);
        }
    }

    public void closeFlusher() {
        this.failFlusher(SENTINEL_CLOSE_EXCEPTION);
    }

    public void failFlusher(Throwable t) {
        boolean abort = false;
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure == null) {
                this._failure = t;
                abort = true;
            }
        }
        if (abort) {
            this.abort(t);
        }
    }

    protected IteratingCallback.Action process() throws Throwable {
        boolean demand = false;
        while (true) {
            try (AutoLock ignored = this._lock.lock();){
                if (this._failure != null) {
                    throw this._failure;
                }
                if (this._inputDemand) {
                    IteratingCallback.Action action = IteratingCallback.Action.IDLE;
                    return action;
                }
                if (this._needContent) {
                    demand = true;
                    this._inputDemand = true;
                }
            }
            if (demand) {
                this._needContent = false;
                this._nextDemand.demand();
                return IteratingCallback.Action.SCHEDULED;
            }
            boolean first = this._first;
            this._first = false;
            boolean needContent = this.handle(this._frame, this._callback, first);
            if (!needContent) continue;
            AutoLock ignored = this._lock.lock();
            try {
                this._needContent = true;
                this._first = true;
                this._frame = null;
                this._callback = null;
                continue;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    protected void onCompleteFailure(Throwable cause) {
        Callback callback;
        try (AutoLock ignored = this._lock.lock();){
            if (this._failure != null) {
                ExceptionUtil.addSuppressedIfNotAssociated((Throwable)this._failure, (Throwable)cause);
            } else {
                this._failure = cause;
            }
            callback = this._callback;
            this._frame = null;
            this._callback = null;
        }
        if (callback != null) {
            callback.failed(cause);
        }
    }

    public Invocable.InvocationType getInvocationType() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._callback == null) {
                Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
                return invocationType;
            }
            Invocable.InvocationType invocationType = this._callback.getInvocationType();
            return invocationType;
        }
    }
}

