/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.expressions.AliasedExpression;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Field;
import com.google.cloud.firestore.pipeline.expressions.Selectable;
import com.google.cloud.firestore.pipeline.stages.InternalOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.cloud.firestore.pipeline.stages.UnnestOptions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.Value;
import javax.annotation.Nonnull;

public final class Unnest
extends Stage {
    private final Expression expr;
    private final Field alias;

    public Unnest(@Nonnull Field field, @Nonnull String alias) {
        super("unnest", InternalOptions.EMPTY);
        this.expr = field;
        this.alias = Expression.field(alias);
    }

    public Unnest(@Nonnull Field field, @Nonnull String alias, @Nonnull UnnestOptions options) {
        super("unnest", options.options);
        this.expr = field;
        this.alias = Expression.field(alias);
    }

    public Unnest(@Nonnull Selectable field) {
        super("unnest", InternalOptions.EMPTY);
        if (field instanceof AliasedExpression) {
            this.expr = ((AliasedExpression)field).getExpr();
            this.alias = Expression.field(((AliasedExpression)field).getAlias());
        } else {
            this.expr = (Field)field;
            this.alias = (Field)field;
        }
    }

    public Unnest(@Nonnull Selectable field, @Nonnull UnnestOptions options) {
        super("unnest", options.options);
        if (field instanceof AliasedExpression) {
            this.expr = ((AliasedExpression)field).getExpr();
            this.alias = Expression.field(((AliasedExpression)field).getAlias());
        } else {
            this.expr = (Field)field;
            this.alias = (Field)field;
        }
    }

    @Override
    Iterable<Value> toStageArgs() {
        return ImmutableList.of((Object)PipelineUtils.encodeValue(this.expr), (Object)PipelineUtils.encodeValue(this.alias));
    }
}

