/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotAllowedValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final List<String> fieldNames;

    public NotAllowedValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.NOT_ALLOWED, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (schemaNode.isArray()) {
            int size = schemaNode.size();
            this.fieldNames = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                this.fieldNames.add(schemaNode.get(i).asText());
            }
        } else {
            this.fieldNames = Collections.emptyList();
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        for (String fieldName : this.fieldNames) {
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode == null) continue;
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().property(fieldName)).instanceNode(node)).evaluationPath(executionContext.getEvaluationPath())).instanceLocation(instanceLocation.append(fieldName))).locale(executionContext.getExecutionConfig().getLocale())).arguments(fieldName)).build());
        }
    }
}

