/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.MatchError;
import scala.collection.AbstractIterator;
import scala.collection.IterableOnce$;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorInline$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class NewVectorIterator<A>
extends AbstractIterator<A>
implements Cloneable {
    private final Vector<A> v;
    private int totalLength;
    private final int sliceCount;
    private Object[] a1;
    private Object[][] a2;
    private Object[][][] a3;
    private Object[][][][] a4;
    private Object[][][][][] a5;
    private Object[][][][][][] a6;
    private int a1len;
    private int i1;
    private int oldPos;
    private int len1;
    private int sliceIdx;
    private int sliceDim;
    private int sliceStart;
    private int sliceEnd;

    public NewVectorIterator(Vector<A> v, int totalLength, int sliceCount) {
        this.v = v;
        this.totalLength = totalLength;
        this.sliceCount = sliceCount;
        this.a1 = v.prefix1();
        this.a1len = this.a1.length;
        this.i1 = 0;
        this.oldPos = 0;
        this.len1 = this.totalLength();
        this.sliceIdx = 0;
        this.sliceDim = 1;
        this.sliceStart = 0;
        this.sliceEnd = this.a1len;
    }

    private int totalLength() {
        return this.totalLength;
    }

    private void totalLength_$eq(int x$0) {
        this.totalLength = x$0;
    }

    private int sliceCount() {
        return this.sliceCount;
    }

    @Override
    public int knownSize() {
        return this.len1 - this.i1;
    }

    @Override
    public boolean hasNext() {
        return this.len1 > this.i1;
    }

    @Override
    public A next() {
        if (this.i1 == this.a1len) {
            this.advance();
        }
        Object r = this.a1[this.i1];
        ++this.i1;
        return (A)r;
    }

    private void advanceSlice() {
        if (!this.hasNext()) {
            Iterator$.MODULE$.empty().next();
        }
        ++this.sliceIdx;
        Object[] slice = this.v.vectorSlice(this.sliceIdx);
        while (slice.length == 0) {
            ++this.sliceIdx;
            slice = this.v.vectorSlice(this.sliceIdx);
        }
        this.sliceStart = this.sliceEnd;
        int n = this.sliceDim = VectorInline$.MODULE$.vectorSliceDim(this.sliceCount(), this.sliceIdx);
        switch (n) {
            case 1: {
                this.a1 = slice;
                break;
            }
            case 2: {
                this.a2 = (Object[][])slice;
                break;
            }
            case 3: {
                this.a3 = (Object[][][])slice;
                break;
            }
            case 4: {
                this.a4 = (Object[][][][])slice;
                break;
            }
            case 5: {
                this.a5 = (Object[][][][][])slice;
                break;
            }
            case 6: {
                this.a6 = (Object[][][][][][])slice;
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        this.sliceEnd = this.sliceStart + slice.length * (1 << 5 * (this.sliceDim - 1));
        if (this.sliceEnd > this.totalLength()) {
            this.sliceEnd = this.totalLength();
        }
        if (this.sliceDim > 1) {
            this.oldPos = (1 << 5 * this.sliceDim) - 1;
            return;
        }
    }

    private void advance() {
        int pos = this.i1 - this.len1 + this.totalLength();
        if (pos == this.sliceEnd) {
            this.advanceSlice();
        }
        if (this.sliceDim > 1) {
            int io = pos - this.sliceStart;
            int xor = this.oldPos ^ io;
            this.advanceA(io, xor);
            this.oldPos = io;
        }
        this.len1 -= this.i1;
        this.a1len = Math.min(this.a1.length, this.len1);
        this.i1 = 0;
    }

    private void advanceA(int io, int xor) {
        if (xor < 1024) {
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 32768) {
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[0];
            return;
        }
        if (xor < 0x100000) {
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[0];
            this.a1 = this.a2[0];
            return;
        }
        if (xor < 0x2000000) {
            this.a4 = this.a5[io >>> 20 & 0x1F];
            this.a3 = this.a4[0];
            this.a2 = this.a3[0];
            this.a1 = this.a2[0];
            return;
        }
        this.a5 = this.a6[io >>> 25];
        this.a4 = this.a5[0];
        this.a3 = this.a4[0];
        this.a2 = this.a3[0];
        this.a1 = this.a2[0];
    }

    private void setA(int io, int xor) {
        if (xor < 1024) {
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 32768) {
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 0x100000) {
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        if (xor < 0x2000000) {
            this.a4 = this.a5[io >>> 20 & 0x1F];
            this.a3 = this.a4[io >>> 15 & 0x1F];
            this.a2 = this.a3[io >>> 10 & 0x1F];
            this.a1 = this.a2[io >>> 5 & 0x1F];
            return;
        }
        this.a5 = this.a6[io >>> 25];
        this.a4 = this.a5[io >>> 20 & 0x1F];
        this.a3 = this.a4[io >>> 15 & 0x1F];
        this.a2 = this.a3[io >>> 10 & 0x1F];
        this.a1 = this.a2[io >>> 5 & 0x1F];
    }

    @Override
    public Iterator<A> drop(int n) {
        if (n > 0) {
            int oldpos = this.i1 - this.len1 + this.totalLength();
            int newpos = Math.min(oldpos + n, this.totalLength());
            if (newpos == this.totalLength()) {
                this.i1 = 0;
                this.len1 = 0;
                this.a1len = 0;
            } else {
                while (newpos >= this.sliceEnd) {
                    this.advanceSlice();
                }
                int io = newpos - this.sliceStart;
                if (this.sliceDim > 1) {
                    int xor = this.oldPos ^ io;
                    this.setA(io, xor);
                    this.oldPos = io;
                }
                this.a1len = this.a1.length;
                this.i1 = io & 0x1F;
                this.len1 = this.i1 + (this.totalLength() - newpos);
                if (this.a1len > this.len1) {
                    this.a1len = this.len1;
                }
            }
        }
        return this;
    }

    @Override
    public Iterator<A> take(int n) {
        if (n < this.knownSize()) {
            int trunc = this.knownSize() - Math.max(0, n);
            this.totalLength_$eq(this.totalLength() - trunc);
            this.len1 -= trunc;
            if (this.len1 < this.a1len) {
                this.a1len = this.len1;
            }
            if (this.totalLength() < this.sliceEnd) {
                this.sliceEnd = this.totalLength();
            }
        }
        return this;
    }

    @Override
    public Iterator<A> slice(int from, int until) {
        int n;
        int _until = Math.max(until, 0);
        if (from > 0) {
            this.drop(from);
            n = _until - from;
        } else {
            n = _until;
        }
        int n2 = n;
        return this.take(n2);
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        int count;
        int xsLen = ScalaRunTime$.MODULE$.array_length(xs);
        int total = IterableOnce$.MODULE$.elemsToCopyToArray(this.knownSize(), xsLen, start, len);
        boolean isBoxed = xs instanceof Object[];
        for (int copied = 0; copied < total; copied += count) {
            if (this.i1 == this.a1len) {
                this.advance();
            }
            count = Math.min(total - copied, this.a1.length - this.i1);
            if (isBoxed) {
                System.arraycopy(this.a1, this.i1, xs, start + copied, count);
            } else {
                Array$.MODULE$.copy(this.a1, this.i1, xs, start + copied, count);
            }
            this.i1 += count;
        }
        return total;
    }

    @Override
    public Vector<A> toVector() {
        return (Vector)this.v.slice(this.i1 - this.len1 + this.totalLength(), this.totalLength());
    }

    public NewVectorIterator<A> split(int at) {
        NewVectorIterator it2 = (NewVectorIterator)this.clone();
        it2.take(at);
        this.drop(at);
        return it2;
    }
}

