// Code generated by /Users/dpittman/src/peg/peg delocate.peg. DO NOT EDIT.

package main

import (
	"bytes"
	"fmt"
	"io"
	"os"
	"sort"
	"strconv"
)

const endSymbol rune = 1114112

/* The rule types inferred from the grammar are below. */
type pegRule uint8

const (
	ruleUnknown pegRule = iota
	ruleAsmFile
	ruleStatement
	ruleGlobalDirective
	ruleDirective
	ruleDirectiveName
	ruleLocationDirective
	ruleZeroDirective
	ruleFileDirective
	ruleLocDirective
	ruleArgs
	ruleArg
	ruleQuotedArg
	ruleQuotedText
	ruleLabelContainingDirective
	ruleLabelContainingDirectiveName
	ruleSymbolArgs
	ruleSymbolArg
	ruleSymbolExpr
	ruleSymbolAtom
	ruleSymbolOperator
	ruleOpenParen
	ruleCloseParen
	ruleSymbolType
	ruleDot
	ruleTCMarker
	ruleEscapedChar
	ruleWS
	ruleComment
	ruleLabel
	ruleSymbolName
	ruleLocalSymbol
	ruleLocalLabel
	ruleLocalLabelRef
	ruleInstruction
	ruleInstructionName
	ruleInstructionArg
	ruleGOTLocation
	ruleGOTSymbolOffset
	ruleAVX512Token
	ruleTOCRefHigh
	ruleTOCRefLow
	ruleIndirectionIndicator
	ruleRegisterOrConstant
	ruleARMConstantTweak
	ruleARMRegister
	ruleARMVectorRegister
	ruleSVE2PredicateRegister
	ruleARMRegisterBoundary
	ruleMemoryRef
	ruleSymbolRef
	ruleLow12BitsSymbolRef
	ruleARMBaseIndexScale
	ruleARMGOTLow12
	ruleARMPostincrement
	ruleBaseIndexScale
	ruleOperator
	ruleOffsetOperator
	ruleOffset
	ruleSection
	ruleSegmentRegister
)

var rul3s = [...]string{
	"Unknown",
	"AsmFile",
	"Statement",
	"GlobalDirective",
	"Directive",
	"DirectiveName",
	"LocationDirective",
	"ZeroDirective",
	"FileDirective",
	"LocDirective",
	"Args",
	"Arg",
	"QuotedArg",
	"QuotedText",
	"LabelContainingDirective",
	"LabelContainingDirectiveName",
	"SymbolArgs",
	"SymbolArg",
	"SymbolExpr",
	"SymbolAtom",
	"SymbolOperator",
	"OpenParen",
	"CloseParen",
	"SymbolType",
	"Dot",
	"TCMarker",
	"EscapedChar",
	"WS",
	"Comment",
	"Label",
	"SymbolName",
	"LocalSymbol",
	"LocalLabel",
	"LocalLabelRef",
	"Instruction",
	"InstructionName",
	"InstructionArg",
	"GOTLocation",
	"GOTSymbolOffset",
	"AVX512Token",
	"TOCRefHigh",
	"TOCRefLow",
	"IndirectionIndicator",
	"RegisterOrConstant",
	"ARMConstantTweak",
	"ARMRegister",
	"ARMVectorRegister",
	"SVE2PredicateRegister",
	"ARMRegisterBoundary",
	"MemoryRef",
	"SymbolRef",
	"Low12BitsSymbolRef",
	"ARMBaseIndexScale",
	"ARMGOTLow12",
	"ARMPostincrement",
	"BaseIndexScale",
	"Operator",
	"OffsetOperator",
	"Offset",
	"Section",
	"SegmentRegister",
}

type token32 struct {
	pegRule
	begin, end uint32
}

func (t *token32) String() string {
	return fmt.Sprintf("\x1B[34m%v\x1B[m %v %v", rul3s[t.pegRule], t.begin, t.end)
}

type node32 struct {
	token32
	up, next *node32
}

func (node *node32) print(w io.Writer, pretty bool, buffer string) {
	var print func(node *node32, depth int)
	print = func(node *node32, depth int) {
		for node != nil {
			for c := 0; c < depth; c++ {
				fmt.Fprintf(w, " ")
			}
			rule := rul3s[node.pegRule]
			quote := strconv.Quote(string(([]rune(buffer)[node.begin:node.end])))
			if !pretty {
				fmt.Fprintf(w, "%v %v\n", rule, quote)
			} else {
				fmt.Fprintf(w, "\x1B[36m%v\x1B[m %v\n", rule, quote)
			}
			if node.up != nil {
				print(node.up, depth+1)
			}
			node = node.next
		}
	}
	print(node, 0)
}

func (node *node32) Print(w io.Writer, buffer string) {
	node.print(w, false, buffer)
}

func (node *node32) PrettyPrint(w io.Writer, buffer string) {
	node.print(w, true, buffer)
}

type tokens32 struct {
	tree []token32
}

func (t *tokens32) Trim(length uint32) {
	t.tree = t.tree[:length]
}

func (t *tokens32) Print() {
	for _, token := range t.tree {
		fmt.Println(token.String())
	}
}

func (t *tokens32) AST() *node32 {
	type element struct {
		node *node32
		down *element
	}
	tokens := t.Tokens()
	var stack *element
	for _, token := range tokens {
		if token.begin == token.end {
			continue
		}
		node := &node32{token32: token}
		for stack != nil && stack.node.begin >= token.begin && stack.node.end <= token.end {
			stack.node.next = node.up
			node.up = stack.node
			stack = stack.down
		}
		stack = &element{node: node, down: stack}
	}
	if stack != nil {
		return stack.node
	}
	return nil
}

func (t *tokens32) PrintSyntaxTree(buffer string) {
	t.AST().Print(os.Stdout, buffer)
}

func (t *tokens32) WriteSyntaxTree(w io.Writer, buffer string) {
	t.AST().Print(w, buffer)
}

func (t *tokens32) PrettyPrintSyntaxTree(buffer string) {
	t.AST().PrettyPrint(os.Stdout, buffer)
}

func (t *tokens32) Add(rule pegRule, begin, end, index uint32) {
	tree, i := t.tree, int(index)
	if i >= len(tree) {
		t.tree = append(tree, token32{pegRule: rule, begin: begin, end: end})
		return
	}
	tree[i] = token32{pegRule: rule, begin: begin, end: end}
}

func (t *tokens32) Tokens() []token32 {
	return t.tree
}

type Asm struct {
	Buffer         string
	buffer         []rune
	rules          [61]func() bool
	parse          func(rule ...int) error
	reset          func()
	Pretty         bool
	disableMemoize bool
	tokens32
}

func (p *Asm) Parse(rule ...int) error {
	return p.parse(rule...)
}

func (p *Asm) Reset() {
	p.reset()
}

type textPosition struct {
	line, symbol int
}

type textPositionMap map[int]textPosition

func translatePositions(buffer []rune, positions []int) textPositionMap {
	length, translations, j, line, symbol := len(positions), make(textPositionMap, len(positions)), 0, 1, 0
	sort.Ints(positions)

search:
	for i, c := range buffer {
		if c == '\n' {
			line, symbol = line+1, 0
		} else {
			symbol++
		}
		if i == positions[j] {
			translations[positions[j]] = textPosition{line, symbol}
			for j++; j < length; j++ {
				if i != positions[j] {
					continue search
				}
			}
			break search
		}
	}

	return translations
}

type parseError struct {
	p   *Asm
	max token32
}

func (e *parseError) Error() string {
	tokens, err := []token32{e.max}, "\n"
	positions, p := make([]int, 2*len(tokens)), 0
	for _, token := range tokens {
		positions[p], p = int(token.begin), p+1
		positions[p], p = int(token.end), p+1
	}
	translations := translatePositions(e.p.buffer, positions)
	format := "parse error near %v (line %v symbol %v - line %v symbol %v):\n%v\n"
	if e.p.Pretty {
		format = "parse error near \x1B[34m%v\x1B[m (line %v symbol %v - line %v symbol %v):\n%v\n"
	}
	for _, token := range tokens {
		begin, end := int(token.begin), int(token.end)
		err += fmt.Sprintf(format,
			rul3s[token.pegRule],
			translations[begin].line, translations[begin].symbol,
			translations[end].line, translations[end].symbol,
			strconv.Quote(string(e.p.buffer[begin:end])))
	}

	return err
}

func (p *Asm) PrintSyntaxTree() {
	if p.Pretty {
		p.tokens32.PrettyPrintSyntaxTree(p.Buffer)
	} else {
		p.tokens32.PrintSyntaxTree(p.Buffer)
	}
}

func (p *Asm) WriteSyntaxTree(w io.Writer) {
	p.tokens32.WriteSyntaxTree(w, p.Buffer)
}

func (p *Asm) SprintSyntaxTree() string {
	var b bytes.Buffer
	p.WriteSyntaxTree(&b)
	return b.String()
}

func Pretty(pretty bool) func(*Asm) error {
	return func(p *Asm) error {
		p.Pretty = pretty
		return nil
	}
}

func Size(size int) func(*Asm) error {
	return func(p *Asm) error {
		p.tokens32 = tokens32{tree: make([]token32, 0, size)}
		return nil
	}
}

func DisableMemoize() func(*Asm) error {
	return func(p *Asm) error {
		p.disableMemoize = true
		return nil
	}
}

type memo struct {
	Matched bool
	Partial []token32
}

type memoKey struct {
	Rule     uint32
	Position uint32
}

func (p *Asm) Init(options ...func(*Asm) error) error {
	var (
		max                  token32
		position, tokenIndex uint32
		buffer               []rune
		memoization          map[memoKey]memo
	)
	for _, option := range options {
		err := option(p)
		if err != nil {
			return err
		}
	}
	p.reset = func() {
		max = token32{}
		position, tokenIndex = 0, 0
		memoization = make(map[memoKey]memo)
		p.buffer = []rune(p.Buffer)
		if len(p.buffer) == 0 || p.buffer[len(p.buffer)-1] != endSymbol {
			p.buffer = append(p.buffer, endSymbol)
		}
		buffer = p.buffer
	}
	p.reset()

	_rules := p.rules
	tree := p.tokens32
	p.parse = func(rule ...int) error {
		r := 1
		if len(rule) > 0 {
			r = rule[0]
		}
		matches := p.rules[r]()
		p.tokens32 = tree
		if matches {
			p.Trim(tokenIndex)
			return nil
		}
		return &parseError{p, max}
	}

	add := func(rule pegRule, begin uint32) {
		tree.Add(rule, begin, position, tokenIndex)
		tokenIndex++
		if begin != position && position > max.end {
			max = token32{rule, begin, position}
		}
	}

	memoize := func(rule uint32, begin uint32, tokenIndexStart uint32, matched bool) {
		if p.disableMemoize {
			return
		}
		key := memoKey{rule, begin}
		if !matched {
			memoization[key] = memo{Matched: false}
		} else {
			t := tree.tree[tokenIndexStart:tokenIndex]
			tokenCopy := make([]token32, len(t))
			copy(tokenCopy, t)
			memoization[key] = memo{Matched: true, Partial: tokenCopy}
		}
	}

	memoizedResult := func(m memo) bool {
		if !m.Matched {
			return false
		}
		tree.tree = append(tree.tree[:tokenIndex], m.Partial...)
		tokenIndex += uint32(len(m.Partial))
		position = m.Partial[len(m.Partial)-1].end
		if tree.tree[tokenIndex-1].begin != position && position > max.end {
			max = tree.tree[tokenIndex-1]
		}
		return true
	}

	matchDot := func() bool {
		if buffer[position] != endSymbol {
			position++
			return true
		}
		return false
	}

	/*matchChar := func(c byte) bool {
		if buffer[position] == c {
			position++
			return true
		}
		return false
	}*/

	/*matchRange := func(lower byte, upper byte) bool {
		if c := buffer[position]; c >= lower && c <= upper {
			position++
			return true
		}
		return false
	}*/

	_rules = [...]func() bool{
		nil,
		/* 0 AsmFile <- <(Statement* !.)> */
		func() bool {
			if memoized, ok := memoization[memoKey{0, position}]; ok {
				return memoizedResult(memoized)
			}
			position0, tokenIndex0 := position, tokenIndex
			{
				position1 := position
			l2:
				{
					position3, tokenIndex3 := position, tokenIndex
					if !_rules[ruleStatement]() {
						goto l3
					}
					goto l2
				l3:
					position, tokenIndex = position3, tokenIndex3
				}
				{
					position4, tokenIndex4 := position, tokenIndex
					if !matchDot() {
						goto l4
					}
					goto l0
				l4:
					position, tokenIndex = position4, tokenIndex4
				}
				add(ruleAsmFile, position1)
			}
			memoize(0, position0, tokenIndex0, true)
			return true
		l0:
			memoize(0, position0, tokenIndex0, false)
			position, tokenIndex = position0, tokenIndex0
			return false
		},
		/* 1 Statement <- <(WS? (Label / ((GlobalDirective / LocationDirective / LabelContainingDirective / ZeroDirective / Instruction / Directive / Comment / ) WS? ((Comment? '\n') / ';'))))> */
		func() bool {
			if memoized, ok := memoization[memoKey{1, position}]; ok {
				return memoizedResult(memoized)
			}
			position5, tokenIndex5 := position, tokenIndex
			{
				position6 := position
				{
					position7, tokenIndex7 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l7
					}
					goto l8
				l7:
					position, tokenIndex = position7, tokenIndex7
				}
			l8:
				{
					position9, tokenIndex9 := position, tokenIndex
					if !_rules[ruleLabel]() {
						goto l10
					}
					goto l9
				l10:
					position, tokenIndex = position9, tokenIndex9
					{
						position11, tokenIndex11 := position, tokenIndex
						if !_rules[ruleGlobalDirective]() {
							goto l12
						}
						goto l11
					l12:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLocationDirective]() {
							goto l13
						}
						goto l11
					l13:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleLabelContainingDirective]() {
							goto l14
						}
						goto l11
					l14:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleZeroDirective]() {
							goto l15
						}
						goto l11
					l15:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleInstruction]() {
							goto l16
						}
						goto l11
					l16:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleDirective]() {
							goto l17
						}
						goto l11
					l17:
						position, tokenIndex = position11, tokenIndex11
						if !_rules[ruleComment]() {
							goto l18
						}
						goto l11
					l18:
						position, tokenIndex = position11, tokenIndex11
					}
				l11:
					{
						position19, tokenIndex19 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l19
						}
						goto l20
					l19:
						position, tokenIndex = position19, tokenIndex19
					}
				l20:
					{
						position21, tokenIndex21 := position, tokenIndex
						{
							position23, tokenIndex23 := position, tokenIndex
							if !_rules[ruleComment]() {
								goto l23
							}
							goto l24
						l23:
							position, tokenIndex = position23, tokenIndex23
						}
					l24:
						if buffer[position] != rune('\n') {
							goto l22
						}
						position++
						goto l21
					l22:
						position, tokenIndex = position21, tokenIndex21
						if buffer[position] != rune(';') {
							goto l5
						}
						position++
					}
				l21:
				}
			l9:
				add(ruleStatement, position6)
			}
			memoize(1, position5, tokenIndex5, true)
			return true
		l5:
			memoize(1, position5, tokenIndex5, false)
			position, tokenIndex = position5, tokenIndex5
			return false
		},
		/* 2 GlobalDirective <- <((('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('a' / 'A') ('l' / 'L')) / ('.' ('g' / 'G') ('l' / 'L') ('o' / 'O') ('b' / 'B') ('l' / 'L'))) WS SymbolName)> */
		func() bool {
			if memoized, ok := memoization[memoKey{2, position}]; ok {
				return memoizedResult(memoized)
			}
			position25, tokenIndex25 := position, tokenIndex
			{
				position26 := position
				{
					position27, tokenIndex27 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l28
					}
					position++
					{
						position29, tokenIndex29 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l30
						}
						position++
						goto l29
					l30:
						position, tokenIndex = position29, tokenIndex29
						if buffer[position] != rune('G') {
							goto l28
						}
						position++
					}
				l29:
					{
						position31, tokenIndex31 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l32
						}
						position++
						goto l31
					l32:
						position, tokenIndex = position31, tokenIndex31
						if buffer[position] != rune('L') {
							goto l28
						}
						position++
					}
				l31:
					{
						position33, tokenIndex33 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l34
						}
						position++
						goto l33
					l34:
						position, tokenIndex = position33, tokenIndex33
						if buffer[position] != rune('O') {
							goto l28
						}
						position++
					}
				l33:
					{
						position35, tokenIndex35 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l36
						}
						position++
						goto l35
					l36:
						position, tokenIndex = position35, tokenIndex35
						if buffer[position] != rune('B') {
							goto l28
						}
						position++
					}
				l35:
					{
						position37, tokenIndex37 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l38
						}
						position++
						goto l37
					l38:
						position, tokenIndex = position37, tokenIndex37
						if buffer[position] != rune('A') {
							goto l28
						}
						position++
					}
				l37:
					{
						position39, tokenIndex39 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l40
						}
						position++
						goto l39
					l40:
						position, tokenIndex = position39, tokenIndex39
						if buffer[position] != rune('L') {
							goto l28
						}
						position++
					}
				l39:
					goto l27
				l28:
					position, tokenIndex = position27, tokenIndex27
					if buffer[position] != rune('.') {
						goto l25
					}
					position++
					{
						position41, tokenIndex41 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l42
						}
						position++
						goto l41
					l42:
						position, tokenIndex = position41, tokenIndex41
						if buffer[position] != rune('G') {
							goto l25
						}
						position++
					}
				l41:
					{
						position43, tokenIndex43 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l44
						}
						position++
						goto l43
					l44:
						position, tokenIndex = position43, tokenIndex43
						if buffer[position] != rune('L') {
							goto l25
						}
						position++
					}
				l43:
					{
						position45, tokenIndex45 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l46
						}
						position++
						goto l45
					l46:
						position, tokenIndex = position45, tokenIndex45
						if buffer[position] != rune('O') {
							goto l25
						}
						position++
					}
				l45:
					{
						position47, tokenIndex47 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l48
						}
						position++
						goto l47
					l48:
						position, tokenIndex = position47, tokenIndex47
						if buffer[position] != rune('B') {
							goto l25
						}
						position++
					}
				l47:
					{
						position49, tokenIndex49 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l50
						}
						position++
						goto l49
					l50:
						position, tokenIndex = position49, tokenIndex49
						if buffer[position] != rune('L') {
							goto l25
						}
						position++
					}
				l49:
				}
			l27:
				if !_rules[ruleWS]() {
					goto l25
				}
				if !_rules[ruleSymbolName]() {
					goto l25
				}
				add(ruleGlobalDirective, position26)
			}
			memoize(2, position25, tokenIndex25, true)
			return true
		l25:
			memoize(2, position25, tokenIndex25, false)
			position, tokenIndex = position25, tokenIndex25
			return false
		},
		/* 3 Directive <- <('.' DirectiveName (WS Args)?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{3, position}]; ok {
				return memoizedResult(memoized)
			}
			position51, tokenIndex51 := position, tokenIndex
			{
				position52 := position
				if buffer[position] != rune('.') {
					goto l51
				}
				position++
				if !_rules[ruleDirectiveName]() {
					goto l51
				}
				{
					position53, tokenIndex53 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l53
					}
					if !_rules[ruleArgs]() {
						goto l53
					}
					goto l54
				l53:
					position, tokenIndex = position53, tokenIndex53
				}
			l54:
				add(ruleDirective, position52)
			}
			memoize(3, position51, tokenIndex51, true)
			return true
		l51:
			memoize(3, position51, tokenIndex51, false)
			position, tokenIndex = position51, tokenIndex51
			return false
		},
		/* 4 DirectiveName <- <([a-z] / [A-Z] / ([0-9] / [0-9]) / '_')+> */
		func() bool {
			if memoized, ok := memoization[memoKey{4, position}]; ok {
				return memoizedResult(memoized)
			}
			position55, tokenIndex55 := position, tokenIndex
			{
				position56 := position
				{
					position59, tokenIndex59 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l60
					}
					position++
					goto l59
				l60:
					position, tokenIndex = position59, tokenIndex59
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l61
					}
					position++
					goto l59
				l61:
					position, tokenIndex = position59, tokenIndex59
					{
						position63, tokenIndex63 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l64
						}
						position++
						goto l63
					l64:
						position, tokenIndex = position63, tokenIndex63
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l62
						}
						position++
					}
				l63:
					goto l59
				l62:
					position, tokenIndex = position59, tokenIndex59
					if buffer[position] != rune('_') {
						goto l55
					}
					position++
				}
			l59:
			l57:
				{
					position58, tokenIndex58 := position, tokenIndex
					{
						position65, tokenIndex65 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l66
						}
						position++
						goto l65
					l66:
						position, tokenIndex = position65, tokenIndex65
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l67
						}
						position++
						goto l65
					l67:
						position, tokenIndex = position65, tokenIndex65
						{
							position69, tokenIndex69 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l70
							}
							position++
							goto l69
						l70:
							position, tokenIndex = position69, tokenIndex69
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l68
							}
							position++
						}
					l69:
						goto l65
					l68:
						position, tokenIndex = position65, tokenIndex65
						if buffer[position] != rune('_') {
							goto l58
						}
						position++
					}
				l65:
					goto l57
				l58:
					position, tokenIndex = position58, tokenIndex58
				}
				add(ruleDirectiveName, position56)
			}
			memoize(4, position55, tokenIndex55, true)
			return true
		l55:
			memoize(4, position55, tokenIndex55, false)
			position, tokenIndex = position55, tokenIndex55
			return false
		},
		/* 5 LocationDirective <- <(FileDirective / LocDirective)> */
		func() bool {
			if memoized, ok := memoization[memoKey{5, position}]; ok {
				return memoizedResult(memoized)
			}
			position71, tokenIndex71 := position, tokenIndex
			{
				position72 := position
				{
					position73, tokenIndex73 := position, tokenIndex
					if !_rules[ruleFileDirective]() {
						goto l74
					}
					goto l73
				l74:
					position, tokenIndex = position73, tokenIndex73
					if !_rules[ruleLocDirective]() {
						goto l71
					}
				}
			l73:
				add(ruleLocationDirective, position72)
			}
			memoize(5, position71, tokenIndex71, true)
			return true
		l71:
			memoize(5, position71, tokenIndex71, false)
			position, tokenIndex = position71, tokenIndex71
			return false
		},
		/* 6 ZeroDirective <- <('.' ('z' / 'Z') ('e' / 'E') ('r' / 'R') ('o' / 'O') WS (!('#' / '\n') .)+)> */
		func() bool {
			if memoized, ok := memoization[memoKey{6, position}]; ok {
				return memoizedResult(memoized)
			}
			position75, tokenIndex75 := position, tokenIndex
			{
				position76 := position
				if buffer[position] != rune('.') {
					goto l75
				}
				position++
				{
					position77, tokenIndex77 := position, tokenIndex
					if buffer[position] != rune('z') {
						goto l78
					}
					position++
					goto l77
				l78:
					position, tokenIndex = position77, tokenIndex77
					if buffer[position] != rune('Z') {
						goto l75
					}
					position++
				}
			l77:
				{
					position79, tokenIndex79 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l80
					}
					position++
					goto l79
				l80:
					position, tokenIndex = position79, tokenIndex79
					if buffer[position] != rune('E') {
						goto l75
					}
					position++
				}
			l79:
				{
					position81, tokenIndex81 := position, tokenIndex
					if buffer[position] != rune('r') {
						goto l82
					}
					position++
					goto l81
				l82:
					position, tokenIndex = position81, tokenIndex81
					if buffer[position] != rune('R') {
						goto l75
					}
					position++
				}
			l81:
				{
					position83, tokenIndex83 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l84
					}
					position++
					goto l83
				l84:
					position, tokenIndex = position83, tokenIndex83
					if buffer[position] != rune('O') {
						goto l75
					}
					position++
				}
			l83:
				if !_rules[ruleWS]() {
					goto l75
				}
				{
					position87, tokenIndex87 := position, tokenIndex
					{
						position88, tokenIndex88 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l89
						}
						position++
						goto l88
					l89:
						position, tokenIndex = position88, tokenIndex88
						if buffer[position] != rune('\n') {
							goto l87
						}
						position++
					}
				l88:
					goto l75
				l87:
					position, tokenIndex = position87, tokenIndex87
				}
				if !matchDot() {
					goto l75
				}
			l85:
				{
					position86, tokenIndex86 := position, tokenIndex
					{
						position90, tokenIndex90 := position, tokenIndex
						{
							position91, tokenIndex91 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l92
							}
							position++
							goto l91
						l92:
							position, tokenIndex = position91, tokenIndex91
							if buffer[position] != rune('\n') {
								goto l90
							}
							position++
						}
					l91:
						goto l86
					l90:
						position, tokenIndex = position90, tokenIndex90
					}
					if !matchDot() {
						goto l86
					}
					goto l85
				l86:
					position, tokenIndex = position86, tokenIndex86
				}
				add(ruleZeroDirective, position76)
			}
			memoize(6, position75, tokenIndex75, true)
			return true
		l75:
			memoize(6, position75, tokenIndex75, false)
			position, tokenIndex = position75, tokenIndex75
			return false
		},
		/* 7 FileDirective <- <('.' ('f' / 'F') ('i' / 'I') ('l' / 'L') ('e' / 'E') WS (!('#' / '\n') .)+)> */
		func() bool {
			if memoized, ok := memoization[memoKey{7, position}]; ok {
				return memoizedResult(memoized)
			}
			position93, tokenIndex93 := position, tokenIndex
			{
				position94 := position
				if buffer[position] != rune('.') {
					goto l93
				}
				position++
				{
					position95, tokenIndex95 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l96
					}
					position++
					goto l95
				l96:
					position, tokenIndex = position95, tokenIndex95
					if buffer[position] != rune('F') {
						goto l93
					}
					position++
				}
			l95:
				{
					position97, tokenIndex97 := position, tokenIndex
					if buffer[position] != rune('i') {
						goto l98
					}
					position++
					goto l97
				l98:
					position, tokenIndex = position97, tokenIndex97
					if buffer[position] != rune('I') {
						goto l93
					}
					position++
				}
			l97:
				{
					position99, tokenIndex99 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l100
					}
					position++
					goto l99
				l100:
					position, tokenIndex = position99, tokenIndex99
					if buffer[position] != rune('L') {
						goto l93
					}
					position++
				}
			l99:
				{
					position101, tokenIndex101 := position, tokenIndex
					if buffer[position] != rune('e') {
						goto l102
					}
					position++
					goto l101
				l102:
					position, tokenIndex = position101, tokenIndex101
					if buffer[position] != rune('E') {
						goto l93
					}
					position++
				}
			l101:
				if !_rules[ruleWS]() {
					goto l93
				}
				{
					position105, tokenIndex105 := position, tokenIndex
					{
						position106, tokenIndex106 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l107
						}
						position++
						goto l106
					l107:
						position, tokenIndex = position106, tokenIndex106
						if buffer[position] != rune('\n') {
							goto l105
						}
						position++
					}
				l106:
					goto l93
				l105:
					position, tokenIndex = position105, tokenIndex105
				}
				if !matchDot() {
					goto l93
				}
			l103:
				{
					position104, tokenIndex104 := position, tokenIndex
					{
						position108, tokenIndex108 := position, tokenIndex
						{
							position109, tokenIndex109 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l110
							}
							position++
							goto l109
						l110:
							position, tokenIndex = position109, tokenIndex109
							if buffer[position] != rune('\n') {
								goto l108
							}
							position++
						}
					l109:
						goto l104
					l108:
						position, tokenIndex = position108, tokenIndex108
					}
					if !matchDot() {
						goto l104
					}
					goto l103
				l104:
					position, tokenIndex = position104, tokenIndex104
				}
				add(ruleFileDirective, position94)
			}
			memoize(7, position93, tokenIndex93, true)
			return true
		l93:
			memoize(7, position93, tokenIndex93, false)
			position, tokenIndex = position93, tokenIndex93
			return false
		},
		/* 8 LocDirective <- <('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') WS (!('#' / '/' / '\n') .)+)> */
		func() bool {
			if memoized, ok := memoization[memoKey{8, position}]; ok {
				return memoizedResult(memoized)
			}
			position111, tokenIndex111 := position, tokenIndex
			{
				position112 := position
				if buffer[position] != rune('.') {
					goto l111
				}
				position++
				{
					position113, tokenIndex113 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l114
					}
					position++
					goto l113
				l114:
					position, tokenIndex = position113, tokenIndex113
					if buffer[position] != rune('L') {
						goto l111
					}
					position++
				}
			l113:
				{
					position115, tokenIndex115 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l116
					}
					position++
					goto l115
				l116:
					position, tokenIndex = position115, tokenIndex115
					if buffer[position] != rune('O') {
						goto l111
					}
					position++
				}
			l115:
				{
					position117, tokenIndex117 := position, tokenIndex
					if buffer[position] != rune('c') {
						goto l118
					}
					position++
					goto l117
				l118:
					position, tokenIndex = position117, tokenIndex117
					if buffer[position] != rune('C') {
						goto l111
					}
					position++
				}
			l117:
				if !_rules[ruleWS]() {
					goto l111
				}
				{
					position121, tokenIndex121 := position, tokenIndex
					{
						position122, tokenIndex122 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l123
						}
						position++
						goto l122
					l123:
						position, tokenIndex = position122, tokenIndex122
						if buffer[position] != rune('/') {
							goto l124
						}
						position++
						goto l122
					l124:
						position, tokenIndex = position122, tokenIndex122
						if buffer[position] != rune('\n') {
							goto l121
						}
						position++
					}
				l122:
					goto l111
				l121:
					position, tokenIndex = position121, tokenIndex121
				}
				if !matchDot() {
					goto l111
				}
			l119:
				{
					position120, tokenIndex120 := position, tokenIndex
					{
						position125, tokenIndex125 := position, tokenIndex
						{
							position126, tokenIndex126 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l127
							}
							position++
							goto l126
						l127:
							position, tokenIndex = position126, tokenIndex126
							if buffer[position] != rune('/') {
								goto l128
							}
							position++
							goto l126
						l128:
							position, tokenIndex = position126, tokenIndex126
							if buffer[position] != rune('\n') {
								goto l125
							}
							position++
						}
					l126:
						goto l120
					l125:
						position, tokenIndex = position125, tokenIndex125
					}
					if !matchDot() {
						goto l120
					}
					goto l119
				l120:
					position, tokenIndex = position120, tokenIndex120
				}
				add(ruleLocDirective, position112)
			}
			memoize(8, position111, tokenIndex111, true)
			return true
		l111:
			memoize(8, position111, tokenIndex111, false)
			position, tokenIndex = position111, tokenIndex111
			return false
		},
		/* 9 Args <- <(Arg (WS? ',' WS? Arg)*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{9, position}]; ok {
				return memoizedResult(memoized)
			}
			position129, tokenIndex129 := position, tokenIndex
			{
				position130 := position
				if !_rules[ruleArg]() {
					goto l129
				}
			l131:
				{
					position132, tokenIndex132 := position, tokenIndex
					{
						position133, tokenIndex133 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l133
						}
						goto l134
					l133:
						position, tokenIndex = position133, tokenIndex133
					}
				l134:
					if buffer[position] != rune(',') {
						goto l132
					}
					position++
					{
						position135, tokenIndex135 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l135
						}
						goto l136
					l135:
						position, tokenIndex = position135, tokenIndex135
					}
				l136:
					if !_rules[ruleArg]() {
						goto l132
					}
					goto l131
				l132:
					position, tokenIndex = position132, tokenIndex132
				}
				add(ruleArgs, position130)
			}
			memoize(9, position129, tokenIndex129, true)
			return true
		l129:
			memoize(9, position129, tokenIndex129, false)
			position, tokenIndex = position129, tokenIndex129
			return false
		},
		/* 10 Arg <- <(QuotedArg / ([0-9] / [0-9] / ([a-z] / [A-Z]) / '%' / '+' / '-' / '*' / '_' / '@' / '.')*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{10, position}]; ok {
				return memoizedResult(memoized)
			}
			position137, tokenIndex137 := position, tokenIndex
			{
				position138 := position
				{
					position139, tokenIndex139 := position, tokenIndex
					if !_rules[ruleQuotedArg]() {
						goto l140
					}
					goto l139
				l140:
					position, tokenIndex = position139, tokenIndex139
				l141:
					{
						position142, tokenIndex142 := position, tokenIndex
						{
							position143, tokenIndex143 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l144
							}
							position++
							goto l143
						l144:
							position, tokenIndex = position143, tokenIndex143
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l145
							}
							position++
							goto l143
						l145:
							position, tokenIndex = position143, tokenIndex143
							{
								position147, tokenIndex147 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('z') {
									goto l148
								}
								position++
								goto l147
							l148:
								position, tokenIndex = position147, tokenIndex147
								if c := buffer[position]; c < rune('A') || c > rune('Z') {
									goto l146
								}
								position++
							}
						l147:
							goto l143
						l146:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('%') {
								goto l149
							}
							position++
							goto l143
						l149:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('+') {
								goto l150
							}
							position++
							goto l143
						l150:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('-') {
								goto l151
							}
							position++
							goto l143
						l151:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('*') {
								goto l152
							}
							position++
							goto l143
						l152:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('_') {
								goto l153
							}
							position++
							goto l143
						l153:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('@') {
								goto l154
							}
							position++
							goto l143
						l154:
							position, tokenIndex = position143, tokenIndex143
							if buffer[position] != rune('.') {
								goto l142
							}
							position++
						}
					l143:
						goto l141
					l142:
						position, tokenIndex = position142, tokenIndex142
					}
				}
			l139:
				add(ruleArg, position138)
			}
			memoize(10, position137, tokenIndex137, true)
			return true
		},
		/* 11 QuotedArg <- <('"' QuotedText '"')> */
		func() bool {
			if memoized, ok := memoization[memoKey{11, position}]; ok {
				return memoizedResult(memoized)
			}
			position155, tokenIndex155 := position, tokenIndex
			{
				position156 := position
				if buffer[position] != rune('"') {
					goto l155
				}
				position++
				if !_rules[ruleQuotedText]() {
					goto l155
				}
				if buffer[position] != rune('"') {
					goto l155
				}
				position++
				add(ruleQuotedArg, position156)
			}
			memoize(11, position155, tokenIndex155, true)
			return true
		l155:
			memoize(11, position155, tokenIndex155, false)
			position, tokenIndex = position155, tokenIndex155
			return false
		},
		/* 12 QuotedText <- <(EscapedChar / (!'"' .))*> */
		func() bool {
			if memoized, ok := memoization[memoKey{12, position}]; ok {
				return memoizedResult(memoized)
			}
			position157, tokenIndex157 := position, tokenIndex
			{
				position158 := position
			l159:
				{
					position160, tokenIndex160 := position, tokenIndex
					{
						position161, tokenIndex161 := position, tokenIndex
						if !_rules[ruleEscapedChar]() {
							goto l162
						}
						goto l161
					l162:
						position, tokenIndex = position161, tokenIndex161
						{
							position163, tokenIndex163 := position, tokenIndex
							if buffer[position] != rune('"') {
								goto l163
							}
							position++
							goto l160
						l163:
							position, tokenIndex = position163, tokenIndex163
						}
						if !matchDot() {
							goto l160
						}
					}
				l161:
					goto l159
				l160:
					position, tokenIndex = position160, tokenIndex160
				}
				add(ruleQuotedText, position158)
			}
			memoize(12, position157, tokenIndex157, true)
			return true
		},
		/* 13 LabelContainingDirective <- <(LabelContainingDirectiveName WS SymbolArgs)> */
		func() bool {
			if memoized, ok := memoization[memoKey{13, position}]; ok {
				return memoizedResult(memoized)
			}
			position164, tokenIndex164 := position, tokenIndex
			{
				position165 := position
				if !_rules[ruleLabelContainingDirectiveName]() {
					goto l164
				}
				if !_rules[ruleWS]() {
					goto l164
				}
				if !_rules[ruleSymbolArgs]() {
					goto l164
				}
				add(ruleLabelContainingDirective, position165)
			}
			memoize(13, position164, tokenIndex164, true)
			return true
		l164:
			memoize(13, position164, tokenIndex164, false)
			position, tokenIndex = position164, tokenIndex164
			return false
		},
		/* 14 LabelContainingDirectiveName <- <(('.' ('x' / 'X') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('h' / 'H') ('w' / 'W') ('o' / 'O') ('r' / 'R') ('d' / 'D')) / ('.' ('l' / 'L') ('o' / 'O') ('n' / 'N') ('g' / 'G')) / ('.' ('s' / 'S') ('e' / 'E') ('t' / 'T')) / ('.' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '8' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' '4' ('b' / 'B') ('y' / 'Y') ('t' / 'T') ('e' / 'E')) / ('.' ('q' / 'Q') ('u' / 'U') ('a' / 'A') ('d' / 'D')) / ('.' ('t' / 'T') ('c' / 'C')) / ('.' ('l' / 'L') ('o' / 'O') ('c' / 'C') ('a' / 'A') ('l' / 'L') ('e' / 'E') ('n' / 'N') ('t' / 'T') ('r' / 'R') ('y' / 'Y')) / ('.' ('s' / 'S') ('i' / 'I') ('z' / 'Z') ('e' / 'E')) / ('.' ('t' / 'T') ('y' / 'Y') ('p' / 'P') ('e' / 'E')) / ('.' ('u' / 'U') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8') / ('.' ('s' / 'S') ('l' / 'L') ('e' / 'E') ('b' / 'B') '1' '2' '8'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{14, position}]; ok {
				return memoizedResult(memoized)
			}
			position166, tokenIndex166 := position, tokenIndex
			{
				position167 := position
				{
					position168, tokenIndex168 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l169
					}
					position++
					{
						position170, tokenIndex170 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l171
						}
						position++
						goto l170
					l171:
						position, tokenIndex = position170, tokenIndex170
						if buffer[position] != rune('X') {
							goto l169
						}
						position++
					}
				l170:
					{
						position172, tokenIndex172 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l173
						}
						position++
						goto l172
					l173:
						position, tokenIndex = position172, tokenIndex172
						if buffer[position] != rune('W') {
							goto l169
						}
						position++
					}
				l172:
					{
						position174, tokenIndex174 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l175
						}
						position++
						goto l174
					l175:
						position, tokenIndex = position174, tokenIndex174
						if buffer[position] != rune('O') {
							goto l169
						}
						position++
					}
				l174:
					{
						position176, tokenIndex176 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l177
						}
						position++
						goto l176
					l177:
						position, tokenIndex = position176, tokenIndex176
						if buffer[position] != rune('R') {
							goto l169
						}
						position++
					}
				l176:
					{
						position178, tokenIndex178 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l179
						}
						position++
						goto l178
					l179:
						position, tokenIndex = position178, tokenIndex178
						if buffer[position] != rune('D') {
							goto l169
						}
						position++
					}
				l178:
					goto l168
				l169:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l180
					}
					position++
					{
						position181, tokenIndex181 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l182
						}
						position++
						goto l181
					l182:
						position, tokenIndex = position181, tokenIndex181
						if buffer[position] != rune('W') {
							goto l180
						}
						position++
					}
				l181:
					{
						position183, tokenIndex183 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l184
						}
						position++
						goto l183
					l184:
						position, tokenIndex = position183, tokenIndex183
						if buffer[position] != rune('O') {
							goto l180
						}
						position++
					}
				l183:
					{
						position185, tokenIndex185 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l186
						}
						position++
						goto l185
					l186:
						position, tokenIndex = position185, tokenIndex185
						if buffer[position] != rune('R') {
							goto l180
						}
						position++
					}
				l185:
					{
						position187, tokenIndex187 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l188
						}
						position++
						goto l187
					l188:
						position, tokenIndex = position187, tokenIndex187
						if buffer[position] != rune('D') {
							goto l180
						}
						position++
					}
				l187:
					goto l168
				l180:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l189
					}
					position++
					{
						position190, tokenIndex190 := position, tokenIndex
						if buffer[position] != rune('h') {
							goto l191
						}
						position++
						goto l190
					l191:
						position, tokenIndex = position190, tokenIndex190
						if buffer[position] != rune('H') {
							goto l189
						}
						position++
					}
				l190:
					{
						position192, tokenIndex192 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l193
						}
						position++
						goto l192
					l193:
						position, tokenIndex = position192, tokenIndex192
						if buffer[position] != rune('W') {
							goto l189
						}
						position++
					}
				l192:
					{
						position194, tokenIndex194 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l195
						}
						position++
						goto l194
					l195:
						position, tokenIndex = position194, tokenIndex194
						if buffer[position] != rune('O') {
							goto l189
						}
						position++
					}
				l194:
					{
						position196, tokenIndex196 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l197
						}
						position++
						goto l196
					l197:
						position, tokenIndex = position196, tokenIndex196
						if buffer[position] != rune('R') {
							goto l189
						}
						position++
					}
				l196:
					{
						position198, tokenIndex198 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l199
						}
						position++
						goto l198
					l199:
						position, tokenIndex = position198, tokenIndex198
						if buffer[position] != rune('D') {
							goto l189
						}
						position++
					}
				l198:
					goto l168
				l189:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l200
					}
					position++
					{
						position201, tokenIndex201 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l202
						}
						position++
						goto l201
					l202:
						position, tokenIndex = position201, tokenIndex201
						if buffer[position] != rune('L') {
							goto l200
						}
						position++
					}
				l201:
					{
						position203, tokenIndex203 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l204
						}
						position++
						goto l203
					l204:
						position, tokenIndex = position203, tokenIndex203
						if buffer[position] != rune('O') {
							goto l200
						}
						position++
					}
				l203:
					{
						position205, tokenIndex205 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l206
						}
						position++
						goto l205
					l206:
						position, tokenIndex = position205, tokenIndex205
						if buffer[position] != rune('N') {
							goto l200
						}
						position++
					}
				l205:
					{
						position207, tokenIndex207 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l208
						}
						position++
						goto l207
					l208:
						position, tokenIndex = position207, tokenIndex207
						if buffer[position] != rune('G') {
							goto l200
						}
						position++
					}
				l207:
					goto l168
				l200:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l209
					}
					position++
					{
						position210, tokenIndex210 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l211
						}
						position++
						goto l210
					l211:
						position, tokenIndex = position210, tokenIndex210
						if buffer[position] != rune('S') {
							goto l209
						}
						position++
					}
				l210:
					{
						position212, tokenIndex212 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l213
						}
						position++
						goto l212
					l213:
						position, tokenIndex = position212, tokenIndex212
						if buffer[position] != rune('E') {
							goto l209
						}
						position++
					}
				l212:
					{
						position214, tokenIndex214 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l215
						}
						position++
						goto l214
					l215:
						position, tokenIndex = position214, tokenIndex214
						if buffer[position] != rune('T') {
							goto l209
						}
						position++
					}
				l214:
					goto l168
				l209:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l216
					}
					position++
					{
						position217, tokenIndex217 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l218
						}
						position++
						goto l217
					l218:
						position, tokenIndex = position217, tokenIndex217
						if buffer[position] != rune('B') {
							goto l216
						}
						position++
					}
				l217:
					{
						position219, tokenIndex219 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l220
						}
						position++
						goto l219
					l220:
						position, tokenIndex = position219, tokenIndex219
						if buffer[position] != rune('Y') {
							goto l216
						}
						position++
					}
				l219:
					{
						position221, tokenIndex221 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l222
						}
						position++
						goto l221
					l222:
						position, tokenIndex = position221, tokenIndex221
						if buffer[position] != rune('T') {
							goto l216
						}
						position++
					}
				l221:
					{
						position223, tokenIndex223 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l224
						}
						position++
						goto l223
					l224:
						position, tokenIndex = position223, tokenIndex223
						if buffer[position] != rune('E') {
							goto l216
						}
						position++
					}
				l223:
					goto l168
				l216:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l225
					}
					position++
					if buffer[position] != rune('8') {
						goto l225
					}
					position++
					{
						position226, tokenIndex226 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l227
						}
						position++
						goto l226
					l227:
						position, tokenIndex = position226, tokenIndex226
						if buffer[position] != rune('B') {
							goto l225
						}
						position++
					}
				l226:
					{
						position228, tokenIndex228 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l229
						}
						position++
						goto l228
					l229:
						position, tokenIndex = position228, tokenIndex228
						if buffer[position] != rune('Y') {
							goto l225
						}
						position++
					}
				l228:
					{
						position230, tokenIndex230 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l231
						}
						position++
						goto l230
					l231:
						position, tokenIndex = position230, tokenIndex230
						if buffer[position] != rune('T') {
							goto l225
						}
						position++
					}
				l230:
					{
						position232, tokenIndex232 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l233
						}
						position++
						goto l232
					l233:
						position, tokenIndex = position232, tokenIndex232
						if buffer[position] != rune('E') {
							goto l225
						}
						position++
					}
				l232:
					goto l168
				l225:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l234
					}
					position++
					if buffer[position] != rune('4') {
						goto l234
					}
					position++
					{
						position235, tokenIndex235 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l236
						}
						position++
						goto l235
					l236:
						position, tokenIndex = position235, tokenIndex235
						if buffer[position] != rune('B') {
							goto l234
						}
						position++
					}
				l235:
					{
						position237, tokenIndex237 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l238
						}
						position++
						goto l237
					l238:
						position, tokenIndex = position237, tokenIndex237
						if buffer[position] != rune('Y') {
							goto l234
						}
						position++
					}
				l237:
					{
						position239, tokenIndex239 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l240
						}
						position++
						goto l239
					l240:
						position, tokenIndex = position239, tokenIndex239
						if buffer[position] != rune('T') {
							goto l234
						}
						position++
					}
				l239:
					{
						position241, tokenIndex241 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l242
						}
						position++
						goto l241
					l242:
						position, tokenIndex = position241, tokenIndex241
						if buffer[position] != rune('E') {
							goto l234
						}
						position++
					}
				l241:
					goto l168
				l234:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l243
					}
					position++
					{
						position244, tokenIndex244 := position, tokenIndex
						if buffer[position] != rune('q') {
							goto l245
						}
						position++
						goto l244
					l245:
						position, tokenIndex = position244, tokenIndex244
						if buffer[position] != rune('Q') {
							goto l243
						}
						position++
					}
				l244:
					{
						position246, tokenIndex246 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l247
						}
						position++
						goto l246
					l247:
						position, tokenIndex = position246, tokenIndex246
						if buffer[position] != rune('U') {
							goto l243
						}
						position++
					}
				l246:
					{
						position248, tokenIndex248 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l249
						}
						position++
						goto l248
					l249:
						position, tokenIndex = position248, tokenIndex248
						if buffer[position] != rune('A') {
							goto l243
						}
						position++
					}
				l248:
					{
						position250, tokenIndex250 := position, tokenIndex
						if buffer[position] != rune('d') {
							goto l251
						}
						position++
						goto l250
					l251:
						position, tokenIndex = position250, tokenIndex250
						if buffer[position] != rune('D') {
							goto l243
						}
						position++
					}
				l250:
					goto l168
				l243:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l252
					}
					position++
					{
						position253, tokenIndex253 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l254
						}
						position++
						goto l253
					l254:
						position, tokenIndex = position253, tokenIndex253
						if buffer[position] != rune('T') {
							goto l252
						}
						position++
					}
				l253:
					{
						position255, tokenIndex255 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l256
						}
						position++
						goto l255
					l256:
						position, tokenIndex = position255, tokenIndex255
						if buffer[position] != rune('C') {
							goto l252
						}
						position++
					}
				l255:
					goto l168
				l252:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l257
					}
					position++
					{
						position258, tokenIndex258 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l259
						}
						position++
						goto l258
					l259:
						position, tokenIndex = position258, tokenIndex258
						if buffer[position] != rune('L') {
							goto l257
						}
						position++
					}
				l258:
					{
						position260, tokenIndex260 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l261
						}
						position++
						goto l260
					l261:
						position, tokenIndex = position260, tokenIndex260
						if buffer[position] != rune('O') {
							goto l257
						}
						position++
					}
				l260:
					{
						position262, tokenIndex262 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l263
						}
						position++
						goto l262
					l263:
						position, tokenIndex = position262, tokenIndex262
						if buffer[position] != rune('C') {
							goto l257
						}
						position++
					}
				l262:
					{
						position264, tokenIndex264 := position, tokenIndex
						if buffer[position] != rune('a') {
							goto l265
						}
						position++
						goto l264
					l265:
						position, tokenIndex = position264, tokenIndex264
						if buffer[position] != rune('A') {
							goto l257
						}
						position++
					}
				l264:
					{
						position266, tokenIndex266 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l267
						}
						position++
						goto l266
					l267:
						position, tokenIndex = position266, tokenIndex266
						if buffer[position] != rune('L') {
							goto l257
						}
						position++
					}
				l266:
					{
						position268, tokenIndex268 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l269
						}
						position++
						goto l268
					l269:
						position, tokenIndex = position268, tokenIndex268
						if buffer[position] != rune('E') {
							goto l257
						}
						position++
					}
				l268:
					{
						position270, tokenIndex270 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l271
						}
						position++
						goto l270
					l271:
						position, tokenIndex = position270, tokenIndex270
						if buffer[position] != rune('N') {
							goto l257
						}
						position++
					}
				l270:
					{
						position272, tokenIndex272 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l273
						}
						position++
						goto l272
					l273:
						position, tokenIndex = position272, tokenIndex272
						if buffer[position] != rune('T') {
							goto l257
						}
						position++
					}
				l272:
					{
						position274, tokenIndex274 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l275
						}
						position++
						goto l274
					l275:
						position, tokenIndex = position274, tokenIndex274
						if buffer[position] != rune('R') {
							goto l257
						}
						position++
					}
				l274:
					{
						position276, tokenIndex276 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l277
						}
						position++
						goto l276
					l277:
						position, tokenIndex = position276, tokenIndex276
						if buffer[position] != rune('Y') {
							goto l257
						}
						position++
					}
				l276:
					goto l168
				l257:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l278
					}
					position++
					{
						position279, tokenIndex279 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l280
						}
						position++
						goto l279
					l280:
						position, tokenIndex = position279, tokenIndex279
						if buffer[position] != rune('S') {
							goto l278
						}
						position++
					}
				l279:
					{
						position281, tokenIndex281 := position, tokenIndex
						if buffer[position] != rune('i') {
							goto l282
						}
						position++
						goto l281
					l282:
						position, tokenIndex = position281, tokenIndex281
						if buffer[position] != rune('I') {
							goto l278
						}
						position++
					}
				l281:
					{
						position283, tokenIndex283 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l284
						}
						position++
						goto l283
					l284:
						position, tokenIndex = position283, tokenIndex283
						if buffer[position] != rune('Z') {
							goto l278
						}
						position++
					}
				l283:
					{
						position285, tokenIndex285 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l286
						}
						position++
						goto l285
					l286:
						position, tokenIndex = position285, tokenIndex285
						if buffer[position] != rune('E') {
							goto l278
						}
						position++
					}
				l285:
					goto l168
				l278:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l287
					}
					position++
					{
						position288, tokenIndex288 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l289
						}
						position++
						goto l288
					l289:
						position, tokenIndex = position288, tokenIndex288
						if buffer[position] != rune('T') {
							goto l287
						}
						position++
					}
				l288:
					{
						position290, tokenIndex290 := position, tokenIndex
						if buffer[position] != rune('y') {
							goto l291
						}
						position++
						goto l290
					l291:
						position, tokenIndex = position290, tokenIndex290
						if buffer[position] != rune('Y') {
							goto l287
						}
						position++
					}
				l290:
					{
						position292, tokenIndex292 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l293
						}
						position++
						goto l292
					l293:
						position, tokenIndex = position292, tokenIndex292
						if buffer[position] != rune('P') {
							goto l287
						}
						position++
					}
				l292:
					{
						position294, tokenIndex294 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l295
						}
						position++
						goto l294
					l295:
						position, tokenIndex = position294, tokenIndex294
						if buffer[position] != rune('E') {
							goto l287
						}
						position++
					}
				l294:
					goto l168
				l287:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l296
					}
					position++
					{
						position297, tokenIndex297 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l298
						}
						position++
						goto l297
					l298:
						position, tokenIndex = position297, tokenIndex297
						if buffer[position] != rune('U') {
							goto l296
						}
						position++
					}
				l297:
					{
						position299, tokenIndex299 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l300
						}
						position++
						goto l299
					l300:
						position, tokenIndex = position299, tokenIndex299
						if buffer[position] != rune('L') {
							goto l296
						}
						position++
					}
				l299:
					{
						position301, tokenIndex301 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l302
						}
						position++
						goto l301
					l302:
						position, tokenIndex = position301, tokenIndex301
						if buffer[position] != rune('E') {
							goto l296
						}
						position++
					}
				l301:
					{
						position303, tokenIndex303 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l304
						}
						position++
						goto l303
					l304:
						position, tokenIndex = position303, tokenIndex303
						if buffer[position] != rune('B') {
							goto l296
						}
						position++
					}
				l303:
					if buffer[position] != rune('1') {
						goto l296
					}
					position++
					if buffer[position] != rune('2') {
						goto l296
					}
					position++
					if buffer[position] != rune('8') {
						goto l296
					}
					position++
					goto l168
				l296:
					position, tokenIndex = position168, tokenIndex168
					if buffer[position] != rune('.') {
						goto l166
					}
					position++
					{
						position305, tokenIndex305 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l306
						}
						position++
						goto l305
					l306:
						position, tokenIndex = position305, tokenIndex305
						if buffer[position] != rune('S') {
							goto l166
						}
						position++
					}
				l305:
					{
						position307, tokenIndex307 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l308
						}
						position++
						goto l307
					l308:
						position, tokenIndex = position307, tokenIndex307
						if buffer[position] != rune('L') {
							goto l166
						}
						position++
					}
				l307:
					{
						position309, tokenIndex309 := position, tokenIndex
						if buffer[position] != rune('e') {
							goto l310
						}
						position++
						goto l309
					l310:
						position, tokenIndex = position309, tokenIndex309
						if buffer[position] != rune('E') {
							goto l166
						}
						position++
					}
				l309:
					{
						position311, tokenIndex311 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l312
						}
						position++
						goto l311
					l312:
						position, tokenIndex = position311, tokenIndex311
						if buffer[position] != rune('B') {
							goto l166
						}
						position++
					}
				l311:
					if buffer[position] != rune('1') {
						goto l166
					}
					position++
					if buffer[position] != rune('2') {
						goto l166
					}
					position++
					if buffer[position] != rune('8') {
						goto l166
					}
					position++
				}
			l168:
				add(ruleLabelContainingDirectiveName, position167)
			}
			memoize(14, position166, tokenIndex166, true)
			return true
		l166:
			memoize(14, position166, tokenIndex166, false)
			position, tokenIndex = position166, tokenIndex166
			return false
		},
		/* 15 SymbolArgs <- <(SymbolArg (WS? ',' WS? SymbolArg)*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{15, position}]; ok {
				return memoizedResult(memoized)
			}
			position313, tokenIndex313 := position, tokenIndex
			{
				position314 := position
				if !_rules[ruleSymbolArg]() {
					goto l313
				}
			l315:
				{
					position316, tokenIndex316 := position, tokenIndex
					{
						position317, tokenIndex317 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l317
						}
						goto l318
					l317:
						position, tokenIndex = position317, tokenIndex317
					}
				l318:
					if buffer[position] != rune(',') {
						goto l316
					}
					position++
					{
						position319, tokenIndex319 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l319
						}
						goto l320
					l319:
						position, tokenIndex = position319, tokenIndex319
					}
				l320:
					if !_rules[ruleSymbolArg]() {
						goto l316
					}
					goto l315
				l316:
					position, tokenIndex = position316, tokenIndex316
				}
				add(ruleSymbolArgs, position314)
			}
			memoize(15, position313, tokenIndex313, true)
			return true
		l313:
			memoize(15, position313, tokenIndex313, false)
			position, tokenIndex = position313, tokenIndex313
			return false
		},
		/* 16 SymbolArg <- <SymbolExpr> */
		func() bool {
			if memoized, ok := memoization[memoKey{16, position}]; ok {
				return memoizedResult(memoized)
			}
			position321, tokenIndex321 := position, tokenIndex
			{
				position322 := position
				if !_rules[ruleSymbolExpr]() {
					goto l321
				}
				add(ruleSymbolArg, position322)
			}
			memoize(16, position321, tokenIndex321, true)
			return true
		l321:
			memoize(16, position321, tokenIndex321, false)
			position, tokenIndex = position321, tokenIndex321
			return false
		},
		/* 17 SymbolExpr <- <(SymbolAtom (WS? SymbolOperator WS? SymbolExpr)?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{17, position}]; ok {
				return memoizedResult(memoized)
			}
			position323, tokenIndex323 := position, tokenIndex
			{
				position324 := position
				if !_rules[ruleSymbolAtom]() {
					goto l323
				}
				{
					position325, tokenIndex325 := position, tokenIndex
					{
						position327, tokenIndex327 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l327
						}
						goto l328
					l327:
						position, tokenIndex = position327, tokenIndex327
					}
				l328:
					if !_rules[ruleSymbolOperator]() {
						goto l325
					}
					{
						position329, tokenIndex329 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l329
						}
						goto l330
					l329:
						position, tokenIndex = position329, tokenIndex329
					}
				l330:
					if !_rules[ruleSymbolExpr]() {
						goto l325
					}
					goto l326
				l325:
					position, tokenIndex = position325, tokenIndex325
				}
			l326:
				add(ruleSymbolExpr, position324)
			}
			memoize(17, position323, tokenIndex323, true)
			return true
		l323:
			memoize(17, position323, tokenIndex323, false)
			position, tokenIndex = position323, tokenIndex323
			return false
		},
		/* 18 SymbolAtom <- <(Offset / SymbolType / LocalLabelRef / (LocalSymbol TCMarker?) / (SymbolName Offset) / (SymbolName TCMarker?) / Dot / (OpenParen WS? SymbolExpr WS? CloseParen))> */
		func() bool {
			if memoized, ok := memoization[memoKey{18, position}]; ok {
				return memoizedResult(memoized)
			}
			position331, tokenIndex331 := position, tokenIndex
			{
				position332 := position
				{
					position333, tokenIndex333 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l334
					}
					goto l333
				l334:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolType]() {
						goto l335
					}
					goto l333
				l335:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleLocalLabelRef]() {
						goto l336
					}
					goto l333
				l336:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleLocalSymbol]() {
						goto l337
					}
					{
						position338, tokenIndex338 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l338
						}
						goto l339
					l338:
						position, tokenIndex = position338, tokenIndex338
					}
				l339:
					goto l333
				l337:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolName]() {
						goto l340
					}
					if !_rules[ruleOffset]() {
						goto l340
					}
					goto l333
				l340:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleSymbolName]() {
						goto l341
					}
					{
						position342, tokenIndex342 := position, tokenIndex
						if !_rules[ruleTCMarker]() {
							goto l342
						}
						goto l343
					l342:
						position, tokenIndex = position342, tokenIndex342
					}
				l343:
					goto l333
				l341:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleDot]() {
						goto l344
					}
					goto l333
				l344:
					position, tokenIndex = position333, tokenIndex333
					if !_rules[ruleOpenParen]() {
						goto l331
					}
					{
						position345, tokenIndex345 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l345
						}
						goto l346
					l345:
						position, tokenIndex = position345, tokenIndex345
					}
				l346:
					if !_rules[ruleSymbolExpr]() {
						goto l331
					}
					{
						position347, tokenIndex347 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l347
						}
						goto l348
					l347:
						position, tokenIndex = position347, tokenIndex347
					}
				l348:
					if !_rules[ruleCloseParen]() {
						goto l331
					}
				}
			l333:
				add(ruleSymbolAtom, position332)
			}
			memoize(18, position331, tokenIndex331, true)
			return true
		l331:
			memoize(18, position331, tokenIndex331, false)
			position, tokenIndex = position331, tokenIndex331
			return false
		},
		/* 19 SymbolOperator <- <('+' / '-' / '|' / ('<' '<') / ('>' '>'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{19, position}]; ok {
				return memoizedResult(memoized)
			}
			position349, tokenIndex349 := position, tokenIndex
			{
				position350 := position
				{
					position351, tokenIndex351 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l352
					}
					position++
					goto l351
				l352:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('-') {
						goto l353
					}
					position++
					goto l351
				l353:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('|') {
						goto l354
					}
					position++
					goto l351
				l354:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('<') {
						goto l355
					}
					position++
					if buffer[position] != rune('<') {
						goto l355
					}
					position++
					goto l351
				l355:
					position, tokenIndex = position351, tokenIndex351
					if buffer[position] != rune('>') {
						goto l349
					}
					position++
					if buffer[position] != rune('>') {
						goto l349
					}
					position++
				}
			l351:
				add(ruleSymbolOperator, position350)
			}
			memoize(19, position349, tokenIndex349, true)
			return true
		l349:
			memoize(19, position349, tokenIndex349, false)
			position, tokenIndex = position349, tokenIndex349
			return false
		},
		/* 20 OpenParen <- <'('> */
		func() bool {
			if memoized, ok := memoization[memoKey{20, position}]; ok {
				return memoizedResult(memoized)
			}
			position356, tokenIndex356 := position, tokenIndex
			{
				position357 := position
				if buffer[position] != rune('(') {
					goto l356
				}
				position++
				add(ruleOpenParen, position357)
			}
			memoize(20, position356, tokenIndex356, true)
			return true
		l356:
			memoize(20, position356, tokenIndex356, false)
			position, tokenIndex = position356, tokenIndex356
			return false
		},
		/* 21 CloseParen <- <')'> */
		func() bool {
			if memoized, ok := memoization[memoKey{21, position}]; ok {
				return memoizedResult(memoized)
			}
			position358, tokenIndex358 := position, tokenIndex
			{
				position359 := position
				if buffer[position] != rune(')') {
					goto l358
				}
				position++
				add(ruleCloseParen, position359)
			}
			memoize(21, position358, tokenIndex358, true)
			return true
		l358:
			memoize(21, position358, tokenIndex358, false)
			position, tokenIndex = position358, tokenIndex358
			return false
		},
		/* 22 SymbolType <- <(('@' / '%') (('f' 'u' 'n' 'c' 't' 'i' 'o' 'n') / ('o' 'b' 'j' 'e' 'c' 't')))> */
		func() bool {
			if memoized, ok := memoization[memoKey{22, position}]; ok {
				return memoizedResult(memoized)
			}
			position360, tokenIndex360 := position, tokenIndex
			{
				position361 := position
				{
					position362, tokenIndex362 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l363
					}
					position++
					goto l362
				l363:
					position, tokenIndex = position362, tokenIndex362
					if buffer[position] != rune('%') {
						goto l360
					}
					position++
				}
			l362:
				{
					position364, tokenIndex364 := position, tokenIndex
					if buffer[position] != rune('f') {
						goto l365
					}
					position++
					if buffer[position] != rune('u') {
						goto l365
					}
					position++
					if buffer[position] != rune('n') {
						goto l365
					}
					position++
					if buffer[position] != rune('c') {
						goto l365
					}
					position++
					if buffer[position] != rune('t') {
						goto l365
					}
					position++
					if buffer[position] != rune('i') {
						goto l365
					}
					position++
					if buffer[position] != rune('o') {
						goto l365
					}
					position++
					if buffer[position] != rune('n') {
						goto l365
					}
					position++
					goto l364
				l365:
					position, tokenIndex = position364, tokenIndex364
					if buffer[position] != rune('o') {
						goto l360
					}
					position++
					if buffer[position] != rune('b') {
						goto l360
					}
					position++
					if buffer[position] != rune('j') {
						goto l360
					}
					position++
					if buffer[position] != rune('e') {
						goto l360
					}
					position++
					if buffer[position] != rune('c') {
						goto l360
					}
					position++
					if buffer[position] != rune('t') {
						goto l360
					}
					position++
				}
			l364:
				add(ruleSymbolType, position361)
			}
			memoize(22, position360, tokenIndex360, true)
			return true
		l360:
			memoize(22, position360, tokenIndex360, false)
			position, tokenIndex = position360, tokenIndex360
			return false
		},
		/* 23 Dot <- <'.'> */
		func() bool {
			if memoized, ok := memoization[memoKey{23, position}]; ok {
				return memoizedResult(memoized)
			}
			position366, tokenIndex366 := position, tokenIndex
			{
				position367 := position
				if buffer[position] != rune('.') {
					goto l366
				}
				position++
				add(ruleDot, position367)
			}
			memoize(23, position366, tokenIndex366, true)
			return true
		l366:
			memoize(23, position366, tokenIndex366, false)
			position, tokenIndex = position366, tokenIndex366
			return false
		},
		/* 24 TCMarker <- <('[' 'T' 'C' ']')> */
		func() bool {
			if memoized, ok := memoization[memoKey{24, position}]; ok {
				return memoizedResult(memoized)
			}
			position368, tokenIndex368 := position, tokenIndex
			{
				position369 := position
				if buffer[position] != rune('[') {
					goto l368
				}
				position++
				if buffer[position] != rune('T') {
					goto l368
				}
				position++
				if buffer[position] != rune('C') {
					goto l368
				}
				position++
				if buffer[position] != rune(']') {
					goto l368
				}
				position++
				add(ruleTCMarker, position369)
			}
			memoize(24, position368, tokenIndex368, true)
			return true
		l368:
			memoize(24, position368, tokenIndex368, false)
			position, tokenIndex = position368, tokenIndex368
			return false
		},
		/* 25 EscapedChar <- <('\\' .)> */
		func() bool {
			if memoized, ok := memoization[memoKey{25, position}]; ok {
				return memoizedResult(memoized)
			}
			position370, tokenIndex370 := position, tokenIndex
			{
				position371 := position
				if buffer[position] != rune('\\') {
					goto l370
				}
				position++
				if !matchDot() {
					goto l370
				}
				add(ruleEscapedChar, position371)
			}
			memoize(25, position370, tokenIndex370, true)
			return true
		l370:
			memoize(25, position370, tokenIndex370, false)
			position, tokenIndex = position370, tokenIndex370
			return false
		},
		/* 26 WS <- <(' ' / '\t')+> */
		func() bool {
			if memoized, ok := memoization[memoKey{26, position}]; ok {
				return memoizedResult(memoized)
			}
			position372, tokenIndex372 := position, tokenIndex
			{
				position373 := position
				{
					position376, tokenIndex376 := position, tokenIndex
					if buffer[position] != rune(' ') {
						goto l377
					}
					position++
					goto l376
				l377:
					position, tokenIndex = position376, tokenIndex376
					if buffer[position] != rune('\t') {
						goto l372
					}
					position++
				}
			l376:
			l374:
				{
					position375, tokenIndex375 := position, tokenIndex
					{
						position378, tokenIndex378 := position, tokenIndex
						if buffer[position] != rune(' ') {
							goto l379
						}
						position++
						goto l378
					l379:
						position, tokenIndex = position378, tokenIndex378
						if buffer[position] != rune('\t') {
							goto l375
						}
						position++
					}
				l378:
					goto l374
				l375:
					position, tokenIndex = position375, tokenIndex375
				}
				add(ruleWS, position373)
			}
			memoize(26, position372, tokenIndex372, true)
			return true
		l372:
			memoize(26, position372, tokenIndex372, false)
			position, tokenIndex = position372, tokenIndex372
			return false
		},
		/* 27 Comment <- <((('/' '/') / '#') (!'\n' .)*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{27, position}]; ok {
				return memoizedResult(memoized)
			}
			position380, tokenIndex380 := position, tokenIndex
			{
				position381 := position
				{
					position382, tokenIndex382 := position, tokenIndex
					if buffer[position] != rune('/') {
						goto l383
					}
					position++
					if buffer[position] != rune('/') {
						goto l383
					}
					position++
					goto l382
				l383:
					position, tokenIndex = position382, tokenIndex382
					if buffer[position] != rune('#') {
						goto l380
					}
					position++
				}
			l382:
			l384:
				{
					position385, tokenIndex385 := position, tokenIndex
					{
						position386, tokenIndex386 := position, tokenIndex
						if buffer[position] != rune('\n') {
							goto l386
						}
						position++
						goto l385
					l386:
						position, tokenIndex = position386, tokenIndex386
					}
					if !matchDot() {
						goto l385
					}
					goto l384
				l385:
					position, tokenIndex = position385, tokenIndex385
				}
				add(ruleComment, position381)
			}
			memoize(27, position380, tokenIndex380, true)
			return true
		l380:
			memoize(27, position380, tokenIndex380, false)
			position, tokenIndex = position380, tokenIndex380
			return false
		},
		/* 28 Label <- <((LocalSymbol / LocalLabel / SymbolName) ':')> */
		func() bool {
			if memoized, ok := memoization[memoKey{28, position}]; ok {
				return memoizedResult(memoized)
			}
			position387, tokenIndex387 := position, tokenIndex
			{
				position388 := position
				{
					position389, tokenIndex389 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l390
					}
					goto l389
				l390:
					position, tokenIndex = position389, tokenIndex389
					if !_rules[ruleLocalLabel]() {
						goto l391
					}
					goto l389
				l391:
					position, tokenIndex = position389, tokenIndex389
					if !_rules[ruleSymbolName]() {
						goto l387
					}
				}
			l389:
				if buffer[position] != rune(':') {
					goto l387
				}
				position++
				add(ruleLabel, position388)
			}
			memoize(28, position387, tokenIndex387, true)
			return true
		l387:
			memoize(28, position387, tokenIndex387, false)
			position, tokenIndex = position387, tokenIndex387
			return false
		},
		/* 29 SymbolName <- <(([a-z] / [A-Z] / '.' / '_') ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]) / '$' / '_')*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{29, position}]; ok {
				return memoizedResult(memoized)
			}
			position392, tokenIndex392 := position, tokenIndex
			{
				position393 := position
				{
					position394, tokenIndex394 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l395
					}
					position++
					goto l394
				l395:
					position, tokenIndex = position394, tokenIndex394
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l396
					}
					position++
					goto l394
				l396:
					position, tokenIndex = position394, tokenIndex394
					if buffer[position] != rune('.') {
						goto l397
					}
					position++
					goto l394
				l397:
					position, tokenIndex = position394, tokenIndex394
					if buffer[position] != rune('_') {
						goto l392
					}
					position++
				}
			l394:
			l398:
				{
					position399, tokenIndex399 := position, tokenIndex
					{
						position400, tokenIndex400 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l401
						}
						position++
						goto l400
					l401:
						position, tokenIndex = position400, tokenIndex400
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l402
						}
						position++
						goto l400
					l402:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('.') {
							goto l403
						}
						position++
						goto l400
					l403:
						position, tokenIndex = position400, tokenIndex400
						{
							position405, tokenIndex405 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l406
							}
							position++
							goto l405
						l406:
							position, tokenIndex = position405, tokenIndex405
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l404
							}
							position++
						}
					l405:
						goto l400
					l404:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('$') {
							goto l407
						}
						position++
						goto l400
					l407:
						position, tokenIndex = position400, tokenIndex400
						if buffer[position] != rune('_') {
							goto l399
						}
						position++
					}
				l400:
					goto l398
				l399:
					position, tokenIndex = position399, tokenIndex399
				}
				add(ruleSymbolName, position393)
			}
			memoize(29, position392, tokenIndex392, true)
			return true
		l392:
			memoize(29, position392, tokenIndex392, false)
			position, tokenIndex = position392, tokenIndex392
			return false
		},
		/* 30 LocalSymbol <- <('.' 'L' ([a-z] / [A-Z] / ([a-z] / [A-Z]) / '.' / ([0-9] / [0-9]) / '$' / '_')+)> */
		func() bool {
			if memoized, ok := memoization[memoKey{30, position}]; ok {
				return memoizedResult(memoized)
			}
			position408, tokenIndex408 := position, tokenIndex
			{
				position409 := position
				if buffer[position] != rune('.') {
					goto l408
				}
				position++
				if buffer[position] != rune('L') {
					goto l408
				}
				position++
				{
					position412, tokenIndex412 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l413
					}
					position++
					goto l412
				l413:
					position, tokenIndex = position412, tokenIndex412
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l414
					}
					position++
					goto l412
				l414:
					position, tokenIndex = position412, tokenIndex412
					{
						position416, tokenIndex416 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l417
						}
						position++
						goto l416
					l417:
						position, tokenIndex = position416, tokenIndex416
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l415
						}
						position++
					}
				l416:
					goto l412
				l415:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('.') {
						goto l418
					}
					position++
					goto l412
				l418:
					position, tokenIndex = position412, tokenIndex412
					{
						position420, tokenIndex420 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l421
						}
						position++
						goto l420
					l421:
						position, tokenIndex = position420, tokenIndex420
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l419
						}
						position++
					}
				l420:
					goto l412
				l419:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('$') {
						goto l422
					}
					position++
					goto l412
				l422:
					position, tokenIndex = position412, tokenIndex412
					if buffer[position] != rune('_') {
						goto l408
					}
					position++
				}
			l412:
			l410:
				{
					position411, tokenIndex411 := position, tokenIndex
					{
						position423, tokenIndex423 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l424
						}
						position++
						goto l423
					l424:
						position, tokenIndex = position423, tokenIndex423
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l425
						}
						position++
						goto l423
					l425:
						position, tokenIndex = position423, tokenIndex423
						{
							position427, tokenIndex427 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l428
							}
							position++
							goto l427
						l428:
							position, tokenIndex = position427, tokenIndex427
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l426
							}
							position++
						}
					l427:
						goto l423
					l426:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('.') {
							goto l429
						}
						position++
						goto l423
					l429:
						position, tokenIndex = position423, tokenIndex423
						{
							position431, tokenIndex431 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l432
							}
							position++
							goto l431
						l432:
							position, tokenIndex = position431, tokenIndex431
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l430
							}
							position++
						}
					l431:
						goto l423
					l430:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('$') {
							goto l433
						}
						position++
						goto l423
					l433:
						position, tokenIndex = position423, tokenIndex423
						if buffer[position] != rune('_') {
							goto l411
						}
						position++
					}
				l423:
					goto l410
				l411:
					position, tokenIndex = position411, tokenIndex411
				}
				add(ruleLocalSymbol, position409)
			}
			memoize(30, position408, tokenIndex408, true)
			return true
		l408:
			memoize(30, position408, tokenIndex408, false)
			position, tokenIndex = position408, tokenIndex408
			return false
		},
		/* 31 LocalLabel <- <([0-9] ([0-9] / '$')*)> */
		func() bool {
			if memoized, ok := memoization[memoKey{31, position}]; ok {
				return memoizedResult(memoized)
			}
			position434, tokenIndex434 := position, tokenIndex
			{
				position435 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l434
				}
				position++
			l436:
				{
					position437, tokenIndex437 := position, tokenIndex
					{
						position438, tokenIndex438 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l439
						}
						position++
						goto l438
					l439:
						position, tokenIndex = position438, tokenIndex438
						if buffer[position] != rune('$') {
							goto l437
						}
						position++
					}
				l438:
					goto l436
				l437:
					position, tokenIndex = position437, tokenIndex437
				}
				add(ruleLocalLabel, position435)
			}
			memoize(31, position434, tokenIndex434, true)
			return true
		l434:
			memoize(31, position434, tokenIndex434, false)
			position, tokenIndex = position434, tokenIndex434
			return false
		},
		/* 32 LocalLabelRef <- <([0-9] ([0-9] / '$')* ('b' / 'f'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{32, position}]; ok {
				return memoizedResult(memoized)
			}
			position440, tokenIndex440 := position, tokenIndex
			{
				position441 := position
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l440
				}
				position++
			l442:
				{
					position443, tokenIndex443 := position, tokenIndex
					{
						position444, tokenIndex444 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l445
						}
						position++
						goto l444
					l445:
						position, tokenIndex = position444, tokenIndex444
						if buffer[position] != rune('$') {
							goto l443
						}
						position++
					}
				l444:
					goto l442
				l443:
					position, tokenIndex = position443, tokenIndex443
				}
				{
					position446, tokenIndex446 := position, tokenIndex
					if buffer[position] != rune('b') {
						goto l447
					}
					position++
					goto l446
				l447:
					position, tokenIndex = position446, tokenIndex446
					if buffer[position] != rune('f') {
						goto l440
					}
					position++
				}
			l446:
				add(ruleLocalLabelRef, position441)
			}
			memoize(32, position440, tokenIndex440, true)
			return true
		l440:
			memoize(32, position440, tokenIndex440, false)
			position, tokenIndex = position440, tokenIndex440
			return false
		},
		/* 33 Instruction <- <(InstructionName (WS InstructionArg (WS? ','? WS? InstructionArg)*)?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{33, position}]; ok {
				return memoizedResult(memoized)
			}
			position448, tokenIndex448 := position, tokenIndex
			{
				position449 := position
				if !_rules[ruleInstructionName]() {
					goto l448
				}
				{
					position450, tokenIndex450 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l450
					}
					if !_rules[ruleInstructionArg]() {
						goto l450
					}
				l452:
					{
						position453, tokenIndex453 := position, tokenIndex
						{
							position454, tokenIndex454 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l454
							}
							goto l455
						l454:
							position, tokenIndex = position454, tokenIndex454
						}
					l455:
						{
							position456, tokenIndex456 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l456
							}
							position++
							goto l457
						l456:
							position, tokenIndex = position456, tokenIndex456
						}
					l457:
						{
							position458, tokenIndex458 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l458
							}
							goto l459
						l458:
							position, tokenIndex = position458, tokenIndex458
						}
					l459:
						if !_rules[ruleInstructionArg]() {
							goto l453
						}
						goto l452
					l453:
						position, tokenIndex = position453, tokenIndex453
					}
					goto l451
				l450:
					position, tokenIndex = position450, tokenIndex450
				}
			l451:
				add(ruleInstruction, position449)
			}
			memoize(33, position448, tokenIndex448, true)
			return true
		l448:
			memoize(33, position448, tokenIndex448, false)
			position, tokenIndex = position448, tokenIndex448
			return false
		},
		/* 34 InstructionName <- <(([a-z] / [A-Z]) ([a-z] / [A-Z] / '.' / ([0-9] / [0-9]))* ('.' / '+' / '-')?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{34, position}]; ok {
				return memoizedResult(memoized)
			}
			position460, tokenIndex460 := position, tokenIndex
			{
				position461 := position
				{
					position462, tokenIndex462 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l463
					}
					position++
					goto l462
				l463:
					position, tokenIndex = position462, tokenIndex462
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l460
					}
					position++
				}
			l462:
			l464:
				{
					position465, tokenIndex465 := position, tokenIndex
					{
						position466, tokenIndex466 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l467
						}
						position++
						goto l466
					l467:
						position, tokenIndex = position466, tokenIndex466
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l468
						}
						position++
						goto l466
					l468:
						position, tokenIndex = position466, tokenIndex466
						if buffer[position] != rune('.') {
							goto l469
						}
						position++
						goto l466
					l469:
						position, tokenIndex = position466, tokenIndex466
						{
							position470, tokenIndex470 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l471
							}
							position++
							goto l470
						l471:
							position, tokenIndex = position470, tokenIndex470
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l465
							}
							position++
						}
					l470:
					}
				l466:
					goto l464
				l465:
					position, tokenIndex = position465, tokenIndex465
				}
				{
					position472, tokenIndex472 := position, tokenIndex
					{
						position474, tokenIndex474 := position, tokenIndex
						if buffer[position] != rune('.') {
							goto l475
						}
						position++
						goto l474
					l475:
						position, tokenIndex = position474, tokenIndex474
						if buffer[position] != rune('+') {
							goto l476
						}
						position++
						goto l474
					l476:
						position, tokenIndex = position474, tokenIndex474
						if buffer[position] != rune('-') {
							goto l472
						}
						position++
					}
				l474:
					goto l473
				l472:
					position, tokenIndex = position472, tokenIndex472
				}
			l473:
				add(ruleInstructionName, position461)
			}
			memoize(34, position460, tokenIndex460, true)
			return true
		l460:
			memoize(34, position460, tokenIndex460, false)
			position, tokenIndex = position460, tokenIndex460
			return false
		},
		/* 35 InstructionArg <- <(IndirectionIndicator? (ARMConstantTweak / RegisterOrConstant / LocalLabelRef / TOCRefHigh / TOCRefLow / GOTLocation / GOTSymbolOffset / MemoryRef / AVX512Token))> */
		func() bool {
			if memoized, ok := memoization[memoKey{35, position}]; ok {
				return memoizedResult(memoized)
			}
			position477, tokenIndex477 := position, tokenIndex
			{
				position478 := position
				{
					position479, tokenIndex479 := position, tokenIndex
					if !_rules[ruleIndirectionIndicator]() {
						goto l479
					}
					goto l480
				l479:
					position, tokenIndex = position479, tokenIndex479
				}
			l480:
				{
					position481, tokenIndex481 := position, tokenIndex
					if !_rules[ruleARMConstantTweak]() {
						goto l482
					}
					goto l481
				l482:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleRegisterOrConstant]() {
						goto l483
					}
					goto l481
				l483:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleLocalLabelRef]() {
						goto l484
					}
					goto l481
				l484:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleTOCRefHigh]() {
						goto l485
					}
					goto l481
				l485:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleTOCRefLow]() {
						goto l486
					}
					goto l481
				l486:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleGOTLocation]() {
						goto l487
					}
					goto l481
				l487:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleGOTSymbolOffset]() {
						goto l488
					}
					goto l481
				l488:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleMemoryRef]() {
						goto l489
					}
					goto l481
				l489:
					position, tokenIndex = position481, tokenIndex481
					if !_rules[ruleAVX512Token]() {
						goto l477
					}
				}
			l481:
				add(ruleInstructionArg, position478)
			}
			memoize(35, position477, tokenIndex477, true)
			return true
		l477:
			memoize(35, position477, tokenIndex477, false)
			position, tokenIndex = position477, tokenIndex477
			return false
		},
		/* 36 GOTLocation <- <('$' '_' 'G' 'L' 'O' 'B' 'A' 'L' '_' 'O' 'F' 'F' 'S' 'E' 'T' '_' 'T' 'A' 'B' 'L' 'E' '_' '-' LocalSymbol)> */
		func() bool {
			if memoized, ok := memoization[memoKey{36, position}]; ok {
				return memoizedResult(memoized)
			}
			position490, tokenIndex490 := position, tokenIndex
			{
				position491 := position
				if buffer[position] != rune('$') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('G') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('O') {
					goto l490
				}
				position++
				if buffer[position] != rune('B') {
					goto l490
				}
				position++
				if buffer[position] != rune('A') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('O') {
					goto l490
				}
				position++
				if buffer[position] != rune('F') {
					goto l490
				}
				position++
				if buffer[position] != rune('F') {
					goto l490
				}
				position++
				if buffer[position] != rune('S') {
					goto l490
				}
				position++
				if buffer[position] != rune('E') {
					goto l490
				}
				position++
				if buffer[position] != rune('T') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('T') {
					goto l490
				}
				position++
				if buffer[position] != rune('A') {
					goto l490
				}
				position++
				if buffer[position] != rune('B') {
					goto l490
				}
				position++
				if buffer[position] != rune('L') {
					goto l490
				}
				position++
				if buffer[position] != rune('E') {
					goto l490
				}
				position++
				if buffer[position] != rune('_') {
					goto l490
				}
				position++
				if buffer[position] != rune('-') {
					goto l490
				}
				position++
				if !_rules[ruleLocalSymbol]() {
					goto l490
				}
				add(ruleGOTLocation, position491)
			}
			memoize(36, position490, tokenIndex490, true)
			return true
		l490:
			memoize(36, position490, tokenIndex490, false)
			position, tokenIndex = position490, tokenIndex490
			return false
		},
		/* 37 GOTSymbolOffset <- <(('$' SymbolName ('@' 'G' 'O' 'T') ('O' 'F' 'F')?) / (':' ('g' / 'G') ('o' / 'O') ('t' / 'T') ':' SymbolName))> */
		func() bool {
			if memoized, ok := memoization[memoKey{37, position}]; ok {
				return memoizedResult(memoized)
			}
			position492, tokenIndex492 := position, tokenIndex
			{
				position493 := position
				{
					position494, tokenIndex494 := position, tokenIndex
					if buffer[position] != rune('$') {
						goto l495
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l495
					}
					if buffer[position] != rune('@') {
						goto l495
					}
					position++
					if buffer[position] != rune('G') {
						goto l495
					}
					position++
					if buffer[position] != rune('O') {
						goto l495
					}
					position++
					if buffer[position] != rune('T') {
						goto l495
					}
					position++
					{
						position496, tokenIndex496 := position, tokenIndex
						if buffer[position] != rune('O') {
							goto l496
						}
						position++
						if buffer[position] != rune('F') {
							goto l496
						}
						position++
						if buffer[position] != rune('F') {
							goto l496
						}
						position++
						goto l497
					l496:
						position, tokenIndex = position496, tokenIndex496
					}
				l497:
					goto l494
				l495:
					position, tokenIndex = position494, tokenIndex494
					if buffer[position] != rune(':') {
						goto l492
					}
					position++
					{
						position498, tokenIndex498 := position, tokenIndex
						if buffer[position] != rune('g') {
							goto l499
						}
						position++
						goto l498
					l499:
						position, tokenIndex = position498, tokenIndex498
						if buffer[position] != rune('G') {
							goto l492
						}
						position++
					}
				l498:
					{
						position500, tokenIndex500 := position, tokenIndex
						if buffer[position] != rune('o') {
							goto l501
						}
						position++
						goto l500
					l501:
						position, tokenIndex = position500, tokenIndex500
						if buffer[position] != rune('O') {
							goto l492
						}
						position++
					}
				l500:
					{
						position502, tokenIndex502 := position, tokenIndex
						if buffer[position] != rune('t') {
							goto l503
						}
						position++
						goto l502
					l503:
						position, tokenIndex = position502, tokenIndex502
						if buffer[position] != rune('T') {
							goto l492
						}
						position++
					}
				l502:
					if buffer[position] != rune(':') {
						goto l492
					}
					position++
					if !_rules[ruleSymbolName]() {
						goto l492
					}
				}
			l494:
				add(ruleGOTSymbolOffset, position493)
			}
			memoize(37, position492, tokenIndex492, true)
			return true
		l492:
			memoize(37, position492, tokenIndex492, false)
			position, tokenIndex = position492, tokenIndex492
			return false
		},
		/* 38 AVX512Token <- <(WS? '{' '%'? ([0-9] / [a-z])* '}')> */
		func() bool {
			if memoized, ok := memoization[memoKey{38, position}]; ok {
				return memoizedResult(memoized)
			}
			position504, tokenIndex504 := position, tokenIndex
			{
				position505 := position
				{
					position506, tokenIndex506 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l506
					}
					goto l507
				l506:
					position, tokenIndex = position506, tokenIndex506
				}
			l507:
				if buffer[position] != rune('{') {
					goto l504
				}
				position++
				{
					position508, tokenIndex508 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l508
					}
					position++
					goto l509
				l508:
					position, tokenIndex = position508, tokenIndex508
				}
			l509:
			l510:
				{
					position511, tokenIndex511 := position, tokenIndex
					{
						position512, tokenIndex512 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l513
						}
						position++
						goto l512
					l513:
						position, tokenIndex = position512, tokenIndex512
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l511
						}
						position++
					}
				l512:
					goto l510
				l511:
					position, tokenIndex = position511, tokenIndex511
				}
				if buffer[position] != rune('}') {
					goto l504
				}
				position++
				add(ruleAVX512Token, position505)
			}
			memoize(38, position504, tokenIndex504, true)
			return true
		l504:
			memoize(38, position504, tokenIndex504, false)
			position, tokenIndex = position504, tokenIndex504
			return false
		},
		/* 39 TOCRefHigh <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('h' / 'H') ('a' / 'A')))> */
		func() bool {
			if memoized, ok := memoization[memoKey{39, position}]; ok {
				return memoizedResult(memoized)
			}
			position514, tokenIndex514 := position, tokenIndex
			{
				position515 := position
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('T') {
					goto l514
				}
				position++
				if buffer[position] != rune('O') {
					goto l514
				}
				position++
				if buffer[position] != rune('C') {
					goto l514
				}
				position++
				if buffer[position] != rune('.') {
					goto l514
				}
				position++
				if buffer[position] != rune('-') {
					goto l514
				}
				position++
				{
					position516, tokenIndex516 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l517
					}
					position++
					if buffer[position] != rune('b') {
						goto l517
					}
					position++
					goto l516
				l517:
					position, tokenIndex = position516, tokenIndex516
					if buffer[position] != rune('.') {
						goto l514
					}
					position++
					if buffer[position] != rune('L') {
						goto l514
					}
					position++
					{
						position520, tokenIndex520 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l521
						}
						position++
						goto l520
					l521:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l522
						}
						position++
						goto l520
					l522:
						position, tokenIndex = position520, tokenIndex520
						if buffer[position] != rune('_') {
							goto l523
						}
						position++
						goto l520
					l523:
						position, tokenIndex = position520, tokenIndex520
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l514
						}
						position++
					}
				l520:
				l518:
					{
						position519, tokenIndex519 := position, tokenIndex
						{
							position524, tokenIndex524 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l525
							}
							position++
							goto l524
						l525:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l526
							}
							position++
							goto l524
						l526:
							position, tokenIndex = position524, tokenIndex524
							if buffer[position] != rune('_') {
								goto l527
							}
							position++
							goto l524
						l527:
							position, tokenIndex = position524, tokenIndex524
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l519
							}
							position++
						}
					l524:
						goto l518
					l519:
						position, tokenIndex = position519, tokenIndex519
					}
				}
			l516:
				if buffer[position] != rune('@') {
					goto l514
				}
				position++
				{
					position528, tokenIndex528 := position, tokenIndex
					if buffer[position] != rune('h') {
						goto l529
					}
					position++
					goto l528
				l529:
					position, tokenIndex = position528, tokenIndex528
					if buffer[position] != rune('H') {
						goto l514
					}
					position++
				}
			l528:
				{
					position530, tokenIndex530 := position, tokenIndex
					if buffer[position] != rune('a') {
						goto l531
					}
					position++
					goto l530
				l531:
					position, tokenIndex = position530, tokenIndex530
					if buffer[position] != rune('A') {
						goto l514
					}
					position++
				}
			l530:
				add(ruleTOCRefHigh, position515)
			}
			memoize(39, position514, tokenIndex514, true)
			return true
		l514:
			memoize(39, position514, tokenIndex514, false)
			position, tokenIndex = position514, tokenIndex514
			return false
		},
		/* 40 TOCRefLow <- <('.' 'T' 'O' 'C' '.' '-' (('0' 'b') / ('.' 'L' ([a-z] / [A-Z] / '_' / [0-9])+)) ('@' ('l' / 'L')))> */
		func() bool {
			if memoized, ok := memoization[memoKey{40, position}]; ok {
				return memoizedResult(memoized)
			}
			position532, tokenIndex532 := position, tokenIndex
			{
				position533 := position
				if buffer[position] != rune('.') {
					goto l532
				}
				position++
				if buffer[position] != rune('T') {
					goto l532
				}
				position++
				if buffer[position] != rune('O') {
					goto l532
				}
				position++
				if buffer[position] != rune('C') {
					goto l532
				}
				position++
				if buffer[position] != rune('.') {
					goto l532
				}
				position++
				if buffer[position] != rune('-') {
					goto l532
				}
				position++
				{
					position534, tokenIndex534 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l535
					}
					position++
					if buffer[position] != rune('b') {
						goto l535
					}
					position++
					goto l534
				l535:
					position, tokenIndex = position534, tokenIndex534
					if buffer[position] != rune('.') {
						goto l532
					}
					position++
					if buffer[position] != rune('L') {
						goto l532
					}
					position++
					{
						position538, tokenIndex538 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l539
						}
						position++
						goto l538
					l539:
						position, tokenIndex = position538, tokenIndex538
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l540
						}
						position++
						goto l538
					l540:
						position, tokenIndex = position538, tokenIndex538
						if buffer[position] != rune('_') {
							goto l541
						}
						position++
						goto l538
					l541:
						position, tokenIndex = position538, tokenIndex538
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l532
						}
						position++
					}
				l538:
				l536:
					{
						position537, tokenIndex537 := position, tokenIndex
						{
							position542, tokenIndex542 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l543
							}
							position++
							goto l542
						l543:
							position, tokenIndex = position542, tokenIndex542
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l544
							}
							position++
							goto l542
						l544:
							position, tokenIndex = position542, tokenIndex542
							if buffer[position] != rune('_') {
								goto l545
							}
							position++
							goto l542
						l545:
							position, tokenIndex = position542, tokenIndex542
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l537
							}
							position++
						}
					l542:
						goto l536
					l537:
						position, tokenIndex = position537, tokenIndex537
					}
				}
			l534:
				if buffer[position] != rune('@') {
					goto l532
				}
				position++
				{
					position546, tokenIndex546 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l547
					}
					position++
					goto l546
				l547:
					position, tokenIndex = position546, tokenIndex546
					if buffer[position] != rune('L') {
						goto l532
					}
					position++
				}
			l546:
				add(ruleTOCRefLow, position533)
			}
			memoize(40, position532, tokenIndex532, true)
			return true
		l532:
			memoize(40, position532, tokenIndex532, false)
			position, tokenIndex = position532, tokenIndex532
			return false
		},
		/* 41 IndirectionIndicator <- <'*'> */
		func() bool {
			if memoized, ok := memoization[memoKey{41, position}]; ok {
				return memoizedResult(memoized)
			}
			position548, tokenIndex548 := position, tokenIndex
			{
				position549 := position
				if buffer[position] != rune('*') {
					goto l548
				}
				position++
				add(ruleIndirectionIndicator, position549)
			}
			memoize(41, position548, tokenIndex548, true)
			return true
		l548:
			memoize(41, position548, tokenIndex548, false)
			position, tokenIndex = position548, tokenIndex548
			return false
		},
		/* 42 RegisterOrConstant <- <((('%' ([a-z] / [A-Z]) ([a-z] / [A-Z] / ([0-9] / [0-9]))*) / ('$' [0-9]+ WS? '*' WS? '(' [0-9]+ WS? '-' WS? [0-9]+ ')') / ('$'? ((Offset Offset) / Offset)) / ('#' Offset ('*' [0-9]+ ('-' [0-9] [0-9]*)?)?) / ('#' '~'? '(' [0-9] WS? ('<' '<') WS? [0-9] [0-9]? ')') / (('#' / '$') '~'? ('0' 'x')? ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ('$' '(' '-' [0-9]+ ')') / ARMRegister) !('f' / 'b' / ':' / '(' / '+' / '-'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{42, position}]; ok {
				return memoizedResult(memoized)
			}
			position550, tokenIndex550 := position, tokenIndex
			{
				position551 := position
				{
					position552, tokenIndex552 := position, tokenIndex
					if buffer[position] != rune('%') {
						goto l553
					}
					position++
					{
						position554, tokenIndex554 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l555
						}
						position++
						goto l554
					l555:
						position, tokenIndex = position554, tokenIndex554
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l553
						}
						position++
					}
				l554:
				l556:
					{
						position557, tokenIndex557 := position, tokenIndex
						{
							position558, tokenIndex558 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l559
							}
							position++
							goto l558
						l559:
							position, tokenIndex = position558, tokenIndex558
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l560
							}
							position++
							goto l558
						l560:
							position, tokenIndex = position558, tokenIndex558
							{
								position561, tokenIndex561 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l562
								}
								position++
								goto l561
							l562:
								position, tokenIndex = position561, tokenIndex561
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l557
								}
								position++
							}
						l561:
						}
					l558:
						goto l556
					l557:
						position, tokenIndex = position557, tokenIndex557
					}
					goto l552
				l553:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('$') {
						goto l563
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l564:
					{
						position565, tokenIndex565 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l565
						}
						position++
						goto l564
					l565:
						position, tokenIndex = position565, tokenIndex565
					}
					{
						position566, tokenIndex566 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l566
						}
						goto l567
					l566:
						position, tokenIndex = position566, tokenIndex566
					}
				l567:
					if buffer[position] != rune('*') {
						goto l563
					}
					position++
					{
						position568, tokenIndex568 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l568
						}
						goto l569
					l568:
						position, tokenIndex = position568, tokenIndex568
					}
				l569:
					if buffer[position] != rune('(') {
						goto l563
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l570:
					{
						position571, tokenIndex571 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l571
						}
						position++
						goto l570
					l571:
						position, tokenIndex = position571, tokenIndex571
					}
					{
						position572, tokenIndex572 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l572
						}
						goto l573
					l572:
						position, tokenIndex = position572, tokenIndex572
					}
				l573:
					if buffer[position] != rune('-') {
						goto l563
					}
					position++
					{
						position574, tokenIndex574 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l574
						}
						goto l575
					l574:
						position, tokenIndex = position574, tokenIndex574
					}
				l575:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l563
					}
					position++
				l576:
					{
						position577, tokenIndex577 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l577
						}
						position++
						goto l576
					l577:
						position, tokenIndex = position577, tokenIndex577
					}
					if buffer[position] != rune(')') {
						goto l563
					}
					position++
					goto l552
				l563:
					position, tokenIndex = position552, tokenIndex552
					{
						position579, tokenIndex579 := position, tokenIndex
						if buffer[position] != rune('$') {
							goto l579
						}
						position++
						goto l580
					l579:
						position, tokenIndex = position579, tokenIndex579
					}
				l580:
					{
						position581, tokenIndex581 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l582
						}
						if !_rules[ruleOffset]() {
							goto l582
						}
						goto l581
					l582:
						position, tokenIndex = position581, tokenIndex581
						if !_rules[ruleOffset]() {
							goto l578
						}
					}
				l581:
					goto l552
				l578:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('#') {
						goto l583
					}
					position++
					if !_rules[ruleOffset]() {
						goto l583
					}
					{
						position584, tokenIndex584 := position, tokenIndex
						if buffer[position] != rune('*') {
							goto l584
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l584
						}
						position++
					l586:
						{
							position587, tokenIndex587 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l587
							}
							position++
							goto l586
						l587:
							position, tokenIndex = position587, tokenIndex587
						}
						{
							position588, tokenIndex588 := position, tokenIndex
							if buffer[position] != rune('-') {
								goto l588
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l588
							}
							position++
						l590:
							{
								position591, tokenIndex591 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l591
								}
								position++
								goto l590
							l591:
								position, tokenIndex = position591, tokenIndex591
							}
							goto l589
						l588:
							position, tokenIndex = position588, tokenIndex588
						}
					l589:
						goto l585
					l584:
						position, tokenIndex = position584, tokenIndex584
					}
				l585:
					goto l552
				l583:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('#') {
						goto l592
					}
					position++
					{
						position593, tokenIndex593 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l593
						}
						position++
						goto l594
					l593:
						position, tokenIndex = position593, tokenIndex593
					}
				l594:
					if buffer[position] != rune('(') {
						goto l592
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l592
					}
					position++
					{
						position595, tokenIndex595 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l595
						}
						goto l596
					l595:
						position, tokenIndex = position595, tokenIndex595
					}
				l596:
					if buffer[position] != rune('<') {
						goto l592
					}
					position++
					if buffer[position] != rune('<') {
						goto l592
					}
					position++
					{
						position597, tokenIndex597 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l597
						}
						goto l598
					l597:
						position, tokenIndex = position597, tokenIndex597
					}
				l598:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l592
					}
					position++
					{
						position599, tokenIndex599 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l599
						}
						position++
						goto l600
					l599:
						position, tokenIndex = position599, tokenIndex599
					}
				l600:
					if buffer[position] != rune(')') {
						goto l592
					}
					position++
					goto l552
				l592:
					position, tokenIndex = position552, tokenIndex552
					{
						position602, tokenIndex602 := position, tokenIndex
						if buffer[position] != rune('#') {
							goto l603
						}
						position++
						goto l602
					l603:
						position, tokenIndex = position602, tokenIndex602
						if buffer[position] != rune('$') {
							goto l601
						}
						position++
					}
				l602:
					{
						position604, tokenIndex604 := position, tokenIndex
						if buffer[position] != rune('~') {
							goto l604
						}
						position++
						goto l605
					l604:
						position, tokenIndex = position604, tokenIndex604
					}
				l605:
					{
						position606, tokenIndex606 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l606
						}
						position++
						if buffer[position] != rune('x') {
							goto l606
						}
						position++
						goto l607
					l606:
						position, tokenIndex = position606, tokenIndex606
					}
				l607:
					{
						position610, tokenIndex610 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l611
						}
						position++
						goto l610
					l611:
						position, tokenIndex = position610, tokenIndex610
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l612
						}
						position++
						goto l610
					l612:
						position, tokenIndex = position610, tokenIndex610
						{
							position613, tokenIndex613 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l614
							}
							position++
							goto l613
						l614:
							position, tokenIndex = position613, tokenIndex613
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l601
							}
							position++
						}
					l613:
					}
				l610:
				l608:
					{
						position609, tokenIndex609 := position, tokenIndex
						{
							position615, tokenIndex615 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l616
							}
							position++
							goto l615
						l616:
							position, tokenIndex = position615, tokenIndex615
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l617
							}
							position++
							goto l615
						l617:
							position, tokenIndex = position615, tokenIndex615
							{
								position618, tokenIndex618 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l619
								}
								position++
								goto l618
							l619:
								position, tokenIndex = position618, tokenIndex618
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l609
								}
								position++
							}
						l618:
						}
					l615:
						goto l608
					l609:
						position, tokenIndex = position609, tokenIndex609
					}
					goto l552
				l601:
					position, tokenIndex = position552, tokenIndex552
					if buffer[position] != rune('$') {
						goto l620
					}
					position++
					if buffer[position] != rune('(') {
						goto l620
					}
					position++
					if buffer[position] != rune('-') {
						goto l620
					}
					position++
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l620
					}
					position++
				l621:
					{
						position622, tokenIndex622 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l622
						}
						position++
						goto l621
					l622:
						position, tokenIndex = position622, tokenIndex622
					}
					if buffer[position] != rune(')') {
						goto l620
					}
					position++
					goto l552
				l620:
					position, tokenIndex = position552, tokenIndex552
					if !_rules[ruleARMRegister]() {
						goto l550
					}
				}
			l552:
				{
					position623, tokenIndex623 := position, tokenIndex
					{
						position624, tokenIndex624 := position, tokenIndex
						if buffer[position] != rune('f') {
							goto l625
						}
						position++
						goto l624
					l625:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune('b') {
							goto l626
						}
						position++
						goto l624
					l626:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune(':') {
							goto l627
						}
						position++
						goto l624
					l627:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune('(') {
							goto l628
						}
						position++
						goto l624
					l628:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune('+') {
							goto l629
						}
						position++
						goto l624
					l629:
						position, tokenIndex = position624, tokenIndex624
						if buffer[position] != rune('-') {
							goto l623
						}
						position++
					}
				l624:
					goto l550
				l623:
					position, tokenIndex = position623, tokenIndex623
				}
				add(ruleRegisterOrConstant, position551)
			}
			memoize(42, position550, tokenIndex550, true)
			return true
		l550:
			memoize(42, position550, tokenIndex550, false)
			position, tokenIndex = position550, tokenIndex550
			return false
		},
		/* 43 ARMConstantTweak <- <((((('u' / 's') (('x' / 'X') ('t' / 'T')) ('x' / 'w' / 'h' / 'b')) / (('l' / 'L') ('s' / 'S') ('l' / 'L')) / (('l' / 'L') ('s' / 'S') ('r' / 'R')) / (('r' / 'R') ('o' / 'O') ('r' / 'R')) / (('a' / 'A') ('s' / 'S') ('r' / 'R'))) (WS '#'? Offset)?) / (('m' / 'M') ('u' / 'U') ('l' / 'L') ' ' ('v' / 'V') ('l' / 'L')))> */
		func() bool {
			if memoized, ok := memoization[memoKey{43, position}]; ok {
				return memoizedResult(memoized)
			}
			position630, tokenIndex630 := position, tokenIndex
			{
				position631 := position
				{
					position632, tokenIndex632 := position, tokenIndex
					{
						position634, tokenIndex634 := position, tokenIndex
						{
							position636, tokenIndex636 := position, tokenIndex
							if buffer[position] != rune('u') {
								goto l637
							}
							position++
							goto l636
						l637:
							position, tokenIndex = position636, tokenIndex636
							if buffer[position] != rune('s') {
								goto l635
							}
							position++
						}
					l636:
						{
							position638, tokenIndex638 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l639
							}
							position++
							goto l638
						l639:
							position, tokenIndex = position638, tokenIndex638
							if buffer[position] != rune('X') {
								goto l635
							}
							position++
						}
					l638:
						{
							position640, tokenIndex640 := position, tokenIndex
							if buffer[position] != rune('t') {
								goto l641
							}
							position++
							goto l640
						l641:
							position, tokenIndex = position640, tokenIndex640
							if buffer[position] != rune('T') {
								goto l635
							}
							position++
						}
					l640:
						{
							position642, tokenIndex642 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l643
							}
							position++
							goto l642
						l643:
							position, tokenIndex = position642, tokenIndex642
							if buffer[position] != rune('w') {
								goto l644
							}
							position++
							goto l642
						l644:
							position, tokenIndex = position642, tokenIndex642
							if buffer[position] != rune('h') {
								goto l645
							}
							position++
							goto l642
						l645:
							position, tokenIndex = position642, tokenIndex642
							if buffer[position] != rune('b') {
								goto l635
							}
							position++
						}
					l642:
						goto l634
					l635:
						position, tokenIndex = position634, tokenIndex634
						{
							position647, tokenIndex647 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l648
							}
							position++
							goto l647
						l648:
							position, tokenIndex = position647, tokenIndex647
							if buffer[position] != rune('L') {
								goto l646
							}
							position++
						}
					l647:
						{
							position649, tokenIndex649 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l650
							}
							position++
							goto l649
						l650:
							position, tokenIndex = position649, tokenIndex649
							if buffer[position] != rune('S') {
								goto l646
							}
							position++
						}
					l649:
						{
							position651, tokenIndex651 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l652
							}
							position++
							goto l651
						l652:
							position, tokenIndex = position651, tokenIndex651
							if buffer[position] != rune('L') {
								goto l646
							}
							position++
						}
					l651:
						goto l634
					l646:
						position, tokenIndex = position634, tokenIndex634
						{
							position654, tokenIndex654 := position, tokenIndex
							if buffer[position] != rune('l') {
								goto l655
							}
							position++
							goto l654
						l655:
							position, tokenIndex = position654, tokenIndex654
							if buffer[position] != rune('L') {
								goto l653
							}
							position++
						}
					l654:
						{
							position656, tokenIndex656 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l657
							}
							position++
							goto l656
						l657:
							position, tokenIndex = position656, tokenIndex656
							if buffer[position] != rune('S') {
								goto l653
							}
							position++
						}
					l656:
						{
							position658, tokenIndex658 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l659
							}
							position++
							goto l658
						l659:
							position, tokenIndex = position658, tokenIndex658
							if buffer[position] != rune('R') {
								goto l653
							}
							position++
						}
					l658:
						goto l634
					l653:
						position, tokenIndex = position634, tokenIndex634
						{
							position661, tokenIndex661 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l662
							}
							position++
							goto l661
						l662:
							position, tokenIndex = position661, tokenIndex661
							if buffer[position] != rune('R') {
								goto l660
							}
							position++
						}
					l661:
						{
							position663, tokenIndex663 := position, tokenIndex
							if buffer[position] != rune('o') {
								goto l664
							}
							position++
							goto l663
						l664:
							position, tokenIndex = position663, tokenIndex663
							if buffer[position] != rune('O') {
								goto l660
							}
							position++
						}
					l663:
						{
							position665, tokenIndex665 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l666
							}
							position++
							goto l665
						l666:
							position, tokenIndex = position665, tokenIndex665
							if buffer[position] != rune('R') {
								goto l660
							}
							position++
						}
					l665:
						goto l634
					l660:
						position, tokenIndex = position634, tokenIndex634
						{
							position667, tokenIndex667 := position, tokenIndex
							if buffer[position] != rune('a') {
								goto l668
							}
							position++
							goto l667
						l668:
							position, tokenIndex = position667, tokenIndex667
							if buffer[position] != rune('A') {
								goto l633
							}
							position++
						}
					l667:
						{
							position669, tokenIndex669 := position, tokenIndex
							if buffer[position] != rune('s') {
								goto l670
							}
							position++
							goto l669
						l670:
							position, tokenIndex = position669, tokenIndex669
							if buffer[position] != rune('S') {
								goto l633
							}
							position++
						}
					l669:
						{
							position671, tokenIndex671 := position, tokenIndex
							if buffer[position] != rune('r') {
								goto l672
							}
							position++
							goto l671
						l672:
							position, tokenIndex = position671, tokenIndex671
							if buffer[position] != rune('R') {
								goto l633
							}
							position++
						}
					l671:
					}
				l634:
					{
						position673, tokenIndex673 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l673
						}
						{
							position675, tokenIndex675 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l675
							}
							position++
							goto l676
						l675:
							position, tokenIndex = position675, tokenIndex675
						}
					l676:
						if !_rules[ruleOffset]() {
							goto l673
						}
						goto l674
					l673:
						position, tokenIndex = position673, tokenIndex673
					}
				l674:
					goto l632
				l633:
					position, tokenIndex = position632, tokenIndex632
					{
						position677, tokenIndex677 := position, tokenIndex
						if buffer[position] != rune('m') {
							goto l678
						}
						position++
						goto l677
					l678:
						position, tokenIndex = position677, tokenIndex677
						if buffer[position] != rune('M') {
							goto l630
						}
						position++
					}
				l677:
					{
						position679, tokenIndex679 := position, tokenIndex
						if buffer[position] != rune('u') {
							goto l680
						}
						position++
						goto l679
					l680:
						position, tokenIndex = position679, tokenIndex679
						if buffer[position] != rune('U') {
							goto l630
						}
						position++
					}
				l679:
					{
						position681, tokenIndex681 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l682
						}
						position++
						goto l681
					l682:
						position, tokenIndex = position681, tokenIndex681
						if buffer[position] != rune('L') {
							goto l630
						}
						position++
					}
				l681:
					if buffer[position] != rune(' ') {
						goto l630
					}
					position++
					{
						position683, tokenIndex683 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l684
						}
						position++
						goto l683
					l684:
						position, tokenIndex = position683, tokenIndex683
						if buffer[position] != rune('V') {
							goto l630
						}
						position++
					}
				l683:
					{
						position685, tokenIndex685 := position, tokenIndex
						if buffer[position] != rune('l') {
							goto l686
						}
						position++
						goto l685
					l686:
						position, tokenIndex = position685, tokenIndex685
						if buffer[position] != rune('L') {
							goto l630
						}
						position++
					}
				l685:
				}
			l632:
				add(ruleARMConstantTweak, position631)
			}
			memoize(43, position630, tokenIndex630, true)
			return true
		l630:
			memoize(43, position630, tokenIndex630, false)
			position, tokenIndex = position630, tokenIndex630
			return false
		},
		/* 44 ARMRegister <- <((('s' / 'S') ('p' / 'P')) / (('x' / 'w' / 'd' / 'q' / 's' / 'h' / 'b') [0-9] [0-9]? !ARMRegisterBoundary) / (('x' / 'X') ('z' / 'Z') ('r' / 'R')) / (('w' / 'W') ('z' / 'Z') ('r' / 'R')) / (('n' / 'N') ('z' / 'Z') ('c' / 'C') ('v' / 'V')) / ARMVectorRegister / SVE2PredicateRegister / ('{' WS? ARMVectorRegister WS? ((',' / '-') WS? ARMVectorRegister)* WS? '}' ('[' [0-9] [0-9]? ']')?))> */
		func() bool {
			if memoized, ok := memoization[memoKey{44, position}]; ok {
				return memoizedResult(memoized)
			}
			position687, tokenIndex687 := position, tokenIndex
			{
				position688 := position
				{
					position689, tokenIndex689 := position, tokenIndex
					{
						position691, tokenIndex691 := position, tokenIndex
						if buffer[position] != rune('s') {
							goto l692
						}
						position++
						goto l691
					l692:
						position, tokenIndex = position691, tokenIndex691
						if buffer[position] != rune('S') {
							goto l690
						}
						position++
					}
				l691:
					{
						position693, tokenIndex693 := position, tokenIndex
						if buffer[position] != rune('p') {
							goto l694
						}
						position++
						goto l693
					l694:
						position, tokenIndex = position693, tokenIndex693
						if buffer[position] != rune('P') {
							goto l690
						}
						position++
					}
				l693:
					goto l689
				l690:
					position, tokenIndex = position689, tokenIndex689
					{
						position696, tokenIndex696 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l697
						}
						position++
						goto l696
					l697:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('w') {
							goto l698
						}
						position++
						goto l696
					l698:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('d') {
							goto l699
						}
						position++
						goto l696
					l699:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('q') {
							goto l700
						}
						position++
						goto l696
					l700:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('s') {
							goto l701
						}
						position++
						goto l696
					l701:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('h') {
							goto l702
						}
						position++
						goto l696
					l702:
						position, tokenIndex = position696, tokenIndex696
						if buffer[position] != rune('b') {
							goto l695
						}
						position++
					}
				l696:
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l695
					}
					position++
					{
						position703, tokenIndex703 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l703
						}
						position++
						goto l704
					l703:
						position, tokenIndex = position703, tokenIndex703
					}
				l704:
					{
						position705, tokenIndex705 := position, tokenIndex
						if !_rules[ruleARMRegisterBoundary]() {
							goto l705
						}
						goto l695
					l705:
						position, tokenIndex = position705, tokenIndex705
					}
					goto l689
				l695:
					position, tokenIndex = position689, tokenIndex689
					{
						position707, tokenIndex707 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l708
						}
						position++
						goto l707
					l708:
						position, tokenIndex = position707, tokenIndex707
						if buffer[position] != rune('X') {
							goto l706
						}
						position++
					}
				l707:
					{
						position709, tokenIndex709 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l710
						}
						position++
						goto l709
					l710:
						position, tokenIndex = position709, tokenIndex709
						if buffer[position] != rune('Z') {
							goto l706
						}
						position++
					}
				l709:
					{
						position711, tokenIndex711 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l712
						}
						position++
						goto l711
					l712:
						position, tokenIndex = position711, tokenIndex711
						if buffer[position] != rune('R') {
							goto l706
						}
						position++
					}
				l711:
					goto l689
				l706:
					position, tokenIndex = position689, tokenIndex689
					{
						position714, tokenIndex714 := position, tokenIndex
						if buffer[position] != rune('w') {
							goto l715
						}
						position++
						goto l714
					l715:
						position, tokenIndex = position714, tokenIndex714
						if buffer[position] != rune('W') {
							goto l713
						}
						position++
					}
				l714:
					{
						position716, tokenIndex716 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l717
						}
						position++
						goto l716
					l717:
						position, tokenIndex = position716, tokenIndex716
						if buffer[position] != rune('Z') {
							goto l713
						}
						position++
					}
				l716:
					{
						position718, tokenIndex718 := position, tokenIndex
						if buffer[position] != rune('r') {
							goto l719
						}
						position++
						goto l718
					l719:
						position, tokenIndex = position718, tokenIndex718
						if buffer[position] != rune('R') {
							goto l713
						}
						position++
					}
				l718:
					goto l689
				l713:
					position, tokenIndex = position689, tokenIndex689
					{
						position721, tokenIndex721 := position, tokenIndex
						if buffer[position] != rune('n') {
							goto l722
						}
						position++
						goto l721
					l722:
						position, tokenIndex = position721, tokenIndex721
						if buffer[position] != rune('N') {
							goto l720
						}
						position++
					}
				l721:
					{
						position723, tokenIndex723 := position, tokenIndex
						if buffer[position] != rune('z') {
							goto l724
						}
						position++
						goto l723
					l724:
						position, tokenIndex = position723, tokenIndex723
						if buffer[position] != rune('Z') {
							goto l720
						}
						position++
					}
				l723:
					{
						position725, tokenIndex725 := position, tokenIndex
						if buffer[position] != rune('c') {
							goto l726
						}
						position++
						goto l725
					l726:
						position, tokenIndex = position725, tokenIndex725
						if buffer[position] != rune('C') {
							goto l720
						}
						position++
					}
				l725:
					{
						position727, tokenIndex727 := position, tokenIndex
						if buffer[position] != rune('v') {
							goto l728
						}
						position++
						goto l727
					l728:
						position, tokenIndex = position727, tokenIndex727
						if buffer[position] != rune('V') {
							goto l720
						}
						position++
					}
				l727:
					goto l689
				l720:
					position, tokenIndex = position689, tokenIndex689
					if !_rules[ruleARMVectorRegister]() {
						goto l729
					}
					goto l689
				l729:
					position, tokenIndex = position689, tokenIndex689
					if !_rules[ruleSVE2PredicateRegister]() {
						goto l730
					}
					goto l689
				l730:
					position, tokenIndex = position689, tokenIndex689
					if buffer[position] != rune('{') {
						goto l687
					}
					position++
					{
						position731, tokenIndex731 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l731
						}
						goto l732
					l731:
						position, tokenIndex = position731, tokenIndex731
					}
				l732:
					if !_rules[ruleARMVectorRegister]() {
						goto l687
					}
					{
						position733, tokenIndex733 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l733
						}
						goto l734
					l733:
						position, tokenIndex = position733, tokenIndex733
					}
				l734:
				l735:
					{
						position736, tokenIndex736 := position, tokenIndex
						{
							position737, tokenIndex737 := position, tokenIndex
							if buffer[position] != rune(',') {
								goto l738
							}
							position++
							goto l737
						l738:
							position, tokenIndex = position737, tokenIndex737
							if buffer[position] != rune('-') {
								goto l736
							}
							position++
						}
					l737:
						{
							position739, tokenIndex739 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l739
							}
							goto l740
						l739:
							position, tokenIndex = position739, tokenIndex739
						}
					l740:
						if !_rules[ruleARMVectorRegister]() {
							goto l736
						}
						goto l735
					l736:
						position, tokenIndex = position736, tokenIndex736
					}
					{
						position741, tokenIndex741 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l741
						}
						goto l742
					l741:
						position, tokenIndex = position741, tokenIndex741
					}
				l742:
					if buffer[position] != rune('}') {
						goto l687
					}
					position++
					{
						position743, tokenIndex743 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l743
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l743
						}
						position++
						{
							position745, tokenIndex745 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l745
							}
							position++
							goto l746
						l745:
							position, tokenIndex = position745, tokenIndex745
						}
					l746:
						if buffer[position] != rune(']') {
							goto l743
						}
						position++
						goto l744
					l743:
						position, tokenIndex = position743, tokenIndex743
					}
				l744:
				}
			l689:
				add(ruleARMRegister, position688)
			}
			memoize(44, position687, tokenIndex687, true)
			return true
		l687:
			memoize(44, position687, tokenIndex687, false)
			position, tokenIndex = position687, tokenIndex687
			return false
		},
		/* 45 ARMVectorRegister <- <(('v' / 'z') [0-9] [0-9]? ('.' [0-9]* ('b' / 's' / 'd' / 'h' / 'q') ('[' [0-9] [0-9]? ']')?)?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{45, position}]; ok {
				return memoizedResult(memoized)
			}
			position747, tokenIndex747 := position, tokenIndex
			{
				position748 := position
				{
					position749, tokenIndex749 := position, tokenIndex
					if buffer[position] != rune('v') {
						goto l750
					}
					position++
					goto l749
				l750:
					position, tokenIndex = position749, tokenIndex749
					if buffer[position] != rune('z') {
						goto l747
					}
					position++
				}
			l749:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l747
				}
				position++
				{
					position751, tokenIndex751 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l751
					}
					position++
					goto l752
				l751:
					position, tokenIndex = position751, tokenIndex751
				}
			l752:
				{
					position753, tokenIndex753 := position, tokenIndex
					if buffer[position] != rune('.') {
						goto l753
					}
					position++
				l755:
					{
						position756, tokenIndex756 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l756
						}
						position++
						goto l755
					l756:
						position, tokenIndex = position756, tokenIndex756
					}
					{
						position757, tokenIndex757 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l758
						}
						position++
						goto l757
					l758:
						position, tokenIndex = position757, tokenIndex757
						if buffer[position] != rune('s') {
							goto l759
						}
						position++
						goto l757
					l759:
						position, tokenIndex = position757, tokenIndex757
						if buffer[position] != rune('d') {
							goto l760
						}
						position++
						goto l757
					l760:
						position, tokenIndex = position757, tokenIndex757
						if buffer[position] != rune('h') {
							goto l761
						}
						position++
						goto l757
					l761:
						position, tokenIndex = position757, tokenIndex757
						if buffer[position] != rune('q') {
							goto l753
						}
						position++
					}
				l757:
					{
						position762, tokenIndex762 := position, tokenIndex
						if buffer[position] != rune('[') {
							goto l762
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l762
						}
						position++
						{
							position764, tokenIndex764 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l764
							}
							position++
							goto l765
						l764:
							position, tokenIndex = position764, tokenIndex764
						}
					l765:
						if buffer[position] != rune(']') {
							goto l762
						}
						position++
						goto l763
					l762:
						position, tokenIndex = position762, tokenIndex762
					}
				l763:
					goto l754
				l753:
					position, tokenIndex = position753, tokenIndex753
				}
			l754:
				add(ruleARMVectorRegister, position748)
			}
			memoize(45, position747, tokenIndex747, true)
			return true
		l747:
			memoize(45, position747, tokenIndex747, false)
			position, tokenIndex = position747, tokenIndex747
			return false
		},
		/* 46 SVE2PredicateRegister <- <(('p' / 'P') [0-9] [0-9]? '/' ('m' / 'M' / 'z' / 'Z'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{46, position}]; ok {
				return memoizedResult(memoized)
			}
			position766, tokenIndex766 := position, tokenIndex
			{
				position767 := position
				{
					position768, tokenIndex768 := position, tokenIndex
					if buffer[position] != rune('p') {
						goto l769
					}
					position++
					goto l768
				l769:
					position, tokenIndex = position768, tokenIndex768
					if buffer[position] != rune('P') {
						goto l766
					}
					position++
				}
			l768:
				if c := buffer[position]; c < rune('0') || c > rune('9') {
					goto l766
				}
				position++
				{
					position770, tokenIndex770 := position, tokenIndex
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l770
					}
					position++
					goto l771
				l770:
					position, tokenIndex = position770, tokenIndex770
				}
			l771:
				if buffer[position] != rune('/') {
					goto l766
				}
				position++
				{
					position772, tokenIndex772 := position, tokenIndex
					if buffer[position] != rune('m') {
						goto l773
					}
					position++
					goto l772
				l773:
					position, tokenIndex = position772, tokenIndex772
					if buffer[position] != rune('M') {
						goto l774
					}
					position++
					goto l772
				l774:
					position, tokenIndex = position772, tokenIndex772
					if buffer[position] != rune('z') {
						goto l775
					}
					position++
					goto l772
				l775:
					position, tokenIndex = position772, tokenIndex772
					if buffer[position] != rune('Z') {
						goto l766
					}
					position++
				}
			l772:
				add(ruleSVE2PredicateRegister, position767)
			}
			memoize(46, position766, tokenIndex766, true)
			return true
		l766:
			memoize(46, position766, tokenIndex766, false)
			position, tokenIndex = position766, tokenIndex766
			return false
		},
		/* 47 ARMRegisterBoundary <- <([a-z] / [A-Z] / [0-9] / '_')> */
		func() bool {
			if memoized, ok := memoization[memoKey{47, position}]; ok {
				return memoizedResult(memoized)
			}
			position776, tokenIndex776 := position, tokenIndex
			{
				position777 := position
				{
					position778, tokenIndex778 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l779
					}
					position++
					goto l778
				l779:
					position, tokenIndex = position778, tokenIndex778
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l780
					}
					position++
					goto l778
				l780:
					position, tokenIndex = position778, tokenIndex778
					if c := buffer[position]; c < rune('0') || c > rune('9') {
						goto l781
					}
					position++
					goto l778
				l781:
					position, tokenIndex = position778, tokenIndex778
					if buffer[position] != rune('_') {
						goto l776
					}
					position++
				}
			l778:
				add(ruleARMRegisterBoundary, position777)
			}
			memoize(47, position776, tokenIndex776, true)
			return true
		l776:
			memoize(47, position776, tokenIndex776, false)
			position, tokenIndex = position776, tokenIndex776
			return false
		},
		/* 48 MemoryRef <- <((SymbolRef BaseIndexScale) / SymbolRef / Low12BitsSymbolRef / (Offset* BaseIndexScale) / (SegmentRegister Offset BaseIndexScale) / (SegmentRegister BaseIndexScale) / (SegmentRegister Offset) / ARMBaseIndexScale / BaseIndexScale)> */
		func() bool {
			if memoized, ok := memoization[memoKey{48, position}]; ok {
				return memoizedResult(memoized)
			}
			position782, tokenIndex782 := position, tokenIndex
			{
				position783 := position
				{
					position784, tokenIndex784 := position, tokenIndex
					if !_rules[ruleSymbolRef]() {
						goto l785
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l785
					}
					goto l784
				l785:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleSymbolRef]() {
						goto l786
					}
					goto l784
				l786:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleLow12BitsSymbolRef]() {
						goto l787
					}
					goto l784
				l787:
					position, tokenIndex = position784, tokenIndex784
				l789:
					{
						position790, tokenIndex790 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l790
						}
						goto l789
					l790:
						position, tokenIndex = position790, tokenIndex790
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l788
					}
					goto l784
				l788:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleSegmentRegister]() {
						goto l791
					}
					if !_rules[ruleOffset]() {
						goto l791
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l791
					}
					goto l784
				l791:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleSegmentRegister]() {
						goto l792
					}
					if !_rules[ruleBaseIndexScale]() {
						goto l792
					}
					goto l784
				l792:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleSegmentRegister]() {
						goto l793
					}
					if !_rules[ruleOffset]() {
						goto l793
					}
					goto l784
				l793:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleARMBaseIndexScale]() {
						goto l794
					}
					goto l784
				l794:
					position, tokenIndex = position784, tokenIndex784
					if !_rules[ruleBaseIndexScale]() {
						goto l782
					}
				}
			l784:
				add(ruleMemoryRef, position783)
			}
			memoize(48, position782, tokenIndex782, true)
			return true
		l782:
			memoize(48, position782, tokenIndex782, false)
			position, tokenIndex = position782, tokenIndex782
			return false
		},
		/* 49 SymbolRef <- <((Offset* '+')? (LocalSymbol / SymbolName) Offset* ('@' Section Offset*)?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{49, position}]; ok {
				return memoizedResult(memoized)
			}
			position795, tokenIndex795 := position, tokenIndex
			{
				position796 := position
				{
					position797, tokenIndex797 := position, tokenIndex
				l799:
					{
						position800, tokenIndex800 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l800
						}
						goto l799
					l800:
						position, tokenIndex = position800, tokenIndex800
					}
					if buffer[position] != rune('+') {
						goto l797
					}
					position++
					goto l798
				l797:
					position, tokenIndex = position797, tokenIndex797
				}
			l798:
				{
					position801, tokenIndex801 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l802
					}
					goto l801
				l802:
					position, tokenIndex = position801, tokenIndex801
					if !_rules[ruleSymbolName]() {
						goto l795
					}
				}
			l801:
			l803:
				{
					position804, tokenIndex804 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l804
					}
					goto l803
				l804:
					position, tokenIndex = position804, tokenIndex804
				}
				{
					position805, tokenIndex805 := position, tokenIndex
					if buffer[position] != rune('@') {
						goto l805
					}
					position++
					if !_rules[ruleSection]() {
						goto l805
					}
				l807:
					{
						position808, tokenIndex808 := position, tokenIndex
						if !_rules[ruleOffset]() {
							goto l808
						}
						goto l807
					l808:
						position, tokenIndex = position808, tokenIndex808
					}
					goto l806
				l805:
					position, tokenIndex = position805, tokenIndex805
				}
			l806:
				add(ruleSymbolRef, position796)
			}
			memoize(49, position795, tokenIndex795, true)
			return true
		l795:
			memoize(49, position795, tokenIndex795, false)
			position, tokenIndex = position795, tokenIndex795
			return false
		},
		/* 50 Low12BitsSymbolRef <- <(':' ('l' / 'L') ('o' / 'O') '1' '2' ':' (LocalSymbol / SymbolName) Offset?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{50, position}]; ok {
				return memoizedResult(memoized)
			}
			position809, tokenIndex809 := position, tokenIndex
			{
				position810 := position
				if buffer[position] != rune(':') {
					goto l809
				}
				position++
				{
					position811, tokenIndex811 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l812
					}
					position++
					goto l811
				l812:
					position, tokenIndex = position811, tokenIndex811
					if buffer[position] != rune('L') {
						goto l809
					}
					position++
				}
			l811:
				{
					position813, tokenIndex813 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l814
					}
					position++
					goto l813
				l814:
					position, tokenIndex = position813, tokenIndex813
					if buffer[position] != rune('O') {
						goto l809
					}
					position++
				}
			l813:
				if buffer[position] != rune('1') {
					goto l809
				}
				position++
				if buffer[position] != rune('2') {
					goto l809
				}
				position++
				if buffer[position] != rune(':') {
					goto l809
				}
				position++
				{
					position815, tokenIndex815 := position, tokenIndex
					if !_rules[ruleLocalSymbol]() {
						goto l816
					}
					goto l815
				l816:
					position, tokenIndex = position815, tokenIndex815
					if !_rules[ruleSymbolName]() {
						goto l809
					}
				}
			l815:
				{
					position817, tokenIndex817 := position, tokenIndex
					if !_rules[ruleOffset]() {
						goto l817
					}
					goto l818
				l817:
					position, tokenIndex = position817, tokenIndex817
				}
			l818:
				add(ruleLow12BitsSymbolRef, position810)
			}
			memoize(50, position809, tokenIndex809, true)
			return true
		l809:
			memoize(50, position809, tokenIndex809, false)
			position, tokenIndex = position809, tokenIndex809
			return false
		},
		/* 51 ARMBaseIndexScale <- <('[' ARMRegister (',' WS? (('#'? Offset (('*' [0-9]+) / ('*' '(' [0-9]+ Operator [0-9]+ ')') / ('+' [0-9]+)*)?) / ('#'? ARMGOTLow12) / ('#'? Low12BitsSymbolRef) / ARMRegister) (',' WS? ARMConstantTweak)?)? ']' ARMPostincrement?)> */
		func() bool {
			if memoized, ok := memoization[memoKey{51, position}]; ok {
				return memoizedResult(memoized)
			}
			position819, tokenIndex819 := position, tokenIndex
			{
				position820 := position
				if buffer[position] != rune('[') {
					goto l819
				}
				position++
				if !_rules[ruleARMRegister]() {
					goto l819
				}
				{
					position821, tokenIndex821 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l821
					}
					position++
					{
						position823, tokenIndex823 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l823
						}
						goto l824
					l823:
						position, tokenIndex = position823, tokenIndex823
					}
				l824:
					{
						position825, tokenIndex825 := position, tokenIndex
						{
							position827, tokenIndex827 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l827
							}
							position++
							goto l828
						l827:
							position, tokenIndex = position827, tokenIndex827
						}
					l828:
						if !_rules[ruleOffset]() {
							goto l826
						}
						{
							position829, tokenIndex829 := position, tokenIndex
							{
								position831, tokenIndex831 := position, tokenIndex
								if buffer[position] != rune('*') {
									goto l832
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l832
								}
								position++
							l833:
								{
									position834, tokenIndex834 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l834
									}
									position++
									goto l833
								l834:
									position, tokenIndex = position834, tokenIndex834
								}
								goto l831
							l832:
								position, tokenIndex = position831, tokenIndex831
								if buffer[position] != rune('*') {
									goto l835
								}
								position++
								if buffer[position] != rune('(') {
									goto l835
								}
								position++
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l835
								}
								position++
							l836:
								{
									position837, tokenIndex837 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l837
									}
									position++
									goto l836
								l837:
									position, tokenIndex = position837, tokenIndex837
								}
								if !_rules[ruleOperator]() {
									goto l835
								}
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l835
								}
								position++
							l838:
								{
									position839, tokenIndex839 := position, tokenIndex
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l839
									}
									position++
									goto l838
								l839:
									position, tokenIndex = position839, tokenIndex839
								}
								if buffer[position] != rune(')') {
									goto l835
								}
								position++
								goto l831
							l835:
								position, tokenIndex = position831, tokenIndex831
							l840:
								{
									position841, tokenIndex841 := position, tokenIndex
									if buffer[position] != rune('+') {
										goto l841
									}
									position++
									if c := buffer[position]; c < rune('0') || c > rune('9') {
										goto l841
									}
									position++
								l842:
									{
										position843, tokenIndex843 := position, tokenIndex
										if c := buffer[position]; c < rune('0') || c > rune('9') {
											goto l843
										}
										position++
										goto l842
									l843:
										position, tokenIndex = position843, tokenIndex843
									}
									goto l840
								l841:
									position, tokenIndex = position841, tokenIndex841
								}
							}
						l831:
							goto l830

							position, tokenIndex = position829, tokenIndex829
						}
					l830:
						goto l825
					l826:
						position, tokenIndex = position825, tokenIndex825
						{
							position845, tokenIndex845 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l845
							}
							position++
							goto l846
						l845:
							position, tokenIndex = position845, tokenIndex845
						}
					l846:
						if !_rules[ruleARMGOTLow12]() {
							goto l844
						}
						goto l825
					l844:
						position, tokenIndex = position825, tokenIndex825
						{
							position848, tokenIndex848 := position, tokenIndex
							if buffer[position] != rune('#') {
								goto l848
							}
							position++
							goto l849
						l848:
							position, tokenIndex = position848, tokenIndex848
						}
					l849:
						if !_rules[ruleLow12BitsSymbolRef]() {
							goto l847
						}
						goto l825
					l847:
						position, tokenIndex = position825, tokenIndex825
						if !_rules[ruleARMRegister]() {
							goto l821
						}
					}
				l825:
					{
						position850, tokenIndex850 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l850
						}
						position++
						{
							position852, tokenIndex852 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l852
							}
							goto l853
						l852:
							position, tokenIndex = position852, tokenIndex852
						}
					l853:
						if !_rules[ruleARMConstantTweak]() {
							goto l850
						}
						goto l851
					l850:
						position, tokenIndex = position850, tokenIndex850
					}
				l851:
					goto l822
				l821:
					position, tokenIndex = position821, tokenIndex821
				}
			l822:
				if buffer[position] != rune(']') {
					goto l819
				}
				position++
				{
					position854, tokenIndex854 := position, tokenIndex
					if !_rules[ruleARMPostincrement]() {
						goto l854
					}
					goto l855
				l854:
					position, tokenIndex = position854, tokenIndex854
				}
			l855:
				add(ruleARMBaseIndexScale, position820)
			}
			memoize(51, position819, tokenIndex819, true)
			return true
		l819:
			memoize(51, position819, tokenIndex819, false)
			position, tokenIndex = position819, tokenIndex819
			return false
		},
		/* 52 ARMGOTLow12 <- <(':' ('g' / 'G') ('o' / 'O') ('t' / 'T') '_' ('l' / 'L') ('o' / 'O') '1' '2' ':' SymbolName)> */
		func() bool {
			if memoized, ok := memoization[memoKey{52, position}]; ok {
				return memoizedResult(memoized)
			}
			position856, tokenIndex856 := position, tokenIndex
			{
				position857 := position
				if buffer[position] != rune(':') {
					goto l856
				}
				position++
				{
					position858, tokenIndex858 := position, tokenIndex
					if buffer[position] != rune('g') {
						goto l859
					}
					position++
					goto l858
				l859:
					position, tokenIndex = position858, tokenIndex858
					if buffer[position] != rune('G') {
						goto l856
					}
					position++
				}
			l858:
				{
					position860, tokenIndex860 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l861
					}
					position++
					goto l860
				l861:
					position, tokenIndex = position860, tokenIndex860
					if buffer[position] != rune('O') {
						goto l856
					}
					position++
				}
			l860:
				{
					position862, tokenIndex862 := position, tokenIndex
					if buffer[position] != rune('t') {
						goto l863
					}
					position++
					goto l862
				l863:
					position, tokenIndex = position862, tokenIndex862
					if buffer[position] != rune('T') {
						goto l856
					}
					position++
				}
			l862:
				if buffer[position] != rune('_') {
					goto l856
				}
				position++
				{
					position864, tokenIndex864 := position, tokenIndex
					if buffer[position] != rune('l') {
						goto l865
					}
					position++
					goto l864
				l865:
					position, tokenIndex = position864, tokenIndex864
					if buffer[position] != rune('L') {
						goto l856
					}
					position++
				}
			l864:
				{
					position866, tokenIndex866 := position, tokenIndex
					if buffer[position] != rune('o') {
						goto l867
					}
					position++
					goto l866
				l867:
					position, tokenIndex = position866, tokenIndex866
					if buffer[position] != rune('O') {
						goto l856
					}
					position++
				}
			l866:
				if buffer[position] != rune('1') {
					goto l856
				}
				position++
				if buffer[position] != rune('2') {
					goto l856
				}
				position++
				if buffer[position] != rune(':') {
					goto l856
				}
				position++
				if !_rules[ruleSymbolName]() {
					goto l856
				}
				add(ruleARMGOTLow12, position857)
			}
			memoize(52, position856, tokenIndex856, true)
			return true
		l856:
			memoize(52, position856, tokenIndex856, false)
			position, tokenIndex = position856, tokenIndex856
			return false
		},
		/* 53 ARMPostincrement <- <'!'> */
		func() bool {
			if memoized, ok := memoization[memoKey{53, position}]; ok {
				return memoizedResult(memoized)
			}
			position868, tokenIndex868 := position, tokenIndex
			{
				position869 := position
				if buffer[position] != rune('!') {
					goto l868
				}
				position++
				add(ruleARMPostincrement, position869)
			}
			memoize(53, position868, tokenIndex868, true)
			return true
		l868:
			memoize(53, position868, tokenIndex868, false)
			position, tokenIndex = position868, tokenIndex868
			return false
		},
		/* 54 BaseIndexScale <- <('(' RegisterOrConstant? WS? (',' WS? RegisterOrConstant WS? (',' [0-9]+)?)? ')')> */
		func() bool {
			if memoized, ok := memoization[memoKey{54, position}]; ok {
				return memoizedResult(memoized)
			}
			position870, tokenIndex870 := position, tokenIndex
			{
				position871 := position
				if buffer[position] != rune('(') {
					goto l870
				}
				position++
				{
					position872, tokenIndex872 := position, tokenIndex
					if !_rules[ruleRegisterOrConstant]() {
						goto l872
					}
					goto l873
				l872:
					position, tokenIndex = position872, tokenIndex872
				}
			l873:
				{
					position874, tokenIndex874 := position, tokenIndex
					if !_rules[ruleWS]() {
						goto l874
					}
					goto l875
				l874:
					position, tokenIndex = position874, tokenIndex874
				}
			l875:
				{
					position876, tokenIndex876 := position, tokenIndex
					if buffer[position] != rune(',') {
						goto l876
					}
					position++
					{
						position878, tokenIndex878 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l878
						}
						goto l879
					l878:
						position, tokenIndex = position878, tokenIndex878
					}
				l879:
					if !_rules[ruleRegisterOrConstant]() {
						goto l876
					}
					{
						position880, tokenIndex880 := position, tokenIndex
						if !_rules[ruleWS]() {
							goto l880
						}
						goto l881
					l880:
						position, tokenIndex = position880, tokenIndex880
					}
				l881:
					{
						position882, tokenIndex882 := position, tokenIndex
						if buffer[position] != rune(',') {
							goto l882
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l882
						}
						position++
					l884:
						{
							position885, tokenIndex885 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l885
							}
							position++
							goto l884
						l885:
							position, tokenIndex = position885, tokenIndex885
						}
						goto l883
					l882:
						position, tokenIndex = position882, tokenIndex882
					}
				l883:
					goto l877
				l876:
					position, tokenIndex = position876, tokenIndex876
				}
			l877:
				if buffer[position] != rune(')') {
					goto l870
				}
				position++
				add(ruleBaseIndexScale, position871)
			}
			memoize(54, position870, tokenIndex870, true)
			return true
		l870:
			memoize(54, position870, tokenIndex870, false)
			position, tokenIndex = position870, tokenIndex870
			return false
		},
		/* 55 Operator <- <('+' / '-')> */
		func() bool {
			if memoized, ok := memoization[memoKey{55, position}]; ok {
				return memoizedResult(memoized)
			}
			position886, tokenIndex886 := position, tokenIndex
			{
				position887 := position
				{
					position888, tokenIndex888 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l889
					}
					position++
					goto l888
				l889:
					position, tokenIndex = position888, tokenIndex888
					if buffer[position] != rune('-') {
						goto l886
					}
					position++
				}
			l888:
				add(ruleOperator, position887)
			}
			memoize(55, position886, tokenIndex886, true)
			return true
		l886:
			memoize(55, position886, tokenIndex886, false)
			position, tokenIndex = position886, tokenIndex886
			return false
		},
		/* 56 OffsetOperator <- <('+' / '-' / '*')> */
		func() bool {
			if memoized, ok := memoization[memoKey{56, position}]; ok {
				return memoizedResult(memoized)
			}
			position890, tokenIndex890 := position, tokenIndex
			{
				position891 := position
				{
					position892, tokenIndex892 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l893
					}
					position++
					goto l892
				l893:
					position, tokenIndex = position892, tokenIndex892
					if buffer[position] != rune('-') {
						goto l894
					}
					position++
					goto l892
				l894:
					position, tokenIndex = position892, tokenIndex892
					if buffer[position] != rune('*') {
						goto l890
					}
					position++
				}
			l892:
				add(ruleOffsetOperator, position891)
			}
			memoize(56, position890, tokenIndex890, true)
			return true
		l890:
			memoize(56, position890, tokenIndex890, false)
			position, tokenIndex = position890, tokenIndex890
			return false
		},
		/* 57 Offset <- <('+'? '-'? (('0' ('b' / 'B') ('0' / '1')+) / ('0' ('x' / 'X') ([0-9] / [0-9] / ([a-f] / [A-F]))+) / ((([0-9]+ WS OffsetOperator [0-9]+) / ([0-9]+ (OffsetOperator '(' [0-9]+ OffsetOperator [0-9]+ ')')?) / ([0-9]+ (OffsetOperator [0-9]+ OffsetOperator [0-9]+)?) / ([0-9]+ (OffsetOperator [0-9]+)?) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ OffsetOperator [0-9]+) / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')' OffsetOperator [0-9]+ !'x') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ ')') / ('(' [0-9]+ WS? OffsetOperator WS? [0-9]+ WS? OffsetOperator WS? [0-9]+ ')')) !([a-z] / [A-Z]))))> */
		func() bool {
			if memoized, ok := memoization[memoKey{57, position}]; ok {
				return memoizedResult(memoized)
			}
			position895, tokenIndex895 := position, tokenIndex
			{
				position896 := position
				{
					position897, tokenIndex897 := position, tokenIndex
					if buffer[position] != rune('+') {
						goto l897
					}
					position++
					goto l898
				l897:
					position, tokenIndex = position897, tokenIndex897
				}
			l898:
				{
					position899, tokenIndex899 := position, tokenIndex
					if buffer[position] != rune('-') {
						goto l899
					}
					position++
					goto l900
				l899:
					position, tokenIndex = position899, tokenIndex899
				}
			l900:
				{
					position901, tokenIndex901 := position, tokenIndex
					if buffer[position] != rune('0') {
						goto l902
					}
					position++
					{
						position903, tokenIndex903 := position, tokenIndex
						if buffer[position] != rune('b') {
							goto l904
						}
						position++
						goto l903
					l904:
						position, tokenIndex = position903, tokenIndex903
						if buffer[position] != rune('B') {
							goto l902
						}
						position++
					}
				l903:
					{
						position907, tokenIndex907 := position, tokenIndex
						if buffer[position] != rune('0') {
							goto l908
						}
						position++
						goto l907
					l908:
						position, tokenIndex = position907, tokenIndex907
						if buffer[position] != rune('1') {
							goto l902
						}
						position++
					}
				l907:
				l905:
					{
						position906, tokenIndex906 := position, tokenIndex
						{
							position909, tokenIndex909 := position, tokenIndex
							if buffer[position] != rune('0') {
								goto l910
							}
							position++
							goto l909
						l910:
							position, tokenIndex = position909, tokenIndex909
							if buffer[position] != rune('1') {
								goto l906
							}
							position++
						}
					l909:
						goto l905
					l906:
						position, tokenIndex = position906, tokenIndex906
					}
					goto l901
				l902:
					position, tokenIndex = position901, tokenIndex901
					if buffer[position] != rune('0') {
						goto l911
					}
					position++
					{
						position912, tokenIndex912 := position, tokenIndex
						if buffer[position] != rune('x') {
							goto l913
						}
						position++
						goto l912
					l913:
						position, tokenIndex = position912, tokenIndex912
						if buffer[position] != rune('X') {
							goto l911
						}
						position++
					}
				l912:
					{
						position916, tokenIndex916 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l917
						}
						position++
						goto l916
					l917:
						position, tokenIndex = position916, tokenIndex916
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l918
						}
						position++
						goto l916
					l918:
						position, tokenIndex = position916, tokenIndex916
						{
							position919, tokenIndex919 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('f') {
								goto l920
							}
							position++
							goto l919
						l920:
							position, tokenIndex = position919, tokenIndex919
							if c := buffer[position]; c < rune('A') || c > rune('F') {
								goto l911
							}
							position++
						}
					l919:
					}
				l916:
				l914:
					{
						position915, tokenIndex915 := position, tokenIndex
						{
							position921, tokenIndex921 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l922
							}
							position++
							goto l921
						l922:
							position, tokenIndex = position921, tokenIndex921
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l923
							}
							position++
							goto l921
						l923:
							position, tokenIndex = position921, tokenIndex921
							{
								position924, tokenIndex924 := position, tokenIndex
								if c := buffer[position]; c < rune('a') || c > rune('f') {
									goto l925
								}
								position++
								goto l924
							l925:
								position, tokenIndex = position924, tokenIndex924
								if c := buffer[position]; c < rune('A') || c > rune('F') {
									goto l915
								}
								position++
							}
						l924:
						}
					l921:
						goto l914
					l915:
						position, tokenIndex = position915, tokenIndex915
					}
					goto l901
				l911:
					position, tokenIndex = position901, tokenIndex901
					{
						position926, tokenIndex926 := position, tokenIndex
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l927
						}
						position++
					l928:
						{
							position929, tokenIndex929 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l929
							}
							position++
							goto l928
						l929:
							position, tokenIndex = position929, tokenIndex929
						}
						if !_rules[ruleWS]() {
							goto l927
						}
						if !_rules[ruleOffsetOperator]() {
							goto l927
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l927
						}
						position++
					l930:
						{
							position931, tokenIndex931 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l931
							}
							position++
							goto l930
						l931:
							position, tokenIndex = position931, tokenIndex931
						}
						goto l926
					l927:
						position, tokenIndex = position926, tokenIndex926
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l932
						}
						position++
					l933:
						{
							position934, tokenIndex934 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l934
							}
							position++
							goto l933
						l934:
							position, tokenIndex = position934, tokenIndex934
						}
						{
							position935, tokenIndex935 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l935
							}
							if buffer[position] != rune('(') {
								goto l935
							}
							position++
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l935
							}
							position++
						l937:
							{
								position938, tokenIndex938 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l938
								}
								position++
								goto l937
							l938:
								position, tokenIndex = position938, tokenIndex938
							}
							if !_rules[ruleOffsetOperator]() {
								goto l935
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l935
							}
							position++
						l939:
							{
								position940, tokenIndex940 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l940
								}
								position++
								goto l939
							l940:
								position, tokenIndex = position940, tokenIndex940
							}
							if buffer[position] != rune(')') {
								goto l935
							}
							position++
							goto l936
						l935:
							position, tokenIndex = position935, tokenIndex935
						}
					l936:
						goto l926
					l932:
						position, tokenIndex = position926, tokenIndex926
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l941
						}
						position++
					l942:
						{
							position943, tokenIndex943 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l943
							}
							position++
							goto l942
						l943:
							position, tokenIndex = position943, tokenIndex943
						}
						{
							position944, tokenIndex944 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l944
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l944
							}
							position++
						l946:
							{
								position947, tokenIndex947 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l947
								}
								position++
								goto l946
							l947:
								position, tokenIndex = position947, tokenIndex947
							}
							if !_rules[ruleOffsetOperator]() {
								goto l944
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l944
							}
							position++
						l948:
							{
								position949, tokenIndex949 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l949
								}
								position++
								goto l948
							l949:
								position, tokenIndex = position949, tokenIndex949
							}
							goto l945
						l944:
							position, tokenIndex = position944, tokenIndex944
						}
					l945:
						goto l926
					l941:
						position, tokenIndex = position926, tokenIndex926
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l950
						}
						position++
					l951:
						{
							position952, tokenIndex952 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l952
							}
							position++
							goto l951
						l952:
							position, tokenIndex = position952, tokenIndex952
						}
						{
							position953, tokenIndex953 := position, tokenIndex
							if !_rules[ruleOffsetOperator]() {
								goto l953
							}
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l953
							}
							position++
						l955:
							{
								position956, tokenIndex956 := position, tokenIndex
								if c := buffer[position]; c < rune('0') || c > rune('9') {
									goto l956
								}
								position++
								goto l955
							l956:
								position, tokenIndex = position956, tokenIndex956
							}
							goto l954
						l953:
							position, tokenIndex = position953, tokenIndex953
						}
					l954:
						goto l926
					l950:
						position, tokenIndex = position926, tokenIndex926
						if buffer[position] != rune('(') {
							goto l957
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l957
						}
						position++
					l958:
						{
							position959, tokenIndex959 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l959
							}
							position++
							goto l958
						l959:
							position, tokenIndex = position959, tokenIndex959
						}
						{
							position960, tokenIndex960 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l960
							}
							goto l961
						l960:
							position, tokenIndex = position960, tokenIndex960
						}
					l961:
						if !_rules[ruleOffsetOperator]() {
							goto l957
						}
						{
							position962, tokenIndex962 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l962
							}
							goto l963
						l962:
							position, tokenIndex = position962, tokenIndex962
						}
					l963:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l957
						}
						position++
					l964:
						{
							position965, tokenIndex965 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l965
							}
							position++
							goto l964
						l965:
							position, tokenIndex = position965, tokenIndex965
						}
						if buffer[position] != rune(')') {
							goto l957
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l957
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l957
						}
						position++
					l966:
						{
							position967, tokenIndex967 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l967
							}
							position++
							goto l966
						l967:
							position, tokenIndex = position967, tokenIndex967
						}
						if !_rules[ruleOffsetOperator]() {
							goto l957
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l957
						}
						position++
					l968:
						{
							position969, tokenIndex969 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l969
							}
							position++
							goto l968
						l969:
							position, tokenIndex = position969, tokenIndex969
						}
						goto l926
					l957:
						position, tokenIndex = position926, tokenIndex926
						if buffer[position] != rune('(') {
							goto l970
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l970
						}
						position++
					l971:
						{
							position972, tokenIndex972 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l972
							}
							position++
							goto l971
						l972:
							position, tokenIndex = position972, tokenIndex972
						}
						{
							position973, tokenIndex973 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l973
							}
							goto l974
						l973:
							position, tokenIndex = position973, tokenIndex973
						}
					l974:
						if !_rules[ruleOffsetOperator]() {
							goto l970
						}
						{
							position975, tokenIndex975 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l975
							}
							goto l976
						l975:
							position, tokenIndex = position975, tokenIndex975
						}
					l976:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l970
						}
						position++
					l977:
						{
							position978, tokenIndex978 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l978
							}
							position++
							goto l977
						l978:
							position, tokenIndex = position978, tokenIndex978
						}
						if buffer[position] != rune(')') {
							goto l970
						}
						position++
						if !_rules[ruleOffsetOperator]() {
							goto l970
						}
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l970
						}
						position++
					l979:
						{
							position980, tokenIndex980 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l980
							}
							position++
							goto l979
						l980:
							position, tokenIndex = position980, tokenIndex980
						}
						{
							position981, tokenIndex981 := position, tokenIndex
							if buffer[position] != rune('x') {
								goto l981
							}
							position++
							goto l970
						l981:
							position, tokenIndex = position981, tokenIndex981
						}
						goto l926
					l970:
						position, tokenIndex = position926, tokenIndex926
						if buffer[position] != rune('(') {
							goto l982
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l982
						}
						position++
					l983:
						{
							position984, tokenIndex984 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l984
							}
							position++
							goto l983
						l984:
							position, tokenIndex = position984, tokenIndex984
						}
						{
							position985, tokenIndex985 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l985
							}
							goto l986
						l985:
							position, tokenIndex = position985, tokenIndex985
						}
					l986:
						if !_rules[ruleOffsetOperator]() {
							goto l982
						}
						{
							position987, tokenIndex987 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l987
							}
							goto l988
						l987:
							position, tokenIndex = position987, tokenIndex987
						}
					l988:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l982
						}
						position++
					l989:
						{
							position990, tokenIndex990 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l990
							}
							position++
							goto l989
						l990:
							position, tokenIndex = position990, tokenIndex990
						}
						if buffer[position] != rune(')') {
							goto l982
						}
						position++
						goto l926
					l982:
						position, tokenIndex = position926, tokenIndex926
						if buffer[position] != rune('(') {
							goto l895
						}
						position++
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l895
						}
						position++
					l991:
						{
							position992, tokenIndex992 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l992
							}
							position++
							goto l991
						l992:
							position, tokenIndex = position992, tokenIndex992
						}
						{
							position993, tokenIndex993 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l993
							}
							goto l994
						l993:
							position, tokenIndex = position993, tokenIndex993
						}
					l994:
						if !_rules[ruleOffsetOperator]() {
							goto l895
						}
						{
							position995, tokenIndex995 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l995
							}
							goto l996
						l995:
							position, tokenIndex = position995, tokenIndex995
						}
					l996:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l895
						}
						position++
					l997:
						{
							position998, tokenIndex998 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l998
							}
							position++
							goto l997
						l998:
							position, tokenIndex = position998, tokenIndex998
						}
						{
							position999, tokenIndex999 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l999
							}
							goto l1000
						l999:
							position, tokenIndex = position999, tokenIndex999
						}
					l1000:
						if !_rules[ruleOffsetOperator]() {
							goto l895
						}
						{
							position1001, tokenIndex1001 := position, tokenIndex
							if !_rules[ruleWS]() {
								goto l1001
							}
							goto l1002
						l1001:
							position, tokenIndex = position1001, tokenIndex1001
						}
					l1002:
						if c := buffer[position]; c < rune('0') || c > rune('9') {
							goto l895
						}
						position++
					l1003:
						{
							position1004, tokenIndex1004 := position, tokenIndex
							if c := buffer[position]; c < rune('0') || c > rune('9') {
								goto l1004
							}
							position++
							goto l1003
						l1004:
							position, tokenIndex = position1004, tokenIndex1004
						}
						if buffer[position] != rune(')') {
							goto l895
						}
						position++
					}
				l926:
					{
						position1005, tokenIndex1005 := position, tokenIndex
						{
							position1006, tokenIndex1006 := position, tokenIndex
							if c := buffer[position]; c < rune('a') || c > rune('z') {
								goto l1007
							}
							position++
							goto l1006
						l1007:
							position, tokenIndex = position1006, tokenIndex1006
							if c := buffer[position]; c < rune('A') || c > rune('Z') {
								goto l1005
							}
							position++
						}
					l1006:
						goto l895
					l1005:
						position, tokenIndex = position1005, tokenIndex1005
					}
				}
			l901:
				add(ruleOffset, position896)
			}
			memoize(57, position895, tokenIndex895, true)
			return true
		l895:
			memoize(57, position895, tokenIndex895, false)
			position, tokenIndex = position895, tokenIndex895
			return false
		},
		/* 58 Section <- <([a-z] / [A-Z] / '@')+> */
		func() bool {
			if memoized, ok := memoization[memoKey{58, position}]; ok {
				return memoizedResult(memoized)
			}
			position1008, tokenIndex1008 := position, tokenIndex
			{
				position1009 := position
				{
					position1012, tokenIndex1012 := position, tokenIndex
					if c := buffer[position]; c < rune('a') || c > rune('z') {
						goto l1013
					}
					position++
					goto l1012
				l1013:
					position, tokenIndex = position1012, tokenIndex1012
					if c := buffer[position]; c < rune('A') || c > rune('Z') {
						goto l1014
					}
					position++
					goto l1012
				l1014:
					position, tokenIndex = position1012, tokenIndex1012
					if buffer[position] != rune('@') {
						goto l1008
					}
					position++
				}
			l1012:
			l1010:
				{
					position1011, tokenIndex1011 := position, tokenIndex
					{
						position1015, tokenIndex1015 := position, tokenIndex
						if c := buffer[position]; c < rune('a') || c > rune('z') {
							goto l1016
						}
						position++
						goto l1015
					l1016:
						position, tokenIndex = position1015, tokenIndex1015
						if c := buffer[position]; c < rune('A') || c > rune('Z') {
							goto l1017
						}
						position++
						goto l1015
					l1017:
						position, tokenIndex = position1015, tokenIndex1015
						if buffer[position] != rune('@') {
							goto l1011
						}
						position++
					}
				l1015:
					goto l1010
				l1011:
					position, tokenIndex = position1011, tokenIndex1011
				}
				add(ruleSection, position1009)
			}
			memoize(58, position1008, tokenIndex1008, true)
			return true
		l1008:
			memoize(58, position1008, tokenIndex1008, false)
			position, tokenIndex = position1008, tokenIndex1008
			return false
		},
		/* 59 SegmentRegister <- <('%' ([c-g] / 's') ('s' ':'))> */
		func() bool {
			if memoized, ok := memoization[memoKey{59, position}]; ok {
				return memoizedResult(memoized)
			}
			position1018, tokenIndex1018 := position, tokenIndex
			{
				position1019 := position
				if buffer[position] != rune('%') {
					goto l1018
				}
				position++
				{
					position1020, tokenIndex1020 := position, tokenIndex
					if c := buffer[position]; c < rune('c') || c > rune('g') {
						goto l1021
					}
					position++
					goto l1020
				l1021:
					position, tokenIndex = position1020, tokenIndex1020
					if buffer[position] != rune('s') {
						goto l1018
					}
					position++
				}
			l1020:
				if buffer[position] != rune('s') {
					goto l1018
				}
				position++
				if buffer[position] != rune(':') {
					goto l1018
				}
				position++
				add(ruleSegmentRegister, position1019)
			}
			memoize(59, position1018, tokenIndex1018, true)
			return true
		l1018:
			memoize(59, position1018, tokenIndex1018, false)
			position, tokenIndex = position1018, tokenIndex1018
			return false
		},
	}
	p.rules = _rules
	return nil
}
