set(RMLUI_IS_CONFIG_FILE TRUE)
set(RMLUI_SVG_PLUGIN OFF)
set(RMLUI_LOTTIE_PLUGIN OFF)
set(RMLUI_FONT_ENGINE "freetype")
set(RMLUI_LUA_BINDINGS OFF)
set(RMLUI_LUA_BINDINGS_LIBRARY "")
set(RMLUI_TRACY_PROFILING "OFF")

macro(report_dependency_not_found friendly_name target_name)
	if(RmlUi_FIND_REQUIRED)
		message(FATAL_ERROR
				"${friendly_name} could not be found.\n"
				"Please ensure that ${friendly_name} can be found by CMake, or linked to using \"${target_name}\" as its "
				"target name. If you are consuming RmlUi from another CMake project, you can create an ALIAS target to "
				"offer an alternative name for a CMake target."
			)
	endif()
	return()
endmacro()
macro(report_dependency_found_or_error friendly_name target_name)
	if(NOT TARGET ${target_name})
		report_dependency_not_found(${friendly_name} ${target_name})
	endif()
	if(ARGC GREATER "2" AND ARGV2)
		set(success_message " - ${ARGV2}")
	endif()
	message(STATUS "Found ${friendly_name} target ${target_name}${success_message}")
endmacro()

list(APPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/Modules")

include("${CMAKE_CURRENT_LIST_DIR}/Dependencies.cmake")

include("${CMAKE_CURRENT_LIST_DIR}/RmlUiTargets.cmake")
