/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictResolution;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class ChangelistConflictTracker {
    private final Map<String, Conflict> myConflicts;
    private final Options myOptions;
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ZipperUpdater myZipperUpdater;
    private final Set<VirtualFile> myCheckSet;
    private final AtomicBoolean myShouldIgnoreModifications;

    @NotNull
    public static ChangelistConflictTracker getInstance(@NotNull Project project) {
        if (project == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(0);
        }
        ChangelistConflictTracker changelistConflictTracker = ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker();
        if (changelistConflictTracker == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(1);
        }
        return changelistConflictTracker;
    }

    public ChangelistConflictTracker(@NotNull Project project, @NotNull ChangeListManager changeListManager) {
        if (project == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(2);
        }
        if (changeListManager == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(3);
        }
        this.myConflicts = Collections.synchronizedMap(new LinkedHashMap());
        this.myOptions = new Options();
        this.myCheckSet = new HashSet<VirtualFile>();
        this.myShouldIgnoreModifications = new AtomicBoolean(false);
        this.myProject = project;
        this.myChangeListManager = changeListManager;
        this.myZipperUpdater = new ZipperUpdater(300, Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
    }

    public void setIgnoreModifications(boolean value) {
        this.myShouldIgnoreModifications.set(value);
    }

    @RequiresEdt
    private void checkFiles() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        if (this.myCheckSet.isEmpty()) {
            return;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myCheckSet);
        this.myCheckSet.clear();
        this.myChangeListManager.invokeAfterUpdate(false, () -> {
            LocalChangeList defaultList = this.myChangeListManager.getDefaultChangeList();
            for (VirtualFile file : files) {
                this.checkOneFile(file, defaultList);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private void checkOneFile(@NotNull VirtualFile file, @NotNull LocalChangeList defaultList) {
        if (file == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(4);
        }
        if (defaultList == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertBackgroundThread();
        if (!this.shouldDetectConflictsFor(file)) {
            return;
        }
        LocalChangeList changeList = this.myChangeListManager.getChangeList(file);
        if (changeList == null || Comparing.equal((Object)changeList, (Object)defaultList)) {
            return;
        }
        String path = file.getPath();
        boolean newConflict = false;
        Map<String, Conflict> map = this.myConflicts;
        synchronized (map) {
            Conflict conflict = this.myConflicts.get(path);
            if (conflict == null) {
                conflict = new Conflict();
                this.myConflicts.put(path, conflict);
                newConflict = true;
            }
        }
        if (newConflict && this.myOptions.HIGHLIGHT_CONFLICTS) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file);
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
        }
    }

    public boolean isWritingAllowed(@NotNull VirtualFile file) {
        if (file == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(6);
        }
        if (this.isFromActiveChangelist(file)) {
            return true;
        }
        Conflict conflict = this.myConflicts.get(file.getPath());
        return conflict != null && conflict.ignored;
    }

    public boolean isFromActiveChangelist(VirtualFile file) {
        List changeLists2 = this.myChangeListManager.getChangeLists(file);
        return changeLists2.isEmpty() || ContainerUtil.exists((Iterable)changeLists2, list -> list.isDefault());
    }

    private boolean shouldDetectConflicts() {
        if (!this.myOptions.SHOW_DIALOG && !this.myOptions.HIGHLIGHT_CONFLICTS) {
            return false;
        }
        if (!this.myChangeListManager.areChangeListsEnabled()) {
            return false;
        }
        Object[] activeVcss = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss();
        if (activeVcss.length == 0) {
            return false;
        }
        boolean onlyPartialChangelists = LineStatusTrackerManager.getInstance(this.myProject).arePartialChangelistsEnabled() && ContainerUtil.all((Object[])activeVcss, vcs -> vcs.arePartialChangelistsSupported());
        return !onlyPartialChangelists;
    }

    private boolean shouldDetectConflictsFor(@NotNull VirtualFile file) {
        AbstractVcs vcs;
        if (file == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(7);
        }
        if ((vcs = VcsUtil.getVcsFor((Project)this.myProject, (VirtualFile)file)) == null) {
            return false;
        }
        return !LineStatusTrackerManager.getInstance(this.myProject).arePartialChangelistsEnabled(file);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private void clearChanges(Collection<? extends Change> collection) {
        void changes;
        ThreadingAssertions.assertBackgroundThread();
        if (!this.shouldDetectConflicts() && !this.myOptions.HIGHLIGHT_NON_ACTIVE_CHANGELIST) {
            return;
        }
        for (Change change : changes) {
            VirtualFile file;
            boolean conflictRemoved;
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            FilePath filePath = revision.getFile();
            String path = filePath.getPath();
            Conflict conflict = this.myConflicts.remove(path);
            boolean bl = conflictRemoved = conflict != null && !conflict.ignored;
            if (!conflictRemoved && !this.myOptions.HIGHLIGHT_NON_ACTIVE_CHANGELIST || (file = filePath.getVirtualFile()) == null) continue;
            FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file);
            if (!conflictRemoved) continue;
            EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
        }
    }

    public void startTracking() {
        this.myProject.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(), (Disposable)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(Element to) {
        Map<String, Conflict> map = this.myConflicts;
        synchronized (map) {
            this.myConflicts.forEach((path, conflict) -> {
                if (conflict.ignored) {
                    Element fileElement = new Element("file");
                    fileElement.setAttribute("path", path);
                    fileElement.setAttribute("ignored", Boolean.toString(conflict.ignored));
                    to.addContent(fileElement);
                }
            });
        }
        XmlSerializer.serializeInto((Object)this.myOptions, (Element)to);
    }

    public void loadState(@NotNull Element from) {
        if (from == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(8);
        }
        this.myConflicts.clear();
        List files = from.getChildren("file");
        for (Element element : files) {
            VirtualFile vf;
            String path = element.getAttributeValue("path");
            if (path == null || (vf = LocalFileSystem.getInstance().findFileByIoFile(new File(path))) == null || this.myChangeListManager.getChangeList(vf) == null) continue;
            Conflict conflict = new Conflict();
            conflict.ignored = Boolean.parseBoolean(element.getAttributeValue("ignored"));
            this.myConflicts.put(path, conflict);
        }
        XmlSerializer.deserializeInto((Object)this.myOptions, (Element)from);
    }

    public void optionsChanged() {
        FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
    }

    public void clearAllIgnored() {
        for (Conflict conflict : this.myConflicts.values()) {
            conflict.ignored = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getIgnoredConflicts() {
        Map<String, Conflict> map = this.myConflicts;
        synchronized (map) {
            return ContainerUtil.mapNotNull(this.myConflicts.entrySet(), entry -> ((Conflict)entry.getValue()).ignored ? (String)entry.getKey() : null);
        }
    }

    public boolean hasConflict(@NotNull VirtualFile file) {
        if (file == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(9);
        }
        if (!this.shouldDetectConflicts()) {
            return false;
        }
        String path = file.getPath();
        Conflict conflict = this.myConflicts.get(path);
        if (conflict == null || conflict.ignored) {
            return false;
        }
        if (!this.shouldDetectConflictsFor(file) || this.isFromActiveChangelist(file)) {
            this.myConflicts.remove(path);
            return false;
        }
        return true;
    }

    public void ignoreConflict(@NotNull VirtualFile file, boolean ignore) {
        String path;
        Conflict conflict;
        if (file == null) {
            ChangelistConflictTracker.$$$reportNull$$$0(10);
        }
        if ((conflict = this.myConflicts.get(path = file.getPath())) == null) {
            conflict = new Conflict();
            this.myConflicts.put(path, conflict);
        }
        conflict.ignored = ignore;
        FileStatusManager.getInstance((Project)this.myProject).fileStatusChanged(file);
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
    }

    public Options getOptions() {
        return this.myOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkOneFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWritingAllowed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldDetectConflictsFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ignoreConflict";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class Options {
        public boolean SHOW_DIALOG = false;
        public boolean HIGHLIGHT_CONFLICTS = true;
        public boolean HIGHLIGHT_NON_ACTIVE_CHANGELIST = false;
        public ChangelistConflictResolution LAST_RESOLUTION = ChangelistConflictResolution.IGNORE;
    }

    public static class Conflict {
        boolean ignored;
    }

    private class MyChangeListListener
    implements ChangeListListener {
        private MyChangeListListener() {
        }

        public void changeListChanged(ChangeList list) {
            if (((LocalChangeList)list).isDefault()) {
                ChangelistConflictTracker.this.clearChanges(list.getChanges());
            }
        }

        public void changesMoved(Collection<? extends Change> changes, ChangeList fromList, ChangeList toList) {
            if (((LocalChangeList)toList).isDefault() || ((LocalChangeList)fromList).isDefault()) {
                ChangelistConflictTracker.this.clearChanges(changes);
            }
        }

        public void changesRemoved(Collection<? extends Change> changes, ChangeList fromList) {
            ChangelistConflictTracker.this.clearChanges(changes);
        }

        public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
            ChangelistConflictTracker.this.clearChanges(newDefaultList.getChanges());
        }

        public void changeListAvailabilityChanged() {
            ChangelistConflictTracker.this.optionsChanged();
        }
    }

    private class MyDocumentListener
    implements BulkAwareDocumentListener.Simple {
        private MyDocumentListener() {
        }

        public void afterDocumentChange(@NotNull Document document) {
            if (document == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (ChangelistConflictTracker.this.myShouldIgnoreModifications.get() || !ChangelistConflictTracker.this.shouldDetectConflicts()) {
                return;
            }
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            if (file == null || !file.isInLocalFileSystem() || ChangesUtil.isInternalOperation((VirtualFile)file)) {
                return;
            }
            ChangelistConflictTracker.this.myCheckSet.add(file);
            ChangelistConflictTracker.this.myZipperUpdater.queue(() -> ChangelistConflictTracker.this.checkFiles());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictTracker$MyDocumentListener", "afterDocumentChange"));
        }
    }
}

