/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JProgressBar;
import org.assertj.core.description.Description;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JProgressBarIndeterminateQuery;
import org.assertj.swing.edt.GuiLazyLoadingDescription;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.timing.Timeout;

final class JProgressBarWaitUntilIsDeterminate {
    @RunsInEDT
    static void waitUntilValueIsDeterminate(final @Nonnull JProgressBar progressBar, @Nonnull Timeout timeout) {
        Pause.pause(new Condition(JProgressBarWaitUntilIsDeterminate.untilIsDeterminate(progressBar)){

            @Override
            public boolean test() {
                return !JProgressBarIndeterminateQuery.isIndeterminate(progressBar);
            }
        }, timeout);
    }

    private static Description untilIsDeterminate(final @Nonnull JProgressBar progressBar) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return Formatting.format(progressBar) + " to be in determinate mode";
            }
        };
    }

    private JProgressBarWaitUntilIsDeterminate() {
    }
}

