'''OpenGL extension EXT.shader_pixel_local_storage2

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.shader_pixel_local_storage2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds on EXT_shader_pixel_local_storage by lifting the
	restriction that pixel local storage is not supported when rendering to
	multiple draw buffers.
	
	Moreover, pixel local storage values are no longer lost when writing to
	user-defined fragment outputs, and, correspondingly, framebuffer pixel
	values do not always become undefined when the shader writes to pixel local
	storage.
	
	This extension adds the following capabilities:
	- support for pixel local storage in combination with multiple user-
	  defined fragment outputs
	- support for clearing pixel local storage variables
	- support for multi-word pixel local storage variables

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/shader_pixel_local_storage2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.shader_pixel_local_storage2 import *
from OpenGL.raw.GLES2.EXT.shader_pixel_local_storage2 import _EXTENSION_NAME

def glInitShaderPixelLocalStorage2EXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glClearPixelLocalStorageuiEXT.values size not checked against n
glClearPixelLocalStorageuiEXT=wrapper.wrapper(glClearPixelLocalStorageuiEXT).setInputArraySize(
    'values', None
)
### END AUTOGENERATED SECTION