'''OpenGL extension VERSION.GL_3_2

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_3_2 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_3_2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.VERSION.GL_3_2 import *
from OpenGL.raw.GL.VERSION.GL_3_2 import _EXTENSION_NAME

def glInitGl32VERSION():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glDrawElementsBaseVertex.indices size not checked against 'count,type'
glDrawElementsBaseVertex=wrapper.wrapper(glDrawElementsBaseVertex).setInputArraySize(
    'indices', None
)
# INPUT glDrawRangeElementsBaseVertex.indices size not checked against 'count,type'
glDrawRangeElementsBaseVertex=wrapper.wrapper(glDrawRangeElementsBaseVertex).setInputArraySize(
    'indices', None
)
# INPUT glDrawElementsInstancedBaseVertex.indices size not checked against 'count,type'
glDrawElementsInstancedBaseVertex=wrapper.wrapper(glDrawElementsInstancedBaseVertex).setInputArraySize(
    'indices', None
)
# INPUT glMultiDrawElementsBaseVertex.basevertex size not checked against drawcount
# INPUT glMultiDrawElementsBaseVertex.count size not checked against drawcount
# INPUT glMultiDrawElementsBaseVertex.indices size not checked against drawcount
glMultiDrawElementsBaseVertex=wrapper.wrapper(glMultiDrawElementsBaseVertex).setInputArraySize(
    'basevertex', None
).setInputArraySize(
    'count', None
).setInputArraySize(
    'indices', None
)
glGetInteger64v=wrapper.wrapper(glGetInteger64v).setOutput(
    'data',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetSynciv=wrapper.wrapper(glGetSynciv).setOutput(
    'length',size=(1,),orPassIn=True
).setOutput(
    'values',size=lambda x:(x,),pnameArg='count',orPassIn=True
)
glGetInteger64i_v=wrapper.wrapper(glGetInteger64i_v).setOutput(
    'data',size=_glgets._glget_size_mapping,pnameArg='target',orPassIn=True
)
glGetBufferParameteri64v=wrapper.wrapper(glGetBufferParameteri64v).setOutput(
    'params',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
glGetMultisamplefv=wrapper.wrapper(glGetMultisamplefv).setOutput(
    'val',size=_glgets._glget_size_mapping,pnameArg='pname',orPassIn=True
)
### END AUTOGENERATED SECTION
