/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class Statistics {
    public static @Nullable BigDecimal median(List<BigDecimal> inputList) {
        ArrayList<BigDecimal> bdList = new ArrayList<BigDecimal>(inputList);
        int size = bdList.size();
        if (size >= 0) {
            int k = size / 2;
            BigDecimal median = null;
            if (size % 2 == 1) {
                median = Statistics.quickSelect(bdList, 0, size - 1, k, false);
            } else {
                median = Statistics.quickSelect(bdList, 0, size - 1, k, true);
                if (median != null) {
                    median = median.add(bdList.get(k - 1)).divide(BigDecimal.valueOf(2L));
                }
            }
            return median;
        }
        return null;
    }

    static @Nullable BigDecimal quickSelect(ArrayList<BigDecimal> bdList, int l, int r, int k, boolean forcePreviousOrder) {
        if (r < 0) {
            return null;
        }
        if (r == 0) {
            return bdList.get(r);
        }
        int left = l;
        int right = r;
        while (true) {
            int pivotIndex = left;
            if (k == (pivotIndex = Statistics.partition(bdList, left, right, pivotIndex, forcePreviousOrder))) {
                return bdList.get(k);
            }
            if (k < pivotIndex) {
                right = pivotIndex - 1;
                continue;
            }
            left = pivotIndex + 1;
        }
    }

    private static int partition(ArrayList<BigDecimal> bdList, int left, int right, int pivotIndex, boolean forcePreviousOrder) {
        BigDecimal pivotValue = bdList.get(pivotIndex);
        Statistics.swap(bdList, pivotIndex, right);
        int beforePivotIndex = left;
        int storeIndex = left;
        int i = left;
        while (i < right) {
            if (bdList.get(i).compareTo(pivotValue) < 0) {
                if (forcePreviousOrder && bdList.get(i).compareTo(bdList.get(beforePivotIndex)) > 0) {
                    beforePivotIndex = storeIndex;
                }
                Statistics.swap(bdList, storeIndex, i);
                ++storeIndex;
            }
            ++i;
        }
        Statistics.swap(bdList, right, storeIndex);
        if (forcePreviousOrder && storeIndex > beforePivotIndex) {
            Statistics.swap(bdList, beforePivotIndex, storeIndex - 1);
        }
        return storeIndex;
    }

    private static void swap(ArrayList<BigDecimal> bdList, int i, int j) {
        if (i != j) {
            BigDecimal tmp = bdList.get(i);
            bdList.set(i, bdList.get(j));
            bdList.set(j, tmp);
        }
    }
}

