/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.UpdateSwiftPasswordDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSwiftPasswordRequest
extends BmcRequest<UpdateSwiftPasswordDetails> {
    private String userId;
    private String swiftPasswordId;
    private UpdateSwiftPasswordDetails updateSwiftPasswordDetails;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getSwiftPasswordId() {
        return this.swiftPasswordId;
    }

    public UpdateSwiftPasswordDetails getUpdateSwiftPasswordDetails() {
        return this.updateSwiftPasswordDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateSwiftPasswordDetails getBody$() {
        return this.updateSwiftPasswordDetails;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).swiftPasswordId(this.swiftPasswordId).updateSwiftPasswordDetails(this.updateSwiftPasswordDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",swiftPasswordId=").append(String.valueOf(this.swiftPasswordId));
        sb.append(",updateSwiftPasswordDetails=").append(String.valueOf((Object)this.updateSwiftPasswordDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSwiftPasswordRequest)) {
            return false;
        }
        UpdateSwiftPasswordRequest other = (UpdateSwiftPasswordRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.swiftPasswordId, other.swiftPasswordId) && Objects.equals((Object)this.updateSwiftPasswordDetails, (Object)other.updateSwiftPasswordDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.swiftPasswordId == null ? 43 : this.swiftPasswordId.hashCode());
        result = result * 59 + (this.updateSwiftPasswordDetails == null ? 43 : this.updateSwiftPasswordDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSwiftPasswordRequest, UpdateSwiftPasswordDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String swiftPasswordId = null;
        private UpdateSwiftPasswordDetails updateSwiftPasswordDetails = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder swiftPasswordId(String swiftPasswordId) {
            this.swiftPasswordId = swiftPasswordId;
            return this;
        }

        public Builder updateSwiftPasswordDetails(UpdateSwiftPasswordDetails updateSwiftPasswordDetails) {
            this.updateSwiftPasswordDetails = updateSwiftPasswordDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSwiftPasswordRequest o) {
            this.userId(o.getUserId());
            this.swiftPasswordId(o.getSwiftPasswordId());
            this.updateSwiftPasswordDetails(o.getUpdateSwiftPasswordDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSwiftPasswordRequest build() {
            UpdateSwiftPasswordRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSwiftPasswordDetails body) {
            this.updateSwiftPasswordDetails(body);
            return this;
        }

        public UpdateSwiftPasswordRequest buildWithoutInvocationCallback() {
            UpdateSwiftPasswordRequest request = new UpdateSwiftPasswordRequest();
            request.userId = this.userId;
            request.swiftPasswordId = this.swiftPasswordId;
            request.updateSwiftPasswordDetails = this.updateSwiftPasswordDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

