/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;

public final class DAPVariable {
    private final DAPDebugger debugger;
    private final DAPFrame frame;
    private final DAPVariable parentVariable;
    private final int variableReference;
    private final String name;
    private final String type;
    private final String value;
    private final int totalChildren;
    private final AtomicReference<DAPVariable[]> children = new AtomicReference();

    DAPVariable(DAPDebugger debugger, DAPFrame frame, DAPVariable parentVariable, int variableReference, String name, String type, String value, int totalChildren) {
        this.debugger = debugger;
        this.frame = frame;
        this.parentVariable = parentVariable;
        this.variableReference = variableReference;
        this.name = name;
        this.type = type;
        this.value = value;
        this.totalChildren = totalChildren;
    }

    public DAPFrame getFrame() {
        return this.frame;
    }

    public DAPVariable getParent() {
        return this.parentVariable;
    }

    public int getVariableReference() {
        return this.variableReference;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int getTotalChildren() {
        return this.totalChildren;
    }

    public DAPVariable[] getChildren(int from, int to) {
        DAPVariable[] vars = this.children.get();
        if (vars == null) {
            try {
                vars = (DAPVariable[])this.debugger.getVariableChildren(this.frame, this).get().toArray(DAPVariable[]::new);
                this.children.set(vars);
            }
            catch (InterruptedException | ExecutionException ex) {
                return new DAPVariable[0];
            }
        }
        if (from >= 0) {
            vars = from < (to = Math.min(to, vars.length)) ? Arrays.copyOfRange(vars, from, to) : new DAPVariable[]{};
        }
        return vars;
    }
}

