/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ServiceLocatorStrategy {
    private static final String CREATE_INVOCATION = ".create()";
    private final String serviceLocator;

    private ServiceLocatorStrategy(String serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    public String genLocalEjbStringLookup(String jndiName, String homeName, FileObject referencingFO, String referencingClass, boolean create) {
        String initString = ServiceLocatorStrategy.initString("getLocalHome", jndiName, referencingFO, referencingClass, this.serviceLocator, "");
        return "return " + this.addCast(create, homeName, initString, CREATE_INVOCATION) + ";";
    }

    public String genRemoteEjbStringLookup(String jndiName, String homeCls, FileObject fileObject, String className, boolean create) {
        String initString = ServiceLocatorStrategy.initString("getRemoteHome", jndiName, fileObject, className, this.serviceLocator, "," + homeCls + ".class");
        return "return " + this.addCast(create, homeCls, initString, CREATE_INVOCATION) + ";";
    }

    public String genDestinationLookup(String jndiName, FileObject fileObject, String className) {
        return ServiceLocatorStrategy.initString("getDestination", jndiName, fileObject, className, this.serviceLocator, "");
    }

    public String genJMSFactory(String jndiName, FileObject fileObject, String className) {
        return ServiceLocatorStrategy.initString("getConnectionFactory", jndiName, fileObject, className, this.serviceLocator, "");
    }

    public String genDataSource(String jndiName, FileObject fileObject, String className) {
        return ServiceLocatorStrategy.initString("getDataSource", jndiName, fileObject, className, this.serviceLocator, "");
    }

    public String genMailSession(String jndiName, FileObject fileObject, String className) {
        return ServiceLocatorStrategy.initString("getSession", jndiName, fileObject, className, this.serviceLocator, "");
    }

    public static ServiceLocatorStrategy create(Project project, FileObject srcFile, String serviceLocator) {
        return new ServiceLocatorStrategy(serviceLocator);
    }

    private ClassPath buildClassPathFromImportedProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        assert (project != null) : "cannot find project for file";
        ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        assert (cpp != null) : "project doesn't have class path provider";
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        ClassPath classPath = ClassPathSupport.createClassPath(Collections.emptyList());
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (root.getChildren().length <= 0) continue;
            ClassPath tcp = cpp.findClassPath(root.getChildren()[0], "classpath/source");
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{tcp, classPath});
        }
        return classPath;
    }

    private String addCast(boolean cast, String clName, String current, String inv) {
        String newValue = current;
        newValue = "(" + clName + ") " + current;
        if (cast) {
            newValue = "(" + newValue + ")" + inv;
        }
        return newValue;
    }

    private static String initString(String methodName, String jndiName, FileObject referencingFO, String referencingClass, String serviceLocator, String otherParams) {
        String initString = null;
        try {
            String staticCreation = ServiceLocatorStrategy.getStaticLocator(referencingFO, serviceLocator);
            initString = staticCreation != null ? serviceLocator + "." + staticCreation + "()." + methodName + "(\"java:comp/env/" + jndiName + "\"" + otherParams + ")" : ServiceLocatorStrategy.findOrCreateArtifacts(referencingFO, referencingClass, serviceLocator) + "()." + methodName + "(\"java:comp/env/" + jndiName + "\"" + otherParams + ")";
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return initString;
    }

    private static String findOrCreateArtifacts(FileObject fileObject, final String className, final String serviceLocator) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] methodName = new String[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement target = workingCopy.getElements().getTypeElement(className);
                for (ExecutableElement executableElement : ElementFilter.methodsIn(target.getEnclosedElements())) {
                    if (executableElement.getParameters().size() != 0 || !workingCopy.getTypes().isSameType(target.asType(), executableElement.getReturnType())) continue;
                    methodName[0] = executableElement.getSimpleName().toString();
                    break;
                }
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement fieldTypeElement = workingCopy.getElements().getTypeElement(serviceLocator);
                if (methodName[0] == null) {
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)"serviceLocator", (Tree)treeMaker.QualIdent((Element)fieldTypeElement), null);
                    ClassTree classTree = workingCopy.getTrees().getTree(target);
                    ClassTree newClassTree = treeMaker.insertClassMember(classTree, 0, (Tree)variableTree);
                    MethodModel methodModel = MethodModel.create((String)"getServiceLocator", (String)serviceLocator, (String)("if (serviceLocator == null) {\nserviceLocator = new " + serviceLocator + "();\n}\nreturn serviceLocator;\n"), Collections.emptyList(), Collections.emptyList(), Collections.singleton(Modifier.PRIVATE));
                    MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                    classTree = workingCopy.getTrees().getTree(target);
                    newClassTree = treeMaker.addClassMember(newClassTree, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
                    methodName[0] = "getServiceLocator";
                }
            }
        }).commit();
        return methodName[0];
    }

    private static String getStaticLocator(FileObject referencingFO, final String serviceLocator) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)referencingFO);
        final String[] methodName = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(serviceLocator);
                if (typeElement != null) {
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        Set<Modifier> modifiers = executableElement.getModifiers();
                        if (!modifiers.contains((Object)Modifier.STATIC) || !modifiers.contains((Object)Modifier.PUBLIC) || !controller.getTypes().isSameType(typeElement.asType(), executableElement.getReturnType())) continue;
                        methodName[0] = executableElement.getSimpleName().toString();
                    }
                }
            }
        }, true);
        return methodName[0];
    }
}

