/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.metergauge;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.metergauge.MeterGaugeChart;
import org.primefaces.model.chart.MeterGaugeChartModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterGaugeChartRenderer
extends BaseChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MeterGaugeChart chart = (MeterGaugeChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, UIChart uichart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChart chart = (MeterGaugeChart)uichart;
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("PrimeFaces.cw('MeterGaugeChart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        this.encodeData(context, chart);
        this.encodeOptions(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("},'charts');});");
        this.endScript(writer);
    }

    protected void encodeData(FacesContext context, MeterGaugeChart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChartModel model = chart.getValue();
        writer.write(",data:[[" + model.getValue() + "]]");
    }

    protected void encodeOptions(FacesContext context, MeterGaugeChart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        MeterGaugeChartModel model = chart.getValue();
        String label = chart.getLabel();
        this.encodeNumberList(context, "intervals", model.getIntervals());
        this.encodeNumberList(context, "ticks", model.getTicks());
        if (label != null) {
            writer.write(",label:'" + label + "'");
        }
        writer.write(",showTickLabels:" + chart.isShowTickLabels());
        writer.write(",labelHeightAdjust:" + chart.getLabelHeightAdjust());
        writer.write(",intervalOuterRadius:" + chart.getIntervalOuterRadius());
        if (chart.getMin() != Double.MIN_VALUE) {
            writer.write(",min:" + chart.getMin());
        }
        if (chart.getMax() != Double.MAX_VALUE) {
            writer.write(",max:" + chart.getMax());
        }
    }

    protected void encodeNumberList(FacesContext context, String name, List<Number> values) throws IOException {
        if (values != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.write("," + name + ":[");
            Iterator<Number> it = values.iterator();
            while (it.hasNext()) {
                Number number = it.next();
                writer.write(number.toString());
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
    }
}

