/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesContentHandler;
import org.eclipse.mylyn.internal.tasks.core.SaxRepositoriesWriter;
import org.eclipse.mylyn.internal.tasks.core.XmlReaderUtil;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TaskRepositoriesExternalizer {
    private final SaxRepositoriesWriter writer = new SaxRepositoriesWriter();
    public static final String ELEMENT_TASK_REPOSITORIES = "TaskRepositories";
    public static final String ELEMENT_TASK_REPOSITORY = "TaskRepository";
    public static final String ATTRIBUTE_VERSION = "OutputVersion";

    public void writeRepositoriesToXML(Collection<TaskRepository> repositories, File file) {
        block13: {
            ZipOutputStream outputStream = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    outputStream = new ZipOutputStream(new FileOutputStream(file));
                    this.writeRepositories(repositories, outputStream);
                    outputStream.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not write: " + file.getAbsolutePath(), (Throwable)e));
                    if (outputStream == null) break block13;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not close: " + file.getAbsolutePath(), (Throwable)e2));
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not close: " + file.getAbsolutePath(), (Throwable)e));
                    }
                }
            }
        }
    }

    public void writeRepositories(Collection<TaskRepository> repositories, ZipOutputStream outputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("repositories.xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        this.writer.setOutputStream(outputStream);
        this.writer.writeRepositoriesToStream(repositories);
        outputStream.flush();
        outputStream.closeEntry();
    }

    public Set<TaskRepository> readRepositoriesFromXML(File file) {
        if (!file.exists()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = ((ZipInputStream)inputStream).getNextEntry();
            while (entry != null) {
                if ("repositories.xml".equals(entry.getName())) break;
                entry = ((ZipInputStream)inputStream).getNextEntry();
            }
            if (entry == null) {
                return null;
            }
            SaxRepositoriesContentHandler contentHandler = new SaxRepositoriesContentHandler();
            XMLReader reader = XmlReaderUtil.createXmlReader();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(inputStream));
            Set<TaskRepository> set = contentHandler.getRepositories();
            return set;
        }
        catch (Throwable e) {
            file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + "-save"));
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error reading task repositories", e));
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Error closing task repositories file", (Throwable)e));
                }
            }
        }
    }
}

