/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUstreamAttrValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESSPOLICYWINDOW;
    public static final int SYNCPOLICY;

    public CUstreamAttrValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUstreamAttrValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUstreamAttrValue.naccessPolicyWindow(this.address());
    }

    @NativeType(value="CUsynchronizationPolicy")
    public int syncPolicy() {
        return CUstreamAttrValue.nsyncPolicy(this.address());
    }

    public CUstreamAttrValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUstreamAttrValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUstreamAttrValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUstreamAttrValue syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
        CUstreamAttrValue.nsyncPolicy(this.address(), value);
        return this;
    }

    public CUstreamAttrValue set(CUstreamAttrValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUstreamAttrValue malloc() {
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUstreamAttrValue calloc() {
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUstreamAttrValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUstreamAttrValue create(long address) {
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)address);
    }

    @Nullable
    public static CUstreamAttrValue createSafe(long address) {
        return address == 0L ? null : (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUstreamAttrValue.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUstreamAttrValue.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUstreamAttrValue malloc(MemoryStack stack) {
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUstreamAttrValue calloc(MemoryStack stack) {
        return (CUstreamAttrValue)CUstreamAttrValue.wrap(CUstreamAttrValue.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUstreamAttrValue.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int nsyncPolicy(long struct) {
        return UNSAFE.getInt(null, struct + (long)SYNCPOLICY);
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)ACCESSPOLICYWINDOW), (long)CUaccessPolicyWindow.SIZEOF);
    }

    public static void nsyncPolicy(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SYNCPOLICY, value);
    }

    static {
        Struct.Layout layout = CUstreamAttrValue.__union((Struct.Member[])new Struct.Member[]{CUstreamAttrValue.__member((int)CUaccessPolicyWindow.SIZEOF, (int)CUaccessPolicyWindow.ALIGNOF), CUstreamAttrValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESSPOLICYWINDOW = layout.offsetof(0);
        SYNCPOLICY = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUstreamAttrValue, Buffer>
    implements NativeResource {
        private static final CUstreamAttrValue ELEMENT_FACTORY = CUstreamAttrValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUstreamAttrValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUstreamAttrValue.naccessPolicyWindow(this.address());
        }

        @NativeType(value="CUsynchronizationPolicy")
        public int syncPolicy() {
            return CUstreamAttrValue.nsyncPolicy(this.address());
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUstreamAttrValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer syncPolicy(@NativeType(value="CUsynchronizationPolicy") int value) {
            CUstreamAttrValue.nsyncPolicy(this.address(), value);
            return this;
        }
    }
}

