/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect;

import java.io.Serializable;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.dissect.Converter;
import org.logstash.dissect.Converters;

final class ConvertPair
implements Serializable {
    private static final long serialVersionUID = 7227865769253897223L;
    static final ConvertPair[] EMPTY_ARRAY = new ConvertPair[0];
    private final String source;
    private final String _type;
    private final Converter convertion;

    static ConvertPair[] createArrayFromHash(RubyHash hash) {
        if (hash.isNil()) {
            return EMPTY_ARRAY;
        }
        IRubyObject[] convertPairs = hash.to_a().toJavaArray();
        ConvertPair[] pairs = new ConvertPair[convertPairs.length];
        for (int idx = 0; idx < convertPairs.length; ++idx) {
            pairs[idx] = ConvertPair.create((RubyArray)convertPairs[idx]);
        }
        return pairs;
    }

    private static ConvertPair create(RubyArray pair) {
        return new ConvertPair(pair.first().toString(), pair.last().toString());
    }

    private ConvertPair(String left, String right) {
        this.source = left;
        this._type = right;
        this.convertion = Converters.select(this._type);
    }

    String src() {
        return this.source;
    }

    String type() {
        return this._type;
    }

    Converter converter() {
        return this.convertion;
    }
}

