/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;
import org.apache.derby.vti.VTITemplate;

public abstract class StringColumnVTI
extends VTITemplate {
    private String[] _columnNames;
    private boolean _lastColumnWasNull;

    protected abstract String getRawColumn(int var1) throws SQLException;

    public StringColumnVTI(String[] columnNames) {
        if (columnNames != null) {
            this._columnNames = (String[])ArrayUtil.copy((Object[])columnNames);
        }
    }

    public void setColumnNames(String[] columnNames) throws SQLException {
        if (this._columnNames != null) {
            throw this.makeSQLException("X0Y92.S", new Object[0]);
        }
        this._columnNames = (String[])ArrayUtil.copy((Object[])columnNames);
    }

    public int getColumnCount() {
        return this._columnNames.length;
    }

    public String getColumnName(int columnNumber) {
        return this._columnNames[columnNumber - 1];
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._lastColumnWasNull;
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        int count = this._columnNames.length;
        for (int i = 0; i < count; ++i) {
            if (!this._columnNames[i].equals(columnName)) continue;
            return i + 1;
        }
        throw new SQLException("Unknown column name.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String columnValue = this.getRawColumn(columnIndex);
        this.checkNull(columnValue);
        return columnValue;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return false;
        }
        return Boolean.valueOf(columnValue);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Byte.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Short.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0;
        }
        try {
            return Integer.parseInt(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0L;
        }
        try {
            return Long.valueOf(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        try {
            return new BigDecimal(columnValue);
        }
        catch (NumberFormatException e) {
            throw this.wrap(e);
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        try {
            return columnValue.getBytes("UTF-8");
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage());
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Date(this.parseDateTime(columnValue));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Time(this.parseDateTime(columnValue));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new Timestamp(this.parseDateTime(columnValue));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        return this.getEncodedStream(columnValue, "US-ASCII");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getBytes(columnIndex));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new HarmonySerialBlob(this.getBytes(columnIndex));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        String columnValue = this.getString(columnIndex);
        if (columnValue == null) {
            return null;
        }
        return new HarmonySerialClob(this.getString(columnIndex));
    }

    private void checkNull(String columnValue) {
        this._lastColumnWasNull = columnValue == null;
    }

    private SQLException wrap(Throwable t) {
        return new SQLException(t.getMessage());
    }

    private long parseDateTime(String columnValue) throws SQLException {
        try {
            DateFormat df = DateFormat.getDateTimeInstance();
            java.util.Date rawDate = df.parse(columnValue);
            return rawDate.getTime();
        }
        catch (ParseException e) {
            throw this.wrap(e);
        }
    }

    private InputStream getEncodedStream(String columnValue, String encoding) throws SQLException {
        if (columnValue == null) {
            return null;
        }
        try {
            byte[] rawBytes = columnValue.getBytes(encoding);
            return new ByteArrayInputStream(rawBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw this.wrap(e);
        }
    }

    private SQLException makeSQLException(String sqlstate, Object ... args) {
        StandardException se = StandardException.newException((String)sqlstate, (Object[])args);
        return new SQLException(se.getMessage(), se.getSQLState());
    }
}

