/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.List;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class GenericAuthorizer
implements Authorizer {
    private static final int NO_ACCESS = 0;
    private static final int READ_ACCESS = 1;
    private static final int FULL_ACCESS = 2;
    private int userAccessLevel;
    boolean readOnlyConnection;
    private final LanguageConnectionContext lcc;

    GenericAuthorizer(LanguageConnectionContext lcc) throws StandardException {
        this.lcc = lcc;
        this.refresh();
    }

    private boolean connectionMustRemainReadOnly() {
        return this.lcc.getDatabase().isReadOnly() || this.userAccessLevel == 1;
    }

    @Override
    public void authorize(int operation) throws StandardException {
        this.authorize((Activation)null, operation);
    }

    @Override
    public void authorize(Activation activation, int operation) throws StandardException {
        short sqlAllowed = this.lcc.getStatementContext().getSQLAllowed();
        switch (operation) {
            case 2: 
            case 3: {
                if (sqlAllowed != 3) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 1: {
                if (sqlAllowed <= 1) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 0: 
            case 5: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException((String)"25502", (Object[])new Object[0]);
                }
                if (sqlAllowed <= 0) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            case 4: 
            case 6: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException((String)"25503", (Object[])new Object[0]);
                }
                if (sqlAllowed <= 0) break;
                throw GenericAuthorizer.externalRoutineException(operation, sqlAllowed);
            }
            default: {
                SanityManager.THROWASSERT((String)("Bad operation code " + operation));
            }
        }
        if (activation != null) {
            List<StatementPermission> requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList();
            this.authorize(requiredPermissionsList, activation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void authorize(List<StatementPermission> requiredPermissionsList, Activation activation) throws StandardException {
        DataDictionary dd = this.lcc.getDataDictionary();
        if (requiredPermissionsList != null && !requiredPermissionsList.isEmpty() && !this.lcc.getCurrentUserId(activation).equals(dd.getAuthorizationDatabaseOwner())) {
            int ddMode = dd.startReading(this.lcc);
            this.lcc.beginNestedTransaction(true);
            try {
                try {
                    for (StatementPermission rp : requiredPermissionsList) {
                        rp.check(this.lcc, false, activation);
                    }
                }
                finally {
                    dd.doneReading(ddMode, this.lcc);
                }
            }
            finally {
                this.lcc.commitNestedTransaction();
            }
        }
    }

    private static StandardException externalRoutineException(int operation, int sqlAllowed) {
        String sqlState;
        if (sqlAllowed == 1) {
            sqlState = "38002";
        } else if (sqlAllowed == 2) {
            switch (operation) {
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    sqlState = "38002";
                    break;
                }
                default: {
                    sqlState = "38004";
                    break;
                }
            }
        } else {
            sqlState = "38001";
        }
        return StandardException.newException((String)sqlState, (Object[])new Object[0]);
    }

    private void getUserAccessLevel() throws StandardException {
        this.userAccessLevel = 0;
        if (this.userOnAccessList("derby.database.fullAccessUsers")) {
            this.userAccessLevel = 2;
        }
        if (this.userAccessLevel == 0 && this.userOnAccessList("derby.database.readOnlyAccessUsers")) {
            this.userAccessLevel = 1;
        }
        if (this.userAccessLevel == 0) {
            this.userAccessLevel = this.getDefaultAccessLevel();
        }
    }

    private int getDefaultAccessLevel() throws StandardException {
        TransactionController tc = this.lcc.getTransactionExecute();
        String modeS = PropertyUtil.getServiceProperty(tc, "derby.database.defaultConnectionMode");
        if (modeS == null) {
            return 2;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "NOACCESS")) {
            return 0;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "READONLYACCESS")) {
            return 1;
        }
        if (StringUtil.SQLEqualsIgnoreCase(modeS, "FULLACCESS")) {
            return 2;
        }
        SanityManager.THROWASSERT((String)("Invalid value for property derby.database.defaultConnectionMode " + modeS));
        return 2;
    }

    private boolean userOnAccessList(String listName) throws StandardException {
        TransactionController tc = this.lcc.getTransactionExecute();
        String listS = PropertyUtil.getServiceProperty(tc, listName);
        return IdUtil.idOnList(this.lcc.getSessionUserId(), listS);
    }

    @Override
    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    @Override
    public void setReadOnlyConnection(boolean on, boolean authorize) throws StandardException {
        if (authorize && !on && this.connectionMustRemainReadOnly()) {
            throw StandardException.newException((String)"25505", (Object[])new Object[0]);
        }
        this.readOnlyConnection = on;
    }

    @Override
    public final void refresh() throws StandardException {
        this.getUserAccessLevel();
        if (!this.readOnlyConnection) {
            this.readOnlyConnection = this.connectionMustRemainReadOnly();
        }
        if (this.userAccessLevel == 0) {
            throw StandardException.newException((String)"08004.C.3", (Object[])new Object[0]);
        }
    }
}

