/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.Generator;
import json.ext.RuntimeInfo;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

class GeneratorMethods {
    GeneratorMethods() {
    }

    static void populate(RuntimeInfo runtimeInfo, RubyModule rubyModule) {
        GeneratorMethods.defineMethods(rubyModule, "Array", RbArray.class);
        GeneratorMethods.defineMethods(rubyModule, "FalseClass", RbFalse.class);
        GeneratorMethods.defineMethods(rubyModule, "Float", RbFloat.class);
        GeneratorMethods.defineMethods(rubyModule, "Hash", RbHash.class);
        GeneratorMethods.defineMethods(rubyModule, "Integer", RbInteger.class);
        GeneratorMethods.defineMethods(rubyModule, "NilClass", RbNil.class);
        GeneratorMethods.defineMethods(rubyModule, "Object", RbObject.class);
        GeneratorMethods.defineMethods(rubyModule, "String", RbString.class);
        GeneratorMethods.defineMethods(rubyModule, "TrueClass", RbTrue.class);
    }

    private static void defineMethods(RubyModule rubyModule, String string, Class<?> clazz) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder(string);
        rubyModule2.defineAnnotatedMethods(clazz);
    }

    public static class RbObject {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RbString.to_json(threadContext, (IRubyObject)iRubyObject.asString());
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RbString.to_json(threadContext, (IRubyObject)iRubyObject.asString(), iRubyObject2);
        }
    }

    public static class RbNil {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, iRubyObject, Generator.NIL_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, iRubyObject, Generator.NIL_HANDLER, iRubyObject2);
        }
    }

    public static class RbFalse {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.FALSE_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.FALSE_HANDLER, iRubyObject2);
        }
    }

    public static class RbTrue {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.TRUE_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.TRUE_HANDLER, iRubyObject2);
        }
    }

    public static class RbString {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyString)iRubyObject, Generator.STRING_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyString)iRubyObject, Generator.STRING_HANDLER, iRubyObject2);
        }
    }

    public static class RbFloat {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyFloat)iRubyObject, Generator.FLOAT_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyFloat)iRubyObject, Generator.FLOAT_HANDLER, iRubyObject2);
        }
    }

    public static class RbInteger {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, iRubyObject);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class RbArray {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyArray)iRubyObject, Generator.ARRAY_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyArray)iRubyObject, Generator.ARRAY_HANDLER, iRubyObject2);
        }
    }

    public static class RbHash {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyHash)iRubyObject, Generator.HASH_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyHash)iRubyObject, Generator.HASH_HANDLER, iRubyObject2);
        }
    }
}

