/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum ClientTelemetryState {
    SUBSCRIPTION_NEEDED,
    SUBSCRIPTION_IN_PROGRESS,
    PUSH_NEEDED,
    PUSH_IN_PROGRESS,
    TERMINATING_PUSH_NEEDED,
    TERMINATING_PUSH_IN_PROGRESS,
    TERMINATED;

    private static final Map<ClientTelemetryState, List<ClientTelemetryState>> VALID_NEXT_STATES;

    public ClientTelemetryState validateTransition(ClientTelemetryState newState) {
        List<ClientTelemetryState> allowableStates = VALID_NEXT_STATES.get((Object)this);
        if (allowableStates != null && allowableStates.contains((Object)newState)) {
            return newState;
        }
        String validStatesClause = allowableStates != null && !allowableStates.isEmpty() ? String.format("the valid telemetry state transitions from %s are: %s", new Object[]{this, allowableStates.stream().map(Enum::toString).collect(Collectors.joining(", "))}) : String.format("there are no valid telemetry state transitions from %s", new Object[]{this});
        String message = String.format("Invalid telemetry state transition from %s to %s; %s", new Object[]{this, newState, validStatesClause});
        throw new IllegalStateException(message);
    }

    static {
        VALID_NEXT_STATES = new EnumMap<ClientTelemetryState, List<ClientTelemetryState>>(ClientTelemetryState.class);
        VALID_NEXT_STATES.put(SUBSCRIPTION_NEEDED, Arrays.asList(SUBSCRIPTION_IN_PROGRESS, TERMINATED));
        VALID_NEXT_STATES.put(SUBSCRIPTION_IN_PROGRESS, Arrays.asList(PUSH_NEEDED, SUBSCRIPTION_NEEDED, TERMINATING_PUSH_NEEDED, TERMINATED));
        VALID_NEXT_STATES.put(PUSH_NEEDED, Arrays.asList(PUSH_IN_PROGRESS, SUBSCRIPTION_NEEDED, TERMINATING_PUSH_NEEDED, TERMINATED));
        VALID_NEXT_STATES.put(PUSH_IN_PROGRESS, Arrays.asList(PUSH_NEEDED, SUBSCRIPTION_NEEDED, TERMINATING_PUSH_NEEDED, TERMINATED));
        VALID_NEXT_STATES.put(TERMINATING_PUSH_NEEDED, Arrays.asList(TERMINATING_PUSH_IN_PROGRESS, TERMINATED));
        VALID_NEXT_STATES.put(TERMINATING_PUSH_IN_PROGRESS, Collections.singletonList(TERMINATED));
        VALID_NEXT_STATES.put(TERMINATED, Collections.emptyList());
    }
}

