/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.marshal.UnmarshalCache;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;

public class UnmarshalStream
extends InputStream {
    protected final Ruby runtime;
    private final UnmarshalCache cache;
    private IRubyObject proc;
    private final InputStream inputStream;
    private final boolean freeze;

    public UnmarshalStream(Ruby runtime2, InputStream in, IRubyObject proc2) throws IOException {
        this(runtime2, in, false, proc2);
    }

    public UnmarshalStream(Ruby runtime2, InputStream in, boolean freeze2, IRubyObject proc2) throws IOException {
        assert (runtime2 != null);
        assert (in != null);
        if (proc2 == null) {
            proc2 = runtime2.getNil();
        }
        this.runtime = runtime2;
        this.cache = new UnmarshalCache(runtime2);
        this.proc = proc2;
        this.inputStream = in;
        this.freeze = freeze2;
        int major = in.read();
        int minor = in.read();
        if (major == -1 || minor == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        if (major != 4 || minor > 8) {
            throw runtime2.newTypeError(String.format("incompatible marshal file format (can't be read)\n\tformat version %d.%d required; %d.%d given", 4, 8, major, minor));
        }
    }

    public IRubyObject unmarshalObject() throws IOException {
        return this.object0(new MarshalState(false), false, null);
    }

    public static RubyModule getModuleFromPath(Ruby runtime2, String path2) {
        RubyModule value2 = runtime2.getClassFromPath(path2, runtime2.getArgumentError(), false);
        if (value2 == null) {
            throw runtime2.newArgumentError("undefined class/module " + path2);
        }
        if (!value2.isModule()) {
            throw runtime2.newArgumentError(path2 + " does not refer module");
        }
        return value2;
    }

    public static RubyClass getClassFromPath(Ruby runtime2, String path2) {
        RubyModule value2 = runtime2.getClassFromPath(path2, runtime2.getArgumentError(), false);
        if (value2 == null) {
            throw runtime2.newArgumentError("undefined class/module " + path2);
        }
        if (!value2.isClass()) {
            throw runtime2.newArgumentError(path2 + " does not refer class");
        }
        return (RubyClass)value2;
    }

    private IRubyObject doCallProcForObj(IRubyObject result2) {
        if (this.proc == null || this.proc.isNil()) {
            return result2;
        }
        return Helpers.invoke(this.getRuntime().getCurrentContext(), this.proc, "call", result2);
    }

    private int r_byte() throws IOException {
        return this.readUnsignedByte();
    }

    public void ivar(MarshalState state2, IRubyObject object, boolean[] hasEncoding) throws IOException {
        int count2 = this.unmarshalInt();
        RubyClass clazz = object.getMetaClass().getRealClass();
        for (int i2 = 0; i2 < count2; ++i2) {
            RubySymbol key2 = this.symbol();
            String id2 = key2.idString();
            IRubyObject value2 = this.object0(state2, false, null);
            Encoding encoding2 = this.symbolToEncoding(key2, value2);
            if (encoding2 != null) {
                if (!(object instanceof EncodingCapable)) {
                    throw this.runtime.newArgumentError(RubyStringBuilder.str(this.runtime, object, "is not enc_capable"));
                }
                ((EncodingCapable)((Object)object)).setEncoding(encoding2);
                if (hasEncoding == null) continue;
                hasEncoding[0] = true;
                continue;
            }
            if (id2.equals("K")) {
                if (object instanceof RubyHash) {
                    ((RubyHash)object).setRuby2KeywordHash(true);
                    continue;
                }
                throw this.runtime.newArgumentError(RubyStringBuilder.str(this.runtime, "ruby2_keywords flag is given but ", object, " is not a Hash"));
            }
            clazz.getVariableAccessorForWrite(key2.idString()).set(object, value2);
        }
    }

    public IRubyObject entry(IRubyObject value2) {
        this.cache.registerDataLink(value2);
        this.cache.markAsPartialObject(value2);
        return value2;
    }

    private IRubyObject leave(IRubyObject value2, boolean partial) {
        if (!partial) {
            this.cache.noLongerPartial(value2);
            if (this.freeze) {
                RubyClass metaClass = value2.getMetaClass();
                if (metaClass == this.runtime.getString()) {
                    IRubyObject original = value2;
                    if ((value2 = this.runtime.freezeAndDedupString((RubyString)value2)) != original) {
                        original.setFrozen(value2.isFrozen());
                    }
                } else if (!value2.isModule() && !value2.isClass()) {
                    value2.setFrozen(true);
                }
            }
            value2 = this.postProc(value2);
        }
        return value2;
    }

    private RubyModule mustBeModule(Ruby runtime2, IRubyObject value2, IRubyObject path2) {
        if (!value2.isModule()) {
            throw runtime2.newArgumentError(RubyStringBuilder.str(runtime2, path2, " does not refer to module"));
        }
        return (RubyModule)value2;
    }

    private IRubyObject object0(MarshalState state2, boolean partial, List<RubyModule> extendedModules) throws IOException {
        return this.objectFor(this.r_byte(), state2, partial, extendedModules);
    }

    private IRubyObject objectFor(int type2, MarshalState state2, boolean partial, List<RubyModule> extendedModules) throws IOException {
        IRubyObject obj;
        switch (type2) {
            case 64: {
                obj = this.objectForLink();
                break;
            }
            case 73: {
                obj = this.objectForIVar(state2, partial, extendedModules);
                break;
            }
            case 101: {
                obj = this.objectForExtended(extendedModules);
                break;
            }
            case 67: {
                obj = this.objectForUClass(partial, extendedModules);
                break;
            }
            case 48: {
                obj = this.objectForNil();
                break;
            }
            case 84: {
                obj = this.objectForTrue();
                break;
            }
            case 70: {
                obj = this.objectForFalse();
                break;
            }
            case 105: {
                obj = this.objectForFixnum();
                break;
            }
            case 102: {
                obj = this.objectForFloat();
                break;
            }
            case 108: {
                obj = this.objectForBignum();
                break;
            }
            case 34: {
                obj = this.objectForString(partial);
                break;
            }
            case 47: {
                obj = this.objectForRegexp(state2, partial);
                break;
            }
            case 91: {
                obj = this.objectForArray(partial);
                break;
            }
            case 123: {
                obj = this.objectForHash(partial);
                break;
            }
            case 125: {
                obj = this.objectForHashDefault(partial);
                break;
            }
            case 83: {
                obj = this.objectForStruct(partial);
                break;
            }
            case 117: {
                obj = this.objectForUserDef(state2, partial);
                break;
            }
            case 85: {
                obj = this.objectForUsrMarshal(state2, partial, extendedModules);
                break;
            }
            case 111: {
                obj = this.objectForObject(partial);
                break;
            }
            case 100: {
                obj = this.objectForData(state2, partial, extendedModules);
                break;
            }
            case 77: {
                obj = this.objectForModuleOld(state2, partial);
                break;
            }
            case 99: {
                obj = this.objectForClass(partial);
                break;
            }
            case 109: {
                obj = this.objectForModule(partial);
                break;
            }
            case 58: {
                obj = this.objectForSymbol(state2, partial);
                break;
            }
            case 59: {
                obj = this.objectForSymlink();
                break;
            }
            default: {
                throw this.getRuntime().newArgumentError("dump format error(" + (char)type2 + ")");
            }
        }
        return obj;
    }

    private IRubyObject objectForModuleOld(MarshalState state2, boolean partial) throws IOException {
        String name2 = RubyString.byteListToString(this.unmarshalString());
        RubyModule mod = UnmarshalStream.getModuleFromPath(this.getRuntime(), name2);
        this.prohibitIVar(state2, "class/module", name2);
        return this.leave(this.entry(mod), partial);
    }

    public void prohibitIVar(MarshalState state2, String label2, String name2) {
        if (state2 != null && state2.isIvarWaiting()) {
            throw this.runtime.newTypeError("can't override instance variable of " + label2 + "`" + name2 + "'");
        }
    }

    private RubySymbol objectForSymlink() throws IOException {
        return this.symlink();
    }

    private IRubyObject objectForSymbol(MarshalState state2, boolean partial) throws IOException {
        RubySymbol obj = this.symreal(state2);
        if (state2 != null && state2.isIvarWaiting()) {
            state2.setIvarWaiting(false);
        }
        return this.leave(obj, partial);
    }

    private IRubyObject objectForModule(boolean partial) throws IOException {
        return this.leave(this.entry(RubyModule.unmarshalFrom(this)), partial);
    }

    private IRubyObject objectForClass(boolean partial) throws IOException {
        return this.leave(this.entry(RubyClass.unmarshalFrom(this)), partial);
    }

    private IRubyObject objectForData(MarshalState state2, boolean partial, List<RubyModule> extendedModules) throws IOException {
        RubySymbol name2 = this.unique();
        RubyClass klass = UnmarshalStream.getClassFromPath(this.runtime, name2.asJavaString());
        IRubyObject obj = this.entry(klass.allocate());
        if (!obj.respondsTo("_load_data")) {
            throw this.runtime.newTypeError(RubyStringBuilder.str(this.runtime, name2, " needs to have instance method _load_data"));
        }
        IRubyObject arg2 = this.object0(state2, partial, extendedModules);
        obj.callMethod(this.runtime.getCurrentContext(), "_load_data", arg2);
        return this.leave(obj, partial);
    }

    private IRubyObject objectForObject(boolean partial) throws IOException {
        RubySymbol className = this.symbol();
        RubyClass type2 = UnmarshalStream.getClassFromPath(this.runtime, className.idString());
        IRubyObject obj = (IRubyObject)type2.unmarshal(this);
        return this.leave(obj, partial);
    }

    private IRubyObject objectForUserDef(MarshalState state2, boolean partial) throws IOException {
        IRubyObject obj = this.userUnmarshal(state2);
        if (!partial) {
            obj = this.postProc(obj);
        }
        return obj;
    }

    private IRubyObject objectForStruct(boolean partial) throws IOException {
        return this.leave(RubyStruct.unmarshalFrom(this), partial);
    }

    private IRubyObject objectForHashDefault(boolean partial) throws IOException {
        return this.leave(RubyHash.unmarshalFrom(this, true), partial);
    }

    private IRubyObject objectForHash(boolean partial) throws IOException {
        return this.leave(RubyHash.unmarshalFrom(this, false), partial);
    }

    private IRubyObject objectForArray(boolean partial) throws IOException {
        return this.leave(RubyArray.unmarshalFrom(this), partial);
    }

    private IRubyObject objectForRegexp(MarshalState state2, boolean partial) throws IOException {
        return this.leave(this.entry(this.unmarshalRegexp(state2)), partial);
    }

    private IRubyObject objectForString(boolean partial) throws IOException {
        return this.leave(this.entry(RubyString.unmarshalFrom(this)), partial);
    }

    private IRubyObject objectForBignum() throws IOException {
        return this.leave(this.entry(RubyBignum.unmarshalFrom(this)), false);
    }

    private IRubyObject objectForFloat() throws IOException {
        return this.leave(this.entry(RubyFloat.unmarshalFrom(this)), false);
    }

    private IRubyObject objectForFixnum() throws IOException {
        return this.leave(RubyFixnum.unmarshalFrom(this), false);
    }

    private IRubyObject objectForFalse() {
        return this.leave(this.runtime.getFalse(), false);
    }

    private IRubyObject objectForTrue() {
        return this.leave(this.runtime.getTrue(), false);
    }

    private IRubyObject objectForNil() {
        return this.leave(this.runtime.getNil(), false);
    }

    private IRubyObject objectForUClass(boolean partial, List<RubyModule> extendedModules) throws IOException {
        RubyClass c = UnmarshalStream.getClassFromPath(this.runtime, this.unique().asJavaString());
        if (c.isSingleton()) {
            throw this.runtime.newTypeError("singleton can't be loaded");
        }
        int type2 = this.r_byte();
        if (c == this.runtime.getHash() && (type2 == 123 || type2 == 125)) {
            return type2 == 123 ? this.objectForHash(partial) : this.objectForHashDefault(partial);
        }
        IRubyObject obj = this.objectFor(type2, null, partial, extendedModules);
        if (!(obj.getMetaClass() != this.runtime.getModule() && c.isKindOfModule(obj.getMetaClass()) || c.getAllocator() == obj.getMetaClass().getRealClass().getAllocator())) {
            throw this.runtime.newArgumentError("dump format error (user class)");
        }
        ((RubyObject)obj).setMetaClass(c);
        return obj;
    }

    private IRubyObject objectForExtended(List<RubyModule> extendedModules) throws IOException {
        IRubyObject obj;
        RubySymbol path2 = this.unique();
        RubyModule m = UnmarshalStream.getModuleFromPath(this.runtime, path2.asJavaString());
        if (extendedModules == null) {
            extendedModules = new ArrayList<RubyModule>();
        }
        if (m instanceof RubyClass) {
            obj = this.object0(null, true, null);
            RubyClass cls = obj.getMetaClass();
            if (cls != m || cls.isSingleton()) {
                throw this.runtime.newArgumentError(RubyStringBuilder.str(this.runtime, "prepended class ", path2, " differs from class ", cls));
            }
            cls = obj.getSingletonClass();
            for (RubyModule mod : extendedModules) {
                cls.prependModule(mod);
            }
        } else {
            extendedModules.add(this.mustBeModule(this.runtime, m, path2));
            obj = this.object0(null, true, extendedModules);
            this.appendExtendedModules(obj, extendedModules);
        }
        return obj;
    }

    private IRubyObject objectForIVar(MarshalState state2, boolean partial, List<RubyModule> extendedModules) throws IOException {
        MarshalState state1 = new MarshalState(true);
        IRubyObject obj = this.object0(state1, true, extendedModules);
        if (state1.ivarWaiting) {
            this.ivar(state2, obj, null);
        }
        return this.leave(obj, partial);
    }

    private IRubyObject objectForLink() throws IOException {
        IRubyObject obj = this.cache.readDataLink(this);
        if (!this.cache.isPartialObject(obj)) {
            obj = this.postProc(obj);
        }
        return obj;
    }

    private IRubyObject postProc(IRubyObject value2) {
        return this.doCallProcForObj(value2);
    }

    public RubySymbol symbol() throws IOException {
        int type2;
        boolean ivar = false;
        block5: while (true) {
            type2 = this.r_byte();
            switch (type2) {
                case 73: {
                    ivar = true;
                    continue block5;
                }
                case 58: {
                    MarshalState state1 = new MarshalState(ivar);
                    return this.symreal(state1);
                }
                case 59: {
                    if (ivar) {
                        throw this.runtime.newArgumentError("dump format error (symlink with encoding)");
                    }
                    return this.symlink();
                }
            }
            break;
        }
        throw this.runtime.newArgumentError("dump format error for symbol(0x" + Integer.toHexString(type2) + ")");
    }

    private RubySymbol symlink() throws IOException {
        return (RubySymbol)this.cache.readSymbolLink(this);
    }

    private RubySymbol symreal(MarshalState state2) throws IOException {
        ByteList byteList = this.unmarshalString();
        byteList.setEncoding(ASCIIEncoding.INSTANCE);
        UnmarshalStream input = this;
        IOException[] exception2 = new IOException[]{null};
        RubySymbol symbol = RubySymbol.newSymbol(this.runtime, byteList, (sym, newSym) -> {
            try {
                Encoding encoding2 = null;
                this.cache.registerSymbolLink((RubySymbol)sym);
                if (state2 != null && state2.isIvarWaiting()) {
                    int num = input.unmarshalInt();
                    for (int i2 = 0; i2 < num; ++i2) {
                        RubySymbol sym2 = input.symbol();
                        encoding2 = this.symbolToEncoding(sym2, input.unmarshalObject());
                    }
                }
                if (encoding2 != null) {
                    sym.getBytes().setEncoding(encoding2);
                    if (StringSupport.codeRangeScan(encoding2, sym.getBytes()) == 48) {
                        throw this.runtime.newArgumentError(RubyStringBuilder.str(this.runtime, "invalid byte sequence in " + encoding2 + ": ", RubyStringBuilder.inspectIdentifierByteList(this.runtime, sym.getBytes())));
                    }
                }
            }
            catch (IOException e) {
                exception2[0] = e;
            }
        });
        if (exception2[0] != null) {
            throw exception2[0];
        }
        return symbol;
    }

    public RubySymbol unique() throws IOException {
        return this.symbol();
    }

    private IRubyObject unmarshalRegexp(MarshalState state2) throws IOException {
        ByteList byteList = this.unmarshalString();
        byte opts = this.readSignedByte();
        RegexpOptions reOpts = RegexpOptions.fromJoniOptions(opts);
        RubyRegexp regexp2 = (RubyRegexp)this.runtime.getRegexp().allocate();
        IRubyObject ivarHolder = null;
        boolean[] hasEncoding = new boolean[]{false};
        if (state2 != null && state2.isIvarWaiting()) {
            RubyString tmpStr = RubyString.newString(this.runtime, byteList);
            this.ivar(state2, tmpStr, hasEncoding);
            byteList = tmpStr.getByteList();
            state2.setIvarWaiting(false);
            ivarHolder = tmpStr;
        }
        if (!hasEncoding[0]) {
            int ptr;
            byte[] ptrBytes = byteList.unsafeBytes();
            int dst = ptr = byteList.begin();
            int src = ptr;
            int len = byteList.realSize();
            long bs = 0L;
            while (len-- > 0) {
                switch (ptrBytes[src]) {
                    case 92: {
                        ++bs;
                        break;
                    }
                    case 69: 
                    case 70: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 88: 
                    case 89: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 117: 
                    case 121: {
                        if ((bs & 1L) != 0L) {
                            // empty if block
                        }
                    }
                    default: {
                        bs = 0L;
                    }
                }
                int n = --dst;
                ++dst;
                ptrBytes[n] = ptrBytes[src++];
            }
            byteList.setRealSize(dst - ptr);
        }
        regexp2.regexpInitialize(byteList, byteList.getEncoding(), reOpts);
        if (ivarHolder != null) {
            ivarHolder.getInstanceVariables().copyInstanceVariablesInto(regexp2);
        }
        return regexp2;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public int readUnsignedByte() throws IOException {
        int result2 = this.read();
        if (result2 == -1) {
            throw new EOFException("Unexpected end of stream");
        }
        return result2;
    }

    public byte readSignedByte() throws IOException {
        int b2 = this.readUnsignedByte();
        if (b2 > 127) {
            return (byte)(b2 - 256);
        }
        return (byte)b2;
    }

    public ByteList unmarshalString() throws IOException {
        int read2;
        int length2 = this.unmarshalInt();
        byte[] buffer = new byte[length2];
        for (int readLength = 0; readLength < length2; readLength += read2) {
            read2 = this.inputStream.read(buffer, readLength, length2 - readLength);
            if (read2 != -1) continue;
            throw this.getRuntime().newArgumentError("marshal data too short");
        }
        return new ByteList(buffer, false);
    }

    public int unmarshalInt() throws IOException {
        long result2;
        int c = this.readSignedByte();
        if (c == 0) {
            return 0;
        }
        if (4 < c) {
            return c - 5;
        }
        if (c < -4) {
            return c + 5;
        }
        if (c > 0) {
            result2 = 0L;
            for (int i2 = 0; i2 < c; ++i2) {
                result2 |= (long)this.readUnsignedByte() << 8 * i2;
            }
        } else {
            c = -c;
            result2 = -1L;
            for (int i3 = 0; i3 < c; ++i3) {
                result2 &= 255L << 8 * i3 ^ 0xFFFFFFFFFFFFFFFFL;
                result2 |= (long)this.readUnsignedByte() << 8 * i3;
            }
        }
        return (int)result2;
    }

    public Encoding symbolToEncoding(RubySymbol symbol, IRubyObject value2) {
        if (symbol.getEncoding() != USASCIIEncoding.INSTANCE) {
            return null;
        }
        String id2 = symbol.idString();
        if (id2.equals("encoding")) {
            String encodingNameStr = value2.asJavaString();
            ByteList encodingName = new ByteList(ByteList.plain(encodingNameStr));
            EncodingDB.Entry entry = this.runtime.getEncodingService().findEncodingOrAliasEntry(encodingName);
            if (entry == null) {
                throw this.runtime.newArgumentError(RubyStringBuilder.str(this.runtime, "encoding ", value2, " is not registered"));
            }
            return entry.getEncoding();
        }
        if (id2.equals("E")) {
            return value2.isTrue() ? UTF8Encoding.INSTANCE : USASCIIEncoding.INSTANCE;
        }
        return null;
    }

    private IRubyObject userUnmarshal(MarshalState state2) throws IOException {
        IRubyObject unmarshaled;
        String className = this.unique().asJavaString();
        RubyClass classInstance = UnmarshalStream.getClassFromPath(this.runtime, className);
        RubyString data2 = RubyString.newString(this.runtime, this.unmarshalString());
        if (classInstance == this.runtime.getEncoding()) {
            unmarshaled = RubyEncoding.find(this.runtime.getCurrentContext(), classInstance, data2);
        } else {
            if (state2 != null && state2.isIvarWaiting()) {
                this.ivar(state2, data2, null);
                state2.setIvarWaiting(false);
            }
            unmarshaled = classInstance.smartLoadOldUser(data2);
        }
        return this.entry(unmarshaled);
    }

    private IRubyObject objectForUsrMarshal(MarshalState state2, boolean partial, List<RubyModule> extendedModules) throws IOException {
        RubyClass classInstance = UnmarshalStream.getClassFromPath(this.runtime, this.unique().asJavaString());
        IRubyObject obj = classInstance.allocate();
        if (extendedModules != null) {
            this.appendExtendedModules(obj, extendedModules);
        }
        obj = this.entry(obj);
        IRubyObject marshaled = this.unmarshalObject();
        obj = classInstance.smartLoadNewUser(obj, marshaled);
        obj = this.fixupCompat(obj);
        obj = this.postProc(obj);
        if (extendedModules != null) {
            extendedModules.clear();
        }
        return obj;
    }

    private IRubyObject fixupCompat(IRubyObject obj) {
        return obj;
    }

    private void appendExtendedModules(IRubyObject obj, List<RubyModule> extendedModules) {
        Collections.reverse(extendedModules);
        for (RubyModule module : extendedModules) {
            module.extend_object(obj);
        }
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Deprecated
    public void defaultVariablesUnmarshal(MarshalState state2, IRubyObject object) throws IOException {
        this.ivar(state2, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public IRubyObject unmarshalObject(boolean _callProc) throws IOException {
        IRubyObject savedProc = this.proc;
        try {
            this.proc = null;
            IRubyObject iRubyObject = this.object0(new MarshalState(false), false, null);
            return iRubyObject;
        }
        finally {
            this.proc = savedProc;
        }
    }

    @Deprecated
    public UnmarshalStream(Ruby runtime2, InputStream in, IRubyObject proc2, boolean taint2, boolean untrust2) throws IOException {
        this(runtime2, in, proc2);
    }

    @Deprecated
    public UnmarshalStream(Ruby runtime2, InputStream in, IRubyObject proc2, boolean taint2) throws IOException {
        this(runtime2, in, proc2);
    }

    public static class MarshalState {
        private boolean ivarWaiting;

        MarshalState(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }

        public boolean isIvarWaiting() {
            return this.ivarWaiting;
        }

        public void setIvarWaiting(boolean ivarWaiting) {
            this.ivarWaiting = ivarWaiting;
        }
    }
}

