/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.TransportStateReference;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.AbstractSocketEntry;
import org.snmp4j.transport.AbstractTransportServerThread;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportType;
import org.snmp4j.util.CommonTimer;

public class DefaultTcpTransportMapping
extends TcpTransportMapping<SocketEntry> {
    public static final int DEFAULT_MAX_BUSY_LOOPS = 100;
    private static final LogAdapter logger = LogFactory.getLogger(DefaultTcpTransportMapping.class);
    protected ServerThread serverThread;
    private static final int MIN_SNMP_HEADER_LENGTH = 6;
    protected MessageLengthDecoder messageLengthDecoder = new SnmpMesssageLengthDecoder();

    public DefaultTcpTransportMapping() throws IOException {
        super(new TcpAddress(InetAddress.getLocalHost(), 0));
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress, boolean serverEnabled) throws IOException {
        super(serverAddress);
        this.serverEnabled = serverEnabled;
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress) throws IOException {
        super(serverAddress);
        this.serverEnabled = true;
    }

    @Override
    public synchronized void listen() throws IOException {
        if (this.getListenWorkerTask() != null) {
            throw new SocketException("Port already listening");
        }
        this.serverThread = new ServerThread();
        if (logger.isInfoEnabled()) {
            logger.info("TCP address " + String.valueOf(this.getListenAddress()) + " bound successfully");
        }
        this.listenWorkerTask = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultTCPTransportMapping_" + String.valueOf(this.getListenAddress()), this.serverThread, true);
        if (this.getConnectionTimeout() > 0L) {
            this.socketCleaner = SNMP4JSettings.getTimerFactory().createTimer();
        }
        this.getListenWorkerTask().run();
    }

    @Override
    public TransportType getSupportedTransportType() {
        return this.isServerEnabled() ? TransportType.any : TransportType.sender;
    }

    @Override
    public void sendMessage(TcpAddress address, byte[] message, TransportStateReference tmStateReference, long timeoutMillis, int maxRetries) throws IOException {
        if (this.getListenWorkerTask() == null || this.serverThread == null) {
            if (this.isOpenSocketOnSending()) {
                this.listen();
            } else {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            }
        }
        if (this.serverThread != null) {
            if (this.suspendedAddresses.size() > 0 && this.suspendedAddresses.contains(address)) {
                this.handleDroppedMessageToSend(address, message, tmStateReference, timeoutMillis, maxRetries);
            } else {
                this.serverThread.sendMessage(address, message, tmStateReference, this.sockets);
            }
        }
    }

    @Override
    public MessageLengthDecoder getMessageLengthDecoder() {
        return this.messageLengthDecoder;
    }

    @Override
    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        if (messageLengthDecoder == null) {
            throw new NullPointerException();
        }
        this.messageLengthDecoder = messageLengthDecoder;
    }

    @Override
    public CommonTimer getSocketCleaner() {
        return super.getSocketCleaner();
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Override
    public TcpAddress getListenAddress() {
        int port = this.tcpAddress.getPort();
        ServerThread serverThreadCopy = this.serverThread;
        try {
            port = ((InetSocketAddress)serverThreadCopy.ssc.getLocalAddress()).getPort();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new TcpAddress(this.tcpAddress.getInetAddress(), port);
    }

    @Override
    public void wakeupServerSelector() {
        this.serverThread.selector.wakeup();
    }

    protected void addBufferToReadBuffer(SocketEntry entry, ByteBuffer byteBuffer) {
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Adding data " + String.valueOf(byteBuffer) + " to read buffer " + String.valueOf(entry.getReadBuffer()))));
        }
        int buflen = byteBuffer.position();
        if (entry.getReadBuffer() != null) {
            entry.getReadBuffer().put(byteBuffer.array(), 0, buflen);
        } else {
            byte[] message = new byte[byteBuffer.limit()];
            byteBuffer.flip();
            byteBuffer.get(message, 0, buflen);
            ByteBuffer newBuffer = ByteBuffer.wrap(message);
            newBuffer.position(buflen);
            entry.setReadBuffer(newBuffer);
        }
    }

    protected void socketClosedRemotely(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
        logger.debug((Serializable)((Object)"Socket closed remotely"));
        this.cancelNonServerSelectionKey(sk);
        readChannel.close();
        TransportStateEvent e = new TransportStateEvent(this, incomingAddress, 2, null);
        this.fireConnectionStateChanged(e);
        this.sockets.remove(incomingAddress);
    }

    public static class SnmpMesssageLengthDecoder
    implements MessageLengthDecoder {
        @Override
        public int getMinHeaderLength() {
            return 6;
        }

        @Override
        public MessageLength getMessageLength(ByteBuffer buf) throws IOException {
            BER.MutableByte type = new BER.MutableByte();
            BERInputStream is = new BERInputStream(buf);
            int ml = BER.decodeHeader(is, type, false);
            int hl = (int)is.getPosition();
            return new MessageLength(hl, ml);
        }
    }

    protected class ServerThread
    extends AbstractTransportServerThread<TcpAddress, SocketEntry> {
        protected byte[] buf;
        private Throwable lastError;

        public ServerThread() throws IOException {
            super(DefaultTcpTransportMapping.this, DefaultTcpTransportMapping.this.tcpAddress);
            this.lastError = null;
            this.buf = new byte[DefaultTcpTransportMapping.this.getMaxInboundMessageSize()];
            this.selector = Selector.open();
            if (DefaultTcpTransportMapping.this.isServerEnabled()) {
                this.ssc = ServerSocketChannel.open();
                try {
                    this.ssc.configureBlocking(false);
                    InetSocketAddress isa = new InetSocketAddress(DefaultTcpTransportMapping.this.tcpAddress.getInetAddress(), DefaultTcpTransportMapping.this.tcpAddress.getPort());
                    DefaultTcpTransportMapping.this.setSocketOptions(this.ssc.socket());
                    this.ssc.socket().bind(isa);
                    this.ssc.register(this.selector, 16);
                }
                catch (IOException iox) {
                    logger.warn((Serializable)((Object)("Socket bind failed for " + String.valueOf(DefaultTcpTransportMapping.this.tcpAddress) + ": " + iox.getMessage())));
                    try {
                        this.ssc.close();
                    }
                    catch (IOException ioxClose) {
                        logger.warn((Serializable)((Object)("Socket close failed after bind failure for " + String.valueOf(DefaultTcpTransportMapping.this.tcpAddress) + ": " + ioxClose.getMessage())));
                    }
                    throw iox;
                }
            }
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        @Override
        protected SocketEntry createSocketEntry(TcpAddress address, SocketChannel socketChannel, boolean useClientMode, TransportStateReference tmStateReference) {
            return new SocketEntry(address, socketChannel);
        }

        @Override
        protected SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
            return SocketChannel.open();
        }

        @Override
        public void run() {
            this.doServer(DefaultTcpTransportMapping.this.sockets);
        }

        @Override
        protected boolean readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry socketEntry) throws IOException {
            long bytesRead;
            SocketEntry entry = (SocketEntry)sk.attachment();
            if (entry == null) {
                entry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(incomingAddress);
            }
            if (entry != null) {
                entry.used();
                ByteBuffer readBuffer = entry.getReadBuffer();
                if (readBuffer != null) {
                    int bytesRead2 = readChannel.read(readBuffer);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Read " + bytesRead2 + " bytes from " + String.valueOf(incomingAddress))));
                    }
                    if (bytesRead2 >= 0 && (readBuffer.hasRemaining() || readBuffer.position() < DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength())) {
                        entry.addRegistration(this.selector, 1);
                    } else if (bytesRead2 < 0) {
                        DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
                    } else {
                        this.readSnmpMessagePayload(readChannel, incomingAddress, entry, readBuffer);
                    }
                    if (bytesRead2 != 0) {
                        entry.resetBusyLoops();
                        return true;
                    }
                    return false;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf);
            byteBuffer.limit(DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength());
            if (!readChannel.isOpen()) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + String.valueOf(incomingAddress))));
                }
                return false;
            }
            try {
                bytesRead = readChannel.read(byteBuffer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Reading header " + bytesRead + " bytes from " + String.valueOf(incomingAddress))));
                }
            }
            catch (ClosedChannelException ccex) {
                DefaultTcpTransportMapping.this.cancelNonServerSelectionKey(sk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Read channel not open, no bytes read from " + String.valueOf(incomingAddress))));
                }
                return false;
            }
            if (byteBuffer.position() >= DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength()) {
                this.readSnmpMessagePayload(readChannel, incomingAddress, entry, byteBuffer);
            } else if (bytesRead < 0L) {
                DefaultTcpTransportMapping.this.socketClosedRemotely(sk, readChannel, incomingAddress);
            } else if (entry != null && bytesRead > 0L) {
                DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                entry.addRegistration(this.selector, 1);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("No socket entry found for incoming address " + String.valueOf(incomingAddress) + " for incomplete message with length " + bytesRead)));
            }
            if (entry != null && bytesRead != 0L) {
                entry.resetBusyLoops();
                return true;
            }
            return false;
        }

        @Override
        protected void processQueues() {
        }

        @Override
        public SocketEntry removeSocketEntry(TcpAddress incomingAddress) {
            return (SocketEntry)DefaultTcpTransportMapping.this.sockets.remove(incomingAddress);
        }

        @Override
        protected TcpAddress createIncomingAddress(SocketChannel sc) throws IOException {
            Socket s = sc.socket();
            return new TcpAddress(s.getInetAddress(), s.getPort());
        }

        protected void readSnmpMessagePayload(SocketChannel readChannel, TcpAddress incomingAddress, SocketEntry entry, ByteBuffer byteBuffer) throws IOException {
            MessageLength messageLength = DefaultTcpTransportMapping.this.messageLengthDecoder.getMessageLength(ByteBuffer.wrap(byteBuffer.array()));
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Message length is " + String.valueOf(messageLength))));
            }
            if (messageLength.getMessageLength() > DefaultTcpTransportMapping.this.getMaxInboundMessageSize() || messageLength.getMessageLength() <= 0) {
                Socket s;
                logger.error((Serializable)((Object)("Received message length " + String.valueOf(messageLength) + " is greater than inboundBufferSize " + DefaultTcpTransportMapping.this.getMaxInboundMessageSize())));
                if (entry != null && (s = entry.getSocketChannel().socket()) != null) {
                    s.close();
                    logger.info("Socket to " + String.valueOf(entry.getPeerAddress()) + " closed due to an error");
                }
            } else {
                long bytesRead;
                int messageSize = messageLength.getMessageLength();
                if (byteBuffer.position() < messageSize) {
                    if (byteBuffer.capacity() < messageSize) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Extending message buffer size according to message length to " + messageSize)));
                        }
                        byte[] newBuffer = new byte[messageSize];
                        int len = byteBuffer.position();
                        byteBuffer.flip();
                        byteBuffer.get(newBuffer, 0, len);
                        byteBuffer = ByteBuffer.wrap(newBuffer);
                        byteBuffer.position(len);
                        if (entry != null) {
                            byteBuffer.limit(messageSize);
                            entry.setReadBuffer(byteBuffer);
                        }
                    } else {
                        byteBuffer.limit(messageSize);
                    }
                    readChannel.read(byteBuffer);
                }
                if ((bytesRead = (long)byteBuffer.position()) >= (long)messageSize) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Message completed with " + bytesRead + " bytes and " + byteBuffer.limit() + " buffer limit")));
                    }
                    if (entry != null) {
                        entry.setReadBuffer(null);
                    }
                    this.dispatchMessage(incomingAddress, byteBuffer, bytesRead, entry);
                } else if (entry != null && byteBuffer != entry.getReadBuffer()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Adding buffer content to read buffer of entry " + String.valueOf(entry) + ", buffer " + String.valueOf(byteBuffer))));
                    }
                    DefaultTcpTransportMapping.this.addBufferToReadBuffer(entry, byteBuffer);
                }
                if (entry != null) {
                    entry.addRegistration(this.selector, 1);
                }
            }
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead, Object sessionID) {
            ByteBuffer bis;
            byteBuffer.flip();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received message from " + String.valueOf(incomingAddress) + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString())));
            }
            if (DefaultTcpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            TransportStateReference stateReference = new TransportStateReference(DefaultTcpTransportMapping.this, incomingAddress, null, SecurityLevel.undefined, SecurityLevel.undefined, false, sessionID);
            DefaultTcpTransportMapping.this.fireProcessMessage(incomingAddress, bis, stateReference);
        }
    }

    protected static class SocketEntry
    extends AbstractSocketEntry<TcpAddress> {
        private ByteBuffer readBuffer = null;

        public SocketEntry(TcpAddress address, SocketChannel socketChannel) {
            super(address, socketChannel);
            this.setHandshakeFinished(true);
        }

        @Override
        public void closeSession() {
        }

        @Override
        public Object getSessionID() {
            return this.socketChannel;
        }

        public void setReadBuffer(ByteBuffer byteBuffer) {
            this.readBuffer = byteBuffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        @Override
        public String toString() {
            return "SocketEntry[peerAddress=" + String.valueOf(this.getPeerAddress()) + ",socket=" + String.valueOf(this.socketChannel) + ",lastUse=" + String.valueOf(new Date(this.getLastUse() / 1000000L)) + ",readBufferPosition=" + (this.readBuffer == null ? -1 : this.readBuffer.position()) + ",socketTimeout=" + String.valueOf(this.getSocketTimeout()) + "]";
        }
    }
}

