/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import net.sf.saxon.expr.sort.LRUCache;
import net.sf.saxon.lib.URIChecker;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;

public class ConversionRules {
    private StringToDouble stringToDouble = StringToDouble.getInstance();
    private NotationSet notationSet;
    private URIChecker uriChecker;
    private boolean allowYearZero;
    private TypeHierarchy typeHierarchy;
    private LRUCache<Integer, Converter> converterCache = new LRUCache(100, true);

    public ConversionRules copy() {
        ConversionRules cr = new ConversionRules();
        this.copyTo(cr);
        return cr;
    }

    public void copyTo(ConversionRules cr) {
        cr.stringToDouble = this.stringToDouble;
        cr.notationSet = this.notationSet;
        cr.uriChecker = this.uriChecker;
        cr.allowYearZero = this.allowYearZero;
        cr.typeHierarchy = this.typeHierarchy;
        cr.converterCache.clear();
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }

    public void setTypeHierarchy(TypeHierarchy typeHierarchy) {
        this.typeHierarchy = typeHierarchy;
    }

    public void setStringToDoubleConverter(StringToDouble converter) {
        this.stringToDouble = converter;
    }

    public StringToDouble getStringToDoubleConverter() {
        return this.stringToDouble;
    }

    public void setNotationSet(NotationSet notations) {
        this.notationSet = notations;
    }

    public boolean isDeclaredNotation(String uri, String local) {
        if (this.notationSet == null) {
            return true;
        }
        return this.notationSet.isDeclaredNotation(uri, local);
    }

    public void setURIChecker(URIChecker checker) {
        this.uriChecker = checker;
    }

    public boolean isValidURI(CharSequence string) {
        return this.uriChecker == null || this.uriChecker.isValidURI(string);
    }

    public void setAllowYearZero(boolean allowed) {
        this.allowYearZero = allowed;
    }

    public boolean isAllowYearZero() {
        return this.allowYearZero;
    }

    public Converter getConverter(AtomicType source, AtomicType target) {
        int key = source.getPrimitiveType() << 20 | target.getFingerprint();
        Converter converter = this.converterCache.get(key);
        if (converter == null) {
            converter = this.makeConverter(source, target);
            if (converter != null) {
                this.converterCache.put(key, converter);
            } else {
                return null;
            }
        }
        return converter;
    }

    private Converter makeConverter(AtomicType sourceType, AtomicType targetType) {
        if (sourceType == targetType) {
            return StringConverter.IdentityConverter.THE_INSTANCE;
        }
        int tt = targetType.getFingerprint();
        int tp = targetType.getPrimitiveType();
        int st = sourceType.getPrimitiveType();
        if (!(st != 513 && st != 631 || tp != 513 && tp != 631)) {
            return this.makeStringConverter(targetType);
        }
        if (!targetType.isPrimitiveType()) {
            AtomicType primTarget = (AtomicType)targetType.getPrimitiveItemType();
            if (sourceType == primTarget) {
                return new Converter.DownCastingConverter(targetType, this);
            }
            if (st == 513 || st == 631) {
                return this.makeStringConverter(targetType);
            }
            Converter stageOne = this.makeConverter(sourceType, primTarget);
            if (stageOne == null) {
                return null;
            }
            Converter.DownCastingConverter stageTwo = new Converter.DownCastingConverter(targetType, this);
            return new Converter.TwoPhaseConverter(stageOne, stageTwo);
        }
        if (st == tt) {
            if (this.typeHierarchy != null && this.typeHierarchy.isSubType(sourceType, targetType)) {
                return new Converter.UpCastingConverter(targetType);
            }
            Converter.UpCastingConverter upcast = new Converter.UpCastingConverter((AtomicType)sourceType.getPrimitiveItemType());
            Converter.DownCastingConverter downcast = new Converter.DownCastingConverter(targetType, this);
            return new Converter.TwoPhaseConverter(upcast, downcast);
        }
        switch (tt) {
            case 631: {
                return Converter.TO_UNTYPED_ATOMIC;
            }
            case 513: {
                return Converter.TO_STRING;
            }
            case 516: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToFloat(this);
                    }
                    case 515: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return Converter.NUMERIC_TO_FLOAT;
                    }
                    case 514: {
                        return Converter.BOOLEAN_TO_FLOAT;
                    }
                }
                return null;
            }
            case 517: 
            case 635: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return this.stringToDouble;
                    }
                    case 515: 
                    case 516: 
                    case 533: 
                    case 635: {
                        return Converter.NUMERIC_TO_DOUBLE;
                    }
                    case 514: {
                        return Converter.BOOLEAN_TO_DOUBLE;
                    }
                }
                return null;
            }
            case 515: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DECIMAL;
                    }
                    case 516: {
                        return Converter.FLOAT_TO_DECIMAL;
                    }
                    case 517: {
                        return Converter.DOUBLE_TO_DECIMAL;
                    }
                    case 533: {
                        return Converter.INTEGER_TO_DECIMAL;
                    }
                    case 635: {
                        return Converter.NUMERIC_TO_DECIMAL;
                    }
                    case 514: {
                        return Converter.BOOLEAN_TO_DECIMAL;
                    }
                }
                return null;
            }
            case 533: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_INTEGER;
                    }
                    case 516: {
                        return Converter.FLOAT_TO_INTEGER;
                    }
                    case 517: {
                        return Converter.DOUBLE_TO_INTEGER;
                    }
                    case 515: {
                        return Converter.DECIMAL_TO_INTEGER;
                    }
                    case 635: {
                        return Converter.NUMERIC_TO_INTEGER;
                    }
                    case 514: {
                        return Converter.BOOLEAN_TO_INTEGER;
                    }
                }
                return null;
            }
            case 518: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DURATION;
                    }
                    case 633: 
                    case 634: {
                        return new Converter.UpCastingConverter(BuiltInAtomicType.DURATION);
                    }
                }
                return null;
            }
            case 633: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_YEAR_MONTH_DURATION;
                    }
                    case 518: 
                    case 634: {
                        return Converter.DURATION_TO_YEAR_MONTH_DURATION;
                    }
                }
                return null;
            }
            case 634: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_DAY_TIME_DURATION;
                    }
                    case 518: 
                    case 633: {
                        return Converter.DURATION_TO_DAY_TIME_DURATION;
                    }
                }
                return null;
            }
            case 519: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDateTime(this);
                    }
                    case 521: {
                        return Converter.DATE_TO_DATE_TIME;
                    }
                }
                return null;
            }
            case 520: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_TIME;
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_TIME;
                    }
                }
                return null;
            }
            case 521: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToDate(this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_DATE;
                    }
                }
                return null;
            }
            case 522: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYearMonth(this);
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR_MONTH, this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_G_YEAR_MONTH;
                    }
                }
                return null;
            }
            case 523: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToGYear(this);
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_YEAR, this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_G_YEAR;
                    }
                }
                return null;
            }
            case 524: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_G_MONTH_DAY;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH_DAY, this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_G_MONTH_DAY;
                    }
                }
                return null;
            }
            case 525: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_G_DAY;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_DAY, this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_G_DAY;
                    }
                }
                return null;
            }
            case 526: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_G_MONTH;
                    }
                    case 521: {
                        return Converter.TwoPhaseConverter.makeTwoPhaseConverter(BuiltInAtomicType.DATE, BuiltInAtomicType.DATE_TIME, BuiltInAtomicType.G_MONTH, this);
                    }
                    case 519: {
                        return Converter.DATE_TIME_TO_G_MONTH;
                    }
                }
                return null;
            }
            case 514: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_BOOLEAN;
                    }
                    case 515: 
                    case 516: 
                    case 517: 
                    case 533: 
                    case 635: {
                        return Converter.NUMERIC_TO_BOOLEAN;
                    }
                }
                return null;
            }
            case 528: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_BASE64_BINARY;
                    }
                    case 527: {
                        return Converter.HEX_BINARY_TO_BASE64_BINARY;
                    }
                }
                return null;
            }
            case 527: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return StringConverter.STRING_TO_HEX_BINARY;
                    }
                    case 528: {
                        return Converter.BASE64_BINARY_TO_HEX_BINARY;
                    }
                }
                return null;
            }
            case 529: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToAnyURI(this);
                    }
                }
                return null;
            }
            case 530: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToQName(this);
                    }
                    case 531: {
                        return Converter.NOTATION_TO_QNAME;
                    }
                }
                return null;
            }
            case 531: {
                switch (st) {
                    case 513: 
                    case 631: {
                        return new StringConverter.StringToNotation(this);
                    }
                    case 530: {
                        return Converter.QNAME_TO_NOTATION;
                    }
                }
                return null;
            }
            case 632: {
                return Converter.IDENTITY_CONVERTER;
            }
        }
        throw new IllegalArgumentException("Unknown primitive type " + tt);
    }

    private StringConverter makeStringConverter(AtomicType targetType) {
        int tt = targetType.getPrimitiveType();
        if (targetType.isBuiltInType()) {
            if (tt == 513) {
                switch (targetType.getFingerprint()) {
                    case 513: {
                        return StringConverter.STRING_TO_STRING;
                    }
                    case 553: {
                        return StringConverter.STRING_TO_NORMALIZED_STRING;
                    }
                    case 554: {
                        return StringConverter.STRING_TO_TOKEN;
                    }
                    case 555: {
                        return StringConverter.STRING_TO_LANGUAGE;
                    }
                    case 558: {
                        return StringConverter.STRING_TO_NAME;
                    }
                    case 559: {
                        return StringConverter.STRING_TO_NCNAME;
                    }
                    case 560: {
                        return StringConverter.STRING_TO_ID;
                    }
                    case 561: {
                        return StringConverter.STRING_TO_IDREF;
                    }
                    case 563: {
                        return StringConverter.STRING_TO_ENTITY;
                    }
                    case 556: {
                        return StringConverter.STRING_TO_NMTOKEN;
                    }
                }
                throw new AssertionError((Object)"Unknown built-in subtype of xs:string");
            }
            if (tt == 631) {
                return StringConverter.STRING_TO_UNTYPED_ATOMIC;
            }
            if (targetType.isPrimitiveType()) {
                Converter converter = this.getConverter(BuiltInAtomicType.STRING, targetType);
                assert (converter != null);
                return (StringConverter)converter;
            }
            if (tt == 533) {
                return new StringConverter.StringToIntegerSubtype((BuiltInAtomicType)targetType);
            }
            switch (targetType.getFingerprint()) {
                case 634: {
                    return StringConverter.STRING_TO_DAY_TIME_DURATION;
                }
                case 633: {
                    return StringConverter.STRING_TO_YEAR_MONTH_DURATION;
                }
                case 565: {
                    StringConverter.StringToDateTime first = new StringConverter.StringToDateTime(this);
                    Converter.DownCastingConverter second = new Converter.DownCastingConverter(targetType, this);
                    return new StringConverter.StringToNonStringDerivedType(first, second);
                }
            }
            throw new AssertionError((Object)("Unknown built in type " + targetType.toString()));
        }
        if (tt == 513) {
            if (targetType.getBuiltInBaseType() == BuiltInAtomicType.STRING) {
                return new StringConverter.StringToStringSubtype(this, targetType);
            }
            return new StringConverter.StringToDerivedStringSubtype(this, targetType);
        }
        StringConverter first = ((AtomicType)targetType.getPrimitiveItemType()).getStringConverter(this);
        Converter.DownCastingConverter second = new Converter.DownCastingConverter(targetType, this);
        return new StringConverter.StringToNonStringDerivedType(first, second);
    }
}

