/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.report.util.beans.BeanException;
import org.jfree.report.util.beans.ConverterRegistry;
import org.jfree.report.util.beans.ValueConverter;

public final class BeanUtility {
    private BeanInfo beanInfo;
    private Object bean;
    private HashMap properties;

    private BeanUtility() {
    }

    public BeanUtility(Object object) throws IntrospectionException {
        this.bean = object;
        this.beanInfo = Introspector.getBeanInfo(object.getClass());
        this.properties = new HashMap();
        PropertyDescriptor[] propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            this.properties.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
    }

    public BeanUtility derive(Object object) {
        if (!object.getClass().equals(this.bean.getClass())) {
            throw new IllegalArgumentException();
        }
        BeanUtility beanUtility = new BeanUtility();
        beanUtility.bean = object;
        return beanUtility;
    }

    public PropertyDescriptor[] getPropertyInfos() {
        return this.beanInfo.getPropertyDescriptors();
    }

    public Object getProperty(String string) throws BeanException {
        return this.getPropertyForSpecification(new PropertySpecification(string));
    }

    private Object getPropertyForSpecification(PropertySpecification propertySpecification) throws BeanException {
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(propertySpecification.getName());
        if (propertyDescriptor == null) {
            throw new BeanException("No such property:" + propertySpecification);
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && propertySpecification.getIndex() != null) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            Method method = indexedPropertyDescriptor.getIndexedReadMethod();
            if (method == null) {
                throw new BeanException("Property is not readable: " + propertySpecification);
            }
            try {
                return method.invoke(this.bean, new Integer(propertySpecification.getIndex()));
            }
            catch (Exception exception) {
                throw new BeanException("InvokationError", exception);
            }
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new BeanException("Property is not readable: " + propertySpecification);
        }
        if (propertySpecification.getIndex() != null) {
            try {
                Object object = method.invoke(this.bean, (Object[])null);
                if (object == null) {
                    throw new IndexOutOfBoundsException("No such index, property is null");
                }
                if (!object.getClass().isArray()) {
                    throw new BeanException("The property contains no array.");
                }
                int n = Integer.parseInt(propertySpecification.getIndex());
                return Array.get(object, n);
            }
            catch (BeanException beanException) {
                throw beanException;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw indexOutOfBoundsException;
            }
            catch (Exception exception) {
                throw new BeanException("Failed to read indexed property.");
            }
        }
        try {
            return method.invoke(this.bean, (Object[])null);
        }
        catch (Exception exception) {
            throw new BeanException("InvokationError", exception);
        }
    }

    public String getPropertyAsString(String string) throws BeanException {
        PropertySpecification propertySpecification = new PropertySpecification(string);
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(propertySpecification.getName());
        if (propertyDescriptor == null) {
            throw new BeanException("No such property:" + string);
        }
        Object object = this.getPropertyForSpecification(propertySpecification);
        if (object == null) {
            return null;
        }
        ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(object.getClass());
        if (valueConverter == null) {
            throw new BeanException("Unable to handle property of type " + object.getClass().getName());
        }
        return valueConverter.toAttributeValue(object);
    }

    public void setProperty(String string, Object object) throws BeanException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        this.setProperty(new PropertySpecification(string), object);
    }

    private void setProperty(PropertySpecification propertySpecification, Object object) throws BeanException {
        Object object2;
        Method method;
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(propertySpecification.getName());
        if (propertyDescriptor == null) {
            throw new BeanException("No such property:" + propertySpecification);
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor && propertySpecification.getIndex() != null && (method = ((IndexedPropertyDescriptor)(object2 = (IndexedPropertyDescriptor)propertyDescriptor)).getIndexedWriteMethod()) != null) {
            try {
                method.invoke(this.bean, new Integer(propertySpecification.getIndex()), object);
            }
            catch (Exception exception) {
                throw new BeanException("InvokationError", exception);
            }
            return;
        }
        object2 = propertyDescriptor.getWriteMethod();
        if (object2 == null) {
            throw new BeanException("Property is not writeable: " + propertySpecification);
        }
        if (propertySpecification.getIndex() != null) {
            this.updateArrayProperty(propertyDescriptor, propertySpecification, object);
        } else {
            try {
                ((Method)object2).invoke(this.bean, object);
            }
            catch (Exception exception) {
                throw new BeanException("InvokationError", exception);
            }
        }
    }

    private void updateArrayProperty(PropertyDescriptor propertyDescriptor, PropertySpecification propertySpecification, Object object) throws BeanException {
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new BeanException("Property is not readable, cannot perform array update: " + propertySpecification);
        }
        try {
            Object object2 = method.invoke(this.bean, (Object[])null);
            int n = Integer.parseInt(propertySpecification.getIndex());
            Object object3 = this.validateArray(BeanUtility.getPropertyType(propertyDescriptor), object2, n);
            Array.set(object3, n, object);
            Method method2 = propertyDescriptor.getWriteMethod();
            method2.invoke(this.bean, object3);
        }
        catch (BeanException beanException) {
            throw beanException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BeanException("Failed to read property, cannot perform array update: " + propertySpecification);
        }
    }

    private Object validateArray(Class clazz, Object object, int n) throws BeanException {
        if (!clazz.isArray()) {
            throw new BeanException("The property's value is no array.");
        }
        if (object == null) {
            return Array.newInstance(clazz.getComponentType(), n + 1);
        }
        if (!object.getClass().isArray()) {
            throw new BeanException("The property's value is no array.");
        }
        int n2 = Array.getLength(object);
        if (n2 > n) {
            return object;
        }
        Object object2 = Array.newInstance(object.getClass().getComponentType(), n + 1);
        System.arraycopy(object, 0, object2, 0, n2);
        return object;
    }

    public void setPropertyAsString(String string, String string2) throws BeanException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Text must not be null");
        }
        PropertySpecification propertySpecification = new PropertySpecification(string);
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(propertySpecification.getName());
        if (propertyDescriptor == null) {
            throw new BeanException("No such property:" + string);
        }
        this.setPropertyAsString(string, BeanUtility.getPropertyType(propertyDescriptor), string2);
    }

    public Class getPropertyType(String string) throws BeanException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        PropertySpecification propertySpecification = new PropertySpecification(string);
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.properties.get(propertySpecification.getName());
        if (propertyDescriptor == null) {
            throw new BeanException("No such property:" + string);
        }
        return BeanUtility.getPropertyType(propertyDescriptor);
    }

    public static Class getPropertyType(PropertyDescriptor propertyDescriptor) throws BeanException {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz != null) {
            return clazz;
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
            return indexedPropertyDescriptor.getIndexedPropertyType();
        }
        throw new BeanException("Unable to determine the property type.");
    }

    public void setPropertyAsString(String string, Class clazz, String string2) throws BeanException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Type must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("Text must not be null");
        }
        PropertySpecification propertySpecification = new PropertySpecification(string);
        ValueConverter valueConverter = propertySpecification.getIndex() != null && clazz.isArray() ? ConverterRegistry.getInstance().getValueConverter(clazz.getComponentType()) : ConverterRegistry.getInstance().getValueConverter(clazz);
        if (valueConverter == null) {
            throw new BeanException("Unable to handle '" + clazz + "' for property '" + string + "'");
        }
        Object object = valueConverter.toPropertyValue(string2);
        this.setProperty(propertySpecification, object);
    }

    public String[] getProperties() throws BeanException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PropertyDescriptor[] propertyDescriptorArray = this.getPropertyInfos();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (propertyDescriptor.isHidden() || propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) continue;
            if (BeanUtility.getPropertyType(propertyDescriptor).isArray()) {
                int n = this.findMaximumIndex(propertyDescriptor);
                for (int j = 0; j < n; ++j) {
                    arrayList.add(propertyDescriptor.getName() + "[" + j + "]");
                }
                continue;
            }
            arrayList.add(propertyDescriptor.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private int findMaximumIndex(PropertyDescriptor propertyDescriptor) {
        try {
            Object object = this.getPropertyForSpecification(new PropertySpecification(propertyDescriptor.getName()));
            return Array.getLength(object);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static class PropertySpecification {
        private String raw;
        private String name;
        private String index;

        public PropertySpecification(String string) {
            this.raw = string;
            this.name = this.getNormalizedName(string);
            this.index = this.getIndex(string);
        }

        private String getNormalizedName(String string) {
            int n = string.indexOf(91);
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }

        private String getIndex(String string) {
            int n = string.indexOf(91);
            if (n < 0) {
                return null;
            }
            int n2 = string.indexOf(93, n + 1);
            if (n2 < 0) {
                return null;
            }
            return string.substring(n + 1, n2);
        }

        public String getRaw() {
            return this.raw;
        }

        public String getName() {
            return this.name;
        }

        public String getIndex() {
            return this.index;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("PropertySpecification={");
            stringBuffer.append("raw=");
            stringBuffer.append(this.raw);
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }
}

