/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.SecurityActions;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.common.util.SystemPropertiesUtil;
import org.keycloak.saml.processing.core.util.IDFedLSInputResolver;
import org.keycloak.saml.processing.core.util.SchemaManagerUtil;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class JAXPValidationUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static Validator validator;
    protected static SchemaFactory schemaFactory;

    public static void validate(InputStream stream) throws SAXException, IOException {
        try {
            JAXPValidationUtil.validator().validate(new StAXSource(StaxParserUtil.getXMLEventReader(stream)));
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    public static void checkSchemaValidation(Node samlDocument) throws ProcessingException {
        if (SecurityActions.getSystemProperty("picketlink.schema.validate", "false").equalsIgnoreCase("true")) {
            try {
                JAXPValidationUtil.validate(DocumentUtil.getNodeAsStream(samlDocument));
            }
            catch (Exception e) {
                throw logger.processingError(e);
            }
        }
    }

    public static Validator validator() throws SAXException, IOException {
        SystemPropertiesUtil.ensure();
        if (validator == null) {
            Schema schema = JAXPValidationUtil.getSchema();
            if (schema == null) {
                throw logger.nullValueError("schema");
            }
            validator = schema.newValidator();
            boolean successful1 = JAXPValidationUtil.setProperty(validator, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            boolean successful2 = JAXPValidationUtil.setFeature(validator, "http://apache.org/xml/features/disallow-doctype-decl", true);
            successful2 &= JAXPValidationUtil.setFeature(validator, "http://xml.org/sax/features/external-general-entities", false);
            if (!(successful1 &= JAXPValidationUtil.setProperty(validator, "http://javax.xml.XMLConstants/property/accessExternalSchema", "")) && !(successful2 &= JAXPValidationUtil.setFeature(validator, "http://xml.org/sax/features/external-parameter-entities", false))) {
                logger.warn("Cannot disable external access in XML validator");
            }
            validator.setErrorHandler(new CustomErrorHandler());
        }
        return validator;
    }

    private static boolean setProperty(Validator v, String property, String value) {
        try {
            v.setProperty(property, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            logger.debug("Cannot set " + property);
            return false;
        }
        return true;
    }

    private static boolean setFeature(Validator v, String feature, boolean value) {
        try {
            v.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            logger.debug("Cannot set " + feature);
            return false;
        }
        return true;
    }

    private static Schema getSchema() throws IOException {
        boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
        ClassLoader prevTCCL = SecurityActions.getTCCL();
        try {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(JAXPValidationUtil.class.getClassLoader());
            }
            schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new IDFedLSInputResolver());
            schemaFactory.setErrorHandler(new CustomErrorHandler());
        }
        finally {
            if (tccl_jaxp) {
                SecurityActions.setTCCL(prevTCCL);
            }
        }
        Schema schemaGrammar = null;
        try {
            schemaGrammar = schemaFactory.newSchema(JAXPValidationUtil.sources());
        }
        catch (SAXException e) {
            logger.xmlCouldNotGetSchema(e);
        }
        return schemaGrammar;
    }

    private static Source[] sources() throws IOException {
        List<String> schemas = SchemaManagerUtil.getSchemas();
        Source[] sourceArr = new Source[schemas.size()];
        int i = 0;
        for (String schema : schemas) {
            URL url = SecurityActions.loadResource(JAXPValidationUtil.class, schema);
            if (url == null) {
                throw logger.nullValueError("schema url:" + schema);
            }
            sourceArr[i++] = new StreamSource(url.openStream());
        }
        return sourceArr;
    }

    private static class CustomErrorHandler
    implements ErrorHandler {
        private CustomErrorHandler() {
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.logException(ex);
            if (!ex.getMessage().contains("null")) {
                throw ex;
            }
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.logException(ex);
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            this.logException(ex);
        }

        private void logException(SAXParseException sax) {
            StringBuilder builder = new StringBuilder();
            if (logger.isTraceEnabled()) {
                builder.append("[line:").append(sax.getLineNumber()).append(",").append("::col=").append(sax.getColumnNumber()).append("]");
                builder.append("[publicID:").append(sax.getPublicId()).append(",systemId=").append(sax.getSystemId()).append("]");
                builder.append(":").append(sax.getLocalizedMessage());
                logger.trace(builder.toString());
            }
        }
    }
}

