/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.LocalVarAllocator;
import io.quarkus.gizmo2.impl.LocalVarDecrement;
import io.quarkus.gizmo2.impl.LocalVarIncrement;
import io.quarkus.gizmo2.impl.LocalVarSet;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;

public final class LocalVarImpl
extends AssignableImpl
implements LocalVar {
    private final String name;
    private final GenericType type;
    private final BlockCreatorImpl owner;
    int slot = -1;

    LocalVarImpl(BlockCreatorImpl owner, String name, GenericType type) {
        this.name = name;
        this.type = type;
        this.owner = owner;
    }

    @Override
    public String itemName() {
        return "LocalVar:" + this.name;
    }

    @Override
    public BlockCreator block() {
        return this.owner;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ClassDesc type() {
        return this.type.desc();
    }

    @Override
    public GenericType genericType() {
        return this.type;
    }

    @Override
    public boolean bound() {
        return false;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        this.checkSlot();
        cb.loadLocal(Util.actualKindOf(this.typeKind()), this.slot);
    }

    void checkSlot() {
        if (this.slot == -1) {
            if (this.creationSite == null) {
                throw new IllegalStateException("Local variable '" + this.name + "' was not allocated (check if it was declared on the correct BlockCreator or if it was captured if you're generating a lambda)\nTo track callers and get an improved exception message, add the system property `gizmo.debug`");
            }
            throw new IllegalStateException("Local variable '" + this.name + "' created at " + this.creationSite + " was not allocated (check if it was declared on the correct BlockCreator or if it was captured if you're generating a lambda)");
        }
    }

    Item allocator() {
        return new LocalVarAllocator(this);
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        return this.asBound();
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return new LocalVarSet(this, value);
    }

    @Override
    void emitInc(BlockCreatorImpl block, Const amount) {
        if (this.typeKind().asLoadable() == TypeKind.INT) {
            block.addItem(new LocalVarIncrement(this, amount));
        } else {
            super.emitInc(block, amount);
        }
    }

    @Override
    void emitDec(BlockCreatorImpl block, Const amount) {
        if (this.typeKind().asLoadable() == TypeKind.INT) {
            block.addItem(new LocalVarDecrement(this, amount));
        } else {
            super.emitDec(block, amount);
        }
    }
}

