/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.sasl.digest.AbstractDigestFactory;
import org.wildfly.security.sasl.digest.DigestSaslServer;

public class DigestServerFactory
extends AbstractDigestFactory
implements SaslServerFactory {
    private final Supplier<Provider[]> providers;

    public DigestServerFactory() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public DigestServerFactory(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Predicate<String> protocolTest;
        boolean defaultRealm;
        if (!this.matches(props, false) || !this.matchesMech(mechanism)) {
            return null;
        }
        Assert.checkNotNullParam((String)"cbh", (Object)cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        String[] realms = null;
        AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
        try {
            cbh.handle(new Callback[]{availableRealmsCallback});
            realms = availableRealmsCallback.getRealmNames();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
        }
        catch (SaslException e) {
            throw e;
        }
        catch (IOException e) {
            throw ElytronMessages.saslDigest.mechCallbackHandlerFailedForUnknownReason((Throwable)e).toSaslException();
        }
        if (realms == null) {
            defaultRealm = true;
            realms = new String[]{serverName};
        } else {
            defaultRealm = false;
        }
        String utf8 = (String)props.get("com.sun.security.sasl.digest.utf8");
        Charset charset = utf8 == null || Boolean.parseBoolean(utf8) ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        String qopsString = (String)props.get("javax.security.sasl.qop");
        String[] qops = qopsString == null ? null : qopsString.split(",");
        String supportedCipherOpts = (String)props.get("wildfly.security.sasl.digest.ciphers");
        String[] cipherOpts = supportedCipherOpts == null ? null : supportedCipherOpts.split(",");
        String alternativeProtocols = (String)props.get("wildfly.sasl.digest.alternative_protocols");
        if (alternativeProtocols != null) {
            HashSet<String> acceptableProtocols = new HashSet<String>();
            acceptableProtocols.add(protocol.toLowerCase(Locale.ROOT));
            StringTokenizer parser = new StringTokenizer(alternativeProtocols, ", \t\n");
            while (parser.hasMoreTokens()) {
                acceptableProtocols.add(parser.nextToken().trim().toLowerCase(Locale.ROOT));
            }
            protocolTest = acceptableProtocols::contains;
        } else {
            protocolTest = protocol.toLowerCase(Locale.ROOT)::equals;
        }
        DigestSaslServer server = new DigestSaslServer(realms, defaultRealm, mechanism, protocol, serverName, cbh, charset, qops, cipherOpts, protocolTest, this.providers);
        server.init();
        return server;
    }
}

