/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DisallowedMethodsHandler
implements HttpHandler {
    private final Set<String> disallowedMethods;
    private final HttpHandler next;

    public DisallowedMethodsHandler(HttpHandler next, Set<String> disallowedMethods) {
        this.disallowedMethods = new HashSet<String>(disallowedMethods);
        this.next = next;
    }

    public DisallowedMethodsHandler(HttpHandler next, String ... disallowedMethods) {
        this.disallowedMethods = new HashSet<String>(Arrays.asList(disallowedMethods));
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.disallowedMethods.contains(exchange.getRequestMethod())) {
            exchange.setStatusCode(405);
            exchange.endExchange();
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String[] methods;

        private Wrapper(String[] methods) {
            this.methods = methods;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new DisallowedMethodsHandler(handler, this.methods);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "disallowed-methods";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("methods", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("methods");
        }

        @Override
        public String defaultParameter() {
            return "methods";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String[])config.get("methods"));
        }
    }
}

