/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class TXT
extends Data {
    private final byte[] blob;
    private transient String textCache;
    private transient List<String> characterStringsCache;

    public static TXT parse(DataInputStream dis, int length) throws IOException {
        byte[] blob = new byte[length];
        dis.readFully(blob);
        return new TXT(blob);
    }

    public TXT(byte[] blob) {
        this.blob = blob;
    }

    public byte[] getBlob() {
        return (byte[])this.blob.clone();
    }

    public String getText() {
        if (this.textCache == null) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.getCharacterStrings().iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append(" / ");
            }
            this.textCache = sb.toString();
        }
        return this.textCache;
    }

    public List<String> getCharacterStrings() {
        if (this.characterStringsCache == null) {
            List<byte[]> extents = this.getExtents();
            ArrayList<String> characterStrings = new ArrayList<String>(extents.size());
            for (byte[] extent : extents) {
                try {
                    characterStrings.add(new String(extent, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.characterStringsCache = Collections.unmodifiableList(characterStrings);
        }
        return this.characterStringsCache;
    }

    public List<byte[]> getExtents() {
        ArrayList<byte[]> extents = new ArrayList<byte[]>();
        int segLength = 0;
        for (int used = 0; used < this.blob.length; used += segLength) {
            segLength = 0xFF & this.blob[used];
            int end = ++used + segLength;
            byte[] extent = Arrays.copyOfRange(this.blob, used, end);
            extents.add(extent);
        }
        return extents;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.write(this.blob);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.TXT;
    }

    public String toString() {
        return "\"" + this.getText() + "\"";
    }
}

