/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    public static <T> boolean equals(T one, T two) {
        return one == null ? two == null : one.equals(two);
    }

    public static int hashCode(Object object) {
        return object == null ? 31 : object.hashCode();
    }

    public static synchronized String getRandomState(Random random) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(random);
            oos.flush();
        }
        byte[] bytes = bos.toByteArray();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(HEX_DIGITS.charAt(b >> 4 & 0xF));
            sb.append(HEX_DIGITS.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static synchronized Random restoreRandomState(String state) {
        if (state == null || state.isEmpty()) {
            return null;
        }
        byte[] bytes = new byte[state.length() / 2];
        int pos = 0;
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)HEX_DIGITS.indexOf(state.charAt(pos++));
            int n = i;
            bytes[n] = (byte)(bytes[n] << 4);
            int n2 = i++;
            bytes[n2] = (byte)(bytes[n2] | (byte)HEX_DIGITS.indexOf(state.charAt(pos++)));
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bis);
            return (Random)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.log(Level.WARNING, "Unable to restore random state.", e);
            return null;
        }
    }

    public static Reader getFileUTF8Reader(File file) {
        try {
            InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
            return new InputStreamReader(fis, StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "No input stream for " + file.getPath(), ioe);
            return null;
        }
    }

    public static String getUTF8Contents(File file) {
        String ret = null;
        Reader reader = Utils.getFileUTF8Reader(file);
        if (reader != null) {
            CharBuffer cb = CharBuffer.allocate((int)file.length());
            try {
                reader.read(cb);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Read failed for " + file.getPath(), ioe);
            }
            cb.flip();
            ret = cb.toString();
            try {
                reader.close();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Failed to close", ioe);
            }
        }
        return ret;
    }

    public static Writer getUTF8Writer(OutputStream os) {
        return new OutputStreamWriter(os, StandardCharsets.UTF_8);
    }

    private static Writer getF8W(File file, boolean append) {
        try {
            OutputStream fos = append ? Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND) : Files.newOutputStream(file.toPath(), new OpenOption[0]);
            return Utils.getUTF8Writer(fos);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "No output stream for " + file.getName(), ioe);
            return null;
        }
    }

    public static Writer getFileUTF8Writer(File file) {
        return Utils.getF8W(file, false);
    }

    public static Writer getFileUTF8AppendWriter(File file) {
        return Utils.getF8W(file, true);
    }

    public static Transformer makeTransformer(boolean declaration, boolean indent) {
        Transformer tf = null;
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            factory.setAttribute("indent-number", 2);
            tf = factory.newTransformer();
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("method", "xml");
            if (!declaration) {
                tf.setOutputProperty("omit-xml-declaration", "yes");
            }
            if (indent) {
                tf.setOutputProperty("indent", "yes");
                tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
        }
        catch (TransformerException e) {
            logger.log(Level.WARNING, "Failed to install transformer!", e);
        }
        return tf;
    }

    public static void deleteFile(File file) {
        try {
            if (!file.delete()) {
                logger.warning("Failed to delete: " + file.getPath());
            }
        }
        catch (SecurityException ex) {
            logger.log(Level.WARNING, "Exception deleting: " + file.getPath(), ex);
        }
    }

    public static void deleteFiles(List<File> files) {
        for (File f : files) {
            Utils.deleteFile(f);
        }
    }

    public static boolean fileAnySuffix(File file, String ... suffixes) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return false;
        }
        String name = file.getName();
        for (String s : suffixes) {
            if (!name.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean directoryAllPresent(File dir, String ... names) {
        if (dir == null || !dir.isDirectory() || !dir.canRead()) {
            return false;
        }
        for (String n : names) {
            if (new File(dir, n).canRead()) continue;
            return false;
        }
        return true;
    }

    public static void delay(long ms, String warning) {
        try {
            TimeUnit.MILLISECONDS.sleep(ms);
        }
        catch (InterruptedException ie) {
            if (warning == null) {
                Thread.currentThread().interrupt();
            }
            logger.log(Level.WARNING, warning, ie);
        }
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="Deliberate")
    public static void garbageCollect() {
        System.gc();
    }

    public static boolean isHeadless() {
        return "true".equals(System.getProperty("java.awt.headless", "false"));
    }

    public static GraphicsDevice getGoodGraphicsDevice() {
        try {
            return MouseInfo.getPointerInfo().getDevice();
        }
        catch (HeadlessException headlessException) {
            try {
                GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                return lge.getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException2) {
                return null;
            }
        }
    }

    public static int determineDpi(GraphicsDevice gd) {
        int candidateDpi = Toolkit.getDefaultToolkit().getScreenResolution();
        DisplayMode[] displayModes = gd.getDisplayModes();
        if (displayModes.length <= 1) {
            return candidateDpi;
        }
        int highestScreenSize = Arrays.stream(displayModes).map(dm -> dm.getHeight()).max(Integer::compare).get();
        int currentScreenSize = gd.getDisplayMode().getHeight();
        int actualDpi = candidateDpi * currentScreenSize / highestScreenSize;
        return actualDpi;
    }
}

