/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public final class ContextMappingIterator
implements SequenceIterator {
    private final FocusIterator base;
    private final ContextMappingFunction action;
    private final XPathContext context;
    private SequenceIterator stepIterator = null;
    private boolean discharged;

    public ContextMappingIterator(ContextMappingFunction action, XPathContext context) {
        this.base = context.getCurrentIterator();
        this.action = action;
        this.context = context;
    }

    @Override
    public Item next() {
        Item nextItem;
        block6: {
            while (true) {
                if (this.stepIterator != null) {
                    nextItem = this.stepIterator.next();
                    if (nextItem != null) break block6;
                    this.stepIterator = null;
                }
                if (this.base.next() == null) break;
                try {
                    this.stepIterator = this.action.map(this.context);
                    if (this.discharged) {
                        this.stepIterator.discharge();
                    }
                }
                catch (XPathException e) {
                    throw new UncheckedXPathException(e);
                }
                nextItem = this.stepIterator.next();
                if (nextItem == null) {
                    this.stepIterator = null;
                    continue;
                }
                break block6;
                break;
            }
            this.stepIterator = null;
            return null;
        }
        return nextItem;
    }

    @Override
    public void close() {
        this.base.close();
        if (this.stepIterator != null) {
            this.stepIterator.close();
        }
    }

    @Override
    public void discharge() {
        this.base.discharge();
        if (this.stepIterator != null) {
            this.stepIterator.discharge();
        }
        this.discharged = true;
    }
}

