/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.etl.kettle.KettleJob;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.KettleJobPanel;
import ca.sqlpower.architect.swingui.UserRepositoryDirectoryChooser;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.util.Monitorable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.pentaho.di.core.exception.KettleException;

public class KettleJobAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(KettleJobAction.class);

    public KettleJobAction(ArchitectFrame frame) {
        super(frame, Messages.getString("KettleJobAction.name"), Messages.getString("KettleJobAction.description"));
        this.putValue("ShortDescription", Messages.getString("KettleJobAction.shortDescription"));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        logger.debug((Object)"Starting to create a Kettle job.");
        JPanel cp = new JPanel(new BorderLayout(12, 12));
        cp.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final KettleJobPanel kettleETLPanel = new KettleJobPanel(this.getSession());
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (!kettleETLPanel.applyChanges()) {
                    return Boolean.FALSE;
                }
                UserRepositoryDirectoryChooser chooser = new UserRepositoryDirectoryChooser(KettleJobAction.this.frame);
                final KettleJob kettleJob = KettleJobAction.this.getSession().getKettleJob();
                kettleJob.setRepositoryDirectoryChooser(chooser);
                final JDialog createKettleJobMonitor = new JDialog(KettleJobAction.this.frame);
                createKettleJobMonitor.setTitle(Messages.getString("KettleJobAction.progressDialogTitle"));
                FormLayout layout = new FormLayout("pref", "");
                DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                builder.setDefaultDialogBorder();
                builder.append(Messages.getString("KettleJobAction.progressDialogTitle"));
                builder.nextLine();
                JProgressBar progressBar = new JProgressBar();
                builder.append((Component)progressBar);
                builder.nextLine();
                JButton cancel = new JButton(Messages.getString("KettleJobAction.cancelOption"));
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        kettleJob.setCancelled(true);
                    }
                });
                builder.append((Component)cancel);
                createKettleJobMonitor.add(builder.getPanel());
                SPSwingWorker compareWorker = new SPSwingWorker(KettleJobAction.this.getSession()){

                    public void doStuff() throws Exception {
                        createKettleJobMonitor.pack();
                        createKettleJobMonitor.setLocationRelativeTo(KettleJobAction.this.frame);
                        createKettleJobMonitor.setVisible(true);
                        List<SQLTable> tableList = KettleJobAction.this.getSession().getPlayPen().getTables();
                        kettleJob.doExport(tableList, KettleJobAction.this.getSession().getTargetDatabase());
                    }

                    public void cleanup() throws Exception {
                        createKettleJobMonitor.dispose();
                        if (this.getDoStuffException() != null) {
                            Throwable ex = this.getDoStuffException();
                            if (ex instanceof SQLObjectException) {
                                ASUtils.showExceptionDialog(KettleJobAction.this.getSession(), Messages.getString("KettleJobAction.errorReadingTables"), ex);
                            } else if (ex instanceof RuntimeException || ex instanceof IOException || ex instanceof SQLException) {
                                StringBuffer buffer = new StringBuffer();
                                buffer.append(Messages.getString("KettleJobAction.runtimeError")).append("\n");
                                for (String task : kettleJob.getTasksToDo()) {
                                    buffer.append(task).append("\n");
                                }
                                ASUtils.showExceptionDialog(KettleJobAction.this.getSession(), buffer.toString(), ex);
                            } else if (ex instanceof KettleException) {
                                ASUtils.showExceptionDialog(KettleJobAction.this.getSession(), Messages.getString("KettleJobAction.kettleExceptionDuringExport") + "\n" + ex.getMessage().trim(), ex);
                            } else {
                                ASUtils.showExceptionDialog(KettleJobAction.this.getSession(), Messages.getString("KettleJobAction.unexpectedExceptionDuringExport"), ex);
                            }
                            return;
                        }
                        final JDialog toDoListDialog = new JDialog(KettleJobAction.this.frame);
                        toDoListDialog.setTitle(Messages.getString("KettleJobAction.kettleTasksDialogTitle"));
                        FormLayout layout = new FormLayout("10dlu, 2dlu, fill:pref:grow, 12dlu", "pref, fill:pref:grow, pref");
                        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
                        builder.setDefaultDialogBorder();
                        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
                        JTextArea toDoList = new JTextArea(10, 60);
                        toDoList.setEditable(false);
                        List<String> tasksToDo = kettleJob.getTasksToDo();
                        for (String task : tasksToDo) {
                            toDoList.append(task + "\n");
                        }
                        JButton close = new JButton(Messages.getString("KettleJobAction.closeOption"));
                        close.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                toDoListDialog.dispose();
                            }
                        });
                        builder.nextColumn(2);
                        builder.append(Messages.getString("KettleJobAction.kettleTasksInstructions"));
                        builder.nextLine();
                        builder.append("");
                        builder.append((Component)new JScrollPane(toDoList));
                        builder.nextLine();
                        builder.append("");
                        buttonBarBuilder.addGlue();
                        buttonBarBuilder.addGridded((JComponent)close);
                        buttonBarBuilder.addGlue();
                        builder.append((Component)buttonBarBuilder.getPanel());
                        toDoListDialog.add(builder.getPanel());
                        toDoListDialog.pack();
                        toDoListDialog.setLocationRelativeTo(KettleJobAction.this.frame);
                        toDoListDialog.setVisible(true);
                    }
                };
                new Thread((Runnable)compareWorker).start();
                ProgressWatcher.watchProgress((JProgressBar)progressBar, (Monitorable)kettleJob);
                return Boolean.TRUE;
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return Boolean.TRUE;
            }
        };
        JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)kettleETLPanel, (Component)this.getSession().getArchitectFrame(), (String)Messages.getString("KettleJobAction.dialogTitle"), (String)Messages.getString("KettleJobAction.okOption"), (Callable)okCall, (Callable)cancelCall);
        d.pack();
        d.setLocationRelativeTo(this.getSession().getArchitectFrame());
        d.setVisible(true);
    }
}

