/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.Config;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.exceptions.UndefinedResObjectException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResEnumAttr;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFlagsAttr;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.decoder.StringBlock;
import brut.util.ExtDataInputStream;
import com.google.common.io.CountingInputStream;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ARSCDecoder {
    public static final Logger LOGGER;
    public static final /* synthetic */ boolean $assertionsDisabled;
    public final ExtDataInputStream mIn;
    public final ResTable mResTable;
    public final ArrayList mFlagsOffsets;
    public final boolean mKeepBroken;
    public final Config mConfig;
    public final HashMap mResTypeSpecs;
    public final LinkedHashMap mMissingResSpecs;
    public final HashSet mInvalidResConfigFlags;
    public ARSCHeader mHeader;
    public StringBlock mTableStrings;
    public StringBlock mTypeNames;
    public StringBlock mSpecNames;
    public ResPackage mPackage;
    public ResTypeSpec mTypeSpec;
    public ResType mType;
    public int mResId;
    public int mTypeIdOffset;

    public ARSCDecoder(InputStream object, ResTable resTable, boolean bl, boolean bl2) {
        ExtDataInputStream extDataInputStream;
        LittleEndianDataInputStream littleEndianDataInputStream;
        CountingInputStream countingInputStream;
        CountingInputStream countingInputStream2 = countingInputStream;
        countingInputStream = new CountingInputStream((InputStream)object);
        object = littleEndianDataInputStream;
        littleEndianDataInputStream = new LittleEndianDataInputStream(countingInputStream2);
        ExtDataInputStream extDataInputStream2 = extDataInputStream;
        extDataInputStream = new ExtDataInputStream((DataInput)object, countingInputStream2);
        this.mIn = extDataInputStream2;
        this.mResTable = resTable;
        if (bl) {
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
        } else {
            object = null;
        }
        ARSCDecoder aRSCDecoder = this;
        this.mFlagsOffsets = object;
        this.mKeepBroken = bl2;
        aRSCDecoder.mConfig = resTable.mConfig;
        aRSCDecoder.mResTypeSpecs = new HashMap();
        aRSCDecoder.mMissingResSpecs = new LinkedHashMap();
        aRSCDecoder.mInvalidResConfigFlags = new HashSet();
    }

    static {
        $assertionsDisabled = ARSCDecoder.class.desiredAssertionStatus() ^ true;
        LOGGER = Logger.getLogger(ARSCDecoder.class.getName());
    }

    public static String unpackLanguageOrRegion(byte[] byArray, char c) {
        if (!$assertionsDisabled && byArray.length != 2) {
            throw new AssertionError();
        }
        byte by = byArray[0];
        if (by == 0) {
            return "";
        }
        if ((by & 0x80) != 0) {
            char c2 = c;
            byte by2 = byArray[1];
            byte by3 = (byte)(c + (by2 & 0x1F));
            c = (char)(c + ((by2 & 0xE0) >>> 5) + ((by & 3) << 3));
            by = (byte)(c2 + ((by & 0x7C) >>> 2));
            byte[] byArray2 = new byte[3];
            byte[] byArray3 = byArray2;
            byArray2[0] = by3;
            byArray2[1] = c;
            byArray2[2] = by;
            byArray = byArray3;
        }
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final ARSCData decode() {
        FlagsOffset[] flagsOffsetArray;
        block3: {
            try {
                ResPackage[] resPackageArray = resPackageArray.readResourceTable();
                flagsOffsetArray = resPackageArray.mFlagsOffsets;
                if (resPackageArray.mFlagsOffsets == null) break block3;
            }
            catch (IOException iOException) {
                throw new AndrolibException("Could not decode arsc file", iOException);
            }
            flagsOffsetArray = flagsOffsetArray.toArray(new FlagsOffset[0]);
            return new ARSCData(resPackageArray, flagsOffsetArray);
        }
        flagsOffsetArray = null;
        return new ARSCData(resPackageArray, flagsOffsetArray);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final ResPackage[] readResourceTable() {
        var1_1 = v0;
        v0 = new LinkedHashSet<ResPackage>();
        var2_2 = 1;
        block29: while (true) {
            block118: {
                block119: {
                    block120: {
                        block116: {
                            var3_5 = this.mIn;
                            var4_21 = var3_5.mCountIn.count;
                            try {
                                var6_47 = var3_5.mDelegate.readUnsignedShort();
                            }
                            catch (EOFException v3) {
                                var7_52 = v4;
                                var3_6 = 0;
                                var4_22 = 0;
                                var5_31 = var3_5.mCountIn.count;
                                v4 = new ARSCHeader(-1, var3_6, var4_22, var5_31);
                            }
                            var7_52 = v1;
                            v2 = var3_5;
                            var3_6 = v2.mDelegate.readUnsignedShort();
                            v1 = new ARSCHeader(var6_47, var3_6, v2.mDelegate.readInt(), var4_21);
                            this.mHeader = var7_52;
                            var3_7 = ARSCDecoder.LOGGER;
                            var4_23 = var2_2++;
                            var5_32 = this.mIn.mCountIn.count;
                            var6_48 = this.mHeader.type;
                            var7_52 = this.mHeader.chunkSize;
                            var3_7.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", new Object[]{var4_23, var5_32, var6_48, var7_52}));
                            var4_24 = this.mHeader.type;
                            if (var4_24 == 0) break block118;
                            if (var4_24 == 1) break block119;
                            if (var4_24 == 2) break block120;
                            switch (var4_24) {
                                default: {
                                    if (var4_24 != -1) {
                                        v5 = var3_7;
                                        var2_3 = var4_24;
                                        v6 = new Object[1];
                                        var3_7 = v6;
                                        v6[0] = var2_3;
                                        v5.severe(String.format("Unknown chunk type: %04x", (Object[])var3_7));
                                    }
                                    if (this.mConfig.mDecodeResolve == 2 && (var2_4 = this.mPackage) != null && var2_4.mResSpecs.size() > 0) {
                                        for (Object var3_7 : this.mMissingResSpecs.keySet()) {
                                            var4_25 = var3_7.intValue();
                                            var3_7 = (Integer)this.mMissingResSpecs.get(var3_7);
                                            var3_7.getClass();
                                            var5_32 = "APKTOOL_DUMMY_" + Integer.toHexString(var4_25);
                                            var6_48 = v7;
                                            v7 = new ResID(var4_25);
                                            var4_26 = v8;
                                            var3_7 = (ResTypeSpec)this.mResTypeSpecs.get(var3_7);
                                            v8 = new ResResSpec((ResID)var6_48, (String)var5_32, this.mPackage, (ResTypeSpec)var3_7);
                                            if (this.mPackage.mResSpecs.containsKey(var6_48)) continue;
                                            if (this.mPackage.mResSpecs.put(var6_48, var4_26) == null) {
                                                var4_26.mType.addResSpec(var4_26);
                                                var3_7 = this.mPackage;
                                                var5_32 = v9;
                                                v9 = new ResConfigFlags();
                                                var6_48 = (ResType)var3_7.mConfigs.get(var5_32);
                                                if (var6_48 == null) {
                                                    var6_48 = v10;
                                                    v10 = new ResType((ResConfigFlags)var5_32);
                                                    var3_7.mConfigs.put(var5_32, var6_48);
                                                }
                                                var3_7 = v11;
                                                v11 = new ResReferenceValue(this.mPackage, "");
                                                var5_32 = v12;
                                                var6_48.addResource(new ResResource((ResType)var6_48, var4_26, (ResValue)var3_7), false);
                                                var4_26.addResource((ResResource)var5_32, false);
                                                continue;
                                            }
                                            throw new AndrolibException("Multiple resource specs: " + var4_26);
                                        }
                                    }
                                    return var1_1.toArray(new ResPackage[0]);
                                }
                                case 518: {
                                    var3_8 = this.mIn.mDelegate.readInt();
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    var4_24 = 0;
                                    while (true) {
                                        if (var4_24 >= var3_8) continue block29;
                                        var5_32 = this.mIn.mDelegate.readInt();
                                        var6_48 = this.mIn.mDelegate.readInt();
                                        ARSCDecoder.LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", new Object[]{var5_32, var6_48}));
                                        ++var4_24;
                                    }
                                }
                                case 517: {
                                    this.checkChunkType(517);
                                    this.mIn.mDelegate.readInt();
                                    var3_9 = this.mIn.mDelegate.readInt();
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    var4_24 = 0;
                                    while (true) {
                                        if (var4_24 >= var3_9) continue block29;
                                        var5_32 = this.mIn.mDelegate.readInt();
                                        ARSCDecoder.LOGGER.fine(String.format("Skipping overlay (%h)", new Object[]{var5_32}));
                                        ++var4_24;
                                    }
                                }
                                case 516: {
                                    v13 = var3_7;
                                    this.checkChunkType(516);
                                    var3_7 = this.mIn.readUtf16(256);
                                    var4_27 = this.mIn.readUtf16(256);
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    v14 = var5_32 = v15;
                                    var5_32("Overlay name: \"");
                                    v14.append((String)var3_7);
                                    v14.append("\", actor: \"");
                                    v15.append(var4_27);
                                    v15.append("\"");
                                    v13.fine(v15.toString());
                                    continue block29;
                                }
                                case 515: {
                                    this.checkChunkType(515);
                                    var3_10 = this.mIn.mDelegate.readInt();
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    var4_24 = 0;
                                    while (true) {
                                        if (var4_24 >= var3_10) continue block29;
                                        var5_33 = this.mIn.mDelegate.readInt();
                                        var6_48 = this.mIn.readUtf16(128);
                                        this.mResTable.mDynamicRefTable.put(var5_33, var6_48);
                                        var5_32 = var5_33;
                                        v16 = new Object[2];
                                        var7_52 = v16;
                                        v16[0] = var5_32;
                                        v16[1] = var6_48;
                                        ARSCDecoder.LOGGER.fine(String.format("Shared library id: %d, name: \"%s\"", var7_52));
                                        ++var4_24;
                                    }
                                }
                                case 514: {
                                    this.checkChunkType(514);
                                    var3_11 = this.mIn.mDelegate.readUnsignedByte();
                                    this.mIn.mDelegate.readByte();
                                    this.mIn.mDelegate.readShort();
                                    var4_24 = this.mIn.mDelegate.readInt();
                                    var5_32 = this.mFlagsOffsets;
                                    if (var5_32 != null) {
                                        var5_32.add(new FlagsOffset((int)this.mIn.mCountIn.count, var4_24));
                                    }
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    for (var5_34 = 0; var5_34 < var4_24; ++var5_34) {
                                        this.mIn.mDelegate.readInt();
                                    }
                                    var4_28 = v17;
                                    var3_12 = this.mTypeNames.getString(var3_11 - 1);
                                    v17 = new ResTypeSpec(var3_11, (String)var3_12);
                                    this.mTypeSpec = var4_28;
                                    var5_35 = this.mPackage;
                                    if (var5_35.mTypes.containsKey(var3_12)) {
                                        ResPackage.LOGGER.warning("Multiple types detected! " + var4_28 + " ignored!");
                                    } else {
                                        var5_35.mTypes.put(var3_12, var4_28);
                                    }
                                    var3_12 = this.mTypeSpec;
                                    this.mResTypeSpecs.put(var3_12.mId, var3_12);
                                    continue block29;
                                }
                                case 513: {
                                    this.checkChunkType(513);
                                    var4_24 = this.mIn.mDelegate.readUnsignedByte() - this.mTypeIdOffset;
                                    if (this.mResTypeSpecs.containsKey(var4_24)) {
                                        this.mTypeSpec = (ResTypeSpec)this.mResTypeSpecs.get(var4_24);
                                    } else {
                                        var5_32 = v18;
                                        v18 = new ResTypeSpec(var4_24, this.mTypeNames.getString(var4_24 - 1));
                                        this.mTypeSpec = var5_32;
                                        this.mResTypeSpecs.put(var4_24, this.mTypeSpec);
                                        var5_32 = this.mPackage;
                                        var6_48 = this.mTypeSpec;
                                        if (var5_32.mTypes.containsKey(var6_48.mName)) {
                                            ResPackage.LOGGER.warning("Multiple types detected! " + var6_48 + " ignored!");
                                        } else {
                                            var5_32.mTypes.put(var6_48.mName, var6_48);
                                        }
                                    }
                                    this.mResId = this.mResId & -16777216 | this.mTypeSpec.mId << 16;
                                    var5_36 = this.mIn.mDelegate.readUnsignedByte();
                                    this.mIn.mDelegate.readShort();
                                    var6_49 = this.mIn.mDelegate.readInt();
                                    var7_53 = this.mIn.mDelegate.readInt();
                                    var7_54 = this.mHeader.startPosition + (long)var7_53;
                                    var9_55 = this.mIn.mDelegate.readInt();
                                    var10_64 = 8;
                                    if (var9_55 < 8) ** GOTO lbl594
                                    var11_68 = 0;
                                    var12_77 = this.mIn.mDelegate.readUnsignedShort();
                                    var13_81 = this.mIn.mDelegate.readUnsignedShort();
                                    var14_84 = "";
                                    var15_89 = "";
                                    if (var9_55 >= 12) {
                                        var10_65 = this.mIn;
                                        var10_65.getClass();
                                        v19 = new byte[2];
                                        var10_65.mDelegate.readFully(v19);
                                        var14_84 = ARSCDecoder.unpackLanguageOrRegion(v19, 'a');
                                        var10_65 = this.mIn;
                                        var10_65.getClass();
                                        v20 = new byte[2];
                                        var10_65.mDelegate.readFully(v20);
                                        var15_89 = ARSCDecoder.unpackLanguageOrRegion(v20, '0');
                                        var10_64 = 12;
                                    }
                                    var16_91 = 0;
                                    var17_93 = 0;
                                    if (var9_55 >= 14) {
                                        var16_91 = this.mIn.mDelegate.readUnsignedByte();
                                        var17_93 = this.mIn.mDelegate.readUnsignedByte();
                                        var10_64 = 14;
                                    }
                                    var18_96 = 0;
                                    if (var9_55 >= 16) {
                                        var18_96 = this.mIn.mDelegate.readUnsignedShort();
                                        var10_64 = 16;
                                    }
                                    var19_99 = 0;
                                    var20_100 = 0;
                                    var21_102 = 0;
                                    var22_104 = 0;
                                    if (var9_55 >= 20) {
                                        var19_99 = this.mIn.mDelegate.readUnsignedByte();
                                        var20_100 = this.mIn.mDelegate.readUnsignedByte();
                                        var21_102 = this.mIn.mDelegate.readUnsignedByte();
                                        var22_104 = this.mIn.mDelegate.readUnsignedByte();
                                        var10_64 = 20;
                                    }
                                    var23_105 = 0;
                                    var24_107 = 0;
                                    var25_108 = 0;
                                    if (var9_55 >= 28) {
                                        var23_105 = this.mIn.mDelegate.readUnsignedShort();
                                        var24_107 = this.mIn.mDelegate.readUnsignedShort();
                                        var25_108 = this.mIn.mDelegate.readUnsignedShort();
                                        this.mIn.mDelegate.readUnsignedShort();
                                        var10_64 = 28;
                                    }
                                    var26_110 = false;
                                    var27_111 = 0;
                                    var28_112 = 0;
                                    if (var9_55 >= 32) {
                                        var26_110 = this.mIn.mDelegate.readUnsignedByte();
                                        var27_111 = this.mIn.mDelegate.readUnsignedByte();
                                        var28_112 = this.mIn.mDelegate.readUnsignedShort();
                                        var10_64 = 32;
                                    }
                                    var29_113 = 0;
                                    var30_114 = 0;
                                    if (var9_55 >= 36) {
                                        var29_113 = this.mIn.mDelegate.readUnsignedShort();
                                        var30_114 = this.mIn.mDelegate.readUnsignedShort();
                                        var10_64 = 36;
                                    }
                                    var31_115 = "";
                                    var32_116 = "";
                                    if (var9_55 >= 48) {
                                        var31_115 = this.mIn.readAscii(4);
                                        var32_116 = this.mIn.readAscii(8);
                                        var10_64 = 48;
                                    }
                                    var33_117 = 0;
                                    var34_118 = 0;
                                    if (var9_55 >= 52) {
                                        var33_117 = this.mIn.mDelegate.readUnsignedByte();
                                        var34_118 = this.mIn.mDelegate.readUnsignedByte();
                                        this.mIn.mDelegate.readShort();
                                        var10_64 = 52;
                                    }
                                    if (var9_55 >= 60) {
                                        this.mIn.readAscii(8);
                                        var10_64 = 60;
                                    }
                                    if ((var35_119 = var9_55 - 64) > 0) {
                                        v21 = var35_119;
                                        var10_66 = this.mIn;
                                        var10_66.getClass();
                                        var35_120 /* !! */  = new byte[v21];
                                        var10_66.mDelegate.readFully(var35_120 /* !! */ );
                                        var10_64 += v21;
                                        var36_121 = v22;
                                        if (new BigInteger(1, var35_120 /* !! */ ).equals(BigInteger.ZERO)) {
                                            v23 = var3_7;
                                            var3_7 = 64;
                                            v24 = new Object[1];
                                            var35_120 /* !! */  = (byte[])v24;
                                            v24[0] = var3_7;
                                            v23.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", var35_120 /* !! */ ));
                                        } else {
                                            v25 = var3_7;
                                            var3_7 = 64;
                                            var11_69 = var9_55;
                                            v26 = new Object[3];
                                            var35_120 /* !! */  = (byte[])v26;
                                            v26[0] = var3_7;
                                            v26[1] = var11_69;
                                            v26[2] = var36_121;
                                            v25.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", var35_120 /* !! */ ));
                                            var11_68 = 1;
                                        }
                                    }
                                    if ((var3_13 = var9_55 - var10_64) > 0) {
                                        this.mIn.skipBytes(var3_13);
                                    }
                                    var3_14 = v27;
                                    v27 = new ResConfigFlags(var12_77, var13_81, (String)var14_84, (String)var15_89, var16_91, var17_93, var18_96, var19_99, var20_100, var21_102, var22_104, var23_105, var24_107, var25_108, (int)var26_110, var27_111, var28_112, var29_113, var30_114, var31_115, var32_116, var33_117, var34_118);
                                    if (var11_68 != 0 || var3_14.mIsInvalid) {
                                        this.mInvalidResConfigFlags.add(var3_14);
                                    }
                                    this.mIn.mark(this.mHeader.chunkSize);
                                    this.mHeader.checkForUnreadHeader(this.mIn);
                                    var9_55 = (var5_36 & 2) != 0 ? 1 : 0;
                                    var5_36 = (var5_36 & 1) != 0 ? 1 : 0;
                                    if (var5_36 != 0) {
                                        var10_67 = this.mResTable;
                                        if (var10_67.mMainPackage == null) {
                                            var10_67.mApkInfo.mSparseResources = Boolean.TRUE;
                                        }
                                    }
                                    var10_63 = v28;
                                    v28 = new LinkedHashMap<Integer, Integer>();
                                    for (var11_68 = 0; var11_68 < var6_49; ++var11_68) {
                                        if (var5_36 != 0) {
                                            var10_63.put(this.mIn.mDelegate.readUnsignedShort(), this.mIn.mDelegate.readUnsignedShort() * 4);
                                            continue;
                                        }
                                        if (var9_55 != 0) {
                                            var12_77 = this.mIn.mDelegate.readUnsignedShort();
                                            var13_82 = var11_68;
                                            var12_78 = var12_77 == 65535 ? -1 : var12_77 * 4;
                                            var10_63.put(var13_82, var12_78);
                                            continue;
                                        }
                                        var10_63.put(var11_68, this.mIn.mDelegate.readInt());
                                    }
                                    if (this.mInvalidResConfigFlags.contains(var3_14)) {
                                        var5_37 = this.mTypeSpec.mName + var3_14.mQualifiers;
                                        if (this.mKeepBroken) {
                                            ARSCDecoder.LOGGER.warning("Invalid config flags detected: " + var5_37);
                                        } else {
                                            ARSCDecoder.LOGGER.warning("Invalid config flags detected. Dropping resources: " + var5_37);
                                        }
                                    }
                                    if (this.mInvalidResConfigFlags.contains(var3_14) && !this.mKeepBroken) {
                                        var3_14 = null;
                                    } else {
                                        var5_38 = this.mPackage;
                                        var9_56 = (ResType)var5_38.mConfigs.get(var3_14);
                                        if (var9_56 == null) {
                                            v29 = var5_38;
                                            var5_38 = v30;
                                            v30 = new ResType((ResConfigFlags)var3_14);
                                            v29.mConfigs.put(var3_14, var5_38);
                                            var3_14 = var5_38;
                                        } else {
                                            var3_14 = var9_56;
                                        }
                                    }
                                    this.mType = var3_14;
                                    this.mIn.jumpTo(var7_54);
                                    var3_14 = var10_63.keySet().iterator();
                                    while (var3_14.hasNext()) {
                                        v31 = (Integer)var3_14.next();
                                        var5_39 = v31;
                                        this.mResId = this.mResId & -65536 | var5_39;
                                        var9_57 = (Integer)var10_63.get(v31);
                                        if (var9_57 == -1) {
                                            var5_40 = this.mResId;
                                            this.mMissingResSpecs.put(var5_40, var4_24);
                                            continue;
                                        }
                                        var11_70 = var7_54 + (long)var9_57;
                                        var9_58 = this.mIn;
                                        if (var11_70 < var9_58.mCountIn.count) {
                                            var9_58.reset();
                                        }
                                        this.mIn.jumpTo(var11_70);
                                        var9_58 = this.mIn;
                                        if (var9_58.mCountIn.count >= this.mHeader.endPosition) {
                                            var3_15 = var6_49 - var5_39;
                                            var3_14 = var3_15;
                                            var4_29 = this.mTypeSpec.mName;
                                            ARSCDecoder.LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", new Object[]{var3_14, var4_29}));
                                            break;
                                        }
                                        var5_39 = var9_58.mDelegate.readUnsignedShort();
                                        var9_59 = this.mIn.mDelegate.readUnsignedShort();
                                        var11_71 = (var9_59 & 1) != 0;
                                        var12_77 = (var9_59 & 8) != 0 ? 1 : 0;
                                        var13_81 = this.mIn.mDelegate.readInt();
                                        if (var13_81 == -1 && var12_77 == 0) {
                                            while (true) {
                                                var5_41 = null;
                                                break;
                                            }
                                        } else {
                                            if (var12_77 != 0) {
                                                var14_84 = this.mResTable;
                                                if (var14_84.mMainPackage == null) {
                                                    var14_84.mApkInfo.mCompactEntries = Boolean.TRUE;
                                                }
                                            }
                                            if (var12_77 != 0) {
                                                if ((var9_59 = var9_59 >> 8 & 255) == 3) {
                                                    var9_60 = this.mPackage.getValueFactory();
                                                    var11_72 = this.mTableStrings.getHTML(var13_81);
                                                    var9_60.getClass();
                                                    if (var11_72 == null) {
                                                        var9_60 = v32;
                                                        v32 = new ResFileValue(var13_81, "");
                                                    } else if (var11_72.startsWith("res/")) {
                                                        var9_60 = v33;
                                                        v33 = new ResFileValue(var13_81, var11_72);
                                                    } else if (!var11_72.startsWith("r/") && !var11_72.startsWith("R/")) {
                                                        var9_60 = v34;
                                                        v34 = new ResStringValue(var13_81, var11_72);
                                                    } else {
                                                        var9_60 = v35;
                                                        v35 = new ResFileValue(var13_81, var11_72);
                                                    }
                                                } else {
                                                    var9_60 = this.mPackage.getValueFactory().factory(null, var9_59, var13_81);
                                                }
                                            } else if (var11_71) {
                                                var5_39 = this.mIn.mDelegate.readInt();
                                                var9_59 = this.mIn.mDelegate.readInt();
                                                var11_73 = this.mPackage.getValueFactory();
                                                var12_79 = new Pair[var9_59];
                                                for (var14_85 = 0; var14_85 < var9_59; ++var14_85) {
                                                    var15_90 = this.mIn.mDelegate.readInt();
                                                    var16_92 = this.readValue();
                                                    if (var16_92 == null) continue;
                                                    if (!(var16_92 instanceof ResScalarValue)) {
                                                        var17_94 = v36;
                                                        v37 = var16_92;
                                                        var16_92 = v37.toString();
                                                        v36 = new ResStringValue(v37.mRawIntValue, (String)var16_92);
                                                        var16_92 = var17_94;
                                                    }
                                                    var12_79[var14_85] = Pair.of(var15_90, (ResScalarValue)var16_92);
                                                }
                                                var14_86 = this.mTypeSpec;
                                                var15_89 = null;
                                                var16_91 = 0;
                                                var17_95 = v38;
                                                v38 = new ResReferenceValue(var11_73.mPackage, var5_39, (String)var15_89, (boolean)var16_91);
                                                if (var9_59 == 0) {
                                                    var5_42 = v39;
                                                    v39 = new ResBagValue(var17_95);
                                                    var9_60 = var5_42;
                                                } else {
                                                    var5_42 = var14_86.mName;
                                                    var5_42.getClass();
                                                    var14_87 = -1;
                                                    switch (var5_42.hashCode()) {
                                                        default: {
                                                            break;
                                                        }
                                                        case 93090393: {
                                                            if (!var5_42.equals("array")) break;
                                                            var14_87 = 3;
                                                            break;
                                                        }
                                                        case 3004913: {
                                                            if (!var5_42.equals("attr")) break;
                                                            var14_87 = 2;
                                                            break;
                                                        }
                                                        case -475309713: {
                                                            if (!var5_42.equals("plurals")) break;
                                                            var14_87 = 1;
                                                            break;
                                                        }
                                                        case -576469755: {
                                                            if (!var5_42.equals("^attr-private")) break;
                                                            var14_87 = 0;
                                                        }
                                                    }
                                                    switch (var14_87) {
                                                        default: {
                                                            if (var5_42.startsWith("style")) {
                                                                var5_42 = v40;
                                                                v40 = new ResStyleValue(var17_95, var12_79, var11_73);
                                                                var9_60 = var5_42;
                                                                break;
                                                            }
                                                            throw new AndrolibException("unsupported res type name for bags. Found: ".concat((String)var5_42));
                                                        }
                                                        case 3: {
                                                            var5_42 = v41;
                                                            v41 = new ResArrayValue(var17_95, var12_79);
                                                            var9_60 = var5_42;
                                                            break;
                                                        }
                                                        case 1: {
                                                            var5_42 = v42;
                                                            v42 = new ResPluralsValue(var17_95, var12_79);
                                                            var9_60 = var5_42;
                                                            break;
                                                        }
                                                        case 0: 
                                                        case 2: {
                                                            var5_42 = null;
                                                            var14_88 = null;
                                                            var15_89 = null;
                                                            block39: for (var16_91 = 1; var16_91 < var9_59; ++var16_91) {
                                                                var18_98 = (ImmutablePair)var12_79[var16_91];
                                                                switch ((Integer)var18_98.left) {
                                                                    default: {
                                                                        break block39;
                                                                    }
                                                                    case 0x1000003: {
                                                                        var15_89 = ((ResScalarValue)var18_98.right).mRawIntValue != 0;
                                                                        continue block39;
                                                                    }
                                                                    case 0x1000002: {
                                                                        var14_88 = ((ResScalarValue)var18_98.right).mRawIntValue;
                                                                        continue block39;
                                                                    }
                                                                    case 0x1000001: {
                                                                        var5_42 = ((ResScalarValue)var18_98.right).mRawIntValue;
                                                                    }
                                                                }
                                                            }
                                                            var18_96 = ((ResScalarValue)((ImmutablePair)var12_79[0]).right).mRawIntValue;
                                                            var19_99 = var18_96 & 65535;
                                                            if (var16_91 == var9_59) {
                                                                var9_60 = v43;
                                                                v43 = new ResAttr(var17_95, var19_99, (Integer)var5_42, var14_88, (Boolean)var15_89);
                                                                break;
                                                            }
                                                            var20_101 = var17_95.mPackage;
                                                            var21_103 = new Pair[var9_59 - var16_91];
                                                            var22_104 = 0;
                                                            while (var16_91 < var9_59) {
                                                                var23_106 = (ImmutablePair)var12_79[var16_91];
                                                                var24_107 = (Integer)var23_106.left;
                                                                var20_101.mSynthesizedRes.add(new ResID(var24_107));
                                                                var25_109 = null;
                                                                var26_110 = false;
                                                                var21_103[var22_104] = Pair.of(new ResReferenceValue(var11_73.mPackage, var24_107, var25_109, var26_110), (ResScalarValue)var23_106.right);
                                                                ++var16_91;
                                                                ++var22_104;
                                                            }
                                                            var9_59 = var18_96 & 0xFF0000;
                                                            if (var9_59 != 65536) {
                                                                if (var9_59 == 131072) {
                                                                    var9_60 = v44;
                                                                    v44 = new ResFlagsAttr(var17_95, var19_99, (Integer)var5_42, var14_88, (Boolean)var15_89, var21_103);
                                                                    break;
                                                                }
                                                                throw new AndrolibException("Could not decode attr value");
                                                            }
                                                            var9_60 = v45;
                                                            v45 = new ResEnumAttr(var17_95, var19_99, (Integer)var5_42, var14_88, (Boolean)var15_89, var21_103);
                                                        }
                                                    }
                                                }
                                                var5_39 = var13_81;
                                            } else {
                                                var9_60 = this.readValue();
                                                var5_39 = var13_81;
                                            }
                                            if (var9_60 == null) ** continue;
                                            var11_74 = v46;
                                            new EntryData().specNamesId = var5_39;
                                            new EntryData().value = var9_60;
                                            var5_41 = var11_74;
                                        }
                                        if (var5_41 == null) ** GOTO lbl581
                                        v47 = var5_41;
                                        var5_43 = v47.specNamesId;
                                        var9_61 = v47.value;
                                        if (this.mTypeSpec.mName.equals("string") && var9_61 instanceof ResFileValue) {
                                            var11_75 = v48;
                                            v49 = var9_61;
                                            var9_61 = ((ResFileValue)v49).mPath;
                                            v48 = new ResStringValue(((ResFileValue)v49).mRawIntValue, (String)var9_61);
                                            var9_61 = var11_75;
                                        }
                                        if (this.mType == null) continue;
                                        var11_76 = v50;
                                        v50 = new ResID(this.mResId);
                                        if (!this.mPackage.mResSpecs.containsKey(var11_76)) ** GOTO lbl557
                                        var5_44 = (ResResSpec)this.mPackage.mResSpecs.get(var11_76);
                                        if (var5_44 == null) {
                                            throw new UndefinedResObjectException("resource spec: " + var11_76);
                                        }
                                        ** GOTO lbl564
lbl557:
                                        // 1 sources

                                        var12_80 = v51;
                                        var5_44 = this.mSpecNames.getString(var5_43);
                                        var13_83 = this.mTypeSpec;
                                        v51 = new ResResSpec((ResID)var11_76, (String)var5_44, this.mPackage, var13_83);
                                        if (this.mPackage.mResSpecs.put(var11_76, var12_80) != null) ** GOTO lbl580
                                        this.mTypeSpec.addResSpec(var12_80);
                                        var5_44 = var12_80;
lbl564:
                                        // 2 sources

                                        v52 = this.mType;
                                        var11_76 = new ResResource(v52, (ResResSpec)var5_44, (ResValue)var9_61);
                                        try {
                                            v52.addResource((ResResource)var11_76, false);
                                            var5_44.addResource((ResResource)var11_76, false);
                                            continue;
                                        }
                                        catch (AndrolibException var9_62) {
                                            if (this.mKeepBroken) {
                                                this.mType.addResource((ResResource)var11_76, true);
                                                var5_44.addResource((ResResource)var11_76, true);
                                                v53 = new StringBuilder("Duplicate Resource Detected. Ignoring duplicate: ");
                                                v53.append(var11_76);
                                                ARSCDecoder.LOGGER.warning(v53.toString());
                                                continue;
                                            }
                                            throw var9_62;
                                        }
lbl580:
                                        // 1 sources

                                        throw new AndrolibException("Multiple resource specs: " + var12_80);
lbl581:
                                        // 1 sources

                                        var5_41 = this.mResId;
                                        this.mMissingResSpecs.put(var5_41, var4_24);
                                    }
                                    var3_16 = this.mHeader.endPosition;
                                    var5_45 = this.mIn;
                                    var6_50 = var5_45.mCountIn.count;
                                    if (var3_16 <= var6_50) continue block29;
                                    var3_16 = var5_45.skip(var3_16 - var6_50);
                                    var5_45 = v54;
                                    var5_45("Unknown data detected at end of type chunk. Skipping: ");
                                    ARSCDecoder.LOGGER.warning(v54.append(var3_16).append(" byte(s)").toString());
                                    continue block29;
lbl594:
                                    // 1 sources

                                    throw new AndrolibException("Config size < 8");
                                }
                                case 512: 
                            }
                            this.mTypeIdOffset = 0;
                            this.checkChunkType(512);
                            var4_24 = this.mIn.mDelegate.readInt();
                            var5_32 = this.mIn.readUtf16(128);
                            this.mIn.mDelegate.readInt();
                            this.mIn.mDelegate.readInt();
                            this.mIn.mDelegate.readInt();
                            this.mIn.mDelegate.readInt();
                            if (this.mHeader.headerSize == 288) {
                                this.mTypeIdOffset = this.mIn.mDelegate.readInt();
                            }
                            if (this.mTypeIdOffset > 0) {
                                var3_7.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
                            }
                            this.mHeader.checkForUnreadHeader(this.mIn);
                            this.mTypeNames = StringBlock.readWithChunk(this.mIn);
                            this.mSpecNames = StringBlock.readWithChunk(this.mIn);
                            if (var4_24 == 0) {
                                var3_7 = this.mResTable;
                                if (var3_7.mMainPackage != null) {
                                    for (Map.Entry var4_30 : var3_7.mDynamicRefTable.entrySet()) {
                                        if (!var5_32.equals(var4_30.getValue())) continue;
                                        var4_24 = var3_17 = ((Integer)var4_30.getKey()).intValue();
                                        break block116;
                                    }
                                    var4_24 = var3_18 = 0;
                                }
                            }
                        }
                        this.mResId = var4_24 << 24;
                        this.mPackage = var3_19 = v55;
                        var1_1.add(new ResPackage(this.mResTable, var4_24, (String)var5_32));
                        continue;
                    }
                    this.checkChunkType(2);
                    this.mIn.mDelegate.readInt();
                    this.mHeader.checkForUnreadHeader(this.mIn);
                    continue;
                }
                this.checkChunkType(1);
                v56 = this.mHeader;
                var3_20 = v56.startPosition;
                var5_46 = v56.headerSize;
                var6_51 = v56.chunkSize;
                this.mTableStrings = StringBlock.readWithoutChunk(this.mIn, var3_20, var5_46, var6_51);
                continue;
            }
            this.checkChunkType(0);
            this.mHeader.checkForUnreadHeader(this.mIn);
            var3_7.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
            this.mIn.jumpTo(this.mHeader.endPosition);
        }
    }

    public final ResIntBasedValue readValue() {
        Object object;
        if (((ARSCDecoder)object).mIn.mDelegate.readUnsignedShort() < 8) {
            return null;
        }
        ARSCDecoder aRSCDecoder = object;
        aRSCDecoder.mIn.mDelegate.readByte();
        int n = aRSCDecoder.mIn.mDelegate.readUnsignedByte();
        int n2 = ((ARSCDecoder)object).mIn.mDelegate.readInt();
        if (n == 3) {
            ARSCDecoder aRSCDecoder2 = object;
            object = aRSCDecoder2.mPackage.getValueFactory();
            String string = aRSCDecoder2.mTableStrings.getHTML(n2);
            object.getClass();
            if (string == null) {
                ResFileValue resFileValue;
                object = resFileValue;
                resFileValue = new ResFileValue(n2, "");
            } else if (string.startsWith("res/")) {
                ResFileValue resFileValue;
                object = resFileValue;
                resFileValue = new ResFileValue(n2, string);
            } else if (!string.startsWith("r/") && !string.startsWith("R/")) {
                ResStringValue resStringValue;
                object = resStringValue;
                resStringValue = new ResStringValue(n2, string);
            } else {
                ResFileValue resFileValue;
                object = resFileValue;
                resFileValue = new ResFileValue(n2, string);
            }
        } else {
            object = ((ARSCDecoder)object).mPackage.getValueFactory().factory(null, n, n2);
        }
        return object;
    }

    public final void checkChunkType(int n) {
        if (((ARSCDecoder)((Object)n2)).mHeader.type == n) {
            return;
        }
        ARSCDecoder aRSCDecoder = n2;
        Integer n2 = n;
        Integer n3 = aRSCDecoder.mHeader.type;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        objectArray[1] = n3;
        throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", objectArray2));
    }
}

