"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScanDuration = exports.SecurityLevel = exports.CapabInfoMask = exports.ZnpCommandStatus = exports.NvSystemIds = exports.NvItemsIds = exports.DevStates = exports.AddressMode = void 0;
var AddressMode;
(function (AddressMode) {
    AddressMode[AddressMode["ADDR_NOT_PRESENT"] = 0] = "ADDR_NOT_PRESENT";
    AddressMode[AddressMode["ADDR_GROUP"] = 1] = "ADDR_GROUP";
    AddressMode[AddressMode["ADDR_16BIT"] = 2] = "ADDR_16BIT";
    AddressMode[AddressMode["ADDR_64BIT"] = 3] = "ADDR_64BIT";
    AddressMode[AddressMode["ADDR_BROADCAST"] = 15] = "ADDR_BROADCAST";
})(AddressMode || (exports.AddressMode = AddressMode = {}));
var DevStates;
(function (DevStates) {
    DevStates[DevStates["HOLD"] = 0] = "HOLD";
    DevStates[DevStates["INIT"] = 1] = "INIT";
    DevStates[DevStates["NWK_DISC"] = 2] = "NWK_DISC";
    DevStates[DevStates["NWK_JOINING"] = 3] = "NWK_JOINING";
    DevStates[DevStates["NWK_REJOIN"] = 4] = "NWK_REJOIN";
    DevStates[DevStates["END_DEVICE_UNAUTH"] = 5] = "END_DEVICE_UNAUTH";
    DevStates[DevStates["END_DEVICE"] = 6] = "END_DEVICE";
    DevStates[DevStates["ROUTER"] = 7] = "ROUTER";
    DevStates[DevStates["COORD_STARTING"] = 8] = "COORD_STARTING";
    DevStates[DevStates["ZB_COORD"] = 9] = "ZB_COORD";
    DevStates[DevStates["NWK_ORPHAN"] = 10] = "NWK_ORPHAN";
    DevStates[DevStates["INVALID_REQTYPE"] = 128] = "INVALID_REQTYPE";
    DevStates[DevStates["DEVICE_NOT_FOUND"] = 129] = "DEVICE_NOT_FOUND";
    DevStates[DevStates["INVALID_EP"] = 130] = "INVALID_EP";
    DevStates[DevStates["NOT_ACTIVE"] = 131] = "NOT_ACTIVE";
    DevStates[DevStates["NOT_SUPPORTED"] = 132] = "NOT_SUPPORTED";
    DevStates[DevStates["TIMEOUT"] = 133] = "TIMEOUT";
    DevStates[DevStates["NO_MATCH"] = 134] = "NO_MATCH";
    DevStates[DevStates["NO_ENTRY"] = 136] = "NO_ENTRY";
    DevStates[DevStates["NO_DESCRIPTOR"] = 137] = "NO_DESCRIPTOR";
    DevStates[DevStates["INSUFFICIENT_SPACE"] = 138] = "INSUFFICIENT_SPACE";
    DevStates[DevStates["NOT_PERMITTED"] = 139] = "NOT_PERMITTED";
    DevStates[DevStates["TABLE_FULL"] = 140] = "TABLE_FULL";
    DevStates[DevStates["NOT_AUTHORIZED"] = 141] = "NOT_AUTHORIZED";
    DevStates[DevStates["BINDING_TABLE_FULL"] = 142] = "BINDING_TABLE_FULL";
})(DevStates || (exports.DevStates = DevStates = {}));
var NvItemsIds;
(function (NvItemsIds) {
    NvItemsIds[NvItemsIds["EXTADDR"] = 1] = "EXTADDR";
    NvItemsIds[NvItemsIds["BOOTCOUNTER"] = 2] = "BOOTCOUNTER";
    NvItemsIds[NvItemsIds["STARTUP_OPTION"] = 3] = "STARTUP_OPTION";
    NvItemsIds[NvItemsIds["START_DELAY"] = 4] = "START_DELAY";
    NvItemsIds[NvItemsIds["NIB"] = 33] = "NIB";
    NvItemsIds[NvItemsIds["DEVICE_LIST"] = 34] = "DEVICE_LIST";
    NvItemsIds[NvItemsIds["ADDRMGR"] = 35] = "ADDRMGR";
    NvItemsIds[NvItemsIds["POLL_RATE"] = 36] = "POLL_RATE";
    NvItemsIds[NvItemsIds["QUEUED_POLL_RATE"] = 37] = "QUEUED_POLL_RATE";
    NvItemsIds[NvItemsIds["RESPONSE_POLL_RATE"] = 38] = "RESPONSE_POLL_RATE";
    NvItemsIds[NvItemsIds["REJOIN_POLL_RATE"] = 39] = "REJOIN_POLL_RATE";
    NvItemsIds[NvItemsIds["DATA_RETRIES"] = 40] = "DATA_RETRIES";
    NvItemsIds[NvItemsIds["POLL_FAILURE_RETRIES"] = 41] = "POLL_FAILURE_RETRIES";
    NvItemsIds[NvItemsIds["STACK_PROFILE"] = 42] = "STACK_PROFILE";
    NvItemsIds[NvItemsIds["INDIRECT_MSG_TIMEOUT"] = 43] = "INDIRECT_MSG_TIMEOUT";
    NvItemsIds[NvItemsIds["ROUTE_EXPIRY_TIME"] = 44] = "ROUTE_EXPIRY_TIME";
    NvItemsIds[NvItemsIds["EXTENDED_PAN_ID"] = 45] = "EXTENDED_PAN_ID";
    NvItemsIds[NvItemsIds["BCAST_RETRIES"] = 46] = "BCAST_RETRIES";
    NvItemsIds[NvItemsIds["PASSIVE_ACK_TIMEOUT"] = 47] = "PASSIVE_ACK_TIMEOUT";
    NvItemsIds[NvItemsIds["BCAST_DELIVERY_TIME"] = 48] = "BCAST_DELIVERY_TIME";
    NvItemsIds[NvItemsIds["NWK_MODE"] = 49] = "NWK_MODE";
    NvItemsIds[NvItemsIds["CONCENTRATOR_ENABLE"] = 50] = "CONCENTRATOR_ENABLE";
    NvItemsIds[NvItemsIds["CONCENTRATOR_DISCOVERY"] = 51] = "CONCENTRATOR_DISCOVERY";
    NvItemsIds[NvItemsIds["CONCENTRATOR_RADIUS"] = 52] = "CONCENTRATOR_RADIUS";
    NvItemsIds[NvItemsIds["CONCENTRATOR_RC"] = 54] = "CONCENTRATOR_RC";
    NvItemsIds[NvItemsIds["NWK_MGR_MODE"] = 55] = "NWK_MGR_MODE";
    NvItemsIds[NvItemsIds["SRC_RTG_EXPIRY_TIME"] = 56] = "SRC_RTG_EXPIRY_TIME";
    NvItemsIds[NvItemsIds["ROUTE_DISCOVERY_TIME"] = 57] = "ROUTE_DISCOVERY_TIME";
    NvItemsIds[NvItemsIds["NWK_ACTIVE_KEY_INFO"] = 58] = "NWK_ACTIVE_KEY_INFO";
    NvItemsIds[NvItemsIds["NWK_ALTERN_KEY_INFO"] = 59] = "NWK_ALTERN_KEY_INFO";
    NvItemsIds[NvItemsIds["ROUTER_OFF_ASSOC_CLEANUP"] = 60] = "ROUTER_OFF_ASSOC_CLEANUP";
    NvItemsIds[NvItemsIds["NWK_LEAVE_REQ_ALLOWED"] = 61] = "NWK_LEAVE_REQ_ALLOWED";
    NvItemsIds[NvItemsIds["NWK_CHILD_AGE_ENABLE"] = 62] = "NWK_CHILD_AGE_ENABLE";
    NvItemsIds[NvItemsIds["DEVICE_LIST_KA_TIMEOUT"] = 63] = "DEVICE_LIST_KA_TIMEOUT";
    NvItemsIds[NvItemsIds["BINDING_TABLE"] = 65] = "BINDING_TABLE";
    NvItemsIds[NvItemsIds["GROUP_TABLE"] = 66] = "GROUP_TABLE";
    NvItemsIds[NvItemsIds["APS_FRAME_RETRIES"] = 67] = "APS_FRAME_RETRIES";
    NvItemsIds[NvItemsIds["APS_ACK_WAIT_DURATION"] = 68] = "APS_ACK_WAIT_DURATION";
    NvItemsIds[NvItemsIds["APS_ACK_WAIT_MULTIPLIER"] = 69] = "APS_ACK_WAIT_MULTIPLIER";
    NvItemsIds[NvItemsIds["BINDING_TIME"] = 70] = "BINDING_TIME";
    NvItemsIds[NvItemsIds["APS_USE_EXT_PANID"] = 71] = "APS_USE_EXT_PANID";
    NvItemsIds[NvItemsIds["APS_USE_INSECURE_JOIN"] = 72] = "APS_USE_INSECURE_JOIN";
    NvItemsIds[NvItemsIds["COMMISSIONED_NWK_ADDR"] = 73] = "COMMISSIONED_NWK_ADDR";
    NvItemsIds[NvItemsIds["APS_NONMEMBER_RADIUS"] = 75] = "APS_NONMEMBER_RADIUS";
    NvItemsIds[NvItemsIds["APS_LINK_KEY_TABLE"] = 76] = "APS_LINK_KEY_TABLE";
    NvItemsIds[NvItemsIds["APS_DUPREJ_TIMEOUT_INC"] = 77] = "APS_DUPREJ_TIMEOUT_INC";
    NvItemsIds[NvItemsIds["APS_DUPREJ_TIMEOUT_COUNT"] = 78] = "APS_DUPREJ_TIMEOUT_COUNT";
    NvItemsIds[NvItemsIds["APS_DUPREJ_TABLE_SIZE"] = 79] = "APS_DUPREJ_TABLE_SIZE";
    NvItemsIds[NvItemsIds["DIAGNOSTIC_STATS"] = 80] = "DIAGNOSTIC_STATS";
    NvItemsIds[NvItemsIds["BDBNODEISONANETWORK"] = 85] = "BDBNODEISONANETWORK";
    NvItemsIds[NvItemsIds["SECURITY_LEVEL"] = 97] = "SECURITY_LEVEL";
    NvItemsIds[NvItemsIds["PRECFGKEY"] = 98] = "PRECFGKEY";
    NvItemsIds[NvItemsIds["PRECFGKEYS_ENABLE"] = 99] = "PRECFGKEYS_ENABLE";
    NvItemsIds[NvItemsIds["SECURITY_MODE"] = 100] = "SECURITY_MODE";
    NvItemsIds[NvItemsIds["SECURE_PERMIT_JOIN"] = 101] = "SECURE_PERMIT_JOIN";
    NvItemsIds[NvItemsIds["APS_LINK_KEY_TYPE"] = 102] = "APS_LINK_KEY_TYPE";
    NvItemsIds[NvItemsIds["APS_ALLOW_R19_SECURITY"] = 103] = "APS_ALLOW_R19_SECURITY";
    NvItemsIds[NvItemsIds["IMPLICIT_CERTIFICATE"] = 105] = "IMPLICIT_CERTIFICATE";
    NvItemsIds[NvItemsIds["DEVICE_PRIVATE_KEY"] = 106] = "DEVICE_PRIVATE_KEY";
    NvItemsIds[NvItemsIds["CA_PUBLIC_KEY"] = 107] = "CA_PUBLIC_KEY";
    NvItemsIds[NvItemsIds["KE_MAX_DEVICES"] = 108] = "KE_MAX_DEVICES";
    NvItemsIds[NvItemsIds["USE_DEFAULT_TCLK"] = 109] = "USE_DEFAULT_TCLK";
    NvItemsIds[NvItemsIds["RNG_COUNTER"] = 111] = "RNG_COUNTER";
    NvItemsIds[NvItemsIds["RANDOM_SEED"] = 112] = "RANDOM_SEED";
    NvItemsIds[NvItemsIds["TRUSTCENTER_ADDR"] = 113] = "TRUSTCENTER_ADDR";
    NvItemsIds[NvItemsIds["LEGACY_NWK_SEC_MATERIAL_TABLE_START"] = 117] = "LEGACY_NWK_SEC_MATERIAL_TABLE_START";
    NvItemsIds[NvItemsIds["EX_NWK_SEC_MATERIAL_TABLE"] = 7] = "EX_NWK_SEC_MATERIAL_TABLE";
    NvItemsIds[NvItemsIds["USERDESC"] = 129] = "USERDESC";
    NvItemsIds[NvItemsIds["NWKKEY"] = 130] = "NWKKEY";
    NvItemsIds[NvItemsIds["PANID"] = 131] = "PANID";
    NvItemsIds[NvItemsIds["CHANLIST"] = 132] = "CHANLIST";
    NvItemsIds[NvItemsIds["LEAVE_CTRL"] = 133] = "LEAVE_CTRL";
    NvItemsIds[NvItemsIds["SCAN_DURATION"] = 134] = "SCAN_DURATION";
    NvItemsIds[NvItemsIds["LOGICAL_TYPE"] = 135] = "LOGICAL_TYPE";
    NvItemsIds[NvItemsIds["NWKMGR_MIN_TX"] = 136] = "NWKMGR_MIN_TX";
    NvItemsIds[NvItemsIds["NWKMGR_ADDR"] = 137] = "NWKMGR_ADDR";
    NvItemsIds[NvItemsIds["ZDO_DIRECT_CB"] = 143] = "ZDO_DIRECT_CB";
    NvItemsIds[NvItemsIds["SCENE_TABLE"] = 145] = "SCENE_TABLE";
    NvItemsIds[NvItemsIds["MIN_FREE_NWK_ADDR"] = 146] = "MIN_FREE_NWK_ADDR";
    NvItemsIds[NvItemsIds["MAX_FREE_NWK_ADDR"] = 147] = "MAX_FREE_NWK_ADDR";
    NvItemsIds[NvItemsIds["MIN_FREE_GRP_ID"] = 148] = "MIN_FREE_GRP_ID";
    NvItemsIds[NvItemsIds["MAX_FREE_GRP_ID"] = 149] = "MAX_FREE_GRP_ID";
    NvItemsIds[NvItemsIds["MIN_GRP_IDS"] = 150] = "MIN_GRP_IDS";
    NvItemsIds[NvItemsIds["MAX_GRP_IDS"] = 151] = "MAX_GRP_IDS";
    NvItemsIds[NvItemsIds["OTA_BLOCK_REQ_DELAY"] = 152] = "OTA_BLOCK_REQ_DELAY";
    NvItemsIds[NvItemsIds["SAPI_ENDPOINT"] = 161] = "SAPI_ENDPOINT";
    NvItemsIds[NvItemsIds["SAS_SHORT_ADDR"] = 177] = "SAS_SHORT_ADDR";
    NvItemsIds[NvItemsIds["SAS_EXT_PANID"] = 178] = "SAS_EXT_PANID";
    NvItemsIds[NvItemsIds["SAS_PANID"] = 179] = "SAS_PANID";
    NvItemsIds[NvItemsIds["SAS_CHANNEL_MASK"] = 180] = "SAS_CHANNEL_MASK";
    NvItemsIds[NvItemsIds["SAS_PROTOCOL_VER"] = 181] = "SAS_PROTOCOL_VER";
    NvItemsIds[NvItemsIds["SAS_STACK_PROFILE"] = 182] = "SAS_STACK_PROFILE";
    NvItemsIds[NvItemsIds["SAS_STARTUP_CTRL"] = 183] = "SAS_STARTUP_CTRL";
    NvItemsIds[NvItemsIds["SAS_TC_ADDR"] = 193] = "SAS_TC_ADDR";
    NvItemsIds[NvItemsIds["SAS_TC_MASTER_KEY"] = 194] = "SAS_TC_MASTER_KEY";
    NvItemsIds[NvItemsIds["SAS_NWK_KEY"] = 195] = "SAS_NWK_KEY";
    NvItemsIds[NvItemsIds["SAS_USE_INSEC_JOIN"] = 196] = "SAS_USE_INSEC_JOIN";
    NvItemsIds[NvItemsIds["SAS_PRECFG_LINK_KEY"] = 197] = "SAS_PRECFG_LINK_KEY";
    NvItemsIds[NvItemsIds["SAS_NWK_KEY_SEQ_NUM"] = 198] = "SAS_NWK_KEY_SEQ_NUM";
    NvItemsIds[NvItemsIds["SAS_NWK_KEY_TYPE"] = 199] = "SAS_NWK_KEY_TYPE";
    NvItemsIds[NvItemsIds["SAS_NWK_MGR_ADDR"] = 200] = "SAS_NWK_MGR_ADDR";
    NvItemsIds[NvItemsIds["SAS_CURR_TC_MASTER_KEY"] = 209] = "SAS_CURR_TC_MASTER_KEY";
    NvItemsIds[NvItemsIds["SAS_CURR_NWK_KEY"] = 210] = "SAS_CURR_NWK_KEY";
    NvItemsIds[NvItemsIds["SAS_CURR_PRECFG_LINK_KEY"] = 211] = "SAS_CURR_PRECFG_LINK_KEY";
    NvItemsIds[NvItemsIds["TCLK_SEED"] = 257] = "TCLK_SEED";
    NvItemsIds[NvItemsIds["LEGACY_TCLK_TABLE_START_12"] = 257] = "LEGACY_TCLK_TABLE_START_12";
    NvItemsIds[NvItemsIds["LEGACY_TCLK_TABLE_START"] = 273] = "LEGACY_TCLK_TABLE_START";
    NvItemsIds[NvItemsIds["EX_TCLK_TABLE"] = 4] = "EX_TCLK_TABLE";
    NvItemsIds[NvItemsIds["APS_LINK_KEY_DATA_START"] = 513] = "APS_LINK_KEY_DATA_START";
    NvItemsIds[NvItemsIds["APS_LINK_KEY_DATA_END"] = 767] = "APS_LINK_KEY_DATA_END";
    NvItemsIds[NvItemsIds["DUPLICATE_BINDING_TABLE"] = 768] = "DUPLICATE_BINDING_TABLE";
    NvItemsIds[NvItemsIds["DUPLICATE_DEVICE_LIST"] = 769] = "DUPLICATE_DEVICE_LIST";
    NvItemsIds[NvItemsIds["DUPLICATE_DEVICE_LIST_KA_TIMEOUT"] = 770] = "DUPLICATE_DEVICE_LIST_KA_TIMEOUT";
    NvItemsIds[NvItemsIds["ZNP_HAS_CONFIGURED_ZSTACK1"] = 3840] = "ZNP_HAS_CONFIGURED_ZSTACK1";
    NvItemsIds[NvItemsIds["ZNP_HAS_CONFIGURED_ZSTACK3"] = 96] = "ZNP_HAS_CONFIGURED_ZSTACK3";
    NvItemsIds[NvItemsIds["ZCD_NV_EX_APS_KEY_DATA_TABLE"] = 6] = "ZCD_NV_EX_APS_KEY_DATA_TABLE";
    NvItemsIds[NvItemsIds["ZCD_NV_EX_ADDRMGR"] = 1] = "ZCD_NV_EX_ADDRMGR";
})(NvItemsIds || (exports.NvItemsIds = NvItemsIds = {}));
var NvSystemIds;
(function (NvSystemIds) {
    NvSystemIds[NvSystemIds["ZSTACK"] = 1] = "ZSTACK";
})(NvSystemIds || (exports.NvSystemIds = NvSystemIds = {}));
var ZnpCommandStatus;
(function (ZnpCommandStatus) {
    ZnpCommandStatus[ZnpCommandStatus["SUCCESS"] = 0] = "SUCCESS";
    ZnpCommandStatus[ZnpCommandStatus["FAILURE"] = 1] = "FAILURE";
    ZnpCommandStatus[ZnpCommandStatus["INVALID_PARAM"] = 2] = "INVALID_PARAM";
    ZnpCommandStatus[ZnpCommandStatus["NV_ITEM_INITIALIZED"] = 9] = "NV_ITEM_INITIALIZED";
    ZnpCommandStatus[ZnpCommandStatus["NV_OPER_FAILED"] = 10] = "NV_OPER_FAILED";
    ZnpCommandStatus[ZnpCommandStatus["NV_BAD_ITEM_LEN"] = 12] = "NV_BAD_ITEM_LEN";
    ZnpCommandStatus[ZnpCommandStatus["MEM_ERROR"] = 16] = "MEM_ERROR";
    ZnpCommandStatus[ZnpCommandStatus["BUFFER_FULL"] = 17] = "BUFFER_FULL";
    ZnpCommandStatus[ZnpCommandStatus["UNSUPPORTED_MODE"] = 18] = "UNSUPPORTED_MODE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_MEM_ERROR"] = 19] = "MAC_MEM_ERROR";
    ZnpCommandStatus[ZnpCommandStatus["MAC_UNSUPPORTED_NOT_SPOORT"] = 24] = "MAC_UNSUPPORTED_NOT_SPOORT";
    ZnpCommandStatus[ZnpCommandStatus["MAC_BAD_STATE"] = 25] = "MAC_BAD_STATE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_RESOURCES"] = 26] = "MAC_NO_RESOURCES";
    ZnpCommandStatus[ZnpCommandStatus["MAC_ACK_PENDING"] = 27] = "MAC_ACK_PENDING";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_TIME"] = 28] = "MAC_NO_TIME";
    ZnpCommandStatus[ZnpCommandStatus["MAC_TX_ABORTED"] = 29] = "MAC_TX_ABORTED";
    ZnpCommandStatus[ZnpCommandStatus["SAPI_IN_PROGRESS"] = 32] = "SAPI_IN_PROGRESS";
    ZnpCommandStatus[ZnpCommandStatus["SAPI_TIMEOUT"] = 33] = "SAPI_TIMEOUT";
    ZnpCommandStatus[ZnpCommandStatus["SAPI_INIT"] = 34] = "SAPI_INIT";
    ZnpCommandStatus[ZnpCommandStatus["NOT_AUTHORIZED"] = 126] = "NOT_AUTHORIZED";
    ZnpCommandStatus[ZnpCommandStatus["MALFORMED_CMD"] = 128] = "MALFORMED_CMD";
    ZnpCommandStatus[ZnpCommandStatus["UNSUP_CLUSTER_CMD"] = 129] = "UNSUP_CLUSTER_CMD";
    ZnpCommandStatus[ZnpCommandStatus["OTA_ABORT"] = 149] = "OTA_ABORT";
    ZnpCommandStatus[ZnpCommandStatus["OTA_IMAGE_INVALID"] = 150] = "OTA_IMAGE_INVALID";
    ZnpCommandStatus[ZnpCommandStatus["OTA_WAIT_FOR_DATA"] = 151] = "OTA_WAIT_FOR_DATA";
    ZnpCommandStatus[ZnpCommandStatus["OTA_NO_IMAGE_AVAILABLE"] = 152] = "OTA_NO_IMAGE_AVAILABLE";
    ZnpCommandStatus[ZnpCommandStatus["OTA_REQUIRE_MORE_IMAGE"] = 153] = "OTA_REQUIRE_MORE_IMAGE";
    ZnpCommandStatus[ZnpCommandStatus["APS_FAIL"] = 177] = "APS_FAIL";
    ZnpCommandStatus[ZnpCommandStatus["APS_TABLE_FULL"] = 178] = "APS_TABLE_FULL";
    ZnpCommandStatus[ZnpCommandStatus["APS_ILLEGAL_REQUEST"] = 179] = "APS_ILLEGAL_REQUEST";
    ZnpCommandStatus[ZnpCommandStatus["APS_INVALID_BINDING"] = 180] = "APS_INVALID_BINDING";
    ZnpCommandStatus[ZnpCommandStatus["APS_UNSUPPORTED_ATTRIB"] = 181] = "APS_UNSUPPORTED_ATTRIB";
    ZnpCommandStatus[ZnpCommandStatus["APS_NOT_SUPPORTED"] = 182] = "APS_NOT_SUPPORTED";
    ZnpCommandStatus[ZnpCommandStatus["APS_NO_ACK"] = 183] = "APS_NO_ACK";
    ZnpCommandStatus[ZnpCommandStatus["APS_DUPLICATE_ENTRY"] = 184] = "APS_DUPLICATE_ENTRY";
    ZnpCommandStatus[ZnpCommandStatus["APS_NO_BOUND_DEVICE"] = 185] = "APS_NO_BOUND_DEVICE";
    ZnpCommandStatus[ZnpCommandStatus["APS_NOT_ALLOWED"] = 186] = "APS_NOT_ALLOWED";
    ZnpCommandStatus[ZnpCommandStatus["APS_NOT_AUTHENTICATED"] = 187] = "APS_NOT_AUTHENTICATED";
    ZnpCommandStatus[ZnpCommandStatus["SEC_NO_KEY"] = 161] = "SEC_NO_KEY";
    ZnpCommandStatus[ZnpCommandStatus["SEC_OLD_FRM_COUNT"] = 162] = "SEC_OLD_FRM_COUNT";
    ZnpCommandStatus[ZnpCommandStatus["SEC_MAX_FRM_COUNT"] = 163] = "SEC_MAX_FRM_COUNT";
    ZnpCommandStatus[ZnpCommandStatus["SEC_CCM_FAIL"] = 164] = "SEC_CCM_FAIL";
    ZnpCommandStatus[ZnpCommandStatus["NWK_INVALID_PARAM"] = 193] = "NWK_INVALID_PARAM";
    ZnpCommandStatus[ZnpCommandStatus["NWK_INVALID_REQUEST"] = 194] = "NWK_INVALID_REQUEST";
    ZnpCommandStatus[ZnpCommandStatus["NWK_NOT_PERMITTED"] = 195] = "NWK_NOT_PERMITTED";
    ZnpCommandStatus[ZnpCommandStatus["NWK_STARTUP_FAILURE"] = 196] = "NWK_STARTUP_FAILURE";
    ZnpCommandStatus[ZnpCommandStatus["NWK_ALREADY_PRESENT"] = 197] = "NWK_ALREADY_PRESENT";
    ZnpCommandStatus[ZnpCommandStatus["NWK_SYNC_FAILURE"] = 198] = "NWK_SYNC_FAILURE";
    ZnpCommandStatus[ZnpCommandStatus["NWK_TABLE_FULL"] = 199] = "NWK_TABLE_FULL";
    ZnpCommandStatus[ZnpCommandStatus["NWK_UNKNOWN_DEVICE"] = 200] = "NWK_UNKNOWN_DEVICE";
    ZnpCommandStatus[ZnpCommandStatus["NWK_UNSUPPORTED_ATTRIBUTE"] = 201] = "NWK_UNSUPPORTED_ATTRIBUTE";
    ZnpCommandStatus[ZnpCommandStatus["NWK_NO_NETWORKS"] = 202] = "NWK_NO_NETWORKS";
    ZnpCommandStatus[ZnpCommandStatus["NWK_LEAVE_UNCONFIRMED"] = 203] = "NWK_LEAVE_UNCONFIRMED";
    ZnpCommandStatus[ZnpCommandStatus["NWK_NO_ACK"] = 204] = "NWK_NO_ACK";
    ZnpCommandStatus[ZnpCommandStatus["NWK_NO_ROUTE"] = 205] = "NWK_NO_ROUTE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_BEACON_LOSS"] = 224] = "MAC_BEACON_LOSS";
    ZnpCommandStatus[ZnpCommandStatus["MAC_CHANNEL_ACCESS_FAILURE"] = 225] = "MAC_CHANNEL_ACCESS_FAILURE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_DENIED"] = 226] = "MAC_DENIED";
    ZnpCommandStatus[ZnpCommandStatus["MAC_DISABLE_TRX_FAILURE"] = 227] = "MAC_DISABLE_TRX_FAILURE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_FAILED_SECURITY_CHECK"] = 228] = "MAC_FAILED_SECURITY_CHECK";
    ZnpCommandStatus[ZnpCommandStatus["MAC_FRAME_TOO_LONG"] = 229] = "MAC_FRAME_TOO_LONG";
    ZnpCommandStatus[ZnpCommandStatus["MAC_INVALID_GTS"] = 230] = "MAC_INVALID_GTS";
    ZnpCommandStatus[ZnpCommandStatus["MAC_INVALID_HANDLE"] = 231] = "MAC_INVALID_HANDLE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_INVALID_PARAMETER"] = 232] = "MAC_INVALID_PARAMETER";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_ACK"] = 233] = "MAC_NO_ACK";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_BEACON"] = 234] = "MAC_NO_BEACON";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_DATA"] = 235] = "MAC_NO_DATA";
    ZnpCommandStatus[ZnpCommandStatus["MAC_NO_SHORT_ADDR"] = 236] = "MAC_NO_SHORT_ADDR";
    ZnpCommandStatus[ZnpCommandStatus["MAC_OUT_OF_CAP"] = 237] = "MAC_OUT_OF_CAP";
    ZnpCommandStatus[ZnpCommandStatus["MAC_PANID_CONFLICT"] = 238] = "MAC_PANID_CONFLICT";
    ZnpCommandStatus[ZnpCommandStatus["MAC_REALIGNMENT"] = 239] = "MAC_REALIGNMENT";
    ZnpCommandStatus[ZnpCommandStatus["MAC_TRANSACTION_EXPIRED"] = 240] = "MAC_TRANSACTION_EXPIRED";
    ZnpCommandStatus[ZnpCommandStatus["MAC_TRANSACTION_OVERFLOW"] = 241] = "MAC_TRANSACTION_OVERFLOW";
    ZnpCommandStatus[ZnpCommandStatus["MAC_TX_ACTIVE"] = 242] = "MAC_TX_ACTIVE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_UNAVAILABLE_KEY"] = 243] = "MAC_UNAVAILABLE_KEY";
    ZnpCommandStatus[ZnpCommandStatus["MAC_UNSUPPORTED_ATTRIBUTE"] = 244] = "MAC_UNSUPPORTED_ATTRIBUTE";
    ZnpCommandStatus[ZnpCommandStatus["MAC_UNSUPPORTED"] = 245] = "MAC_UNSUPPORTED";
    ZnpCommandStatus[ZnpCommandStatus["MAC_ON_TIME_TOO_LING"] = 246] = "MAC_ON_TIME_TOO_LING";
    ZnpCommandStatus[ZnpCommandStatus["MAC_PAST_TIME"] = 247] = "MAC_PAST_TIME";
    ZnpCommandStatus[ZnpCommandStatus["MAC_TRACKING_OFF"] = 248] = "MAC_TRACKING_OFF";
    ZnpCommandStatus[ZnpCommandStatus["MAC_SCAN_IN_PROGRESS"] = 252] = "MAC_SCAN_IN_PROGRESS";
    ZnpCommandStatus[ZnpCommandStatus["MAC_SRC_MATCH_INVALID_INDEX"] = 255] = "MAC_SRC_MATCH_INVALID_INDEX";
})(ZnpCommandStatus || (exports.ZnpCommandStatus = ZnpCommandStatus = {}));
var CapabInfoMask;
(function (CapabInfoMask) {
    CapabInfoMask[CapabInfoMask["ALTPANCOORD"] = 1] = "ALTPANCOORD";
    CapabInfoMask[CapabInfoMask["DEVICETYPE_FFD"] = 2] = "DEVICETYPE_FFD";
    CapabInfoMask[CapabInfoMask["POWER_AC"] = 4] = "POWER_AC";
    CapabInfoMask[CapabInfoMask["RCVR_ON_IDLE"] = 8] = "RCVR_ON_IDLE";
    CapabInfoMask[CapabInfoMask["SECURITY_CAPABLE"] = 64] = "SECURITY_CAPABLE";
    CapabInfoMask[CapabInfoMask["ALLOC_ADDR"] = 128] = "ALLOC_ADDR";
})(CapabInfoMask || (exports.CapabInfoMask = CapabInfoMask = {}));
var SecurityLevel;
(function (SecurityLevel) {
    SecurityLevel[SecurityLevel["NONE"] = 0] = "NONE";
    SecurityLevel[SecurityLevel["MIC_32"] = 1] = "MIC_32";
    SecurityLevel[SecurityLevel["MIC_64"] = 2] = "MIC_64";
    SecurityLevel[SecurityLevel["MIC_128"] = 3] = "MIC_128";
    SecurityLevel[SecurityLevel["ENC"] = 4] = "ENC";
    SecurityLevel[SecurityLevel["ENC_MIC_32"] = 5] = "ENC_MIC_32";
    SecurityLevel[SecurityLevel["ENC_MIC_64"] = 6] = "ENC_MIC_64";
    SecurityLevel[SecurityLevel["ENC_MIC_128"] = 7] = "ENC_MIC_128";
})(SecurityLevel || (exports.SecurityLevel = SecurityLevel = {}));
var ScanDuration;
(function (ScanDuration) {
    ScanDuration[ScanDuration["CH_CHANGE_REQ"] = 254] = "CH_CHANGE_REQ";
    ScanDuration[ScanDuration["CH_MASK_CHANGE_REQ"] = 255] = "CH_MASK_CHANGE_REQ";
    ScanDuration[ScanDuration["T_NO_BEACONS"] = 15] = "T_NO_BEACONS";
    ScanDuration[ScanDuration["T_4_MINUTES"] = 14] = "T_4_MINUTES";
    ScanDuration[ScanDuration["T_2_MINUTES"] = 13] = "T_2_MINUTES";
    ScanDuration[ScanDuration["T_1_MINUTE"] = 12] = "T_1_MINUTE";
    ScanDuration[ScanDuration["T_31_SECONDS"] = 11] = "T_31_SECONDS";
    ScanDuration[ScanDuration["T_15_SECONDS"] = 10] = "T_15_SECONDS";
    ScanDuration[ScanDuration["T_7_5_SECONDS"] = 9] = "T_7_5_SECONDS";
    ScanDuration[ScanDuration["T_4_SECONDS"] = 8] = "T_4_SECONDS";
    ScanDuration[ScanDuration["T_2_SECONDS"] = 7] = "T_2_SECONDS";
    ScanDuration[ScanDuration["T_1_SECOND"] = 6] = "T_1_SECOND";
    ScanDuration[ScanDuration["T_480_MSEC"] = 5] = "T_480_MSEC";
    ScanDuration[ScanDuration["T_240_MSEC"] = 4] = "T_240_MSEC";
    ScanDuration[ScanDuration["T_120_MSEC"] = 3] = "T_120_MSEC";
    ScanDuration[ScanDuration["T_60_MSEC"] = 2] = "T_60_MSEC";
    ScanDuration[ScanDuration["T_30_MSEC"] = 1] = "T_30_MSEC";
    ScanDuration[ScanDuration["T_15_MSEC"] = 0] = "T_15_MSEC";
})(ScanDuration || (exports.ScanDuration = ScanDuration = {}));
//# sourceMappingURL=common.js.map