/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.recording;

import java.awt.Font;
import java.text.Format;
import java.text.NumberFormat;
import java.time.Duration;
import javax.swing.JLabel;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.utils.DurationFormatter;
import org.graalvm.visualvm.jfr.utils.InstantFormatter;
import org.graalvm.visualvm.jfr.views.recording.RecordingNode;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;

final class RecordingRenderers {
    RecordingRenderers() {
    }

    private static int getMinimumWidth(String valueName) {
        return new JLabel((String)valueName).getPreferredSize().width + 30;
    }

    static class DestinationRenderer
    extends LabelRenderer {
        DestinationRenderer() {
            this.setHorizontalAlignment(11);
        }

        static String getDisplayName() {
            return "Destination";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue("aLongDestinationPathServingAsATemplate", -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(DestinationRenderer.getDisplayName()));
        }
    }

    static class AgeRenderer
    extends DurationRenderer {
        AgeRenderer() {
        }

        static String getDisplayName() {
            return "Max Age";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        @Override
        int getPreferredWidth() {
            this.setValue(999999999L, -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(AgeRenderer.getDisplayName()));
        }
    }

    static class SizeRenderer
    extends FormattedLabelRenderer {
        SizeRenderer() {
            super(Formatters.bytesFormat());
            this.setHorizontalAlignment(11);
        }

        public void setValue(Object value, int row) {
            if (!(value instanceof Long) || (Long)value >= 0L) {
                super.setValue(value, row);
            } else {
                this.setText("");
            }
        }

        static String getDisplayName() {
            return "Max Size";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(99999999999999L, -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(SizeRenderer.getDisplayName()));
        }
    }

    static class IdRenderer
    extends FormattedLabelRenderer {
        IdRenderer() {
            super((Format)NumberFormat.getNumberInstance());
            this.setHorizontalAlignment(11);
        }

        public void setValue(Object value, int row) {
            if (value instanceof Long && (Long)value == -1L) {
                this.setText("");
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Id";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(123456L, -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(IdRenderer.getDisplayName())) + 30;
        }
    }

    static class DurationRenderer
    extends LabelRenderer {
        DurationRenderer() {
            this.setHorizontalAlignment(11);
        }

        public void setValue(Object value, int row) {
            if (value == null) {
                this.setText("");
            } else if (value instanceof Duration) {
                Duration duration = (Duration)value;
                this.setText(DurationFormatter.format(duration));
            } else if (value instanceof Long) {
                long duration = (Long)value;
                if (duration == -1L) {
                    this.setText("");
                } else {
                    this.setText(DurationFormatter.format(Duration.ofNanos(duration)));
                }
            } else {
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Duration";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(999999999L, -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(DurationRenderer.getDisplayName()));
        }
    }

    static class StartRenderer
    extends TimeRenderer {
        StartRenderer(JFRModel model) {
            super(model);
        }

        static String getDisplayName() {
            return "Start";
        }

        static boolean isInitiallyVisible() {
            return true;
        }
    }

    static class TimeRenderer
    extends LabelRenderer {
        private final JFRModel model;

        TimeRenderer(JFRModel model) {
            this.model = model;
            this.setHorizontalAlignment(11);
        }

        public void setValue(Object value, int row) {
            long nanos = value instanceof Long ? (Long)value : Long.MIN_VALUE;
            this.setText(nanos > Long.MIN_VALUE ? InstantFormatter.format(this.model.nsToAbsoluteTime(nanos)) : "");
        }

        static String getDisplayName() {
            return "Time";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue(System.currentTimeMillis(), -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(TimeRenderer.getDisplayName())) + 30;
        }
    }

    static class ThreadRenderer
    extends LabelRenderer {
        ThreadRenderer() {
            this.setHorizontalAlignment(11);
        }

        static String getDisplayName() {
            return "Thread";
        }

        static boolean isInitiallyVisible() {
            return false;
        }

        int getPreferredWidth() {
            this.setValue("aLongThreadNameServingAsATemplate", -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(ThreadRenderer.getDisplayName()));
        }
    }

    static class ValueRenderer
    extends LabelRenderer {
        ValueRenderer() {
            this.setHorizontalAlignment(11);
        }

        static String getDisplayName() {
            return "Value";
        }

        static boolean isInitiallyVisible() {
            return true;
        }

        int getPreferredWidth() {
            this.setValue("referenceValueString", -1);
            return Math.max(this.getPreferredSize().width, RecordingRenderers.getMinimumWidth(ValueRenderer.getDisplayName()));
        }
    }

    static class NameRenderer
    extends LabelRenderer {
        private static Font regular;
        private static Font bold;

        NameRenderer() {
        }

        public void setValue(Object value, int row) {
            if (value instanceof RecordingNode) {
                RecordingNode node = (RecordingNode)((Object)value);
                RecordingNode parent = node.getParent();
                this.setFont(node.getChildCount() > 0 && parent != null && parent.getParent() == null ? NameRenderer.bold() : NameRenderer.regular());
                this.setText(node.name);
            } else {
                this.setFont(value == null || "<no recordings>".equals(value.toString()) ? NameRenderer.regular() : NameRenderer.bold());
                super.setValue(value, row);
            }
        }

        static String getDisplayName() {
            return "Name";
        }

        private static Font regular() {
            if (regular == null) {
                regular = new LabelRenderer().getFont();
            }
            return regular;
        }

        private static Font bold() {
            if (bold == null) {
                bold = new LabelRenderer().getFont().deriveFont(1);
            }
            return bold;
        }
    }
}

