/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.multitabs.StackLayout;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.TabbedImpl;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.openide.windows.TopComponent;

public final class TabContainer
extends JPanel
implements Tabbed.Accessor,
ChangeListener {
    private final TabbedImpl tabbedImpl;
    private final JPanel tcPanel;
    private final TabDisplayer displayer;
    private final StackLayout layout = new StackLayout();

    TabContainer(TabbedImpl tabbedImpl, TabDisplayer tabDisplayer, int n) {
        super(new BorderLayout(0, 0));
        this.tabbedImpl = tabbedImpl;
        this.displayer = tabDisplayer;
        this.tcPanel = new JPanel(this.layout);
        this.add((Component)this.tcPanel, "Center");
        tabbedImpl.getSelectionModel().addChangeListener(this);
        String string = UIManager.getLookAndFeel().getID();
        if ("Nimbus".equals(string)) {
            this.setBorder(new MatteBorder(1, 1, 1, 1, UIManager.getColor("nimbusBorder")));
        } else if ("Aqua".equals(string)) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.setBorder(UIManager.getBorder("Nb.ScrollPane.border"));
        }
        switch (n) {
            case 1: {
                this.add((Component)this.displayer, "North");
                break;
            }
            case 2: {
                this.add((Component)this.displayer, "West");
                break;
            }
            case 4: {
                this.add((Component)this.displayer, "East");
                break;
            }
            case 3: {
                this.add((Component)this.displayer, "South");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid orientation: " + n);
            }
        }
        this.stateChanged(null);
    }

    public final Tabbed getTabbed() {
        return this.tabbedImpl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        TopComponent topComponent = this.tabbedImpl.getSelectedTopComponent();
        if (topComponent != null) {
            boolean bl = topComponent.isVisible();
            this.layout.showComponent((Component)topComponent, this.tcPanel);
            if (!bl) {
                topComponent.requestFocusInWindow();
            }
        }
    }

    Rectangle getContentArea() {
        return this.tcPanel.getBounds();
    }

    TabDisplayer getTabDisplayer() {
        return this.displayer;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.tabbedImpl.getTabModel().addChangeListener((ChangeListener)this);
        this.stateChanged(null);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tabbedImpl.getTabModel().removeChangeListener((ChangeListener)this);
    }
}

