/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.SampledMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.SampledMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.memory.MemoryView;
import org.graalvm.visualvm.lib.ui.swing.ExportUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.renderer.CheckBoxRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;

abstract class SampledTableView
extends MemoryView {
    private MemoryTableModel tableModel;
    private ProfilerTable table;
    private String[] names;
    private int[] instances;
    private long[] bytes;
    private ClientUtils.SourceCodeSelection[] classNames;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private HideableBarRenderer[] renderers;

    SampledTableView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.table;
    }

    @Override
    public void setData(MemoryResultsSnapshot snapshot, GenericFilter filter, int aggregation) {
        final SampledMemoryResultsSnapshot _snapshot = (SampledMemoryResultsSnapshot)snapshot;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean diff = _snapshot instanceof SampledMemoryResultsDiff;
                long totalSize = 0L;
                long _totalSize = 0L;
                long totalInstances = 0L;
                long _totalInstances = 0L;
                SampledTableView.access$002(SampledTableView.this, _snapshot.getClassNames());
                SampledTableView.access$102(SampledTableView.this, _snapshot.getObjectsCounts());
                SampledTableView.access$202(SampledTableView.this, _snapshot.getObjectsSizePerClass());
                SampledTableView.access$302(SampledTableView.this, new ClientUtils.SourceCodeSelection[SampledTableView.this.names.length]);
                for (int i = 0; i < SampledTableView.this.names.length; ++i) {
                    if (diff) {
                        totalInstances = Math.max(totalInstances, (long)SampledTableView.this.instances[i]);
                        _totalInstances = Math.min(_totalInstances, (long)SampledTableView.this.instances[i]);
                        totalSize = Math.max(totalSize, SampledTableView.this.bytes[i]);
                        _totalSize = Math.min(_totalSize, SampledTableView.this.bytes[i]);
                    } else {
                        totalInstances += (long)SampledTableView.this.instances[i];
                        totalSize += SampledTableView.this.bytes[i];
                    }
                    ((SampledTableView)SampledTableView.this).classNames[i] = new ClientUtils.SourceCodeSelection(SampledTableView.this.names[i], "*", null);
                }
                if (diff) {
                    SampledTableView.this.renderers[0].setMaxValue(Math.max(Math.abs(totalSize), Math.abs(_totalSize)));
                    SampledTableView.this.renderers[1].setMaxValue(Math.max(Math.abs(totalInstances), Math.abs(_totalInstances)));
                } else {
                    SampledTableView.this.renderers[0].setMaxValue(totalSize);
                    SampledTableView.this.renderers[1].setMaxValue(totalInstances);
                }
                SampledTableView.this.renderers[0].setDiffMode(diff);
                SampledTableView.this.renderers[1].setDiffMode(diff);
                SampledTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void resetData() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SampledTableView.access$002(SampledTableView.this, null);
                SampledTableView.access$102(SampledTableView.this, null);
                SampledTableView.access$202(SampledTableView.this, null);
                SampledTableView.access$302(SampledTableView.this, null);
                SampledTableView.this.renderers[0].setMaxValue(0L);
                SampledTableView.this.renderers[1].setMaxValue(0L);
                SampledTableView.this.renderers[0].setDiffMode(false);
                SampledTableView.this.renderers[1].setDiffMode(false);
                SampledTableView.this.tableModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.table.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.table.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.table);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider(this.table, EXPORT_LIVE);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider(this.table, EXPORT_LIVE);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.table);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        int offset = this.selection == null ? -1 : 0;
        this.tableModel = new MemoryTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return SampledTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                SampledTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                SampledTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                SampledTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = LIVE_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = LIVE_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = LIVE_COUNT_COLUMN_TOOLTIP;
        }
        this.table.setColumnToolTips(stringArray);
        this.table.providePopupMenu(true);
        this.installDefaultAction();
        this.table.setMainColumn(1 + offset);
        this.table.setFitWidthColumn(1 + offset);
        this.table.setSortColumn(2 + offset);
        this.table.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.table.setColumnVisibility(0, false);
        }
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.table.setColumnRenderer(0, new CheckBoxRenderer());
        }
        this.table.setColumnRenderer(1 + offset, new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(2 + offset, this.renderers[0]);
        this.table.setColumnRenderer(3 + offset, this.renderers[1]);
        if (this.selection != null) {
            int w = new JLabel((String)this.table.getColumnName((int)0)).getPreferredSize().width;
            this.table.setDefaultColumnWidth(0, w + 15);
        }
        this.table.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        if (this.names == null || row == -1) {
            return null;
        }
        if (row >= this.tableModel.getRowCount()) {
            return null;
        }
        return this.classNames[this.table.convertRowIndexToModel(row)];
    }

    static /* synthetic */ String[] access$002(SampledTableView x0, String[] x1) {
        x0.names = x1;
        return x1;
    }

    static /* synthetic */ int[] access$102(SampledTableView x0, int[] x1) {
        x0.instances = x1;
        return x1;
    }

    static /* synthetic */ long[] access$202(SampledTableView x0, long[] x1) {
        x0.bytes = x1;
        return x1;
    }

    static /* synthetic */ ClientUtils.SourceCodeSelection[] access$302(SampledTableView x0, ClientUtils.SourceCodeSelection[] x1) {
        x0.classNames = x1;
        return x1;
    }

    private class MemoryTableModel
    extends AbstractTableModel {
        private MemoryTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (SampledTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return MemoryView.COLUMN_LIVE_BYTES;
            }
            if (columnIndex == 3) {
                return MemoryView.COLUMN_LIVE_OBJECTS;
            }
            if (columnIndex == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (SampledTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return SampledTableView.this.names == null ? 0 : SampledTableView.this.names.length;
        }

        @Override
        public int getColumnCount() {
            return SampledTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (SampledTableView.this.names == null) {
                return null;
            }
            if (SampledTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return SampledTableView.this.names[rowIndex];
            }
            if (columnIndex == 2) {
                return SampledTableView.this.bytes[rowIndex];
            }
            if (columnIndex == 3) {
                return SampledTableView.this.instances[rowIndex];
            }
            if (columnIndex == 0) {
                if (SampledTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return SampledTableView.this.selection.contains(SampledTableView.this.classNames[rowIndex]);
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (SampledTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                if (Boolean.FALSE.equals(aValue)) {
                    SampledTableView.this.selection.remove(SampledTableView.this.classNames[rowIndex]);
                } else {
                    SampledTableView.this.selection.add(SampledTableView.this.classNames[rowIndex]);
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (SampledTableView.this.selection == null) {
                ++columnIndex;
            }
            return columnIndex == 0;
        }
    }
}

