/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS.config;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import lombok.Generated;
import org.apache.hadoop.shaded.com.sun.jna.Memory;
import org.apache.hadoop.shaded.com.sun.jna.Pointer;
import org.apache.hadoop.shaded.com.sun.jna.platform.win32.Win32Exception;
import org.apache.hadoop.shaded.com.sun.jna.ptr.IntByReference;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.config.BaseResolverConfigProvider;
import org.apache.hadoop.shaded.org.xbill.DNS.config.IPHlpAPI;
import org.apache.hadoop.shaded.org.xbill.DNS.config.InitializationException;
import org.apache.hadoop.shaded.org.xbill.DNS.config.ResolverConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsResolverConfigProvider
implements ResolverConfigProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsResolverConfigProvider.class);
    private InnerWindowsResolverConfigProvider inner;

    public WindowsResolverConfigProvider() {
        if (System.getProperty("os.name").contains("Windows")) {
            try {
                this.inner = new InnerWindowsResolverConfigProvider();
            }
            catch (NoClassDefFoundError e) {
                log.debug("JNA not available");
            }
        }
    }

    @Override
    public void initialize() throws InitializationException {
        this.inner.initialize();
    }

    @Override
    public List<InetSocketAddress> servers() {
        return this.inner.servers();
    }

    @Override
    public List<Name> searchPaths() {
        return this.inner.searchPaths();
    }

    @Override
    public boolean isEnabled() {
        return this.inner != null;
    }

    private static final class InnerWindowsResolverConfigProvider
    extends BaseResolverConfigProvider {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(InnerWindowsResolverConfigProvider.class);

        private InnerWindowsResolverConfigProvider() {
        }

        @Override
        public void initialize() throws InitializationException {
            int flags = 39;
            Memory buffer = new Memory(15360L);
            IntByReference size = new IntByReference(0);
            int error = IPHlpAPI.INSTANCE.GetAdaptersAddresses(0, flags, Pointer.NULL, (Pointer)buffer, size);
            if (error == 111 && (error = IPHlpAPI.INSTANCE.GetAdaptersAddresses(0, flags, Pointer.NULL, (Pointer)(buffer = new Memory((long)size.getValue())), size)) != 0) {
                throw new InitializationException((Exception)new Win32Exception(error));
            }
            IPHlpAPI.IP_ADAPTER_ADDRESSES_LH result = new IPHlpAPI.IP_ADAPTER_ADDRESSES_LH((Pointer)buffer);
            do {
                if (result.OperStatus != 1) continue;
                IPHlpAPI.IP_ADAPTER_DNS_SERVER_ADDRESS_XP.ByReference dns = result.FirstDnsServerAddress;
                while (dns != null) {
                    try {
                        InetAddress address = dns.Address.toAddress();
                        if (address instanceof Inet4Address || !address.isSiteLocalAddress()) {
                            this.addNameserver(new InetSocketAddress(address, 53));
                        } else {
                            log.debug("Skipped site-local IPv6 server address {} on adapter index {}", (Object)address, (Object)result.IfIndex);
                        }
                    }
                    catch (UnknownHostException e) {
                        log.warn("Invalid nameserver address on adapter index {}", (Object)result.IfIndex, (Object)e);
                    }
                    dns = dns.Next;
                }
                this.addSearchPath(result.DnsSuffix.toString());
                IPHlpAPI.IP_ADAPTER_DNS_SUFFIX.ByReference suffix = result.FirstDnsSuffix;
                while (suffix != null) {
                    this.addSearchPath(String.valueOf(suffix._String));
                    suffix = suffix.Next;
                }
            } while ((result = result.Next) != null);
        }

        static {
            log.debug("Checking for JNA classes: {} and {}", (Object)Memory.class.getName(), (Object)Win32Exception.class.getName());
        }
    }
}

