/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.ClientMetricsInstanceMetadata;

public class ClientMetricsInstance {
    private final Uuid clientInstanceId;
    private final ClientMetricsInstanceMetadata instanceMetadata;
    private final int subscriptionId;
    private final int subscriptionVersion;
    private final Set<String> metrics;
    private final int pushIntervalMs;
    private long lastGetRequestTimestamp;
    private long lastPushRequestTimestamp;
    private volatile boolean terminating;
    private volatile Errors lastKnownError;

    public ClientMetricsInstance(Uuid clientInstanceId, ClientMetricsInstanceMetadata instanceMetadata, int subscriptionId, int subscriptionVersion, Set<String> metrics, int pushIntervalMs) {
        this.clientInstanceId = Objects.requireNonNull(clientInstanceId);
        this.instanceMetadata = Objects.requireNonNull(instanceMetadata);
        this.subscriptionId = subscriptionId;
        this.subscriptionVersion = subscriptionVersion;
        this.metrics = metrics;
        this.terminating = false;
        this.pushIntervalMs = pushIntervalMs;
        this.lastKnownError = Errors.NONE;
    }

    public Uuid clientInstanceId() {
        return this.clientInstanceId;
    }

    public ClientMetricsInstanceMetadata instanceMetadata() {
        return this.instanceMetadata;
    }

    public int pushIntervalMs() {
        return this.pushIntervalMs;
    }

    public int subscriptionId() {
        return this.subscriptionId;
    }

    public int subscriptionVersion() {
        return this.subscriptionVersion;
    }

    public Set<String> metrics() {
        return this.metrics;
    }

    public boolean terminating() {
        return this.terminating;
    }

    public synchronized void terminating(boolean terminating) {
        this.terminating = terminating;
    }

    public Errors lastKnownError() {
        return this.lastKnownError;
    }

    public synchronized void lastKnownError(Errors lastKnownError) {
        this.lastKnownError = lastKnownError;
    }

    public synchronized boolean maybeUpdateGetRequestTimestamp(long currentTime) {
        long lastRequestTimestamp = Math.max(this.lastGetRequestTimestamp, this.lastPushRequestTimestamp);
        long timeElapsedSinceLastMsg = currentTime - lastRequestTimestamp;
        if (timeElapsedSinceLastMsg >= (long)this.pushIntervalMs) {
            this.lastGetRequestTimestamp = currentTime;
            return true;
        }
        return false;
    }

    public synchronized boolean maybeUpdatePushRequestTimestamp(long currentTime) {
        boolean canAccept;
        boolean bl = canAccept = this.lastGetRequestTimestamp > this.lastPushRequestTimestamp;
        if (!canAccept) {
            long lastRequestTimestamp = Math.max(this.lastGetRequestTimestamp, this.lastPushRequestTimestamp);
            long timeElapsedSinceLastMsg = currentTime - lastRequestTimestamp;
            boolean bl2 = canAccept = timeElapsedSinceLastMsg >= (long)this.pushIntervalMs;
        }
        if (canAccept) {
            this.lastPushRequestTimestamp = currentTime;
        }
        return canAccept;
    }
}

