/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class PartitionChangeRecord
implements ApiMessage {
    int partitionId;
    Uuid topicId;
    List<Integer> isr;
    int leader;
    List<Integer> replicas;
    List<Integer> removingReplicas;
    List<Integer> addingReplicas;
    byte leaderRecoveryState;
    List<Uuid> directories;
    List<Integer> eligibleLeaderReplicas;
    List<Integer> lastKnownELR;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("isr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the ISR didn't change; the new in-sync replicas otherwise."), 1, new Field("leader", (Type)Type.INT32, "-1 if there is now no leader; -2 if the leader didn't change; the new leader otherwise."), 2, new Field("replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the replicas didn't change; the new replicas otherwise."), 3, new Field("removing_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the removing replicas didn't change; the new removing replicas otherwise."), 4, new Field("adding_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the adding replicas didn't change; the new adding replicas otherwise."), 5, new Field("leader_recovery_state", (Type)Type.INT8, "-1 if it didn't change; 0 if the leader was elected from the ISR or recovered from an unclean election; 1 if the leader that was elected using unclean leader election and it is still recovering.")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("isr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the ISR didn't change; the new in-sync replicas otherwise."), 1, new Field("leader", (Type)Type.INT32, "-1 if there is now no leader; -2 if the leader didn't change; the new leader otherwise."), 2, new Field("replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the replicas didn't change; the new replicas otherwise."), 3, new Field("removing_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the removing replicas didn't change; the new removing replicas otherwise."), 4, new Field("adding_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the adding replicas didn't change; the new adding replicas otherwise."), 5, new Field("leader_recovery_state", (Type)Type.INT8, "-1 if it didn't change; 0 if the leader was elected from the ISR or recovered from an unclean election; 1 if the leader that was elected using unclean leader election and it is still recovering."), 8, new Field("directories", (Type)CompactArrayOf.nullable((Type)Type.UUID), "null if the log dirs didn't change; the new log directory for each replica otherwise.")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("isr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the ISR didn't change; the new in-sync replicas otherwise."), 1, new Field("leader", (Type)Type.INT32, "-1 if there is now no leader; -2 if the leader didn't change; the new leader otherwise."), 2, new Field("replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the replicas didn't change; the new replicas otherwise."), 3, new Field("removing_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the removing replicas didn't change; the new removing replicas otherwise."), 4, new Field("adding_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the adding replicas didn't change; the new adding replicas otherwise."), 5, new Field("leader_recovery_state", (Type)Type.INT8, "-1 if it didn't change; 0 if the leader was elected from the ISR or recovered from an unclean election; 1 if the leader that was elected using unclean leader election and it is still recovering."), 8, new Field("directories", (Type)CompactArrayOf.nullable((Type)Type.UUID), "null if the log dirs didn't change; the new log directory for each replica otherwise."), 6, new Field("eligible_leader_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the ELR didn't change; the new eligible leader replicas otherwise."), 7, new Field("last_known_elr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "null if the LastKnownELR didn't change; the last known eligible leader replicas otherwise.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public PartitionChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public PartitionChangeRecord() {
        this.partitionId = -1;
        this.topicId = Uuid.ZERO_UUID;
        this.isr = null;
        this.leader = -2;
        this.replicas = null;
        this.removingReplicas = null;
        this.addingReplicas = null;
        this.leaderRecoveryState = (byte)-1;
        this.directories = null;
        this.eligibleLeaderReplicas = null;
        this.lastKnownELR = null;
    }

    public short apiKey() {
        return 5;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public final void read(Readable _readable, short _version) {
        this.partitionId = _readable.readInt();
        this.topicId = _readable.readUuid();
        this.isr = null;
        this.leader = -2;
        this.replicas = null;
        this.removingReplicas = null;
        this.addingReplicas = null;
        this.leaderRecoveryState = (byte)-1;
        this.directories = null;
        this.eligibleLeaderReplicas = null;
        this.lastKnownELR = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block11: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.isr = null;
                        continue block11;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.isr = newCollection;
                    continue block11;
                }
                case 1: {
                    this.leader = _readable.readInt();
                    continue block11;
                }
                case 2: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.replicas = null;
                        continue block11;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.replicas = newCollection;
                    continue block11;
                }
                case 3: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.removingReplicas = null;
                        continue block11;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.removingReplicas = newCollection;
                    continue block11;
                }
                case 4: {
                    int i;
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.addingReplicas = null;
                        continue block11;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<Integer> newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(_readable.readInt());
                    }
                    this.addingReplicas = newCollection;
                    continue block11;
                }
                case 5: {
                    this.leaderRecoveryState = _readable.readByte();
                    continue block11;
                }
                case 8: {
                    int i;
                    ArrayList<Integer> newCollection;
                    int arrayLength;
                    if (_version >= 1) {
                        arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.directories = null;
                            continue block11;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add((Integer)_readable.readUuid());
                        }
                        this.directories = newCollection;
                        continue block11;
                    }
                    throw new RuntimeException("Tag 8 is not valid for version " + _version);
                }
                case 6: {
                    int i;
                    ArrayList<Integer> newCollection;
                    int arrayLength;
                    if (_version >= 2) {
                        arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.eligibleLeaderReplicas = null;
                            continue block11;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.eligibleLeaderReplicas = newCollection;
                        continue block11;
                    }
                    throw new RuntimeException("Tag 6 is not valid for version " + _version);
                }
                case 7: {
                    int i;
                    ArrayList<Integer> newCollection;
                    int arrayLength;
                    if (_version >= 2) {
                        arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.lastKnownELR = null;
                            continue block11;
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.lastKnownELR = newCollection;
                        continue block11;
                    }
                    throw new RuntimeException("Tag 7 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.partitionId);
        _writable.writeUuid(this.topicId);
        if (this.isr != null) {
            ++_numTaggedFields;
        }
        if (this.leader != -2) {
            ++_numTaggedFields;
        }
        if (this.replicas != null) {
            ++_numTaggedFields;
        }
        if (this.removingReplicas != null) {
            ++_numTaggedFields;
        }
        if (this.addingReplicas != null) {
            ++_numTaggedFields;
        }
        if (this.leaderRecoveryState != -1) {
            ++_numTaggedFields;
        }
        if (_version >= 1) {
            if (this.directories != null) {
                ++_numTaggedFields;
            }
        } else if (this.directories != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (this.eligibleLeaderReplicas != null) {
                ++_numTaggedFields;
            }
        } else if (this.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (this.lastKnownELR != null) {
                ++_numTaggedFields;
            }
        } else if (this.lastKnownELR != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownELR at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.isr != null) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.isr).intValue());
            _writable.writeUnsignedVarint(this.isr.size() + 1);
            for (Integer isrElement : this.isr) {
                _writable.writeInt(isrElement.intValue());
            }
        }
        if (this.leader != -2) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(4);
            _writable.writeInt(this.leader);
        }
        if (this.replicas != null) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.replicas).intValue());
            _writable.writeUnsignedVarint(this.replicas.size() + 1);
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement.intValue());
            }
        }
        if (this.removingReplicas != null) {
            _writable.writeUnsignedVarint(3);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.removingReplicas).intValue());
            _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
            for (Integer removingReplicasElement : this.removingReplicas) {
                _writable.writeInt(removingReplicasElement.intValue());
            }
        }
        if (this.addingReplicas != null) {
            _writable.writeUnsignedVarint(4);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.addingReplicas).intValue());
            _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
            for (Integer addingReplicasElement : this.addingReplicas) {
                _writable.writeInt(addingReplicasElement.intValue());
            }
        }
        if (this.leaderRecoveryState != -1) {
            _writable.writeUnsignedVarint(5);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.leaderRecoveryState);
        }
        if (_version >= 2 && this.eligibleLeaderReplicas != null) {
            _writable.writeUnsignedVarint(6);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.eligibleLeaderReplicas).intValue());
            _writable.writeUnsignedVarint(this.eligibleLeaderReplicas.size() + 1);
            for (Integer eligibleLeaderReplicasElement : this.eligibleLeaderReplicas) {
                _writable.writeInt(eligibleLeaderReplicasElement.intValue());
            }
        }
        if (_version >= 2 && this.lastKnownELR != null) {
            _writable.writeUnsignedVarint(7);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.lastKnownELR).intValue());
            _writable.writeUnsignedVarint(this.lastKnownELR.size() + 1);
            for (Integer lastKnownELRElement : this.lastKnownELR) {
                _writable.writeInt(lastKnownELRElement.intValue());
            }
        }
        if (_version >= 1 && this.directories != null) {
            _writable.writeUnsignedVarint(8);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.directories).intValue());
            _writable.writeUnsignedVarint(this.directories.size() + 1);
            for (Uuid directoriesElement : this.directories) {
                _writable.writeUuid(directoriesElement);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _sizeBeforeArray;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        if (this.isr != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.isr.size() + 1)));
            _size.addBytes(this.isr.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.isr, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.leader != -2) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(4);
        }
        if (this.replicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicas.size() + 1)));
            _size.addBytes(this.replicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.replicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.removingReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.removingReplicas.size() + 1)));
            _size.addBytes(this.removingReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.removingReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.addingReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.addingReplicas.size() + 1)));
            _size.addBytes(this.addingReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.addingReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this.leaderRecoveryState != -1) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 1 && this.directories != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.directories.size() + 1)));
            _size.addBytes(this.directories.size() * 16);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.directories, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 2 && this.eligibleLeaderReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.eligibleLeaderReplicas.size() + 1)));
            _size.addBytes(this.eligibleLeaderReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.eligibleLeaderReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 2 && this.lastKnownELR != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.lastKnownELR.size() + 1)));
            _size.addBytes(this.lastKnownELR.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.lastKnownELR, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionChangeRecord)) {
            return false;
        }
        PartitionChangeRecord other = (PartitionChangeRecord)obj;
        if (this.partitionId != other.partitionId) {
            return false;
        }
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
            return false;
        }
        if (this.leader != other.leader) {
            return false;
        }
        if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
            return false;
        }
        if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
            return false;
        }
        if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
            return false;
        }
        if (this.leaderRecoveryState != other.leaderRecoveryState) {
            return false;
        }
        if (this.directories == null ? other.directories != null : !this.directories.equals(other.directories)) {
            return false;
        }
        if (this.eligibleLeaderReplicas == null ? other.eligibleLeaderReplicas != null : !this.eligibleLeaderReplicas.equals(other.eligibleLeaderReplicas)) {
            return false;
        }
        if (this.lastKnownELR == null ? other.lastKnownELR != null : !this.lastKnownELR.equals(other.lastKnownELR)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.partitionId;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
        hashCode = 31 * hashCode + this.leader;
        hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
        hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
        hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
        hashCode = 31 * hashCode + this.leaderRecoveryState;
        hashCode = 31 * hashCode + (this.directories == null ? 0 : this.directories.hashCode());
        hashCode = 31 * hashCode + (this.eligibleLeaderReplicas == null ? 0 : this.eligibleLeaderReplicas.hashCode());
        hashCode = 31 * hashCode + (this.lastKnownELR == null ? 0 : this.lastKnownELR.hashCode());
        return hashCode;
    }

    public PartitionChangeRecord duplicate() {
        PartitionChangeRecord _duplicate = new PartitionChangeRecord();
        _duplicate.partitionId = this.partitionId;
        _duplicate.topicId = this.topicId;
        if (this.isr == null) {
            _duplicate.isr = null;
        } else {
            ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
            for (Integer n : this.isr) {
                newIsr.add(n);
            }
            _duplicate.isr = newIsr;
        }
        _duplicate.leader = this.leader;
        if (this.replicas == null) {
            _duplicate.replicas = null;
        } else {
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer n : this.replicas) {
                newReplicas.add(n);
            }
            _duplicate.replicas = newReplicas;
        }
        if (this.removingReplicas == null) {
            _duplicate.removingReplicas = null;
        } else {
            ArrayList<Integer> newRemovingReplicas = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer n : this.removingReplicas) {
                newRemovingReplicas.add(n);
            }
            _duplicate.removingReplicas = newRemovingReplicas;
        }
        if (this.addingReplicas == null) {
            _duplicate.addingReplicas = null;
        } else {
            ArrayList<Integer> newAddingReplicas = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer n : this.addingReplicas) {
                newAddingReplicas.add(n);
            }
            _duplicate.addingReplicas = newAddingReplicas;
        }
        _duplicate.leaderRecoveryState = this.leaderRecoveryState;
        if (this.directories == null) {
            _duplicate.directories = null;
        } else {
            ArrayList<Uuid> newDirectories = new ArrayList<Uuid>(this.directories.size());
            for (Uuid uuid : this.directories) {
                newDirectories.add(uuid);
            }
            _duplicate.directories = newDirectories;
        }
        if (this.eligibleLeaderReplicas == null) {
            _duplicate.eligibleLeaderReplicas = null;
        } else {
            ArrayList<Integer> newEligibleLeaderReplicas = new ArrayList<Integer>(this.eligibleLeaderReplicas.size());
            for (Integer n : this.eligibleLeaderReplicas) {
                newEligibleLeaderReplicas.add(n);
            }
            _duplicate.eligibleLeaderReplicas = newEligibleLeaderReplicas;
        }
        if (this.lastKnownELR == null) {
            _duplicate.lastKnownELR = null;
        } else {
            ArrayList<Integer> newLastKnownELR = new ArrayList<Integer>(this.lastKnownELR.size());
            for (Integer n : this.lastKnownELR) {
                newLastKnownELR.add(n);
            }
            _duplicate.lastKnownELR = newLastKnownELR;
        }
        return _duplicate;
    }

    public String toString() {
        return "PartitionChangeRecord(partitionId=" + this.partitionId + ", topicId=" + this.topicId.toString() + ", isr=" + (this.isr == null ? "null" : MessageUtil.deepToString(this.isr.iterator())) + ", leader=" + this.leader + ", replicas=" + (this.replicas == null ? "null" : MessageUtil.deepToString(this.replicas.iterator())) + ", removingReplicas=" + (this.removingReplicas == null ? "null" : MessageUtil.deepToString(this.removingReplicas.iterator())) + ", addingReplicas=" + (this.addingReplicas == null ? "null" : MessageUtil.deepToString(this.addingReplicas.iterator())) + ", leaderRecoveryState=" + this.leaderRecoveryState + ", directories=" + (this.directories == null ? "null" : MessageUtil.deepToString(this.directories.iterator())) + ", eligibleLeaderReplicas=" + (this.eligibleLeaderReplicas == null ? "null" : MessageUtil.deepToString(this.eligibleLeaderReplicas.iterator())) + ", lastKnownELR=" + (this.lastKnownELR == null ? "null" : MessageUtil.deepToString(this.lastKnownELR.iterator())) + ")";
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<Integer> isr() {
        return this.isr;
    }

    public int leader() {
        return this.leader;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public byte leaderRecoveryState() {
        return this.leaderRecoveryState;
    }

    public List<Uuid> directories() {
        return this.directories;
    }

    public List<Integer> eligibleLeaderReplicas() {
        return this.eligibleLeaderReplicas;
    }

    public List<Integer> lastKnownELR() {
        return this.lastKnownELR;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PartitionChangeRecord setPartitionId(int v) {
        this.partitionId = v;
        return this;
    }

    public PartitionChangeRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public PartitionChangeRecord setIsr(List<Integer> v) {
        this.isr = v;
        return this;
    }

    public PartitionChangeRecord setLeader(int v) {
        this.leader = v;
        return this;
    }

    public PartitionChangeRecord setReplicas(List<Integer> v) {
        this.replicas = v;
        return this;
    }

    public PartitionChangeRecord setRemovingReplicas(List<Integer> v) {
        this.removingReplicas = v;
        return this;
    }

    public PartitionChangeRecord setAddingReplicas(List<Integer> v) {
        this.addingReplicas = v;
        return this;
    }

    public PartitionChangeRecord setLeaderRecoveryState(byte v) {
        this.leaderRecoveryState = v;
        return this;
    }

    public PartitionChangeRecord setDirectories(List<Uuid> v) {
        this.directories = v;
        return this;
    }

    public PartitionChangeRecord setEligibleLeaderReplicas(List<Integer> v) {
        this.eligibleLeaderReplicas = v;
        return this;
    }

    public PartitionChangeRecord setLastKnownELR(List<Integer> v) {
        this.lastKnownELR = v;
        return this;
    }
}

