/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opentracingshim.AutoValue_SpanBuilderShim_SpanParentInfo;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanContextShim;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

final class SpanBuilderShim
implements Tracer.SpanBuilder {
    private static final AttributeKey<String> OPENTRACING_REF_TYPE = AttributeKey.stringKey((String)"opentracing.ref_type");
    private static final String OPEN_TRACING_REF_TYPE_CHILD_OF = "child_of";
    private static final String OPEN_TRACING_REF_TYPE_FOLLOWS_FROM = "follows_from";
    private static final Attributes CHILD_OF_ATTR = Attributes.of(OPENTRACING_REF_TYPE, (Object)"child_of");
    private static final Attributes FOLLOWS_FROM_ATTR = Attributes.of(OPENTRACING_REF_TYPE, (Object)"follows_from");
    private final Tracer tracer;
    private final String spanName;
    private List<SpanParentInfo> allParents = Collections.emptyList();
    private boolean ignoreActiveSpan;
    private final List<AttributeKey<?>> spanBuilderAttributeKeys = new ArrayList();
    private final List<Object> spanBuilderAttributeValues = new ArrayList<Object>();
    @Nullable
    private Boolean error;
    private long startTimestampMicros;

    SpanBuilderShim(Tracer tracer, String spanName) {
        this.tracer = tracer;
        this.spanName = spanName;
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
        SpanShim spanShim = ShimUtil.getSpanShim(parent);
        if (spanShim != null) {
            this.addReference(OPEN_TRACING_REF_TYPE_CHILD_OF, spanShim.context());
        }
        return this;
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.SpanContext parent) {
        return this.addReference(OPEN_TRACING_REF_TYPE_CHILD_OF, parent);
    }

    public Tracer.SpanBuilder addReference(@Nullable String referenceType, io.opentracing.SpanContext referencedContext) {
        ReferenceType refType;
        SpanContextShim contextShim = ShimUtil.getContextShim(referencedContext);
        if (contextShim == null) {
            return this;
        }
        if (OPEN_TRACING_REF_TYPE_CHILD_OF.equals(referenceType)) {
            refType = ReferenceType.CHILD_OF;
        } else if (OPEN_TRACING_REF_TYPE_FOLLOWS_FROM.equals(referenceType)) {
            refType = ReferenceType.FOLLOWS_FROM;
        } else {
            return this;
        }
        if (this.allParents.size() == 0) {
            this.allParents = Collections.singletonList(SpanParentInfo.create(contextShim.getSpanContext(), contextShim.getBaggage(), refType));
        } else {
            if (this.allParents.size() == 1) {
                this.allParents = new ArrayList<SpanParentInfo>(this.allParents);
            }
            this.allParents.add(SpanParentInfo.create(contextShim.getSpanContext(), contextShim.getBaggage(), refType));
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        if (Tags.ERROR.getKey().equals(key)) {
            this.error = Boolean.parseBoolean(value);
        } else {
            this.spanBuilderAttributeKeys.add(AttributeKey.stringKey((String)key));
            this.spanBuilderAttributeValues.add(value);
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key)) {
            this.error = value;
        } else {
            this.spanBuilderAttributeKeys.add(AttributeKey.booleanKey((String)key));
            this.spanBuilderAttributeValues.add(value);
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        if (value == null) {
            return this;
        }
        if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            this.spanBuilderAttributeKeys.add(AttributeKey.longKey((String)key));
            this.spanBuilderAttributeValues.add(value.longValue());
        } else if (value instanceof Float || value instanceof Double) {
            this.spanBuilderAttributeKeys.add(AttributeKey.doubleKey((String)key));
            this.spanBuilderAttributeValues.add(value.doubleValue());
        } else {
            this.spanBuilderAttributeKeys.add(AttributeKey.stringKey((String)key));
            this.spanBuilderAttributeValues.add(value.toString());
        }
        return this;
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        if (tag == null) {
            return this;
        }
        if (value instanceof String) {
            this.withTag(tag.getKey(), (String)value);
        } else if (value instanceof Boolean) {
            this.withTag(tag.getKey(), (Boolean)value);
        } else if (value instanceof Number) {
            this.withTag(tag.getKey(), (Number)value);
        } else {
            this.withTag(tag.getKey(), value.toString());
        }
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTimestampMicros = microseconds;
        return this;
    }

    public io.opentracing.Span start() {
        Baggage baggage;
        SpanBuilder builder = this.tracer.spanBuilder(this.spanName);
        SpanContext mainParent = SpanBuilderShim.getMainParent(this.allParents);
        if (this.ignoreActiveSpan && mainParent == null) {
            builder.setNoParent();
            baggage = Baggage.empty();
        } else if (mainParent != null) {
            builder.setParent(Context.root().with((ImplicitContextKeyed)Span.wrap((SpanContext)mainParent)));
            baggage = SpanBuilderShim.getAllBaggage(this.allParents);
        } else {
            baggage = Baggage.current();
        }
        for (SpanParentInfo parentInfo : this.allParents) {
            builder.addLink(parentInfo.getSpanContext(), parentInfo.getRefType() == ReferenceType.CHILD_OF ? CHILD_OF_ATTR : FOLLOWS_FROM_ATTR);
        }
        if (this.startTimestampMicros > 0L) {
            builder.setStartTimestamp(this.startTimestampMicros, TimeUnit.MICROSECONDS);
        }
        for (int i = 0; i < this.spanBuilderAttributeKeys.size(); ++i) {
            AttributeKey<?> key = this.spanBuilderAttributeKeys.get(i);
            Object value = this.spanBuilderAttributeValues.get(i);
            builder.setAttribute(key, value);
        }
        Span span = builder.startSpan();
        if (this.error != null) {
            span.setStatus(this.error != false ? StatusCode.ERROR : StatusCode.OK);
        }
        return new SpanShim(span, baggage);
    }

    @Nullable
    private static SpanContext getMainParent(List<SpanParentInfo> parents) {
        if (parents.size() == 0) {
            return null;
        }
        SpanParentInfo mainParent = parents.get(0);
        for (SpanParentInfo parentInfo : parents) {
            if (parentInfo.getRefType() != ReferenceType.CHILD_OF) continue;
            mainParent = parentInfo;
            break;
        }
        return mainParent.getSpanContext();
    }

    private static Baggage getAllBaggage(List<SpanParentInfo> parents) {
        if (parents.size() == 0) {
            return Baggage.empty();
        }
        if (parents.size() == 1) {
            return parents.get(0).getBaggage();
        }
        BaggageBuilder builder = Baggage.builder();
        for (SpanParentInfo parent : parents) {
            parent.getBaggage().forEach((key, entry) -> builder.put(key, entry.getValue()));
        }
        return builder.build();
    }

    static enum ReferenceType {
        CHILD_OF,
        FOLLOWS_FROM;

    }

    @AutoValue
    @Immutable
    static abstract class SpanParentInfo {
        SpanParentInfo() {
        }

        private static SpanParentInfo create(SpanContext spanContext, Baggage baggage, ReferenceType refType) {
            return new AutoValue_SpanBuilderShim_SpanParentInfo(spanContext, baggage, refType);
        }

        abstract SpanContext getSpanContext();

        abstract Baggage getBaggage();

        abstract ReferenceType getRefType();
    }
}

