/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrClassLoader;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.pkg.PackageListeners;
import org.apache.solr.pkg.PackageListeningClassLoader;
import org.apache.solr.pkg.SolrPackageLoader;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResourceLoader
implements ResourceLoader,
Closeable,
SolrClassLoader,
SolrCoreAware {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String base = "org.apache.solr";
    private static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "handler.tagger.", "search.", "update.", "core.", "response.", "request.", "update.processor.", "util.", "util.circuitbreaker.", "spelling.", "handler.component.", "spelling.suggest.", "spelling.suggest.fst.", "rest.schema.analysis.", "security.", "handler.admin.", "security.jwt.", "security.hadoop.", "handler.sql.", "hdfs.", "hdfs.update.", "crossdc.handler.", "crossdc.update.processor."};
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final String SOLR_ALLOW_UNSAFE_RESOURCELOADING_PARAM = "solr.allow.unsafe.resourceloading";
    private final boolean allowUnsafeResourceloading;
    private String name = "";
    protected URLClassLoader classLoader;
    private final Path instanceDir;
    private String coreName;
    private UUID coreId;
    private SolrConfig config;
    private CoreContainer coreContainer;
    private PackageListeningClassLoader schemaLoader;
    private PackageListeningClassLoader coreReloadingClassLoader;
    private final List<SolrCoreAware> waitingForCore = Collections.synchronizedList(new ArrayList());
    private final List<SolrInfoBean> infoMBeans = Collections.synchronizedList(new ArrayList());
    private final List<ResourceLoaderAware> waitingForResources = Collections.synchronizedList(new ArrayList());
    private volatile boolean live;
    private RestManager.Registry managedResourceRegistry;
    private boolean needToReloadLuceneSPI = false;
    private static final Map<String, String> classNameCache = new ConcurrentHashMap<String, String>();
    private static final Pattern legacyAnalysisPattern = Pattern.compile("((\\Qorg.apache.solr.analysis.\\E)|(\\Qsolr.\\E))([\\p{L}_$][\\p{L}\\p{N}_$]+?)(TokenFilter|Filter|Tokenizer|CharFilter)Factory");
    static final String[] empty = new String[0];
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final Map<Class<?>, Class<?>[]> awareCompatibility = new HashMap();
    private static final Set<Class<?>> schemaResourceLoaderComponents;
    private static final ThreadLocal<ResourceLoaderAware> CURRENT_AWARE;

    public synchronized RestManager.Registry getManagedResourceRegistry() {
        if (this.managedResourceRegistry == null) {
            this.managedResourceRegistry = new RestManager.Registry();
        }
        return this.managedResourceRegistry;
    }

    public SolrClassLoader getSchemaLoader() {
        if (this.schemaLoader == null) {
            this.schemaLoader = this.createSchemaLoader();
        }
        return this.schemaLoader;
    }

    public SolrResourceLoader(String name, List<Path> classpath, Path instanceDir, ClassLoader parent) {
        this(instanceDir, parent);
        this.name = name;
        ArrayList<URL> libUrls = new ArrayList<URL>(classpath.size());
        try {
            for (Path path : classpath) {
                libUrls.add(path.toUri().normalize().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        this.addToClassLoader(libUrls);
    }

    public SolrResourceLoader(Path instanceDir) {
        this(instanceDir, null);
    }

    public SolrResourceLoader(Path instanceDir, ClassLoader parent) {
        this.allowUnsafeResourceloading = Boolean.getBoolean(SOLR_ALLOW_UNSAFE_RESOURCELOADING_PARAM);
        if (instanceDir == null) {
            throw new NullPointerException("SolrResourceLoader instanceDir must be non-null");
        }
        this.instanceDir = instanceDir;
        log.debug("new SolrResourceLoader for directory: '{}'", (Object)this.instanceDir);
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        this.classLoader = URLClassLoader.newInstance(new URL[0], parent);
    }

    synchronized void addToClassLoader(List<URL> urls) {
        URLClassLoader newLoader = SolrResourceLoader.addURLsToClassLoader(this.classLoader, urls);
        if (newLoader == this.classLoader) {
            return;
        }
        this.classLoader = newLoader;
        this.needToReloadLuceneSPI = true;
        if (log.isInfoEnabled()) {
            log.info("Added {} libs to classloader, from paths: {}", (Object)urls.size(), urls.stream().map(u -> u.getPath().substring(0, u.getPath().lastIndexOf(47))).sorted().distinct().collect(Collectors.toList()));
        }
    }

    synchronized void reloadLuceneSPI() {
        if (!this.needToReloadLuceneSPI) {
            return;
        }
        this.needToReloadLuceneSPI = false;
        log.debug("Reloading Lucene SPI");
        PostingsFormat.reloadPostingsFormats((ClassLoader)this.classLoader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)this.classLoader);
        Codec.reloadCodecs((ClassLoader)this.classLoader);
        CharFilterFactory.reloadCharFilters((ClassLoader)this.classLoader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)this.classLoader);
        TokenizerFactory.reloadTokenizers((ClassLoader)this.classLoader);
    }

    private static URLClassLoader addURLsToClassLoader(URLClassLoader oldLoader, List<URL> urls) {
        if (urls.size() == 0) {
            return oldLoader;
        }
        ArrayList<URL> allURLs = new ArrayList<URL>();
        allURLs.addAll(Arrays.asList(oldLoader.getURLs()));
        allURLs.addAll(urls);
        for (URL url : urls) {
            if (!log.isDebugEnabled()) continue;
            log.debug("Adding '{}' to classloader", (Object)url);
        }
        ClassLoader oldParent = oldLoader.getParent();
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{oldLoader});
        return URLClassLoader.newInstance(allURLs.toArray(new URL[0]), oldParent);
    }

    public static List<URL> getURLs(Path libDir, DirectoryStream.Filter<Path> filter) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(libDir, filter);){
            for (Path element : directory) {
                urls.add(element.toUri().normalize().toURL());
            }
        }
        return urls;
    }

    public static List<URL> getURLs(Path libDir) throws IOException {
        return SolrResourceLoader.getURLs(libDir, entry -> true);
    }

    public static List<URL> getFilteredURLs(Path libDir, String regex) throws IOException {
        PathMatcher matcher = libDir.getFileSystem().getPathMatcher("regex:" + regex);
        return SolrResourceLoader.getURLs(libDir, entry -> matcher.matches(entry.getFileName()));
    }

    public Path getConfigPath() {
        return this.instanceDir.resolve("conf");
    }

    @Deprecated(since="9.0.0")
    public String getConfigDir() {
        return this.getConfigPath().toString();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public InputStream openResource(String resource) throws IOException {
        InputStream is;
        if (resource.trim().startsWith("\\\\")) {
            throw new SolrResourceNotFoundException("Resource '" + resource + "' could not be loaded.");
        }
        Path instanceDir = this.getInstancePath().normalize();
        Path inInstanceDir = this.getInstancePath().resolve(resource).normalize();
        Path inConfigDir = instanceDir.resolve("conf").resolve(resource).normalize();
        if (this.allowUnsafeResourceloading || inInstanceDir.startsWith(instanceDir)) {
            if (Files.exists(inConfigDir, new LinkOption[0]) && Files.isReadable(inConfigDir)) {
                return new SolrFileInputStream(inConfigDir);
            }
            if (Files.exists(inInstanceDir, new LinkOption[0]) && Files.isReadable(inInstanceDir)) {
                return new SolrFileInputStream(inInstanceDir);
            }
        }
        if ((is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'))) == null && System.getProperty("jetty.testMode") != null) {
            is = this.classLoader.getResourceAsStream(("conf/" + resource).replace(File.separatorChar, '/'));
        }
        if (is == null) {
            throw new SolrResourceNotFoundException("Can't find resource '" + resource + "' in classpath or '" + instanceDir + "'");
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resourceLocation(String resource) {
        if (resource.trim().startsWith("\\\\")) {
            return null;
        }
        Path inInstanceDir = this.instanceDir.resolve(resource).normalize();
        Path inConfigDir = this.instanceDir.resolve("conf").resolve(resource).normalize();
        if (this.allowUnsafeResourceloading || inInstanceDir.startsWith(this.instanceDir.normalize())) {
            if (Files.exists(inConfigDir, new LinkOption[0]) && Files.isReadable(inConfigDir)) {
                return inConfigDir.normalize().toString();
            }
            if (Files.exists(inInstanceDir, new LinkOption[0]) && Files.isReadable(inInstanceDir)) {
                return inInstanceDir.normalize().toString();
            }
        }
        try (InputStream is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'));){
            if (is != null) {
                String string = "classpath:" + resource;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.allowUnsafeResourceloading) return null;
        String string = resource;
        return string;
    }

    public List<String> getLines(String resource) throws IOException {
        return this.getLines(resource, UTF_8);
    }

    public List<String> getLines(String resource, String encoding) throws IOException {
        return this.getLines(resource, Charset.forName(encoding));
    }

    public List<String> getLines(String resource, Charset charset) throws IOException {
        try {
            return WordlistLoader.getLines((InputStream)this.openResource(resource), (Charset)charset);
        }
        catch (CharacterCodingException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading resource (wrong encoding?): " + resource, (Throwable)ex);
        }
    }

    @VisibleForTesting
    static void clearCache() {
        classNameCache.clear();
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.findClass(cname, expectedType, empty);
    }

    /*
     * Exception decompiling
     */
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType, String ... subpackages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> Class<? extends T> getPackageClass(String cname, Class<T> expectedType) {
        Class<?> type;
        PluginInfo.ClassName cName = PluginInfo.parseClassName(cname);
        if (cName.pkg == null) {
            return null;
        }
        ResourceLoaderAware aware = CURRENT_AWARE.get();
        if (aware != null && schemaResourceLoaderComponents.contains(type = SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, aware))) {
            return this.getSchemaLoader().findClass(cname, expectedType);
        }
        return null;
    }

    public <T> T newInstance(String name, Class<T> expectedType) {
        return this.newInstance(name, expectedType, empty);
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String ... subpackages) {
        return this.newInstance(cname, expectedType, subpackages, NO_CLASSES, NO_OBJECTS);
    }

    public <T> T newInstance(String cName, Class<T> expectedType, String[] subPackages, Class<?>[] params, Object[] args) {
        T obj;
        Class<T> clazz = this.findClass(cName, expectedType, subPackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cName + " in " + this.classLoader);
        }
        try {
            try {
                Constructor<T> constructor = clazz.getConstructor(params);
                obj = constructor.newInstance(args);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                    obj = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw e;
                }
            }
        }
        catch (Error err) {
            log.error("Loading Class {} ({}) triggered serious java error: {}", new Object[]{cName, clazz.getName(), err.getClass().getName(), err});
            throw err;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        this.addToCoreAware(obj);
        this.addToResourceLoaderAware(obj);
        this.addToInfoBeans(obj);
        return obj;
    }

    public <T> void addToInfoBeans(T obj) {
        if (!this.live && obj instanceof SolrInfoBean) {
            this.infoMBeans.add((SolrInfoBean)obj);
        }
    }

    public <T> boolean addToResourceLoaderAware(T obj) {
        if (!this.live) {
            if (obj instanceof ResourceLoaderAware) {
                SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, obj);
                this.waitingForResources.add((ResourceLoaderAware)obj);
            }
            return true;
        }
        return false;
    }

    public <T> boolean addToCoreAware(T obj) {
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                SolrResourceLoader.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add((SolrCoreAware)obj);
            }
            return true;
        }
        return false;
    }

    protected final void setSolrConfig(SolrConfig config) {
        if (this.config != null && this.config != config) {
            throw new IllegalStateException("SolrConfig instance is already associated with this loader");
        }
        this.config = config;
    }

    protected final void setCoreContainer(CoreContainer coreContainer) {
        if (this.coreContainer != null && this.coreContainer != coreContainer) {
            throw new IllegalStateException("CoreContainer instance is already associated with this loader");
        }
        this.coreContainer = coreContainer;
    }

    protected final void setSolrCore(SolrCore core) {
        this.setCoreContainer(core.getCoreContainer());
        this.setSolrConfig(core.getSolrConfig());
        this.coreName = core.getName();
        this.coreId = core.uniqueId;
        final SolrCore.Provider coreProvider = core.coreProvider;
        this.coreReloadingClassLoader = new PackageListeningClassLoader(core.getCoreContainer(), this, pkg -> this.config.maxPackageVersion((String)pkg), null){

            @Override
            protected void doReloadAction(PackageListeners.Listener.Ctx ctx) {
                log.info("Core reloading classloader issued reload for: {}/{} ", (Object)SolrResourceLoader.this.coreName, (Object)SolrResourceLoader.this.coreId);
                coreProvider.reload();
            }
        };
        core.getPackageListeners().addListener(this.coreReloadingClassLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void inform(SolrCore core) {
        if (this.getSchemaLoader() != null) {
            core.getPackageListeners().addListener(this.schemaLoader);
        }
        block2: while (true) {
            if (this.waitingForCore.size() <= 0) {
                this.live = true;
                return;
            }
            SolrCoreAware[] solrCoreAwareArray = this.waitingForCore;
            // MONITORENTER : this.waitingForCore
            SolrCoreAware[] arr = this.waitingForCore.toArray(new SolrCoreAware[0]);
            this.waitingForCore.clear();
            // MONITOREXIT : solrCoreAwareArray
            solrCoreAwareArray = arr;
            int n = solrCoreAwareArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                SolrCoreAware aware = solrCoreAwareArray[n2];
                aware.inform(core);
                ++n2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void inform(ResourceLoader loader) throws IOException {
        block2: while (this.waitingForResources.size() > 0) {
            ResourceLoaderAware[] resourceLoaderAwareArray = this.waitingForResources;
            // MONITORENTER : this.waitingForResources
            ResourceLoaderAware[] arr = this.waitingForResources.toArray(new ResourceLoaderAware[0]);
            this.waitingForResources.clear();
            // MONITOREXIT : resourceLoaderAwareArray
            resourceLoaderAwareArray = arr;
            int n = resourceLoaderAwareArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                ResourceLoaderAware aware = resourceLoaderAwareArray[n2];
                SolrResourceLoader.informAware(loader, aware);
                ++n2;
            }
            break;
        }
        return;
    }

    public static void informAware(ResourceLoader loader, ResourceLoaderAware aware) throws IOException {
        CURRENT_AWARE.set(aware);
        try {
            aware.inform(loader);
        }
        finally {
            CURRENT_AWARE.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(Map<String, SolrInfoBean> infoRegistry) {
        SolrInfoBean[] solrInfoBeanArray = this.infoMBeans;
        synchronized (this.infoMBeans) {
            SolrInfoBean[] arr = this.infoMBeans.toArray(new SolrInfoBean[0]);
            this.waitingForResources.clear();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (SolrInfoBean bean : arr) {
                if (infoRegistry.containsValue(bean)) continue;
                try {
                    infoRegistry.put(bean.getName(), bean);
                }
                catch (Exception e) {
                    log.warn("could not register MBean '{}'.", (Object)bean.getName(), (Object)e);
                }
            }
            return;
        }
    }

    public Path getInstancePath() {
        return this.instanceDir;
    }

    public static Class<?> assertAwareCompatibility(Class<?> aware, Object obj) {
        Class<?>[] valid = awareCompatibility.get(aware);
        if (valid == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Aware interface: " + aware);
        }
        for (Class<?> v : valid) {
            if (!v.isInstance(obj)) continue;
            return v;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid 'Aware' object: ").append(obj);
        builder.append(" -- ").append(aware.getName());
        builder.append(" must be an instance of: ");
        for (Class<?> v : valid) {
            builder.append("[").append(v.getName()).append("] ");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, builder.toString());
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public SolrConfig getSolrConfig() {
        return this.config;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.classLoader});
    }

    public List<SolrInfoBean> getInfoMBeans() {
        return Collections.unmodifiableList(this.infoMBeans);
    }

    public <T> Class<? extends T> findClass(PluginInfo info, Class<T> type, boolean registerCoreReloadListener) {
        if (info.cName.pkg == null) {
            return this.findClass(info.className, type);
        }
        return this._classLookup(info, ver -> ver.getLoader().findClass(info.cName.className, type), registerCoreReloadListener);
    }

    private <T> T _classLookup(PluginInfo info, Function<SolrPackageLoader.SolrPackage.Version, T> fun, boolean registerCoreReloadListener) {
        PluginInfo.ClassName cName = info.cName;
        if (registerCoreReloadListener) {
            if (this.coreReloadingClassLoader == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core not set");
            }
            return fun.apply(this.coreReloadingClassLoader.findPackageVersion(cName, true));
        }
        return fun.apply(this.coreReloadingClassLoader.findPackageVersion(cName, false));
    }

    public <T> T newInstance(PluginInfo info, Class<T> type, boolean registerCoreReloadListener) {
        if (info.cName.pkg == null) {
            return this.newInstance(info.cName.className == null ? type.getName() : info.cName.className, type);
        }
        return (T)this._classLookup(info, version -> version.getLoader().newInstance(info.cName.className, type), registerCoreReloadListener);
    }

    private PackageListeningClassLoader createSchemaLoader() {
        if (this.coreContainer == null || this.coreContainer.getPackageLoader() == null) {
            return null;
        }
        if (this.config == null) {
            throw new IllegalStateException("cannot create package-aware schema loader - no SolrConfig instance is associated with this loader");
        }
        return new PackageListeningClassLoader(this.coreContainer, this, pkg -> this.config.maxPackageVersion((String)pkg), () -> {
            if (this.coreContainer != null && this.coreName != null && this.coreId != null) {
                try (SolrCore c = this.coreContainer.getCore(this.coreName, this.coreId);){
                    if (c != null) {
                        c.fetchLatestSchema();
                    }
                }
            }
        });
    }

    public static void persistConfLocally(SolrResourceLoader loader, String resourceName, byte[] content) {
        Path confFile = loader.getConfigPath().resolve(resourceName);
        try {
            Files.createDirectories(confFile.getParent(), new FileAttribute[0]);
            Files.write(confFile, content, new OpenOption[0]);
            log.info("Written conf file {}", (Object)resourceName);
        }
        catch (IOException e) {
            String msg = "Error persisting conf file " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        finally {
            try {
                IOUtils.fsync((Path)confFile, (boolean)false);
            }
            catch (IOException e) {
                String msg = "Error syncing conf file " + resourceName;
                log.error(msg, (Throwable)e);
            }
        }
    }

    static {
        awareCompatibility.put(SolrCoreAware.class, new Class[]{CircuitBreaker.class, CodecFactory.class, DirectoryFactory.class, ManagedIndexSchemaFactory.class, QueryResponseWriter.class, SearchComponent.class, ShardHandlerFactory.class, SimilarityFactory.class, SolrRequestHandler.class, UpdateRequestProcessorFactory.class});
        awareCompatibility.put(ResourceLoaderAware.class, new Class[]{CharFilterFactory.class, TokenFilterFactory.class, TokenizerFactory.class, QParserPlugin.class, FieldType.class});
        schemaResourceLoaderComponents = Set.of(CharFilterFactory.class, TokenFilterFactory.class, TokenizerFactory.class, FieldType.class);
        CURRENT_AWARE = new ThreadLocal();
    }

    public static class SolrFileInputStream
    extends FilterInputStream {
        private final long lastModified;

        public SolrFileInputStream(Path filePath) throws IOException {
            this(Files.newInputStream(filePath, new OpenOption[0]), Files.getLastModifiedTime(filePath, new LinkOption[0]).toMillis());
        }

        public SolrFileInputStream(InputStream delegate, long lastModified) {
            super(delegate);
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

