/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class SortStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private TupleStream stream;
    private StreamComparator comparator;
    private Worker worker;

    public SortStream(TupleStream stream, StreamComparator comp) throws IOException {
        this.init(stream, comp);
    }

    public SortStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter byExpression = factory.getNamedOperand(expression, "by");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        if (null == byExpression || !(byExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'by' parameter listing fields to sort over but didn't find one", expression));
        }
        this.init(factory.constructStream(streamExpressions.get(0)), factory.constructComparator(((StreamExpressionValue)byExpression.getParameter()).getValue(), FieldComparator.class));
    }

    private void init(TupleStream stream, StreamComparator comp) throws IOException {
        this.stream = stream;
        this.comparator = comp;
        this.worker = new Worker(){
            private final LinkedList<Tuple> tuples = new LinkedList();
            private Tuple eofTuple;

            @Override
            public void readStream(TupleStream stream) throws IOException {
                Tuple tuple = stream.read();
                while (!tuple.EOF) {
                    this.tuples.add(tuple);
                    tuple = stream.read();
                }
                this.eofTuple = tuple;
            }

            @Override
            public void sort() {
                this.tuples.sort(SortStream.this.comparator);
            }

            @Override
            public Tuple read() {
                if (this.tuples.isEmpty()) {
                    return this.eofTuple;
                }
                return this.tuples.removeFirst();
            }
        };
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.stream instanceof Expressible)) throw new IOException("This SortStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
        }
        if (this.comparator == null) {
            throw new IOException("This SortStream contains a non-expressible equalitor - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("by", this.comparator.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelper(this.comparator.toExplanation(factory));
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
        this.worker.readStream(this.stream);
        this.worker.sort();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public Tuple read() throws IOException {
        return this.worker.read();
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.comparator;
    }

    @Override
    public int getCost() {
        return 0;
    }

    private static interface Worker {
        public void readStream(TupleStream var1) throws IOException;

        public void sort();

        public Tuple read();
    }
}

